# END USER
# 1) Copy the supplied file from ./MOJO/Config.fs-uae to 
# Windows:	Where fs-uae.exe is (install directory).
# Linux:	~/FS-UAE/Configurations/Config.fs-uae
# 2) Place the kickstarter roms into FS-UAE/Kickstarts.
# 3) Linux users need to change: LINUXUSER variable


proc calcFilesIn {dir} {
	logtext "Total files in dir: $dir" 1
	set countFiles [glob -nocomplain -dir $dir "*"]
	set countFiles [llength $countFiles]
	logtext "... $countFiles" 1	
	return $countFiles
}

set LINUXUSER "ix";# Linux users needs to change this. 


# DEVELOPER
# TODO -- Search will match Dune, Dune 2 -> extracts too much!
# TODO -- improve linux username... from db or smt.
# FIXME -- config writer does extra linechange.


set mapName $::selectedRomCRC_db2 
set directory [dbDATA eval "SELECT crc FROM \"$::SelectedDB\" WHERE name=\"$mapName\" ";]
set archiveName ""

set INIFilename "Config.fs-uae";#									Make sure that this is readable and writable
if {$::DetectedOS eq "WIN"} {
	set NewpathToINI [string range $::selectedEmu 0 [string last "/" $::selectedEmu]]
	set NewpathToINI [string map {\{ ""} $NewpathToINI]
	set pathToINI "$NewpathToINI$INIFilename"
} else {
	set pathToINI "/home/$LINUXUSER/FS-UAE/Configurations/Config.fs-uae"
}

set pathToTEMP $::TMPDIR1
set model "A500" ;#													A500; TODO A1200 for AGA

set directory [string map {\{ "" \} ""} $directory];	set directory "$::RomDirectory/$directory/"
set archiveDir "$directory$archiveName"

# MAPFILE -- for GB imports -- finds the real file
	set mapfile "$::HOMEDIR/MOJO/$::SelectedDB.map"
		if {[file exists $mapfile]} {
		logtext "MAPFILE found!" 1
		
		set fp [open "$mapfile" r]
		set file_data [read $fp]
		close $fp
		set data [split $file_data "\n"]
			foreach line $data {
				set nameMap [string range $line 0 [string first ">" $line]-1]
				set dirMap [string range $line [string first ">" $line]+1 end]
				if {"$nameMap" eq "$::selectedRom"} {;	
				logtext "DIR:$::RomDirectory/$dirMap" 1
				set archiveDir "$::RomDirectory/$dirMap";		
				}
			}
		} else {;		tk_messageBox -message "ERROR>gamebase imports require a MAPFILE!<\n";		}


# Clear temp and handle extracting		
LD_clearTMP 1;							# Clear TMP#1
if { [string match "*_Disk*" $archiveDir] } {;# 								If <_Disk> is found multple archives needs to be extracted
	set ZipDir [string range $archiveDir 0 [string last "/" $archiveDir]-1]
	set AllZips [glob -nocomplain -dir $ZipDir "$::selectedRomFast*"]
	foreach zip $AllZips {;	LD_extract $zip 1;	}
} else {;					LD_extract $archiveDir 1;	}

# Setup configuration
set drive0 "";set drive1 "";set drive2 "";set drive3 "";set drive4 "";set drive5 "";set drive6 "";set drive7 "";set drive8 "";set drive9 ""
set foundTMPfiles [glob -nocomplain -dir $pathToTEMP "*"]

# Check if there are nultpiple files in temp. load accordingly.
if { [calcFilesIn "$pathToTEMP"] eq 1 } {
	logtext "> Single disk found" 1
	foreach adf $foundTMPfiles {
		set result [regexp {.adf} $adf match];		if {$result} {;		set drive0 "$adf";	} ;# Singlefile
	}
} else {
	logtext "> Multiple disks found" 1
	foreach adf $foundTMPfiles {
		set result [regexp {Disk1} $adf match];		if {$result} {;		set drive0 "$adf";	}
		set result [regexp {Disk2} $adf match];		if {$result} {;		set drive1 "$adf";	}
		set result [regexp {Disk3} $adf match];		if {$result} {;		set drive2 "$adf";	}
		set result [regexp {Disk4} $adf match];		if {$result} {;		set drive3 "$adf";	}
		set result [regexp {Disk5} $adf match];		if {$result} {;		set drive4 "$adf";	}
		set result [regexp {Disk6} $adf match];		if {$result} {;		set drive5 "$adf";	}
		set result [regexp {Disk7} $adf match];		if {$result} {;		set drive6 "$adf";	}
		set result [regexp {Disk8} $adf match];		if {$result} {;		set drive7 "$adf";	}
		set result [regexp {Disk9} $adf match];		if {$result} {;		set drive8 "$adf";	}
		set result [regexp {Disk10} $adf match];	if {$result} {;		set drive9 "$adf";	}
	}
}


set iniFile [open $pathToINI r]
set file_data [read $iniFile]
set data [split $file_data "\n"]
close $iniFile

foreach line $data {
	set result [regexp {amiga_model = } $line match];		if {$result} {;		set line "amiga_model = $model";	}
	
	set result [regexp {floppy_drive_0 = } $line match];	if {$result} {;		set line "floppy_drive_0 = $drive0";	}
	set result [regexp {floppy_drive_1 = } $line match];	if {$result} {;		set line "floppy_drive_1 = $drive1";	}
	set result [regexp {floppy_drive_2 = } $line match];	if {$result} {;		set line "floppy_drive_2 = $drive2";	}
	set result [regexp {floppy_drive_3 = } $line match];	if {$result} {;		set line "floppy_drive_3 = $drive3";	}
	
	set result [regexp {floppy_image_0 = } $line match];	if {$result} {;		set line "floppy_image_0 = $drive0";	}
	set result [regexp {floppy_image_1 = } $line match];	if {$result} {;		set line "floppy_image_1 = $drive1";	}
	set result [regexp {floppy_image_2 = } $line match];	if {$result} {;		set line "floppy_image_2 = $drive2";	}
	set result [regexp {floppy_image_3 = } $line match];	if {$result} {;		set line "floppy_image_3 = $drive3";	}
	set result [regexp {floppy_image_4 = } $line match];	if {$result} {;		set line "floppy_image_4 = $drive4";	}
	set result [regexp {floppy_image_5 = } $line match];	if {$result} {;		set line "floppy_image_5 = $drive5";	}
	set result [regexp {floppy_image_6 = } $line match];	if {$result} {;		set line "floppy_image_6 = $drive6";	}
	set result [regexp {floppy_image_7 = } $line match];	if {$result} {;		set line "floppy_image_7 = $drive7";	}
	set result [regexp {floppy_image_8 = } $line match];	if {$result} {;		set line "floppy_image_8 = $drive8";	}
	set result [regexp {floppy_image_9 = } $line match];	if {$result} {;		set line "floppy_image_9 = $drive9";	}
	
	append iniBuffer "$line\n"
}
	

set iniFile [open $pathToINI w]
puts -nonewline $iniFile $iniBuffer
close $iniFile

if {$::DetectedOS eq "LIN"} {
	set rom $pathToINI
}

