# Common functions for Loaders
set ::TMPDIR0 $::HOMEDIR/TMP/;				# TMP 0 basedir
set ::TMPDIR1 $::HOMEDIR/TMP/ROM/;			# TMP 1 roms	- AUTOPURGE:ON		- should only have one item
set ::TMPDIR2 $::HOMEDIR/TMP/IMG/;			# TMP 2 images	- AUTOPURGE:OFF


proc LD_clearTMP {DIR} {;	# Delete TEMP files
	# TODO -- Use DIR to select which TEM dit to clear
	if {$DIR eq 1} {;				# set Directory
		set DIR $::TMPDIR1
	} elseif {$DIR eq 2} {
		set DIR $::TMPDIR2
	} else {
		set DIR $::TMPDIR0
	}
	
	file mkdir "$DIR";				# make dir
	set fp [open "$DIR/dummy" w];	# write a dumdum
	close $fp

	file delete {*}[glob -dir $DIR *]
	logtext "- Cleared $DIR" 1
}

proc LD_extract {FILE DIR} {
	# TODO -- windows support, mv 7za to MOJO 
	set goodType 1

	set filetype [file extension $FILE]
	if {$filetype eq ".zip"} {;		# Verify filetype (accept only zip & 7z)
		logtext "- GOTFILE: $filetype - OK" 1
	} elseif {$filetype eq ".7z"} {
		logtext "- GOTFILE: $filetype - OK" 1
	} else {
		logtext "- GOTFILE: $filetype - FAIL" 1
		logtext "- $filetype is unsupported!" 1
		set goodType 0
	}

	if {$DIR eq 1} {;				# set Directory
		set DIR $::TMPDIR1
	} elseif {$DIR eq 2} {
		set DIR $::TMPDIR2
	} else {
		set DIR $::TMPDIR0
	}

	if {$goodType eq 1} {;			# extract if OK
		logtext "- Extract <$FILE> to <$DIR>" 1
		
		if {$::DetectedOS eq "WIN"} {
			exec ./MOJO/7za e "$FILE" -o$DIR -aos
		} else {
			exec 7za e "$FILE" -o$DIR -aos
		}
		
	}

}

proc LD_makecue {} {
	# TODO -- get cuefiles -> make playlist for mednafen
	# OPT -- display key to toggle CD
	logtext "= LD_makecue FIXME" 9
}
