# ===== Function =====
#
# 1. 
# 2. Extracts romname.7z into TMP
# 3. 
#
# x. Emulators: mednafen, psx
# x. Systems: psx, pcfx
#
# TODO -- Fails if more than one .bin -> find track 1
# TODO -- Does not handle removing of extracted items!
#
# =====================

logtext "===== Loader : ISO_cue =====" 1
logtext "get: 7z -> req: cue & bin" 1


set TEMP $::TMPDIR2
file mkdir "$TEMP";	# make dir

set result [regexp {(~)} $::selectedRomFast match]
if {$result} {;										# ** MultiCD load **
	logtext "- MultiCD Found!\nname:$::selectedRomFast" 1

	set base [string range $::selectedRomFast 0 [string first "(~)" $::selectedRomFast]]
	set disk "Disc "
	set base "$base$disk"
	logtext "= base<$base>" 9
	set countbinintemp [llength [glob -nocomplain -dir $TEMP $base*]]

	if { $countbinintemp == 0 } {;		# TMP is empty, get from repo
		set matches [glob -nocomplain -dir $::RomDirectory $base*]
		foreach MCD $matches {
			logtext "= Extracting: <$MCD>" 9
			exec 7za e $MCD -o$::HOMEDIR/TMP/ -aos
		}

		LD_makecue;		# TODO -- make cue file for mednafen
		set match [string map {\{ ""} [string map {\} ""} [glob -dir $TEMP $base*1).cue]]];# list of cuefiles
		logtext "M1- <$match>" 1
		set rom $match

	} else {;							# Match found in TMP -- Already extracted
		logtext "- found <$match> in TMP" 1

		if {$countbinintemp > 0} {
			logtext "- Multiple images found! <$countbinintemp>" 1
			set cuefile [glob -dir $TEMP $base*1).cue];# list of cuefiles
			# TODO -- better way to get cue!
#			set cuefile [list 0 $cuefile]
		}

		LD_makecue;		# TODO -- make cue file for mednafen
		set match [string map {\} ""} [string map {\{ ""} $cuefile]]
		logtext "M2- <$match>" 1
		set rom $match
	}

} else {;											# ** Singlemode **
	logtext "- Singlemode" 1
	# Test if already extracted
	set isoexists [glob -nocomplain -dir $TEMP $::selectedRomFast.bin]
	set countbinintemp [llength [glob -nocomplain -dir $TEMP $::selectedRomFast*.bin]]

	if { $countbinintemp == 0 } {;					# EXTRACT & LOAD
		logtext "- not found in TMP" 1
		logtext "- Extracting:.." 1

		set match [string map {\} ""} [string map {\{ ""} [glob -nocomplain -dir $::RomDirectory $::selectedRomFast*]]]
		logtext "- $match" 1

		#set filetype [file extension $match] -nocomplain
		#logtext "- TYPE: $filetype" 1
		LD_extract "$match" 2

		set isoexists [glob -dir $TEMP "$::selectedRomFast.cue"]
		set match [string map {\} ""} [string map {\{ ""} $isoexists]]
		logtext "S1- <$match>" 1
		set rom $match


	} else {;										# LOAD
		logtext "- ..." 1
		if {$countbinintemp > 0} {
			logtext "- Multiple images found! <$countbinintemp>" 9
			set isoexists [glob -dir $TEMP "$::selectedRomFast.cue"];#
		}

		logtext "- found <$isoexists> in TMP" 1
		set match [string map {\} ""} [string map {\{ ""} $isoexists]]
		logtext "-- <$match>" 1
		set rom $match
	}

}
