 # GUI
ttk::frame .n.f6
.n add .n.f6 -text "Multiplayer"

set tstamp [expr { int(rand()*999) }]
set ::mpPlayerName "Anonbar$tstamp"
set ::defaultMPServer " -netplay.host netplay.fobby.net -connect"


grid rowconfigure .n.f6 1 -weight 1
grid columnconfigure .n.f6 1 -weight 1

#set ::MPUsername "Sraamon"
#set ::EVENTTEXT ""
#grid [tk::canvas .n.f6.mpeventcanvas -width 300 ] -column 0 -row 1 -rowspan 1 -sticky nwes
#.n.f6.mpeventcanvas create text 55 30 -text "SRAA\n$::EVENTTEXT" -anchor w -tags "Eventtext" -fill black

#grid [tk::canvas .n.f6.mpnickcanvas -width 300 ] -column 3 -row 0 -rowspan 1 -sticky nwes
grid [tk::text .n.f6.t -height 30 -wrap word -font {Arial 9} -background white]			-column 1 -row 1 -columnspan 2 -sticky nwes
grid [tk::listbox .n.f6.f -listvariable listnames]									-column 3 -row 1 -sticky news 
grid [ttk::button .n.f6.connect  -text "Connect" -command {connectToIRC}]			-column 3 -row 2 -sticky we 
grid [ttk::button .n.f6.disconnect  -text "Close" -command {closeIRC}]			-column 3 -row 3 -sticky we 
grid [ttk::button .n.f6.ccrcgiv  -text "CRC" -command {mpGiveCRC}]			-column 2 -row 3 -sticky we 
grid [ttk::button .n.f6.startmp  -text "Start Multiplayer game" -command {startMPgame}]			-column 1 -row 3 -sticky we 


.n.f6.t tag config bold   -font [linsert [.n.f6.t cget -font] end bold]
.n.f6.t tag config italic -font [linsert [.n.f6.t cget -font] end italic]

#ttk::notebook .n;	grid .n  -column 0 -row 0 -sticky nwes
#grid [tk::text .n.c -height 30 -width 20 -wrap word -font {Arial 9} -background white]	-column 2 -row 1 -sticky we 

set ::registered 0
set ::joined 0
set ::server "irc.freenode.org"
set ::chan   "#ib3kmptestsrv"
set ::me     "ib3kC-$::mpPlayerName"
set ::meseq  0 ;# sequencial number to add to the NICK if the previous was busy
set ::names {}
set ::onlineStatus 0

.n.f6.t insert end "* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\n"
.n.f6.t insert end "-- USAGE --\n"
.n.f6.t insert end "Username / Region - Set these from Options.\n"
.n.f6.t insert end "(Connect) - Connects you to the Multiplayer channel.\n"
.n.f6.t insert end "Once connected your username will appear on the list.\n"
#.n.f6.t insert end "If you are connected while starting a game, your platform and started game are broadcasted on the channel.\n"
.n.f6.t insert end "(Close) - Disonnects you from the Multiplayer channel.\n"
.n.f6.t insert end "(CRC) - Gives you the CRC checksum of selected item (not broadcasted).\n"
#.n.f6.t insert end "-- WHAT WORKS --\n"
#.n.f6.t insert end "Chat, Clientlist, (default) server connect.\n"
.n.f6.t insert end "-- TODO --\n"
#.n.f6.t insert end "Auto-Join, Re-Join.\n"
.n.f6.t insert end "Improve multiplayer matchmaking.\n"
.n.f6.t insert end "More servers\n"
.n.f6.t insert end "-- STARTING MPGAME --\n"
.n.f6.t insert end "1) Select a game from Library.\n"
.n.f6.t insert end "2) Connect to Multiplayer channel.\n"
.n.f6.t insert end "3) Click \"Start Multiplayer game\".\n"
.n.f6.t insert end "!!) Only Mednafen is supported. -- Both Mednafen's -version and rom's CRC must match.\n"
.n.f6.t insert end "* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\n"
.n.f6.t insert end "atm there is only one server and no idea how long it'll work.\n"
.n.f6.t insert end "* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\n"

set ::colors {red blue darkgreen black darkcyan darkmagenta}
foreach color $::colors {
	.n.f6.t tag config $color -foreground $color
}

grid [ttk::entry .n.f6.cmd]		-column 1 -row 2 -columnspan 2 -sticky we 
bind .n.f6.cmd <Return> post
focus .n.f6.cmd

proc shownames {} {
	set ::listnames ""

	foreach n $::names {
		set n [string map {"@" ""} $n];#		Hide statuses

		set isClient "0";	set isClient [regexp {ib3kC-} $n match]
		set isServer "0";	set isServer [regexp {ib3kS-} $n match]
		if {$isClient} {
			set n [string map {"ib3kC-" ""} $n];#	Hide prefix
			set n ">$n"
			lappend ::listnames $n
		} elseif {$isServer} {
			set n [string map {"ib3kS-" ""} $n];#	Hide prefix
			set n "!$n"
			lappend ::listnames $n
		}
     }
	
	.n.f6.t insert end "People in lobby: [llength $::listnames]"
	.n.f6.t yview end
}


proc recv {} {
	gets $::mpchan line
	puts $line
	# handle PING messages from server (lpz 2012 06 18)
	if {[lindex [split $line] 0] eq "PING"} {
		send "PONG [info hostname] [lindex [split $line] 1]"
		return
	}

	if {[regexp {:([^!]*)![^ ].* +PRIVMSG ([^ :]+) +:(.*)} $line -> nick target msg]} {

		set tag ""
		if {$nick eq "ijchain"} {regexp {<([^>]+)>(.+)} $msg -> nick msg}

	if {[string index $line 1] ne {#}} {

	}

	set nick [string map {"ib3kC-" ""} $nick];#	Hide prefix

	# AUTO-REPLY
	if {$msg eq "GETSTAT"} {
		mpGiveStat
		return
	} elseif { [lindex [split $msg] 0] eq "¤MORSESTER>"} {
		.n.f6.t insert end "A NEW CHALLENGER!" $tag

#		lappend ::EVENTTEXT "<[clock format [clock seconds]]> NEW DUDE\n"
#		.n.f6.mpeventcanvas itemconfigure Eventtext -text "$::EVENTTEXT"
		return
	}


	if { [lindex [split $msg] 0] eq "MPGAME>"} {
		.n.f6.t insert end "<$nick>\t $msg\n" {bold darkgreen}
	}
    # .n.f6.t insert end "<$me2>\t" {bold blue} $msg;#\n [list blue $tag]

	.n.f6.t insert end "<$nick>\t $msg\n" $tag


     } elseif {[regexp {^:([^ ]+) +([^ ]+) +([^ ]+) +(.*)} $line -> server code target rest]} {
         switch -- $code {
             001 {
                 set ::registered 1
             }
             433 {;#nick in use
                 set seqlen [string length [incr ::meseq]]
                 #set ::me [string range $::me 0 [expr 8-$seqlen]]$::meseq
                 set ::me $::me$::meseq
                 send "NICK $::me"
             }
             353 {;#namelist
                 if {[regexp {[^:]*:(.*)} $rest -> nameslist]} {
                     foreach name $nameslist {
                         lappend ::names $name
                     }
                 }
             }
             366 {;#end of names
				shownames
				set ::names {}
             }
         }
	#	.n.f6.t insert end "¤ $line\n" {italic grey}
     } else {
	#	.n.f6.t insert end "~ $line\n" {italic gray}

		if {[lindex $line 1] eq "JOIN" || [lindex $line 1] eq "NICK" || [lindex $line 1] eq "PART"} {
			# TODO -- This may be a spam problem
			send "NAMES $::chan"
		}
     }
     .n.f6.t yview end
 }
 
proc usererr msg {
	.n.f6.t insert end "--- $msg\n" {bold red}
	.n.f6.t yview end
}
 
 proc post {} {
     set msg [.n.f6.cmd get]
     .n.f6.cmd delete 0 end
     if [regexp {^/([^ ]+) *(.*)} $msg -> cmd msg] {
         switch -- $cmd {
             #me {set msg "\001ACTION $msg\001"}
             nick {send "NICK $msg"; set ::me $msg}
             quit {send "QUIT $msg"; exit}
             names {send "NAMES $::chan"}
             quote {send $msg}
             join {;}
             msg {
                 if {[regexp {([^ ]+) +(.*)} $msg -> target querymsg]} {
                     send "PRIVMSG $target :$msg"
                     set tags bold;# [list [nickcolor $target] bold]
                     set target ">>> $target <<<"
                     .n.f6.t insert end $target\t $tags $querymsg\n {black bold}
                     .n.f6.t yview end
                 }
             }
             default {usererr "unknown command /$cmd"}
         }
         if {$cmd ne {me} || $cmd eq {msg}} return
     }
     foreach line [split $msg \n] {send "PRIVMSG $::chan :$line"}
     set tag ""
		set me2 [string map {"ib3kC-" ""} $::me]
     .n.f6.t insert end "<$me2>\t" {bold blue} "$msg \n";# [list blue $tag]
     .n.f6.t yview end
 }

proc send str {
	puts $::mpchan $str
	flush $::mpchan
}

proc mpGiveStat {} {
	catch {	send "PRIVMSG $::chan :$::SelectedDB>$::selectedRom\n$::mpPlayerLoca" }
}
proc mpGiveCRC {} {
	catch {
		set match [string map {\} ""} [string map {\{ ""} [glob -dir $::RomDirectory $::selectedRomFast.zip]]]
		set crc [GetCRCFromZip $match]
		.n.f6.t insert end "Not broadcasted: $::SelectedDB>$::selectedRomFast <$crc>\n"
	}
}

proc startMPgame {} {
	catch {
		send "PRIVMSG $::chan :MPGAME> $::SelectedDB>$::selectedRom" 
		lappend ::RomPreset "$::defaultMPServer -netplay.nick $::mpPlayerName"
		set ::RomPreset [string map {\} ""} [string map {\{ ""} $::RomPreset]]
		StartApp $::selectedEmu $::selectedRomFast
	}
}

proc connectToIRC {} {
	set ::me "ib3kC-$::mpPlayerName"
	if {$::onlineStatus eq "0"} { 
		.n.f6.t insert end "Connecting...\n"
		set ::mpchan [socket $::server 6667]
		send "NICK $::me"
		send "USER $::me 0 * :$::ixbarversion"
		send "JOIN $::chan"
		fileevent $::mpchan readable recv
		set ::onlineStatus 1
		.n.f6.t insert end "* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\n"
		.n.f6.t insert end "- - - Establishing Uplink to - - -\n"
		.n.f6.t insert end "- - - ixbar3000 Multiplayer - - -\n"
		.n.f6.t insert end "-- (highly experimental - ;)) --\n"
		.n.f6.t insert end "* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\n"
		send "PRIVMSG $::chan :¤MORSESTER> $::mpPlayerName>$::mpPlayerLoca>$::MPDNA"
	} else {
		$::Console0 insert end "Already Connected\n"
	}

}

proc closeIRC {} {
	if { [info exists ::mpchan] } {
		catch {	close $::mpchan }
		set ::onlineStatus 0
		set ::listnames ""
	}	
}



# This keeps connected, but ixbar3000 hangs after a session
proc cron {} {
	if {!$::joined && $::registered} {
		send "JOIN $::chan"
		set ::joined 1
	}
	after 2000 cron
}
#cron 

