# GUI
ttk::frame .n.f8
.n add .n.f8 -text "Options" 

# TODO -- Put these to db
#set ::mpPlayerName "Anonbar"
set ::mpPlayerLoca "Atlantis"

set ::Console3 [tk::text .n.f8.text -width 50 -height 20];	#	grid $::Console3 -column 0 -columnspan 11 -row 50 -rowspan 3 -padx 10 -pady 10 -sticky we

grid [ttk::labelframe .n.f8.experimental -text "Experimental Functions" -labelanchor n]		-column 1 -row 2 -padx 5 -pady 5 -sticky new
grid [ttk::checkbutton .n.f8.experimental.omnivalues -text "enableOMNIvalues (SLOW!)" -variable enableOMNIvalues -onvalue "1" -offvalue "0" ] -column 10 -row 10 -sticky nw
grid [ttk::checkbutton .n.f8.experimental.omnisearch -text "enableOMNIsearch (SLOW!)" -variable enableOMNIsearch -onvalue "1" -offvalue "0" ] -column 10 -row 11 -sticky nw
grid [ttk::checkbutton .n.f8.experimental.extrapanel -text "enableExtraPanel" -variable enableExtraPanel -onvalue "1" -offvalue "0"] -column 10 -row 12 -sticky nw


grid [ttk::labelframe .n.f8.multiplayer -text "Multiplayer" -labelanchor n]		-column 3 -row 2 -padx 5 -pady 5 -sticky new -rowspan 2

grid [ttk::label .n.f8.multiplayer.pnamelabel -text "Name: " -anchor w] 		-column 0 -row 15 -sticky nw
grid [ttk::entry .n.f8.multiplayer.pname -textvariable mpPlayerName] 			-column 1 -row 15 -sticky nw
grid [ttk::label .n.f8.multiplayer.locatlabel -text "Region: " -anchor w] 		-column 0 -row 16 -sticky nw
grid [ttk::combobox .n.f8.multiplayer.locattype -textvariable mpPlayerLoca ] 	-column 1 -row 16 -sticky nw
.n.f8.multiplayer.locattype configure -values [list {North America} {South America} {Europe} {Africa} {Asia}]
#bind .n.f8.multiplayer.locattype <<ComboboxSelected>> { togglePlayerLocation }
proc togglePlayerLocation {} {
	set ::mpPlayerLoca [.n.f8.multiplayer.locattype get]
}
grid [tk::canvas .n.f8.multiplayer.profilecanvas -width 36 -height 36 -bg aquamarine] 		-column 0 -row 10
grid [ttk::button .n.f8.multiplayer.randombutton -text "randomize" -command {randomProfile}] 		-column 1 -row 10

grid [ttk::checkbutton .n.f8.multiplayer.joinstart -text "Join on start" -variable mpjoinonstart -onvalue "1" -offvalue "0"] -column 1 -row 19 -sticky nw
grid [ttk::checkbutton .n.f8.multiplayer.joinre -text "Re-Join" -variable mprejoin -onvalue "1" -offvalue "0"] -column 1 -row 20 -sticky nw


grid [ttk::labelframe .n.f8.media -text "External Media" -labelanchor n]		-column 1 -row 3 -padx 5 -pady 5 -sticky new
grid [ttk::label .n.f8.media.muslabel -text "Music Player: " -anchor w] 		-column 1 -row 15 -sticky nw
grid [ttk::entry .n.f8.media.musicpla -textvariable MusicPlayer] 				-column 2 -row 15 -sticky nw
grid [ttk::label .n.f8.media.maglabel -text "Manual Viewer: " -anchor w] 		-column 1 -row 16 -sticky nw
grid [ttk::entry .n.f8.media.magazine -textvariable MagazinePlayer] 			-column 2 -row 16 -sticky nw
grid [ttk::label .n.f8.media.vidlabel -text "Video Player: " -anchor w] 		-column 1 -row 17 -sticky nw
grid [ttk::entry .n.f8.media.videopla -textvariable VideoPlayer] 				-column 2 -row 17 -sticky nw
grid [ttk::label .n.f8.media.daelabel -text "Daemon Tools (dir): " -anchor w] 	-column 1 -row 18 -sticky nw
grid [ttk::entry .n.f8.media.daemonlt -textvariable DaemonTools] 				-column 2 -row 18 -sticky nw

#grid [ttk::labelframe .n.f8.star -text "Rating Stars" -labelanchor n]			-column 2 -row 2 -padx 5 -pady 5 -sticky new
#grid [ttk::label .n.f8.star.r1label -text "On: " -anchor w] 					-column 1 -row 1
#grid [ttk::entry .n.f8.star.rating1 -textvariable ratingStar] 					-column 2 -row 1
#grid [ttk::label .n.f8.star.r2label -text "Off: " -anchor w] 					-column 1 -row 2
#grid [ttk::entry .n.f8.star.rating2 -textvariable ratingStar2] 					-column 2 -row 2

#grid [ttk::labelframe .n.f8.colour -text "Colour Tweaks" -labelanchor n]		-column 2 -row 3 -padx 5 -pady 5 -sticky new
#grid [ttk::entry .n.f8.colour.systemBGColor -textvariable systemBGColor -state disabled] 		-column 1 -row 24
#grid [ttk::entry .n.f8.colour.systemBGColorSel -textvariable systemBGColorSel -state disabled] 	-column 1 -row 25
#grid [ttk::entry .n.f8.colour.systemFGColorSel -textvariable systemFGColorSel -state disabled] 	-column 1 -row 26
#grid [ttk::entry .n.f8.colour.systemFGColor -textvariable systemFGColor -state disabled]		-column 1 -row 27

#grid [ttk::labelframe .n.f8.geo -text "Other" -labelanchor n]		-column 1 -row 4 -padx 5 -pady 5 -sticky new
#grid [ttk::label .n.f8.geo.geolabel -text "Height: " -anchor w] 					-column 1 -row 30
#grid [ttk::entry .n.f8.geo.geoheight -textvariable geoheight] 						-column 2 -row 30

grid [ttk::button .n.f8.save -text "Save" -command {saveoptions}] 						-column 3 -row 4

grid [ttk::labelframe .n.f8.imgpaks -text "Installed Imagepaks" -labelanchor n]		-column 2 -rowspan 2 -row 2 -padx 5 -pady 5 -sticky new	

grid [ttk::label .n.f8.imgpaks.noi -image checkNO -text "No-intro: NO" -compound left] 			-column 1 -row 1 -sticky nw
grid [ttk::label .n.f8.imgpaks.exo -image checkNO -text "Exodos v1: NO" -compound left] 		-column 1 -row 2 -sticky nw

grid [ttk::label .n.f8.imgpaks.ex2 -image checkNO -text "Exodos v2: NO" -compound left] 		-column 1 -row 6 -sticky nw
grid [ttk::label .n.f8.imgpaks.exw -image checkNO -text "Win3x0: NO" -compound left] 			-column 1 -row 7 -sticky nw

grid [ttk::label .n.f8.imgpaks.neo -image checkNO -text "Neo Kobe: NO" -compound left] 			-column 1 -row 10 -sticky nw
grid [ttk::label .n.f8.imgpaks.gba -image checkNO -text "Gamebase Amiga: NO" -compound left] 	-column 1 -row 11 -sticky nw
grid [ttk::label .n.f8.imgpaks.gbc -image checkNO -text "Gamebase C64: NO" -compound left] 		-column 1 -row 12 -sticky nw


grid [ttk::label .n.f8.imgpaks.ste -image checkNO -text "Steam: NO" -compound left] 			-column 1 -row 14 -sticky nw
grid [ttk::label .n.f8.imgpaks.mam -image checkNO -text "MAME: NO" -compound left] 				-column 1 -row 15 -sticky nw
grid [ttk::label .n.f8.imgpaks.add -image checkNO -text "Addon 15: NO" -compound left] 			-column 1 -row 20 -sticky nw

if {[file exists "$::HOMEDIR/IMG/systems/nir.i3"]} {;	.n.f8.imgpaks.noi configure -text "No-intro: OK" -image checkOK;}
if {[file exists "$::HOMEDIR/IMG/systems/exo.i3"]} {;	.n.f8.imgpaks.exo configure -text "Exodos v1: OK" -image checkOK;}
if {[file exists "$::HOMEDIR/IMG/systems/nk3.i3"]} {;	.n.f8.imgpaks.neo configure -text "Neo Kobe: OK" -image checkOK;}
if {[file exists "$::HOMEDIR/IMG/systems/gbamiga.i3"]} {;.n.f8.imgpaks.gba configure -text "Gamebase Amiga: OK" -image checkOK;}
if {[file exists "$::HOMEDIR/IMG/systems/gbc64.i3"]} {;	.n.f8.imgpaks.gbc configure -text "Gamebase C64: OK" -image checkOK;}

if {[file exists "$::HOMEDIR/IMG/systems/steam.i3"]} {;	.n.f8.imgpaks.ste configure -text "Steam: OK" -image checkOK;}
if {[file exists "$::HOMEDIR/IMG/systems/mame.i3"]} {;	.n.f8.imgpaks.mam configure -text "MAME: OK" -image checkOK;}
if {[file exists "$::HOMEDIR/IMG/systems/ib31503.i3"]} {;	.n.f8.imgpaks.add configure -text "Addon 15: OK" -image checkOK;}

$::Console3 insert end "Options\n"
set systemconfSystem "0"

# Joystick setup -- START
grid [ttk::labelframe .n.f8.joystick -text "Controller (pad/joystick)" -labelanchor n]	-column 1 -row 5 -padx 5 -pady 5 -sticky new -rowspan 2
grid [ttk::combobox .n.f8.joystick.controllers] 				-column 1 -row 1 -sticky nw

if {$::joystickOK} {
.n.f8.joystick.controllers configure -values [joystick names]
}

bind .n.f8.joystick.controllers <<ComboboxSelected>> { setJoystick }
grid [ttk::label .n.f8.joystick.test -text "---" -compound left] 			-column 2 -row 1 -sticky ne
if {$::joystickOK} {
	proc setJoystick {} {
		set ::joyNum [.n.f8.joystick.controllers current]
	}

	# -- Disable if no joysticks present, else set default
	if { [joystick count] eq 0 } {
		.n.f8.joystick.controllers configure -state disabled
	} else {
		.n.f8.joystick.controllers current $::joyNum
	}
}
# Joystick setup -- END


grid columnconfigure .n.f8 0 -weight 3
grid columnconfigure .n.f8 1 -weight 2
grid columnconfigure .n.f8 2 -weight 2
grid columnconfigure .n.f8 3 -weight 2
grid columnconfigure .n.f8 4 -weight 3
grid rowconfigure .n.f8 0 -weight 1
grid rowconfigure .n.f8 1 -weight 1
grid rowconfigure .n.f8 2 -weight 0
grid rowconfigure .n.f8 3 -weight 0
grid rowconfigure .n.f8 4 -weight 0
grid rowconfigure .n.f8 5 -weight 6



proc colorize {image color} {
	# get image sizes
	set width  [image width  $image]
	set height [image height $image]
	# get color's R G B
	foreach {rr gg bb} [winfo rgb . $color] break
	# compute new colors
	set colors {}
	for {set y 0} {$y < $height} {incr y} {
		set row {}
		for {set x 0} {$x < $width} {incr x} {
			# save transparency
			lappend trans $x $y [$image transparency get $x $y]

			# compute the new color
			foreach {r g b} [$image get $x $y] break

			set isWhite "$r $g $b"
			if {$isWhite eq {255 255 255}} {
				set r 65279
			} else {
				set r [expr {round($r * $rr / 256)}]
			}
			if {$isWhite eq {255 255 255}} {
				set g 65279
			} else {
				set g [expr {round($g * $gg / 256)}]
			}
			if {$isWhite eq {255 255 255}} {
				set b 65279
			} else {
				set b [expr {round($b * $bb / 256)}]
			}
			# append to the current row
			lappend row [format #%4.4x%4.4x%4.4x $r $g $b]
		}
		# append the row
		lappend colors $row
	}
	# set new image
	$image put $colors
	# restore transparency
	foreach {x y t} $trans { $image transparency set $x $y $t }
}

proc getMPusername {} {
	set ::mpPlayerName [dbCONF eval "SELECT EXT1 FROM ixbarconfig WHERE System='ixbar3000' ";]
	if {$::mpPlayerName eq "0" || [string range $::mpPlayerName 0 6] eq "Anonbar"} {
		set tstamp [expr { int(rand()*999) }]
		set ::mpPlayerName "Anonbar$tstamp"
		#randomProfile
	}
}
proc getMPLocation {} {
	set ::mpPlayerLoca [dbCONF eval "SELECT EXT2 FROM ixbarconfig WHERE System='ixbar3000' ";]
	if {$::mpPlayerLoca eq "0"} {
		set ::mpPlayerLoca "Atlantis"
	}
	if {$::mpPlayerLoca eq "Europe"} {
	.n.f8.multiplayer.profilecanvas configure -bg RoyalBlue4
	} elseif {$::mpPlayerLoca eq "Africa"} {
	.n.f8.multiplayer.profilecanvas configure -bg AntiqueWhite3
	} elseif {$::mpPlayerLoca eq "Asia"} {
	.n.f8.multiplayer.profilecanvas configure -bg plum1
	} elseif {$::mpPlayerLoca eq "South America"} {
	.n.f8.multiplayer.profilecanvas configure -bg "pale green"
	} elseif {$::mpPlayerLoca eq "North America"} {
	.n.f8.multiplayer.profilecanvas configure -bg coral1
	}
}

proc getMPoptions {} {
	set ::mpOptions [dbCONF eval "SELECT EXT4 FROM ixbarconfig WHERE System='ixbar3000' ";]
	$::Console3 insert end "dbMPoptions : $::mpOptions\n"
	if {$::mpOptions eq "0"} {
		set ::mpjoinonstart 0
		set ::mprejoin 0
		set ::MPOPTION "$::mpjoinonstart $::mprejoin"
		#$::Console3 insert end "qMPoption : $::MPOPTION\n"
	} else {
		$::Console3 insert end "N/A\n"
		set musou [lindex $::mpOptions 0]
		set auto [lindex $musou 0]
		set rejo [lindex $musou 1]
		set ::mpjoinonstart $auto
		set ::mprejoin $rejo
		set ::MPOPTION "$auto $rejo"
		#$::Console3 insert end "wMPoption : -$::MPOPTION- <$auto><$rejo>\n"

	}
}

getMPusername
getMPLocation
getMPoptions

$::Console3 insert end "You are $::mpPlayerName from $::mpPlayerLoca\n"

# Defaults
image create photo base -file "$::HOMEDIR/IMG/profiles/base.png"
image create photo eyes -file "$::HOMEDIR/IMG/profiles/E/00.png"
image create photo hair -file "$::HOMEDIR/IMG/profiles/H/00.png"

colorize hair sienna4
colorize eyes red
colorize base snow

.n.f8.multiplayer.profilecanvas create image 2 2 -anchor nw -image base
.n.f8.multiplayer.profilecanvas create image 2 2 -anchor nw -image eyes
.n.f8.multiplayer.profilecanvas create image 2 2 -anchor nw -image hair

#image create photo eyes -file "$::HOMEDIR/IMG/profiles/E/01.png"
#image create photo hair -file "$::HOMEDIR/IMG/profiles/H/01.png"
#colorize hair sienna4
		#$::image1 configure -image imgobj1 -compound image


proc updateProfile {b h e m} {
#	$::Console3 insert end "newDNA: $b $h $e $m\n"

set hty [string range $h 0 1]
set hid [string range $h 2 3]
set ety [string range $e 0 1]
set eid [string range $e 2 3]

image create photo base -file "$::HOMEDIR/IMG/profiles/base.png"
if {$b eq "00"} {;			colorize base tan4
} elseif {$b eq "01"} {;	colorize base wheat3
} elseif {$b eq "02"} {;	colorize base sienna4
} elseif {$b eq "03"} {;	colorize base khaki
} elseif {$b eq "04"} {;	colorize base pink
} elseif {$b eq "05"} {;	colorize base goldenrod3
} elseif {$b eq "06"} {;	colorize base ivory
} elseif {$b eq "07"} {;	colorize base white
} elseif {$b eq "08"} {;	colorize base seashell
}

image create photo hair -file "$::HOMEDIR/IMG/profiles/H/$hid.png"
if {$hty eq "00"} {;		colorize hair purple1
} elseif {$hty eq "01"} {;	colorize hair yellow2
} elseif {$hty eq "02"} {;	colorize hair cyan2
} elseif {$hty eq "03"} {;	colorize hair aquamarine
} elseif {$hty eq "04"} {;	colorize hair pink
} elseif {$hty eq "05"} {;	colorize hair green
} elseif {$hty eq "06"} {;	colorize hair white
} elseif {$hty eq "07"} {;	colorize hair black
}

image create photo eyes -file "$::HOMEDIR/IMG/profiles/E/$eid.png"
if {$ety eq "NULL"} {
colorize eyes blue
}

if {$m eq "NULL"} {
}

}

#updateProfile 00 0001 0001 0000

proc randomProfile {} {
	set rnd1 [expr { int(rand()*9) }];#base
	set rnd2 [expr { int(rand()*8) }];#hair
	set rnd3 [expr { int(rand()*8) }]
	set rnd4 [expr { int(rand()*8) }];#eyes

	if {$rnd1 < 10} {;set rnd1 "0$rnd1";}
	if {$rnd2 < 10} {;set rnd2 "0$rnd2";}
	if {$rnd3 < 10} {;set rnd3 "0$rnd3";}
	if {$rnd4 < 10} {;set rnd4 "0$rnd4";}

	set ::MPDNA "$rnd1 $rnd2$rnd3 00$rnd4 0000"
	updateProfile $rnd1 $rnd2$rnd3 00$rnd4 0000
	#updateProfile $::MPDNA
	#$::Console3 insert end "DNA: $::MPDNA\n"
}

proc getMPDNA {} {
	set ::MPDNA [dbCONF eval "SELECT EXT3 FROM ixbarconfig WHERE System='ixbar3000' ";]
	#$::Console3 insert end "me $::MPDNA -- \n"
	if {$::MPDNA eq "0" || [string range $::mpPlayerName 0 6] eq "Anonbar"} {
		randomProfile
	} else {
#		$::Console3 insert end "1z 00 0001 0001 0000\n"
#		updateProfile 00 0001 0001 0000
		$::Console3 insert end "2z [lindex $::MPDNA 0]\n"
		set limitbreak [lindex $::MPDNA 0]
		set b [lindex $limitbreak 0]
		set h [lindex $limitbreak 1]
		set e [lindex $limitbreak 2]
		set m [lindex $limitbreak 3]
		updateProfile $b $h $e $m
	}
}

getMPDNA

	$::Console3 insert end "<$::enableExtraPanel>\n"
	#dbCONF eval "DROP TABLE ixbarconfig "
#	dbCONF eval "CREATE TABLE ixbarconfig (System,OMNIvalues,OMNIsearch,ExtraPanel,Music,Magazine,Video,Daemon,RateOn,RateOff,EXT1,EXT2,EXT3,EXT4,EXT5,EXT6)"
#	dbCONF eval "INSERT INTO ixbarconfig (System,OMNIvalues,OMNIsearch,ExtraPanel,Music,Magazine,Video,Daemon,RateOn,RateOff,EXT1,EXT2,EXT3,EXT4,EXT5,EXT6) values ('ixbar3000','0','0','0','::MusicPlayer','::MagazinePlayer','::VideoPlayer','::DaemonTools','::ratingStar','::ratingStar2','0','0','0','0','0','0');"

proc saveoptions {} {
	$::Console3 delete 1.0 end
	$::Console3 insert end "Saving options... \n OMNIsearch \t $::enableOMNIsearch \n OMNIvalues \t $::enableOMNIvalues \n enableExtraPanel \t $::enableExtraPanel \n"
	$::Console3 insert end "\n Music \t $::MusicPlayer \n Magazine \t $::MagazinePlayer \n Video \t $::VideoPlayer \n Daemon \t $::DaemonTools \n"

	set ::DaemonTools [string map {\} ""} [string map {\{ ""} $::DaemonTools]]
	
	dbCONF eval "UPDATE ixbarconfig SET OMNIsearch='$::enableOMNIsearch' WHERE System='ixbar3000'; "
	dbCONF eval "UPDATE ixbarconfig SET OMNIvalues='$::enableOMNIvalues' WHERE System='ixbar3000'; "
	dbCONF eval "UPDATE ixbarconfig SET ExtraPanel='$::enableExtraPanel' WHERE System='ixbar3000'; "

	dbCONF eval "UPDATE ixbarconfig SET Music='$::MusicPlayer' WHERE System='ixbar3000'; "
	dbCONF eval "UPDATE ixbarconfig SET Magazine='$::MagazinePlayer' WHERE System='ixbar3000'; "
	dbCONF eval "UPDATE ixbarconfig SET Video='$::VideoPlayer' WHERE System='ixbar3000'; "
	dbCONF eval "UPDATE ixbarconfig SET Daemon='$::DaemonTools' WHERE System='ixbar3000'; "
	
	set ::mpPlayerName [.n.f8.multiplayer.pname get]
	dbCONF eval "UPDATE ixbarconfig SET EXT1='$::mpPlayerName' WHERE System='ixbar3000'; "
	set ::me "ib3kC-$::mpPlayerName"

	set ::mpPlayerLoca [.n.f8.multiplayer.locattype get]
	dbCONF eval "UPDATE ixbarconfig SET EXT2='$::mpPlayerLoca' WHERE System='ixbar3000'; "

	set ::MPDNA [string map {\} ""} [string map {\{ ""} $::MPDNA]]
	$::Console3 insert end "\n EXT3='$::MPDNA'"
	dbCONF eval "UPDATE ixbarconfig SET EXT3='$::MPDNA' WHERE System='ixbar3000'; "

	set ::MPOPTION "$::mpjoinonstart $::mprejoin"
	$::Console3 insert end " \n EXT4='$::MPOPTION'"
	dbCONF eval "UPDATE ixbarconfig SET EXT4='$::MPOPTION' WHERE System='ixbar3000'; "

	$::Console3 insert end "\n Multiplayername: $::mpPlayerName from $::mpPlayerLoca\n"

	toggleExtraPanel
}


if {$::mpjoinonstart eq "1"} {;# Joins lobby once ixbar3000 starts
	connectToIRC
}


