# GUI
ttk::frame .n.f2
.n add .n.f2 -text "Statistics"

grid rowconfigure .n.f2 0 -weight 1
grid rowconfigure .n.f2 1 -weight 1
grid rowconfigure .n.f2 22 -weight 0
grid columnconfigure .n.f2 0 -weight 0
grid columnconfigure .n.f2 1 -weight 1
grid columnconfigure .n.f2 10 -weight 0

#tk::button .n.f2.test -text "Init" -command {ClearStats} -relief raised;	grid .n.f2.test -column 0 -row 2 -sticky w

set ::Console2 [tk::text .n.f2.text -width 40 -height 25];	#	grid $::Console2 -column 20 -columnspan 11 -row 0 -rowspan 3 -sticky we

#set ::systemlist2 [tk::listbox .n.f2.systemlist -listvariable db_systems_human -height 30 -width 30]; 	grid .n.f2.systemlist -column 0 -row 0 -sticky nsew
#bind $::systemlist2 <<ListboxSelect>> "clickSystemListStat"

tk::text .n.f2.syslist ;# TODO -- Kill this zombie!

grid [tk::canvas .n.f2.syslistcanvas -width 250 -scrollregion "0 0 200 700" -yscrollcommand ".n.f2.syslistcanvasscr set"] -column 0 -row 0 -rowspan 2 -sticky nwes
grid [ttk::scrollbar .n.f2.syslistcanvasscr -orient vertical -command ".n.f2.syslistcanvas yview" ] -column 0 -row 0 -rowspan 2 -sticky nes

grid [ttk::treeview .n.f2.statPub -selectmode "browse" -columns "value" -yscrollcommand ".n.f2.scrPub set"] -column 1 -row 0 -sticky news
grid [ttk::scrollbar .n.f2.scrPub -orient vertical -command ".n.f2.statPub yview"] -column 1 -row 0 -sticky nse
.n.f2.statPub column #0 -width 300 -anchor e;		.n.f2.statPub heading #0 -text "Publisher"
.n.f2.statPub column value -width 60 -anchor w;		.n.f2.statPub heading value -text "#"

grid [ttk::treeview .n.f2.statDev -selectmode "browse" -columns "value" -yscrollcommand ".n.f2.scrDev set"] -column 1 -row 1 -sticky news
grid [ttk::scrollbar .n.f2.scrDev -orient vertical -command ".n.f2.statDev yview"] -column 1 -row 1 -sticky nse
.n.f2.statDev column #0 -width 300 -anchor e;		.n.f2.statDev heading #0 -text "Developer"
.n.f2.statDev column value -width 60 -anchor w;		.n.f2.statDev heading value -text "#"


grid [ttk::labelframe .n.f2.corpframe -text "Corporation" -labelanchor n -padding 5] -column 2 -columnspan 2 -row 0 -rowspan 2 -sticky nes -padx 5 -pady 5


grid [ttk::notebook .n.f2.corpframe.note]	-column 0 -row 1 -rowspan 3 -sticky ns
ttk::frame .n.f2.corpframe.note.data;		.n.f2.corpframe.note add .n.f2.corpframe.note.data -text "Info" -sticky n
ttk::frame .n.f2.corpframe.note.humn;		.n.f2.corpframe.note add .n.f2.corpframe.note.humn -text "People" -sticky n
ttk::frame .n.f2.corpframe.note.saga;		.n.f2.corpframe.note add .n.f2.corpframe.note.saga -text "Series" -sticky n


image create photo corplogo -file "$::HOMEDIR/IMG/corp/noLogo.png" -height 64 -width 300
grid [tk::label .n.f2.corpframe.logo -image corplogo -anchor center]		-column 0 -row 0 -sticky wn
grid [tk::label .n.f2.corpframe.note.data.game -image star_off -text "-" -height 380 -width 300]	-column 0 -row 1 -sticky wns

image create photo portrait -file "$::HOMEDIR/IMG/legends/Common.png" -height 92 -width 64
grid [tk::label .n.f2.corpframe.note.humn.port -image portrait -compound left -text "-" ]	-column 0 -row 1 -sticky nw
grid [ttk::treeview .n.f2.corpframe.note.humn.list -selectmode "browse" -columns "value" -yscrollcommand ".n.f2.corpframe.note.humn.listscr set"] -column 0 -row 2 -sticky nws
grid [ttk::scrollbar .n.f2.corpframe.note.humn.listscr -orient vertical -command ".n.f2.corpframe.note.humn.list yview"] -column 0 -row 2 -sticky nes
.n.f2.corpframe.note.humn.list column #0 -width 260 -anchor e;			.n.f2.corpframe.note.humn.list heading #0 -text "Developers"
.n.f2.corpframe.note.humn.list column value -width 30 -anchor w;		.n.f2.corpframe.note.humn.list heading value -text "#"

ttk::labelframe .n.f2.yearframe -text "Release Year (100)" -labelanchor n -padding 10;	grid .n.f2.yearframe -column 0 -columnspan 3 -row 22  -padx 5 -pady 5
ttk::frame .n.f2.yearframe.box -relief raised; grid .n.f2.yearframe.box -sticky e
ttk::progressbar .n.f2.yearframe.box.proge;ttk::progressbar .n.f2.yearframe.box.proge0;# null values are here


grid [ttk::button .n.f2.yearframe.box.b0 -text "3500" -command "reCalcReleases 3500"]  -column 2500 -row 1
grid [ttk::button .n.f2.yearframe.box.b1 -text "1000" -command "reCalcReleases 1000"]  -column 2500 -row 2
grid [ttk::button .n.f2.yearframe.box.b2 -text "500" -command "reCalcReleases 500"]  -column 2500 -row 3
grid [ttk::button .n.f2.yearframe.box.b3 -text "250" -command "reCalcReleases 250"]  -column 2500 -row 4
grid [ttk::button .n.f2.yearframe.box.b4 -text "100" -command "reCalcReleases 100"]  -column 2500 -row 5

# DEVELOPERMODE OPTION
# Displays -- bulkrename
if {$::DEVELOPERMODE} {
	ttk::frame .n.f2.corpframe.note.edit;		.n.f2.corpframe.note add .n.f2.corpframe.note.edit -text "Edit" -sticky n
	grid [ttk::button .n.f2.corpframe.note.edit.gp -text "getPublisherName" -command "getPublisherName"]  		-column 0 -row 3
	grid [ttk::button .n.f2.corpframe.note.edit.gd -text "getDeveloperName" -command "getDeveloperName"]  		-column 5 -row 3
	grid [ttk::entry .n.f2.corpframe.note.edit.val -textvariable newValue]  -column 0 -row 5 -columnspan 10 -sticky we
	grid [ttk::button .n.f2.corpframe.note.edit.b -text "fixPub" -command "fixPublisherName"]  		-column 0 -row 8
	grid [ttk::button .n.f2.corpframe.note.edit.c -text "fixDev" -command "fixDeveloperName"]  		-column 5 -row 8

}
	grid [ttk::button .n.f2.lb -text "Logo Browser" -command "popLogoBrowser"]	-column 3 -row 22 -sticky n  -padx 20 -pady 10

proc getPublisherName {} {
	set ::newValue [.n.f2.statPub selection]
	set ::newValue [string map {\} ""} [string map {\{ ""} $::newValue]]
}
proc getDeveloperName {} {
	set ::newValue [.n.f2.statDev selection]
	set ::newValue [string map {\} ""} [string map {\{ ""} $::newValue]]
}


proc fixPublisherName {} {
	set idx [.n.f2.statPub selection]
	$::Console2 insert end "\n$::StatSys -- $idx> $::newValue\n"
	set ::newValue [string map {\} ""} [string map {\{ ""} $::newValue]]
	set ::newValue [string map {' ''} $::newValue]
	set idx [string map {\} ""} [string map {\{ ""} $idx]]
#	set newPublisher "indie 2"
	dbCORP eval "UPDATE \"$::StatSys\" SET publisher='$::newValue' WHERE publisher='$idx'; "
	set ::newValue [string map {'' '} $::newValue]
}
proc fixDeveloperName {} {
	set idx [.n.f2.statDev selection]
	$::Console2 insert end "\n$::StatSys -- $idx> $::newValue\n"
	set ::newValue [string map {\} ""} [string map {\{ ""} $::newValue]]
	set ::newValue [string map {' ''} $::newValue]
	set idx [string map {\} ""} [string map {\{ ""} $idx]]
#	set newPublisher "indie 2"
	dbCORP eval "UPDATE \"$::StatSys\" SET developer='$::newValue' WHERE developer='$idx'; "
	set ::newValue [string map {'' '} $::newValue]
}

proc popLogoBrowser {} {
	tk::toplevel .logobrowser
	wm title .logobrowser "Corporate logo browser"
	wm geometry .logobrowser 320x650-400+50

	set ::Console22 [tk::text .logobrowser.text -width 40 -height 25];	#grid $::Console22 -column 20 -columnspan 11 -row 1 -rowspan 10 -sticky we
	#$::Console22 insert end "!"
	set logodir $::HOMEDIR/IMG/corp/
	set ::logolist [lsort [glob -nocomplain -dir $logodir *.png]]
	set allLogos [llength $::logolist]

	grid [ttk::scale .logobrowser.scroll -orient vertical -from 1 -to $allLogos -command "updateLogobrowser"]	-column 2 -row 1 -rowspan 10 -sticky news

	image create photo corplogo1 -file "$::HOMEDIR/IMG/corp/noLogo.png" -height 64 -width 300
	image create photo corplogo2 -file "$::HOMEDIR/IMG/corp/noLogo.png" -height 64 -width 300
	image create photo corplogo3 -file "$::HOMEDIR/IMG/corp/noLogo.png" -height 64 -width 300
	image create photo corplogo4 -file "$::HOMEDIR/IMG/corp/noLogo.png" -height 64 -width 300
	image create photo corplogo5 -file "$::HOMEDIR/IMG/corp/noLogo.png" -height 64 -width 300
	image create photo corplogo6 -file "$::HOMEDIR/IMG/corp/noLogo.png" -height 64 -width 300
	image create photo corplogo7 -file "$::HOMEDIR/IMG/corp/noLogo.png" -height 64 -width 300
	image create photo corplogo8 -file "$::HOMEDIR/IMG/corp/noLogo.png" -height 64 -width 300
	image create photo corplogo9 -file "$::HOMEDIR/IMG/corp/noLogo.png" -height 64 -width 300
	image create photo corplogo0 -file "$::HOMEDIR/IMG/corp/noLogo.png" -height 64 -width 300

	grid [tk::label .logobrowser.corpLabel1 -image corplogo1 -anchor center -height 64 ]	-column 1 -row 1 -sticky news
	grid [tk::label .logobrowser.corpLabel2 -image corplogo2 -anchor center -height 64 ]	-column 1 -row 2 -sticky news
	grid [tk::label .logobrowser.corpLabel3 -image corplogo3 -anchor center -height 64 ]	-column 1 -row 3 -sticky news
	grid [tk::label .logobrowser.corpLabel4 -image corplogo4 -anchor center -height 64 ]	-column 1 -row 4 -sticky news
	grid [tk::label .logobrowser.corpLabel5 -image corplogo5 -anchor center -height 64 ]	-column 1 -row 5 -sticky news
	grid [tk::label .logobrowser.corpLabel6 -image corplogo6 -anchor center -height 64 ]	-column 1 -row 6 -sticky news
	grid [tk::label .logobrowser.corpLabel7 -image corplogo7 -anchor center -height 64 ]	-column 1 -row 7 -sticky news
	grid [tk::label .logobrowser.corpLabel8 -image corplogo8 -anchor center -height 64 ]	-column 1 -row 8 -sticky news
	grid [tk::label .logobrowser.corpLabel9 -image corplogo9 -anchor center -height 64 ]	-column 1 -row 9 -sticky news
	grid [tk::label .logobrowser.corpLabel0 -image corplogo0 -anchor center -height 64 ]	-column 1 -row 10 -sticky news
}

proc updateLogobrowser {x} {
	set x [expr int($x)]
	set corpName1 [lindex $::logolist $x]
	set corpName2 [lindex $::logolist [expr $x+1]]
	set corpName3 [lindex $::logolist [expr $x+2]]
	set corpName4 [lindex $::logolist [expr $x+3]]
	set corpName5 [lindex $::logolist [expr $x+4]]
	set corpName6 [lindex $::logolist [expr $x+5]]
	set corpName7 [lindex $::logolist [expr $x+6]]
	set corpName8 [lindex $::logolist [expr $x+7]]
	set corpName9 [lindex $::logolist [expr $x+8]]
	set corpName0 [lindex $::logolist [expr $x+9]]

	image create photo corplogo1 -file "$corpName1" -height 64 -width 300
	image create photo corplogo2 -file "$corpName2" -height 64 -width 300
	image create photo corplogo3 -file "$corpName3" -height 64 -width 300
	image create photo corplogo4 -file "$corpName4" -height 64 -width 300
	image create photo corplogo5 -file "$corpName5" -height 64 -width 300
	image create photo corplogo6 -file "$corpName6" -height 64 -width 300
	image create photo corplogo7 -file "$corpName7" -height 64 -width 300
	image create photo corplogo8 -file "$corpName8" -height 64 -width 300
	image create photo corplogo9 -file "$corpName9" -height 64 -width 300
	image create photo corplogo0 -file "$corpName0" -height 64 -width 300
}


$::Console2 insert end "NOTE>"
.n.f2.statPub tag bind tagname <<TreeviewSelect>> "StatItemClickedPub"
.n.f2.statDev tag bind tagname <<TreeviewSelect>> "StatItemClickedDev"
.n.f2.corpframe.note.humn.list tag bind tag <<TreeviewSelect>> "StatItemClickedLegend"

proc StatItemClickedPub {} {
	ClearStatConsole
	set idx [.n.f2.statPub selection]
	$::Console2 insert end "$::StatSys>$idx>>>\n\n"
	set idx [lindex $idx 0]

	set CORPdata [dbCORP eval "SELECT name FROM \"$::StatSys\" WHERE publisher=\"$idx\""]
	#set CORPdata [lindex $CORPdata 0]
	set CORPdata [string map {"\}" ""} $CORPdata]
	set CORPdata [string map {"\{" "\n"} $CORPdata]
	$::Console2 insert end "$CORPdata\n"
	set ::StatCorpData $CORPdata
	StatSetCorp $idx
	StatSetPeopleD $idx
}
proc StatItemClickedDev {} {
	ClearStatConsole
	set idx [.n.f2.statDev selection]
	$::Console2 insert end "$::StatSys>$idx>>>\n\n"
	set idx [lindex $idx 0]

	set CORPdata [dbCORP eval "SELECT name FROM \"$::StatSys\" WHERE developer=\"$idx\""]
	set CORPdata [string map {"\}" ""} $CORPdata]
	set CORPdata [string map {"\{" "\n"} $CORPdata]
	$::Console2 insert end "$CORPdata\n"
	set ::StatCorpData $CORPdata
	StatSetCorp $idx
	StatSetPeopleD $idx
}
proc StatSetCorp {corp} {
	resetLegendPortrait

	set image $::HOMEDIR/IMG/corp/$corp.png;# Get Logo
	if {[file exists "$image"]} {
		image create photo corplogo -file "$image" -height 64 -width 300
		.n.f2.corpframe.logo configure -image corplogo -compound top -text "" -anchor center
	} else {
		resetCorpLogo
	}
	.n.f2.corpframe.note.data.game configure -image star_off -compound bottom -text "$::StatCorpData"

	set Cdata $::HOMEDIR/IMG/corp/$corp.txt;# Get CorpData
	if {[file exists "$Cdata"]} {
		source $Cdata
		.n.f2.corpframe.note.data.game configure -image star_onn -compound bottom -text "$nkan\n$name\n$born\nState: $cond\n$wwww\n$frnc" -anchor n	
	}

	validateCorp $corp
}

proc StatSetPeopleD {corp} {
	.n.f2.corpframe.note.humn.list delete [.n.f2.corpframe.note.humn.list children {}]
	$::Console2 insert end "GetAllPersons <$corp>\n"
	set CorpPersons [dbCORP eval "SELECT design FROM \"$::StatSys\" WHERE developer=\"$corp\""]
	set CorpPersonsM [dbCORP eval "SELECT music FROM \"$::StatSys\" WHERE developer=\"$corp\""]
	set CorpPersonsP [dbCORP eval "SELECT program FROM \"$::StatSys\" WHERE developer=\"$corp\""]
	set CorpPersons "{} $CorpPersons $CorpPersonsM $CorpPersonsP"
	set CorpPersons [string map {"; " "\} \{"} $CorpPersons]

	foreach x $CorpPersons {;dict incr countDev $x;}
	set sorderDictDev [dict'sort $countDev -decreasing]
	$::Console2 insert end "$sorderDictDev <Z>\n"

	set luku "1"
	foreach i $sorderDictDev {
		if {$luku == "1"} {
			set id $i
		} elseif {$luku == "2"} {
			set year $i
			if {$id eq ""} {;set id "UNK";}
			.n.f2.corpframe.note.humn.list insert {} end -id $id -text $id -tags "tag"
			.n.f2.corpframe.note.humn.list set $id value $year
		}
		incr luku
		if {$luku > 2} {;set luku "1";}
	}
	catch {.n.f2.corpframe.note.humn.list delete UNK}

}

proc StatItemClickedLegend {} {

	set idx [.n.f2.corpframe.note.humn.list selection]
	set idx [lindex $idx 0]

	set image $::HOMEDIR/IMG/legends/$idx.png
	if {[file exists "$image"]} {
		image create photo portrait -file "$image" -height 92 -width 64
		.n.f2.corpframe.note.humn.port configure -image portrait -compound left -text "$idx" -anchor center
	} else {
		resetLegendPortrait
	}

	set Ldata $::HOMEDIR/IMG/legends/$idx.txt
	if {[file exists "$Ldata"]} {
		source $Ldata
		.n.f2.corpframe.note.humn.port configure -text "$name\n$born\n\n$work" -anchor n	
	}

	validateEntry $idx
}

proc resetLegendPortrait {} {
	image create photo portrait -file "$::HOMEDIR/IMG/legends/Common.png" -height 92 -width 64
	.n.f2.corpframe.note.humn.port configure -image portrait -compound left -text "N/A" -anchor n
}

proc resetCorpLogo {} {
	image create photo corplogo -file "$::HOMEDIR/IMG/corp/noLogo.png" -height 64 -width 300
	.n.f2.corpframe.logo configure -image corplogo -compound bottom -text "" -anchor center
}


proc reCalcReleases {maxval} {
	#generare statsgraph
	for {set x 1970} {$x<2021} {incr x} {
	.n.f2.yearframe.box.proge$x configure -maximum $maxval
	.n.f2.yearframe configure -text "Release Year ($maxval)"
	}
}


proc InitNewSyslistStat {} {
	set i [llength $::db_systems_human]

	.n.f2.syslistcanvas delete SL_E


	for {set x 0} {$x<$i} {incr x} {
	set dbName [lindex $::db_systems_human $x]
	set dbNamenonH [lindex $::db_systems $x]
	set dbYear [lindex $::db_systems_date $x]
	set dbType [lindex $::db_systems_type $x]
	set dbSys [lindex $::db_systems $x]

#	$::Console2 insert end "* $dbName\n"
	if {[file exists "./IMG/defaults/$dbNamenonH/100.png"]} {
		image create photo sysicon$x -file "./IMG/defaults/$dbNamenonH/100.png"
	} else {
		image create photo sysicon$x -file "./IMG/icon_noicon.png"
	}

	#-height 2 -justify left -relief flat
	set imgLine1 [string range [lindex $::db_systems_human $x] 0 30]
	set imgLine1 [string map {\} ""} [string map {\{ ""} $imgLine1]]
	set imgLine2 [string range "\n$dbYear ($dbType)" 0 30]
	set imgLine3 [string range "\n\t\t\t." 0 30]


	.n.f2.syslistcanvas create image 0 [expr [expr $x*50]+30] -image BGSlab -anchor w    -tags "SL_E SL_En$x SL_Ebg$x"
	.n.f2.syslistcanvas create image 0 [expr [expr $x*50]+30] -image sysicon$x -anchor w -tags "SL_E SL_En$x"

	set dbName [string map {\} ""} [string map {\{ ""} [lindex $::db_systems_human $x]]]
	.n.f2.syslistcanvas create text 55 [expr [expr $x*50]+30] -text "$dbName$imgLine2" -anchor w -tags "SL_E SL_En$x" -fill black

	.n.f2.syslistcanvas bind "SL_En$x" <ButtonPress> "updateStat $dbSys $x"


	}


	
}


#generare statsgraph
for {set x 1970} {$x<2021} {incr x} {
ttk::progressbar .n.f2.yearframe.box.proge$x -orient vertical -length 150 -value 0 -maximum 100 -mode determinate;	grid .n.f2.yearframe.box.proge$x -column $x -row 1 -rowspan 10 -sticky s
ttk::label .n.f2.yearframe.box.yearx$x -text "[string range $x 2 3]" -anchor n	;									grid .n.f2.yearframe.box.yearx$x -column $x -row 20 -sticky s
}



proc updateStat {sys xdb} {
	set ::StatSys $sys
	# Reset values as they are null
	.n.f2.statPub delete [.n.f2.statPub children {}]
	.n.f2.statDev delete [.n.f2.statDev children {}]
	resetCorpLogo
	resetLegendPortrait
	.n.f2.corpframe.note.humn.list delete [.n.f2.corpframe.note.humn.list children {}]
	.n.f2.corpframe.note.data.game configure -image star_off -compound bottom -text ""

	for {set x 1970} {$x<2016} {incr x} {
	.n.f2.yearframe.box.proge$x configure -value 0
	}

#TODO May fail... 
	set count [llength $::db_systems] 
	for {set xx 0} {$xx<$count} {incr xx} {;
	.n.f2.syslistcanvas itemconfigure "SL_Ebg$xx" -image BGSlab
	}
	.n.f2.syslistcanvas itemconfigure "SL_Ebg$xdb" -image BGSlab1

	#setSelectedSystemBGS $xdb
#tk_messageBox -message "Game $sys: $xdb / $count"
#	$::Console2 insert end "STATDB>$sys! \n";#name,crc,series,genre,year,developer,publisher,design,music,program,type,locale
	if {[dbCORP exists "SELECT name FROM sqlite_master WHERE type='table' AND name=\"$sys\" ";]} {
		set CORPdataDev [dbCORP eval "SELECT developer FROM \"$sys\""]
		set CORPdataPub [dbCORP eval "SELECT publisher FROM \"$sys\""]
		set CORPdataYear [dbCORP eval "SELECT year FROM \"$sys\""]
	} else {
		set CORPdataDev ""
		set CORPdataPub ""
		set CORPdataYear ""
	}
#	$::Console2 insert end "CORPdataDev>$CORPdataDev! ----\n"
    set countDev {}
    set countPub {}
    set countYear {}
    foreach x $CORPdataDev {;dict incr countDev $x;}
    foreach p $CORPdataPub {;dict incr countPub $p;}
    foreach y $CORPdataYear {;dict incr countYear $y;}

	set sorderDictDev [dict'sort $countDev -decreasing]
	set sorderDictPub [dict'sort $countPub -decreasing]
	set sorderDictYear [dict'sort $countYear -decreasing]

	set luku "1";# Developers
	foreach i $sorderDictDev {
		if {$luku == "1"} {
			set id $i
		} elseif {$luku == "2"} {
			set year $i
			if {$id eq ""} {;set id "UNK";}
			.n.f2.statDev insert {} end -id $id -text $id -tags "tagname"
			.n.f2.statDev set $id value $year
		}
		incr luku
		if {$luku > 2} {;set luku "1";}
	}
	set luku "1";# Publishers
	foreach i $sorderDictPub {
		if {$luku == "1"} {
			set id $i
		} elseif {$luku == "2"} {
			set year $i
			if {$id eq ""} {;set id "UNK";}
			.n.f2.statPub insert {} end -id $id -text $id -tags "tagname"
			.n.f2.statPub set $id value $year
		}
		incr luku
		if {$luku > 2} {;set luku "1";}
	}
	set luku "1";# Years
	foreach i $sorderDictYear {
		if {$luku == "1"} {
			set year $i
		} elseif {$luku == "2"} {
		#	set year $i
			if {$id eq "" || $id eq "0000"} {;set id "UNK$year";}
		#	.n.f2.statPub insert {} end -id $id -text $id -tags "tagname"
		#	.n.f2.statPub set $id value $year
#		$::Console2 insert end "-->$year _ $i! \n"

if {$year<1970} {;set year 0;}

catch {.n.f2.yearframe.box.proge$year configure -value "$i"}
		
		}
		incr luku
		if {$luku > 2} {;set luku "1";}
	}

catch {.n.f2.statPub delete UNK}
catch {.n.f2.statDev delete UNK}
}


proc dict'sort {dict args} {
    set res {}
    dict for {k v} $dict {lappend res [list $k $v]}
    return [concat {*}[lsort -integer -index 1 {*}$args $res]];#		rank by strength
#    return [concat {*}[lsort -ascii -index 0 {*}$args $res]];#			rank by name
}

proc validateEntry {entry} {;							# This will convert commas into semicolons and remove extra characters
	set newvalue [string map {" , " "; "} $entry]
	set newvalue [string map {", " "; "} $newvalue]
	dbCORP eval "UPDATE \"$::StatSys\" SET design=\"$newvalue\" WHERE design='$entry' ; "
	dbCORP eval "UPDATE \"$::StatSys\" SET music=\"$newvalue\" WHERE music='$entry' ; "
	dbCORP eval "UPDATE \"$::StatSys\" SET program=\"$newvalue\" WHERE program='$entry' ; "
#	tk_messageBox -message "<$entry>\n<$entry2>"
}

proc validateCorp {entry} {;#							Remove ltd and other extras
							#							DISABLED
	set entry2 [string map {", Inc." ""} $entry]
	set entry2 [string map {", Ltd." ""} $entry2]
#	tk_messageBox -message "<$entry>\n<$entry2>"
}

proc ClearStatConsole {} {
	$::Console2 delete 1.0 end
}

proc ClearStats {} {
	$::Console2 insert end "STATDB>CLEAR! \n"
}

