# 	=	=	=	=	=	=	=	=	=	=	=	=	=	=	=	=	=	=	=	=	=	=	=	=	AWARD FUNCTIONS (START)
# clearAwards{}		;# finds selected game-awards and deletes them
# setPage{}
# clearPage{}		
# CheckAwards{}				;# checks if the award file exists. $CheckAward 1 = yes, 0 = no
# addAwardData{}		
# toggleAward{}			
# writeAwardStatus{}	
# 	=	=	=	=	=	=	=	=	=	=	=	=	=	=	=	=	=	=	=	=	=	=	=	=	=	=	=	=	=	=	

# Load Awardeditor beta
source ./SYS/fn_awardeditor.tcl
# ====================================

proc toggleNewAward {aid name type description status} {
# Called when user clicks an award.

	set aw "_award"	
	tk::toplevel .awardwindow
	wm title .awardwindow "Award: <$aid> $::awardID : $name"
	wm geometry .awardwindow 300x200-100+50
	set ::awardstatus $status

	if {$type eq "text"} {
		ttk::entry .awardwindow.name -textvariable awardstatus
		grid .awardwindow.name -column 1 -row 1 -sticky e
	} else {
		set ::awardstatus "1"
	}

	$::Console0 insert end "AwaName: $name \nStatus: $::awardstatus"
	ttk::button .awardwindow.accept -text "Accept" -command "writeNewAwardStatus {$type} {$aid} {$::awardstatus}";	grid .awardwindow.accept -column 2 -row 1 -sticky e
	ttk::button .awardwindow.remove -text "Remove" -command "writeNewAwardStatus {$type} {$aid} 0";					grid .awardwindow.remove -column 2 -row 3 -sticky e
}

proc writeNewAwardStatus {type aid status} {
	$::Console0 insert end "AwardStatus: <$type> $aid $status\n"

	if {$type eq "text"} {
		set status [.awardwindow.name get]
	}

	destroy .awardwindow
	set aw "_award"
	dbSTAT eval "UPDATE \"$::SelectedDB$aw\" SET status='$status' WHERE gid=\"$::awardID\" AND aid = '$aid'; "

#	dbSTAT eval "DELETE FROM $awardtable WHERE gid=\"$::awardID\" AND aid = $aid"
#	dbSTAT eval "INSERT INTO $awardtable (gid,aid,name,type,points,class,description,status) values ('$gameid','$i','$awName','$awType','$awPts','$awTrop','$awDesc','0');"  ;#ok. laittaa awardit dbhen
set dbPlop [dbSTAT eval "SELECT name,status FROM $::SelectedDB$aw WHERE gid=\"$::awardID\" ";]
	$::Console0 insert end "DBq>\n$dbPlop\n\n====\n"

	$::Console0 insert end "> db: $::SelectedDB$aw\nstatus: $status\ngid: $::selectedRomCRC_db1\naid $aid\n"
CheckDBAwards
}

proc AwardParser {} {
	set aw "_award"
	set awardtable $::SelectedDB$aw
	$::Console0 insert end "zx! Start the aw-parser: $::textfromRomlist \n"

	set gameid $::textfromRomlist
	set gameid [string map {' ''} $gameid]

#			set datfile $awardDir$::textfromRomlist.txt
	set fp [open "$::AwardFilename" r]
	set file_data [read $fp]
	close $fp
	set data [split $file_data "\n"]

	set i "1"

	foreach line $data {
		set testi [split $line ";"]
		#$::Console0 insert end "$file_data\n"
		set awName [lindex $testi 1]
		set awType [lindex $testi 2]
		set awPts [lindex $testi 3]
		set awTrop [lindex $testi 4]
		set awDesc [lindex $testi 5]
		set awDesc [string map {' ''} $awDesc]

		# exit when empty
		if {$awName eq ""} {
		break
		}

		# Award Images
		if {[file exists "./AWA/$::SelectedDB/$::textfromRomlist/$i.png"]} {
			image create photo award$i -file "./AWA/$::SelectedDB/$::textfromRomlist/$i.png"
		} else {
			image create photo award$i -file "./AWA/noawimg.gif"
		}

		image create photo Trophy$awTrop -file "./AWA/Trophy_$awTrop.png"
		ttk::label .n.f0.3rd.subnote.awa.awa$i -compound left -text "\[$awPts\]\n$awName\n\"$awDesc\"" -anchor nw -background LightGrey -padding "5 0 0 0"
		.n.f0.3rd.subnote.awa.awa window create $i.end -window .n.f0.3rd.subnote.awa.awa$i
		.n.f0.3rd.subnote.awa.awa$i configure -image Trophy$awTrop

		.n.f0.3rd.subnote.awa.awa insert $i.end "\n"
		#.n.f0.3rd.subnote.awa.awa configure -state disabled
				
		set ::NewAwardID $i;# ...the hell is this

		# Inserts awardfile into database!
		if {[dbSTAT exists "SELECT name FROM sqlite_master WHERE type='table' AND name=\"$awardtable\" ";]} {
#		dbSTAT eval "INSERT INTO \"$awardtable\" (gid,aid,name,type,points,class,description,status) values ('$gameid','$i','$awName','$awType','$awPts','$awTrop','$awDesc','0');"  ;#ok. laittaa awardit dbhen failaa ylapilkun

		dbSTAT eval "INSERT INTO \"$awardtable\" (gid,aid,name,type,points,class,description,status) values ('$gameid','$i','$awName','$awType','$awPts','$awTrop','$awDesc','0');"  ;#ok. laittaa awardit dbhen

		}
		incr i
	}
}

proc AwardDisplay {} {
.n.f0.3rd.subnote.awa.awa delete 1.0 end
	set aw "_award"
	$::Console0 insert end "Display Awards.\n"
	set result [dbSTAT eval "SELECT * FROM $::SelectedDB$aw WHERE gid=\"$::awardID\" ";]

	set aids [dbSTAT eval "SELECT aid FROM $::SelectedDB$aw WHERE gid=\"$::awardID\" ORDER BY aid ASC";]
	set names [dbSTAT eval "SELECT name FROM $::SelectedDB$aw WHERE gid=\"$::awardID\" ORDER BY aid ASC";]
	set types [dbSTAT eval "SELECT type FROM $::SelectedDB$aw WHERE gid=\"$::awardID\" ORDER BY aid ASC";]
	set points [dbSTAT eval "SELECT points FROM $::SelectedDB$aw WHERE gid=\"$::awardID\" ORDER BY aid ASC";]
	set class [dbSTAT eval "SELECT class FROM $::SelectedDB$aw WHERE gid=\"$::awardID\" ORDER BY aid ASC";]
	set descrs [dbSTAT eval "SELECT description FROM $::SelectedDB$aw WHERE gid=\"$::awardID\" ORDER BY aid ASC";]
	set status [dbSTAT eval "SELECT status FROM $::SelectedDB$aw WHERE gid=\"$::awardID\" ORDER BY aid ASC";]

	set i "1"
	set totalRows [dbSTAT eval "SELECT aid FROM $::SelectedDB$aw WHERE gid=\"$::awardID\" ORDER BY aid DESC LIMIT 1";]
	for {set x 0} {$x<$totalRows} {incr x} {

		set awName [lindex $names $x]
		set awType [lindex $types $x]
		set awPts [lindex $points $x]
		set awTrop [lindex $class $x]
		set awDesc [lindex $descrs $x]
		set awStat [lindex $status $x]

		set ::awardtrophydataTotal [expr $::awardtrophydataTotal + $awPts]

	set dummyhax " (.";# for those entries without comma or bracet
	set id $::selectedRomFast$dummyhax
	set id [string range $id 0 [string first " (" $id]-1 ]
	#$::Console0 insert end "./AWA/$::SelectedDB/$id/$i.png.\n"
		# Award Images
		if {[file exists "./AWA/$::SelectedDB/$id/$i.png"]} {
			image create photo award$i -file "./AWA/$::SelectedDB/$id/$i.png"
		} else {
			image create photo award$i -file "./AWA/noawimg.gif"
		}

		tk::button .n.f0.3rd.subnote.awa.awa.row$i -compound left -image "award$i" -text "" -relief raised -command "toggleNewAward {$i} {$awName} {$awType} {$awDesc} {$awStat}"
		.n.f0.3rd.subnote.awa.awa window create $i.0 -window .n.f0.3rd.subnote.awa.awa.row$i

		image create photo Trophy$awTrop -file "./AWA/Trophy_$awTrop.png"

		set awdLine1 [string range " \[$awPts\]\t$awStat" 0 40]
		set awdLine2 [string range "\n$awName" 0 40]
		set awdLine3 [string range "\n\"$awDesc\"" 0 40]
		ttk::label .n.f0.3rd.subnote.awa.awa$i -compound left -text "$awdLine1$awdLine2$awdLine3" -anchor nw -background LightGrey -padding "5 0 0 0"

#		ttk::label .n.f0.3rd.subnote.awa.awa$i -compound left -text " \[$awPts\]\t$awStat\n$awName\n\"$awDesc\"" -anchor nw -background LightGrey -padding "5 0 0 0"
		.n.f0.3rd.subnote.awa.awa window create $i.end -window .n.f0.3rd.subnote.awa.awa$i
		.n.f0.3rd.subnote.awa.awa$i configure -image Trophy$awTrop

		# is the award received -- add colours accordingly
		if {$awStat eq "0"} {
		.n.f0.3rd.subnote.awa.awa.row$i configure -bg black
		} else {
		.n.f0.3rd.subnote.awa.awa.row$i configure -bg gold
		set ::awardtrophydataUser [expr $::awardtrophydataUser + $awPts]
		}
		.n.f0.3rd.subnote.awa.awa insert $i.end "\n"

		incr i
	}
	foreach child [winfo children .n.f0.3rd.subnote.awa.awa] {
	bind $child <Button-4> {event generate .n.f0.3rd.subnote.awa.awa <Button-4>}
	bind $child <Button-5> {event generate .n.f0.3rd.subnote.awa.awa <Button-5>}
	#	$::Console2 insert end "child> $child\n"
	}
}

proc CheckDBAwards {} {
.n.f0.3rd.subnote.awa.awa delete 1.0 end
getAwardfilename
	if {[file exists "$::AwardFilename"]} {
		set aw "_award"
		set awardtable $::SelectedDB$aw
		set ::awardID $::textfromRomlist
		set ::awardtrophydataTotal "0"
		set ::awardtrophydataUser "0"
		
		if {[dbSTAT exists "SELECT name FROM sqlite_master WHERE type='table' AND name=\"$awardtable\" ";]} {
		} else {
		dbSTAT eval "CREATE TABLE \"$awardtable\" (gid, aid, name, type, points, class, description, status);"
		}
		
		set result [dbSTAT eval "SELECT * FROM $::SelectedDB$aw WHERE gid=\"$::awardID\" LIMIT 1";]
		$::Console0 insert end "zx! result - $result!\n"

		if {[string length $result]} {
# since the DB holds the parsed data, we'll use that instead.
AwardDisplay

		} else {
# renders the awardfile then parses it into the DB 
AwardParser
AwardDisplay
		}
	.n.f0.3rd.subnote.awa.progress configure -maximum $::awardtrophydataTotal -value $::awardtrophydataUser
	}
}

proc clearAwards {} {
	# TODO - Check if ' causes errors
	set ::awardID $::textfromRomlist
	set aw "_award"
	$::Console0 insert end "Clearing Award entries...\nDELETE FROM $::SelectedDB$aw WHERE gid=$::awardID\n"

	if {[dbSTAT exists "SELECT name FROM sqlite_master WHERE type='table' AND name=\"$::SelectedDB$aw\" ";]} {
		dbSTAT eval "DELETE FROM $::SelectedDB$aw WHERE gid=\"$::awardID\" "
		set pAwards [dbSTAT eval "SELECT * FROM $::SelectedDB$aw "]
		$::Console0 insert end "Award entries...$pAwards\n"
		tk_messageBox -message "- Removed $::awardID from database.\n\n- You still need to delete the text file from ixbar3000/AWA/$::SelectedDB/$::awardID.txt."
	} else {
		$::Console0 insert end "Warning! No Award entries\n"
	}
	.n.f0.3rd.subnote.awa.awa delete 1.0 end

}




# 	=	=	=	=	=	=	=	=	=	=	=	=	=	=	=	=	AWARD FUNCTIONS (END)
