proc getAwardfilename {} {
# what awrd are we using
	set dummyhax " (.";# for those entries without comma or bracet
	set awardID $::selectedRomFast$dummyhax
	set awardID [string range $awardID 0 [string first " (" $awardID]-1 ]	
#	set ::awardID $::textfromRomlist
	set ::AwardFilename "$::HOMEDIR/AWA/$::SelectedDB/$awardID.txt"
}

proc openAwardeditor {} {
# This will edit the awards textfile
	tk::toplevel .awedit
	wm title .awedit "Award Editor"
	wm geometry .awedit 800x500+100+50

DisableThirdPanel

getAwardfilename
	$::Console0 insert end "GAME IS...\n$::AwardFilename\n"

	if {[file exists "$::AwardFilename"]} {
	$::Console0 insert end "Awardfile exists\n"
	} else {
	$::Console0 insert end "Awardfile NOT exists... Create\n"
	# make dir
	file mkdir "$::HOMEDIR/AWA/$::SelectedDB"

#	set filename "$::AwardFilename"
	set fp [open "$::AwardFilename" w]
	close $fp
	}

#Create GUI
ttk::button .awedit.addnew -text "New" -command {AwardeditorNewAw}	;				grid .awedit.addnew -column 1 -row 100 -sticky nw
#ttk::label .awedit.trophydata -text "Trophy Data: " -anchor w;						grid .awedit.trophydata -column 3 -row 100 -sticky we
ttk::label .awedit.trophydatavar -textvariable awardtrophydatapts;					grid .awedit.trophydatavar -column 4 -row 100 -sticky we

ttk::labelframe .awedit.editframe -text "Edit Award:" -labelanchor n -width 300;	grid .awedit.editframe -column 1 -columnspan 4 -row 101 -sticky w
ttk::label .awedit.editframe.name -text "Name: " -anchor w;							grid .awedit.editframe.name -column 1 -row 2 -sticky we
ttk::entry .awedit.editframe.namevar -textvariable awardname;						grid .awedit.editframe.namevar -column 2 -row 2 -sticky we
ttk::label .awedit.editframe.desc -text "Description: " -anchor w;					grid .awedit.editframe.desc -column 1 -row 3 -sticky we
ttk::entry .awedit.editframe.descvar -textvariable awarddesc;						grid .awedit.editframe.descvar -column 2 -row 3 -sticky we
ttk::label .awedit.editframe.pts -text "Points: " -anchor w;						grid .awedit.editframe.pts -column 1 -row 4 -sticky we
ttk::entry .awedit.editframe.ptsvar -textvariable awardpts;							grid .awedit.editframe.ptsvar -column 2 -row 4 -sticky we
ttk::label .awedit.editframe.trop -text "Trophy: " -anchor w;						grid .awedit.editframe.trop -column 1 -row 5 -sticky we
ttk::entry .awedit.editframe.tropvar -textvariable awardtrop;						grid .awedit.editframe.tropvar -column 2 -row 5 -sticky we
ttk::label .awedit.editframe.type -text "Type: " -anchor w;							grid .awedit.editframe.type -column 1 -row 6 -sticky we
ttk::entry .awedit.editframe.typevar -textvariable awardtype;						grid .awedit.editframe.typevar -column 2 -row 6 -sticky we
ttk::button .awedit.editframe.save -text "Save" -command {saveAwardChanges 1}  -state disabled	;	grid .awedit.editframe.save -column 2 -row 10 -sticky new
ttk::button .awedit.editframe.dele -text "Remove" -command {saveAwardChanges 2}  -state disabled	;	grid .awedit.editframe.dele -column 1 -row 10 -sticky new

# -width $awBoxwidth
tk::text .awedit.area -width 110 -height 20;										grid .awedit.area -column 1 -columnspan 4 -row 1 -sticky w
ttk::scrollbar .awedit.scroll -orient vertical -command ".awedit.area yview";		grid .awedit.scroll -column 4 -row 1 -sticky nse

loadAwardfile
#.awedit.editframe.save -state disabled
#.awedit.editframe.dele -state disabled
}

proc AwardeditorNewAw {} {
# Create temporary award
set ::NewAwardID "1"
set data ">$::NewAwardID;NAME;bool;0;1;DESCRIPTION;\n"

# Open for writing and write
#	set filename "$::HOMEDIR/AWA/SNES/F-Zero2.txt"
	set fp [open "$::AwardFilename" a]
	puts -nonewline $fp $data
	close $fp
loadAwardfile
}

proc loadAwardfile {} {
.awedit.area delete 1.0 end

#open awardfile
#	set filename "$::HOMEDIR/AWA/SNES/F-Zero2.txt"
	set fp [open "$::AwardFilename" r]
	set file_data [read $fp]

# perhaps some other char would be in order, for the last line is olways empty.
	set data [split $file_data "\n"]

	set ::awardtrophydatapts "0"
	set awardtrophydataT1 "0"
	set awardtrophydataT2 "0"
	set awardtrophydataT3 "0"
	set awardtrophydataT4 "0"
	set i "1"
	foreach line $data {
	set testi [split $line ";"]
	#$::Console0 insert end "$file_data\n"
	set awName [lindex $testi 1]
	set awType [lindex $testi 2]
	set awPts [lindex $testi 3]
	set awTrop [lindex $testi 4]
	set awDesc [lindex $testi 5]
#	ttk::button .awedit.area.row$i -text "$awName $i" -command {openAwardeditor} -width 20	;		grid .awedit.area.row$i -column 1 -row $i -sticky ne

if {$awName eq ""} {
break
}


	ttk::button .awedit.area.row$i -text "Edit" -width 5 -command "updateEditframe $i {$awName} {$awType} {$awPts} {$awTrop} {$awDesc}"
	.awedit.area window create $i.0 -window .awedit.area.row$i

	.awedit.area insert $i.end "$i> <$awType> \["

image create photo Trophy$awTrop -file "./AWA/Trophy_$awTrop.png"
.awedit.area image create $i.end -image Trophy$awTrop
	.awedit.area insert $i.end "$awPts\] $awName \"$awDesc\"\n"

set ::awardtrophydatapts [expr $::awardtrophydatapts + $awPts]

if {$awTrop eq "1"} {
incr awardtrophydataT1
} elseif {$awTrop eq "2"} {
incr awardtrophydataT2
} elseif {$awTrop eq "3"} {
incr awardtrophydataT3
} elseif {$awTrop eq "4"} {
incr awardtrophydataT4
}

	incr i
set ::NewAwardID $i
	}
#set ::awardtrophydatapts $::NewAwardID
set ::awardtrophydatapts "Trophy Data> points:$::awardtrophydatapts, Trophies: B:$awardtrophydataT1 S:$awardtrophydataT2 G:$awardtrophydataT3 P:$awardtrophydataT4"
}

proc updateEditframe {awID awName awType awPts awTrop awDesc} {
set ::awardid "$awID"
set ::awardname "$awName"
set ::awarddesc "$awDesc"
set ::awardpts "$awPts"
set ::awardtrop "$awTrop"
set ::awardtype "$awType"
.awedit.editframe.save configure -state normal
.awedit.editframe.dele configure -state normal
}

proc saveAwardChanges {mode} {
# 1 = Edit; 2 = Remove

#open awardfile
#	set filename "$::HOMEDIR/AWA/SNES/F-Zero2.txt"
	set fp [open "$::AwardFilename" r]
	set file_data [read $fp]
	close $fp
# perhaps some other char would be in order, for the last line is olways empty.
	set data [split $file_data "\n"]

set preAwardfile ""
set postAwardfile ""

	set i "1";# Separate Lines
	foreach line $data {
		if {$i < $::awardid} {
		lappend preAwardfile $line
		}
		if {$i > $::awardid} {
		lappend postAwardfile $line
		}
	incr i
	}


# This handles emptylines
set linechanger ""
set linechangerPost ""
if {[llength $preAwardfile] > 0} {
set linechanger "\n"
}
if {[llength $postAwardfile] > 0} {
set linechangerPost "\n"
}

# remove list junk...
set preAwardfile [string map {\{ ""} $preAwardfile]
set preAwardfile [string map {\} ""} $preAwardfile]
set preAwardfile [string map {" >" "\n>"} $preAwardfile]
set postAwardfile [string map {\{ ""} $postAwardfile]
set postAwardfile [string map {\} ""} $postAwardfile]
set postAwardfile [string map {" >" "\n>"} $postAwardfile]

# Generate new awardfile.
if {$mode eq "1"} {
	set data "$preAwardfile$linechanger>$::awardid;$::awardname;$::awardtype;$::awardpts;$::awardtrop;$::awarddesc;$linechangerPost$postAwardfile"
} elseif {$mode eq "2"} {
	set data "$preAwardfile$linechanger$postAwardfile"
}

# Open for writing and write
#	set filename "$::HOMEDIR/AWA/SNES/F-Zero2.txt"
	set fp [open "$::AwardFilename" w+]
	puts -nonewline $fp $data
	close $fp

# Reload award into aw-window
loadAwardfile
}
