proc resetJoystick {} {
	# Sometimes SDL library fails to poll right.
	# instead of value 2 -> value 4. This can be resolved by rescanning the joystick
	# only for linux. win ok??
	if {$::DetectedOS eq "LIN"} {
		joystick rescan
	}
}

set bJoystick 0;				# 1 on ; 0 off
set ::joyNum 0
set ::joystickOK 0


if {$bJoystick} {; # Load proper driver
	# Load sdl binding based on OS and bits, disable further code if no joysticks found
	logtext "- Loading joystick drivers..." 1
	if {$::DetectedOS eq "LIN"} {;			# load linux driver
		# TODO -- Add check for OS-bit
		load $::HOMEDIR/SYS/mkLibsdl/x32/mkLibsdl10.so
		set ::joystickOK 1
		logtext "-- mkLibsdl10 loaded(l)" 1
		if {[joystick count] eq 0} {;		# Check joysticks, if none present cancel loading
			set ::joystickOK 0
		}
	} elseif {$::DetectedOS eq "WIN"} {;	# load windows driver
		#load $::HOMEDIR/SYS/mkLibsdl/x32/SDL.dll
		load $::HOMEDIR/SYS/mkLibsdl/x32/mkLibsdl10.dll
		set ::joystickOK 1
		logtext "-- mkLibsdl10 loaded(w)" 1
		if {[joystick count] eq 0} {;		# Check joysticks, if none present cancel loading
			set ::joystickOK 0
		}
	} else {;								# no driver loaded
		set ::joystickOK 0
		logtext "-- ERROR! no Joystickdriver found" 1
	}
	set ::cabinetCtrl "RL"

} else {
	set ::joystickOK 0
	set ::cabinetCtrl "RL"
}


if {$::joystickOK} {
	# Calibrate, bind buttons and poll events.
	logtext "- Calibrating..." 1
	joystick configure $::joyNum -maxvalue 1000 -deadzone 100

	set joyValidate 1
	logtext "- Validating ..." 1
	if {[joystick info $::joyNum hats] > 0} {
	} else {
		logtext "-- Joystick Error> 1 D-pad required!" 1
		set joyValidate 0
	}
	if {[joystick info $::joyNum buttons] > 2} {
	} else {
		logtext "-- Joystick Error> 3 Buttons required!" 1;# TODO -- ATM it requires 9 buttons -> map buttons better
		set joyValidate 0
	}

	if {$joyValidate eq 1} {
		logtext "-- Joystick> OK!" 1
	} else {
		logtext "-- Joystick> Failed to bind Joystick!" 1
	}


	joystick event eval { 
		set jPol [joystick event peek]

		if { $jPol eq "joystick $::joyNum button 0 value 1" } {
			.n.f8.joystick.test configure -text B0
		} elseif { $jPol eq "joystick $::joyNum button 1 value 1" } {
			.n.f8.joystick.test configure -text B1
		} elseif { $jPol eq "joystick $::joyNum button 2 value 1" } {
			.n.f8.joystick.test configure -text B2
			#destroy .gameover
		} elseif { $jPol eq "joystick $::joyNum button 3 value 1" } {
			.n.f8.joystick.test configure -text B3
		} elseif { $jPol eq "joystick $::joyNum button 4 value 1" } {
			.n.f8.joystick.test configure -text B4
#			.n.f0.stattree focus 3
		} elseif { $jPol eq "joystick $::joyNum button 5 value 1" } {
			.n.f8.joystick.test configure -text B5
		} elseif { $jPol eq "joystick $::joyNum button 6 value 1" } {
			.n.f8.joystick.test configure -text PREV_LETTER
			if {[.n select] eq ".n.f0"} {
				joyNextLetter 1
			}
		} elseif { $jPol eq "joystick $::joyNum button 7 value 1" } {
			.n.f8.joystick.test configure -text NEXT_LETTER
			if {[.n select] eq ".n.f0"} {
				joyNextLetter 2
			}
		} elseif { $jPol eq "joystick $::joyNum button 8 value 1" } {
			.n.f8.joystick.test configure -text START

			if {[.n select] eq ".n.f0"} {
				StartApp $::selectedEmu $::selectedRomFast
			}
		} elseif { $jPol eq "joystick $::joyNum button 9 value 1" } {
			.n.f8.joystick.test configure -text B9
		} elseif { $jPol eq "joystick $::joyNum button 10 value 1" } {
			.n.f8.joystick.test configure -text B10
		} elseif { $jPol eq "joystick $::joyNum button 11 value 1" } {
			.n.f8.joystick.test configure -text B11
		} elseif { $jPol eq "joystick $::joyNum button 12 value 1" } {
			.n.f8.joystick.test configure -text B12
		} elseif { $jPol eq "joystick $::joyNum button 13 value 1" } {
			.n.f8.joystick.test configure -text B13
		}

		if { $jPol eq "joystick $::joyNum hat 0 value 1" } {;		# hat-Up (select prev)
			.n.f8.joystick.test configure -text UP

			if {[.n select] eq ".n.f0"} {
				if { $::cabinetCtrl eq "RL" } {
					joyPrevItem
				} elseif { $::cabinetCtrl eq "SL" } {
					resetJoystick
					joyPrevSys
				} else {
					$::Console0 insert end "Warning! Joystick in weird state"
				}
			}
		} elseif { $jPol eq "joystick $::joyNum hat 0 value 2" } {;	# hat-Right (goto items)
			.n.f8.joystick.test configure -text RIGHT

			if {[.n select] eq ".n.f0"} {
				set ::cabinetCtrl "RL"
				wm title . "$::ixbarversion : ($::TotalSelectedItems) <Items>"
				joyFirstItem
			}
			#$::Console0 insert end "($::cabinetCtrl) J-->\n$jPol\n"
		} elseif { $jPol eq "joystick $::joyNum hat 0 value 4" } {;	# hat-Down (select next)
			.n.f8.joystick.test configure -text DOWN
			if {[.n select] eq ".n.f0"} {
				if { $::cabinetCtrl eq "RL" } {
					joyNextItem
				} elseif { $::cabinetCtrl eq "SL" } {
					resetJoystick
					joyNextSys
				} else {
					$::Console0 insert end "Warning! Joystick in weird state"
				}
			}
		} elseif { $jPol eq "joystick $::joyNum hat 0 value 8" } {;	# hat-Left (goto systems)
			.n.f8.joystick.test configure -text LEFT

			if {[.n select] eq ".n.f0"} {
				set ::cabinetCtrl "SL"
				if {[info exists ::RLitem]} {;unset ::RLitem;}
				wm title . "$::ixbarversion : ($::TotalSelectedItems) <Systems>"
			}
		}

	}

} else {
	logtext "-- Joystick Error> No JoystickOK variable!" 1
}


