# EXODOS parser for EXODOS v2 -- 14/07/2015
# .1 lowercase everything, improved conf-export.

# set the base directory
set exodosgames "$::HOMEDIR/TMP/IBMPC"	;# This is where data is extracted
set exodosgameszip "$::RomDirectory"	;# 1st try for searching (DO NOT EDIT -- this is set from within the program)

# EDIT THE FOLLOWING SECTION FOR 
set exoROOT "$exodosgameszip"			;# the root directory
set eXoDOS2actDir "/eXoDOS2act/Games/"	;# action set
set eXoDOS2advDir "/eXoDOS2adv/Games/"	;# adventure set
set eXoDOS2rpgDir "/eXoDOS2rpg/Games/"	;# rpg set
set eXoDOS2simDir "/eXoDOS2sim/Games/"	;# simulation set
set eXoDOS2strDir "/eXoDOS2str/Games/"	;# strategy set

# NO USER EDITABLE DATA BEYOND THIS LINE !

# make dir for extracted data if one does not exists
if {![file exists $exodosgames]} {	;# find 7z with conf-files
	$::Console0 insert end "\nData directory doesn't exitst, make one."
	file mkdir $exodosgames
}

# get the unique name using romlist entry
set uniqueID [dbDATA eval "SELECT crc FROM \"$::SelectedDB\" WHERE name=\"$::selectedRomFast\" ";]

set dosconf "$::HOMEDIR/MOJO/EXO2_conf/$uniqueID.conf"	;# config directory
set TMPgamedir "$exodosgames/$uniqueID"					;# extracted files go here
$::Console0 insert end "\nEXODOS LOADER v2>> $uniqueID\n$exodosgames/$uniqueID\na)$::RomDirectory\nb)$exodosgameszip\nc)$dosconf"
set exo2act "$exoROOT$eXoDOS2actDir$::selectedRomFast.zip"
set exo2adv "$exoROOT$eXoDOS2advDir$::selectedRomFast.zip"
set exo2rpg "$exoROOT$eXoDOS2rpgDir$::selectedRomFast.zip"
set exo2sim "$exoROOT$eXoDOS2simDir$::selectedRomFast.zip"
set exo2str "$exoROOT$eXoDOS2strDir$::selectedRomFast.zip"

# Extract configs
if {[file exists "$::HOMEDIR/MOJO/EXO2_conf/E2_conf.7z"]} {	;# find 7z with conf-files
	$::Console0 insert end "\nEXODOS LOADER v2>> Found E2_conf! Extracting..."
	tk_messageBox -message "Extracting Exodos v2 configuration files...\nPlease click OK and wait."
	exec 7za x $::HOMEDIR/MOJO/EXO2_conf/E2_conf.7z -o$::HOMEDIR/MOJO/EXO2_conf/ -aos
	file delete "$::HOMEDIR/MOJO/EXO2_conf/E2_conf.7z"		;# delete the 7z
	tk_messageBox -message "Configuration files OK.\nProceeding to data extraction."
}




# Extract data.
if {[string length [glob -nocomplain $TMPgamedir/*] ] > 0} {
	$::Console0 insert end "\nEXODOS2 LOADER>Already extracted. OK to load>\n"







} else {
	$::Console0 insert end "\nEXODOS2 LOADER>TMPgamedir does NOT exists>extract.\n\n"
	# check if zip exists
	set archiveName "$exodosgameszip/$::selectedRomFast.zip"
	if {[file exists "$archiveName"]} {
		$::Console0 insert end "\nArchive found!\n$archiveName\n"
		exec 7za x $archiveName -o$exodosgames/ -aos

	} elseif {[file exists "$exo2act"]} {
		$::Console0 insert end "\nArchive found in act!\n$archiveName\n"
		exec 7za x $exo2act -o$exodosgames/ -aos
		#set TMPgamedirFound ""
	} elseif {[file exists "$exo2adv"]} {
		$::Console0 insert end "\nArchive found in adv!\n$archiveName\n"
		exec 7za x $exo2adv -o$exodosgames/ -aos
	} elseif {[file exists "$exo2rpg"]} {
		$::Console0 insert end "\nArchive found in rpg!\n$archiveName\n"
		exec 7za x $exo2rpg -o$exodosgames/ -aos
	} elseif {[file exists "$exo2sim"]} {
		$::Console0 insert end "\nArchive found in sim!\n$archiveName\n"
		exec 7za x $exo2sim -o$exodosgames/ -aos
	} elseif {[file exists "$exo2str"]} {
		$::Console0 insert end "\nArchive found in str!\n$archiveName\n"
		exec 7za x $exo2str -o$exodosgames/ -aos
	} else {
		$::Console0 insert end "\nError! Archive NOT found!\n"
	}


}


proc setLowercase {TMPgamedir} {
# After extracting, do a linux hack.
	$::Console0 insert end "\nEXO-LOADER>applying linux fix. $TMPgamedir\n"
	$::Console0 insert end "============================================\n"
	# Linux only hack. Linux is case sensitive, DOS isn't. This is bad as cd != CD.
	# This hack changes the directories to small case. And there shouldn't be any problesm with it.

		set files [glob -nocomplain $TMPgamedir/*];#		BASEDIR
		foreach files2 $files {
			set fileToMatch [string range $files2 [string last "/" $files2]+1 end]
			set fileToFix [string tolower $fileToMatch]
			set fileToUse "$TMPgamedir/$fileToFix"

		#$::Console0 insert end "\n>mm:$fileToFix -> $fileToMatch\n"
			if {![string match $fileToFix $fileToMatch]} {
				file rename -force -- $files2 $fileToUse   ;# ! overwrites existing files !
			}
		}

		set subdirs [glob -nocomplain -type d $TMPgamedir/*]

		foreach dir $subdirs {
			set dirToMatch [string range $dir [string last "/" $dir]+1 end]
			set dirToFix [string tolower $dirToMatch]
			set dirToUse "$TMPgamedir/$dirToFix"

	# This renames all files into lowercase.
		foreach dir2 $dir {;# subdirs
			set files [glob -nocomplain $dir2/*]

			foreach files2 $files {;# subdirfiles
				set fileToMatch [string range $files2 [string last "/" $files2]+1 end]
				set fileToFix [string tolower $fileToMatch]
				set fileToUse "$dir2/$fileToFix"
			
				if {![string match $fileToFix $fileToMatch]} {
					file rename -force -- $files2 $fileToUse   ;# ! overwrites existing files !
				}
			}
		}

		if {![string match $dirToFix $dirToMatch]} {
			file rename -force -- $dir $dirToUse   ;# ! overwrites existing dirs !
		}
		
	};#End linux hack
}



proc fixCuesheet {TMPgamedir} {
	$::Console0 insert end "<CUE FIXER>\n"

	set cuedir "$TMPgamedir/cd";# lets presume that we only have this one dir containing files
	set files [glob -nocomplain $cuedir/*]

	foreach files2 $files {;# get all files and filter the cues
		set fileToMatch [string range $files2 [string last "/" $files2]+1 end]
		set fileToFix [string tolower $fileToMatch]
		set fileToUse "$cuedir/$fileToFix"

		if { [string range $fileToMatch [string last "." $fileToMatch]+1 end] eq "cue" } {
		$::Console0 insert end "\nfixing cue> $files2>\n"
			set fileId [open $files2 r]
			set file_data [read $fileId]
			# TODO -- search: FILE "gk21.img" BINARY -- regex or similar would be better, but for now:
			set file_data [string tolower $file_data];# lowercase target it the referred file.
			set file_data [string map "file FILE" $file_data];# fix keywords
			set file_data [string map "binary BINARY" $file_data]
			set file_data [string map "track TRACK" $file_data]
			set file_data [string map "index INDEX" $file_data]
			set file_data [string map "mode MODE" $file_data]
			close $fileId

			set fileId [open $files2 w]
			puts -nonewline $fileId "$file_data"
			close $fileId
		}
	}
}


if {$::DetectedOS eq "LIN"} {
	setLowercase "$TMPgamedir"
	fixCuesheet "$TMPgamedir"
}


proc findMultiImages {txt str} {
	set count [regexp -all ***=$str $txt]
	if {$count > 2} {
	tk_messageBox -message "Multiple mounted images found!\npress Ctrl-F4 to change."
	}
}


if {[file exists "$dosconf"]} {
# This parses the conf file, if found, into proper form.
	$::Console0 insert end "\nDos.config found!>\n$dosconf\n"
	set flag_autoexec 0;# 0 until autoexec-line is found

	# open the conf
		set fp [open $dosconf r]
		set file_data [read $fp]
		close $fp
		set data [split $file_data "\n"]

	foreach line $data {
		# Find autoexec and set flag
		set result [regexp {autoexec} $line match]
		if {$result} {
		set flag_autoexec 1
		}

		if {$flag_autoexec eq 1} {
			# test line, remove if not important
			set lineEcho [string range $line 0 3]
			if {$lineEcho eq "echo" || $lineEcho eq "@ech" || $lineEcho eq "cls" || $lineEcho eq "exit" || \
				$lineEcho eq "cd ." || $lineEcho eq "paus" || $lineEcho eq ""  } {

			} else {
				#set lineEcho2 [string map {@ ""} $lineEcho2]
				set line [string map {@ ""} $line]
				set lineEcho2 [string range $line 0 2]
				#TODO Fix everything!, but this small fix too. for the extra at-chars

			#$::Console0 insert end "<$lineEcho2> "
				if {$lineEcho2 eq "mou"} {								;# FILES
#					$::Console0 insert end "Mount1: $line\n"
					set line [string map {"  " " "} $line]
					set line [string map {\" ""} $line]
					set line [string map {.\\ "\""} $line]					;# 027cr3 added
					set line [string map {\\ \/} $line]
					
					if {[string index $line end] eq " "} {
						set line [string range $line 0 end-1]
					}
					set line "$line\""										;# 027cr3 added
					
					if { [regexp { -t cdrom} $line match] } {				;# 027cr3 added exeption for non-imagemount
						set line [string map {\ -t \"\ -t} $line]						
						set line [string range $line 0 end-1]
					}
					
					set line [string map "games \"$exodosgames\"" $line]	;# 027cr3 added quotes
#					$::Console0 insert end "Mount2: $line -$exodosgames-\n"
					append EDexec "$line\n"
					
				
				} elseif {$lineEcho2 eq "img"} {						;# IMAGES
					#set line [string map {.\\ ""} $line]
					#set line [string map {\\ \/} $line]
					set line [string map {\" ""} $line]
					set line [string map {\ .\\ "\"\ \""} $line]					;# 027cr3 added
					set line [string map {\\ \/} $line]
					
					if {[string index $line end] eq " "} {
						set line [string range $line 0 end-1]
					}
					set line "$line\""										;# 027cr3 added
					
					if { [regexp { -t } $line match] } {				;# 027cr3 added exeption for non-imagemount
					#	set line [string map {\ -t \"\ -t} $line]						
						set line [string range $line 0 end-1]
					}
					
					
					set line [string map {\ -t \"\ -t} $line]						;# 027cr3 added
					set line [string map {imgmount\ d\" imgmount\ d} $line]					;# 027cr3 added
					set line [string map {imgmount\ c\" imgmount\ c} $line]					;# 027cr3 added
					set line [string map "games \"$exodosgames\"" $line]	;# 027cr3 added quotes
#					$::Console0 insert end "CD Mount: $line\n"
					append EDexec "$line\n"

				} elseif {$lineEcho2 eq "cd "} {
				#$::Console0 insert end "Directory: $line\n"
				append EDexec "$line\n";# c:
				} elseif {[string index $lineEcho2 0] eq "#"} {
				#$::Console0 insert end "!!!!: $line\n"

				} else {
				#$::Console0 insert end "exec: $line\n"
				append EDexec $line\n

if {$::DetectedOS eq "LIN"} {
				# put lowercase on subdirs and files. keep the structure intact. Linux only.
				set EDexec [string tolower $EDexec]
				set TMPgamedirLC [string tolower $TMPgamedir]
				set EDexec [string map "$TMPgamedirLC $TMPgamedir" $EDexec]
				#$::Console0 insert end "zzzzz: $TMPgamedirLC\n"
				#$::Console0 insert end "yyyyy: $TMPgamedir\n"
}

				# Create conf file for dosbox
				set data "$EDexec"
				set filename "$::HOMEDIR/SYS/dosbox.conf"
				set fileId [open $filename "w"]
				puts -nonewline $fileId $data
				close $fileId

				}
			}
		}
	}
				findMultiImages $EDexec $exodosgames
}


