# EXODOS parser for WIN3x0 v2 -- 05/08/2015


# set the base directory
set exodosgames "$::HOMEDIR/TMP/WIN3X"	;# This is where data is extracted
set exodosgameszip "$::RomDirectory"	;# 1st try for searching (DO NOT EDIT -- this is set from within the program)

# NO USER EDITABLE DATA BEYOND THIS LINE !

# make dir for extracted data if one does not exists
if {![file exists $exodosgames]} {	;# find 7z with conf-files
	$::Console0 insert end "\nData directory doesn't exitst, make one."
	file mkdir $exodosgames
}


# get the unique name using romlist entry
set uniqueID [dbDATA eval "SELECT crc FROM \"$::SelectedDB\" WHERE name=\"$::selectedRomFast\" ";]

set dosconf "$::HOMEDIR/MOJO/EXOw_conf/$uniqueID.conf"	;# config directory
set TMPgamedir "$exodosgames/$uniqueID"					;# extracted files go here
$::Console0 insert end "\nEXO LOADER v2>> $uniqueID\n$exodosgames/$uniqueID\na)$::RomDirectory\nb)$exodosgameszip\nc)$dosconf"


# Extract configs
if {[file exists "$::HOMEDIR/MOJO/EXOw_conf/EW_conf.7z"]} {	;# find 7z with conf-files
	$::Console0 insert end "\nEXO LOADER v2>> Found EW_conf! Extracting..."
	tk_messageBox -message "Extracting WIN3X v2 configuration files...\nPlease click OK and wait."
	exec 7za x $::HOMEDIR/MOJO/EXOw_conf/EW_conf.7z -o$::HOMEDIR/MOJO/EXOw_conf/ -aos
	file delete "$::HOMEDIR/MOJO/EXOw_conf/EW_conf.7z"		;# delete the 7z
	tk_messageBox -message "Configuration files OK.\nProceeding to data extraction."
}



# Extract data.
if {[string length [glob -nocomplain $TMPgamedir/*] ] > 0} {
	$::Console0 insert end "\nEXO LOADER> Already extracted. OK to load>\n"
} else {
	$::Console0 insert end "\nEXO LOADER>TMPgamedir does NOT exists>extract.\n"
	# check if zip exists
	set archiveName "$exodosgameszip/$::selectedRomFast.zip"
	if {[file exists "$archiveName"]} {
		$::Console0 insert end "\nArchive found!\n$archiveName\n"
		exec 7za x $archiveName -o$exodosgames/ -aos
	} else {
		$::Console0 insert end "\nError! Archive NOT found!\n"
	}

		if {$::DetectedOS eq "LIN"} {
		$::Console0 insert end "\nEXO LOADER>applying linux fix.\n"
		# Linux only hack. Linux is case sensitive, DOS isn't. This is bad as cd != CD.
		# This hack changes the directories to small case. And there shouldn't be any problesm with it.
			set subdirs [glob -nocomplain -type d $TMPgamedir/*]
			foreach dir $subdirs {
				set dirToMatch [string range $dir [string last "/" $dir]+1 end]
				set dirToFix [string tolower $dirToMatch]
				set dirToUse "$TMPgamedir/$dirToFix"

		# This renames all files into lowercase.
			foreach dir2 $dir {;# subdirs
				set files [glob -nocomplain $dir2/*]

				foreach files2 $files {;# subdirfiles
					set fileToMatch [string range $files2 [string last "/" $files2]+1 end]
					set fileToFix [string tolower $fileToMatch]
					set fileToUse "$dir2/$fileToFix"
			
					if {![string match $fileToFix $fileToMatch]} {
						file rename -force -- $files2 $fileToUse   ;# ! overwrites existing files !
					}
					if { [string range $fileToMatch [string last "." $fileToMatch]+1 end] eq "cue" } {
						$::Console0 insert end "\nfixing> $files2>\n"
						#set filename "/media/Gensokyo/ixbar3000/ROM/WIN3X/GK23x/cd/gk21.cue"
						set fileId [open $files2 r]
						set file_data [read $fileId]
						# TODO -- search: FILE "gk21.img" BINARY -- regex or similar would be better, but for now:
						set file_data [string tolower $file_data];# lowercase target it the referred file.
						set file_data [string map "file FILE" $file_data];# fix keywords
						set file_data [string map "binary BINARY" $file_data]
						set file_data [string map "track TRACK" $file_data]
						set file_data [string map "index INDEX" $file_data]
						set file_data [string map "mode MODE" $file_data]
						close $fileId

						set fileId [open $files2 w]
						puts -nonewline $fileId "$file_data"
						close $fileId
					}
				}
			}

				if {![string match $dirToFix $dirToMatch]} {
					file rename -force -- $dir $dirToUse   ;# ! overwrites existing dirs !
				}
		}
		};#End linux hack

}


proc findMultiImages {txt str} {
	set count [regexp -all ***=$str $txt]
	if {$count > 2} {
	tk_messageBox -message "Multiple mounted images found!\npress Ctrl-F4 to change."
	}
}

proc chomp {line} {;#		rm last char if its space -- fixes some loadtime errors
	#tk_messageBox -message "chomp this <$line>"
	if {[string index $line end] eq " "} {
		set line [string range $line 0 end-1]
	}
	return $line
}


if {[file exists "$dosconf"]} {
# This parses the conf file, if found, into proper form.
	$::Console0 insert end "Dos.config found!>\n$dosconf\n"
	set flag_autoexec 0;# 0 until autoexec-line is found

	# open the conf
		set fp [open $dosconf r]
		set file_data [read $fp]
		close $fp
		set data [split $file_data "\n"]

	foreach line $data {
		# Find autoexec and set flag
		set result [regexp {autoexec} $line match]
		if {$result} {
		set flag_autoexec 1
		}

		if {$flag_autoexec eq 1} {
			# test line, remove if not important
			set lineEcho [string range $line 0 3]
			if {$lineEcho eq "echo" || $lineEcho eq "@ech" || $lineEcho eq "cls" || $lineEcho eq "exit" || \
				$lineEcho eq "cd ." || $lineEcho eq "paus" || $lineEcho eq "" } {

			} else {
				#set lineEcho2 [string map {@ ""} $lineEcho2]
				set line [string map {@ ""} $line]
				set lineEcho2 [string range $line 0 2]
				#TODO Fix everything!, but this small fix too. for the extra at-chars

#			$::Console0 insert end "<$lineEcho2> "
				if {$lineEcho2 eq "mou"} {								;# FILES
#					$::Console0 insert end "Mount1: $line\n"
					set line [string map {"  " " "} $line]
					set line [string map {.\\ "\""} $line]					;# 027cr3 added
					set line [string map {\\ \/} $line]
					#set exodosgames [string map {\/ \\} $exodosgames]
					
					set line [chomp $line]
					set line "$line\""										;# 027cr3 added
					
					if { [regexp { -t cdrom} $line match] } {				;# 027cr3 added exeption for non-imagemount
						set line [string map {\ -t \"\ -t} $line]						
						set line [string range $line 0 end-1]
					}

					if { [regexp {cd} $line match] } {				;# 027cr3 
						set line [string map {cd\/ cd} $line]		;# cd cannot end with this char
					}
					
					$::Console0 insert end "QWEWQE:$line\n"
					$::Console0 insert end "QWEWQE:[string index $line end-1]\n"
					if { [string index $line end-1] eq "\/" } {	;# 027cr3 
						#set line [string range $line 0 end-1]		;# 
						set line [string map {\/\" \"} $line]		;# cannot end with this char
					}
					
					
					set line [string map "games \"$exodosgames\"" $line]	;# 027cr3 added quotes
#					$::Console0 insert end "Mount2: $line -$exodosgames-\n"
					append EDexec "$line\n"
					
				
				} elseif {$lineEcho2 eq "img"} {						;# IMAGES
					#set line [string map {.\\ ""} $line]
					#set line [string map {\\ \/} $line]
					
				#	set line [string map {\ .\\ "\"\ \""} $line]		;#  .\ -> \ \ 
				
					set line [string map {\" ""} $line]					;# rm quotes
					set line [string map {\ .\\ "\"\ \""} $line]		;# uniform root
					set line [string map {\\ \/} $line]					;# \ -> /
					
					if {[string index $line end] eq " "} {
						set line [string range $line 0 end-1]
					}
					set line "$line\""										;# 027cr3 added
					
					if { [regexp { -t } $line match] } {				;# 027cr3 added exeption for non-imagemount
						set line [string range $line 0 end-1]
					}
					


					
					
					set line [string map {\ -t \"\ -t} $line]						;# 027cr3 added
					set line [string map {imgmount\ d\" imgmount\ d} $line]					;# 027cr3 added
					set line [string map {imgmount\ c\" imgmount\ c} $line]					;# 027cr3 added
					set line [string map "games \"$exodosgames\"" $line]	;# 027cr3 added quotes
#					$::Console0 insert end "CD Mount: $line\n"
					append EDexec "$line\n"

				} elseif {$lineEcho2 eq "cd "} {
#				$::Console0 insert end "Directory: $line\n"
				append EDexec "$line\n"
				} elseif {[string index $lineEcho2 0] eq "#"} {
#				$::Console0 insert end "!!!!: $line\n"

				} else {
#				$::Console0 insert end "exec: $line\n"
				set line [chomp $line]
				append EDexec $line\n


if {$::DetectedOS eq "LIN"} {
				# put lowercase on subdirs and files. keep the structure intact. Linux only.
				set EDexec [string tolower $EDexec]
				set TMPgamedirLC [string tolower $TMPgamedir]
				set EDexec [string map "$TMPgamedirLC $TMPgamedir" $EDexec]
				#$::Console0 insert end "$TMPgamedir\n$TMPgamedirLC\n=========\n $EDexec\n"
}
				# Create conf file for dosbox
				set data "$EDexec"
				set filename "$::HOMEDIR/SYS/dosbox.conf"
				set fileId [open $filename "w"]
				puts -nonewline $fileId $data
				close $fileId
				}
			}
		}
	}
				findMultiImages $EDexec $exodosgames
} else {
	$::Console0 insert end "ERROR! The dosconf-parser failed.\n"
}


