# Extracts romname.7z into TMP
# TODO Fails if more than one .bin -> find track 1

set TEMP $::HOMEDIR/TMP/
	# make dir
	file mkdir "$TEMP"

# Test if already extracted
set isoexists [glob -nocomplain -dir $TEMP $::selectedRomFast.bin]
set countbinintemp [llength [glob -nocomplain -dir $TEMP $::selectedRomFast*.bin]]
$::Console0 insert end "total bin: $countbinintemp\n"

if { $countbinintemp == 0 } {
	$::Console0 insert end "\nExtracting Image... \n"
	set match [glob -nocomplain -dir $::RomDirectory $::selectedRomFast.7z]
	set match [string map {\{ ""} $match]
	set match [string map {\} ""} $match]

	# Delete TEMP files
#	file delete {*}[glob -dir $TEMP *]
#	$::Console0 insert end "D: $::RomDirectory \n ... $TEMP w/\n $match \n"

# TODO 7z only if the file exists
	# Extract the selecter rom into temp - skips file already there
	exec 7za e $match -o$::HOMEDIR/TMP/ -aos

	set isoexists [glob -nocomplain -dir $TEMP $::selectedRomFast.bin]
	set countbinintemp [llength [glob -nocomplain -dir $TEMP $::selectedRomFast*.bin]]
	if {$countbinintemp > 1} {
	$::Console0 insert end "Multiple images found! <$countbinintemp>\n"
	set isoexists [glob -dir $TEMP "$::selectedRomFast (Track 1).bin"];#
	}

	set subikk [llength $isoexists]
	$::Console0 insert end "0 Subfix $subikk\n"
	set isoexists [string map {\{ ""} $isoexists]
	set isoexists [string map {\} ""} $isoexists]
	set rom $isoexists

} else {
	$::Console0 insert end "\nImage already extracted! $isoexists \n"

	if {$countbinintemp > 1} {
	$::Console0 insert end "Multiple images found! <$countbinintemp>\n"
	set isoexists [glob -dir $TEMP "$::selectedRomFast (Track 1).bin"];#
	}

	set isoexists [string map {\{ ""} $isoexists]
	set isoexists [string map {\} ""} $isoexists]
	set rom $isoexists

	$::Console0 insert end "ISO <$rom>\n"

}

