# 	=	=	=	=	=	=	=	=	=	=	=	=	=	=	=	=	DATABASE-PAGE (START)
# addCustomList{}			--add .ixb files
# clickDBSystemList{}		--sets ::DBsys 
# loadconfigDB				--load SystemConfigs from db
# activeChanged				--toggles active-status
# CheckIfActive				--sets ::activesystem based on db-value
# savesetup					--saves values to db
# setupReturnFile			--windows exe
# setupReturnDir			--romdir
# setEmuPresets				--
# sortSysListByGeneration
# sortSysListByManufacturer
# prioritizeSystemlist {orderedlist}
# clearConsole{}			--clears 0 and 1
# hiscoredump{}				--in DBframe
# locationdump{}			--in DBframe
# userdump{}				--in DBframe
# awarddump{}				--in DBframe
# queryMasterDatabase{}		--in DBframe
# dropTable{}				--drops a table.
# cacheManagerlist			--lists cached files to console1
# cacheManagerclear			--deletes all cached files
# 	=	=	=	=	=	=	=	=	=	=	=	=	=	=	=	=	=	=	=	

#grid [ttk::button .n.f1.setupframe.tepa -text "TEST" -command {dbTEST} -width 3]	-column 6 -row 6 -sticky e
proc dbTEST {} {
	$::Console1 insert end "TEST\n"

	set filename "./list8001.txt"
	if {$filename eq ""} {
		$::Console1 insert end "Cancel Loading!\n"
	} else {
		$::Console1 insert end "OK.\n"

		set fp [open $filename r]
		set file_data [read $fp]
		close $fp
		set data [split $file_data "\n"]

		foreach line $data {

			set maker [string range $line [string first "(" $line]+1 [string last ")" $line]-1]
			set linemod "$line ()"
			set entryName [string range $linemod 0 [string first "(" $linemod]-2]

			set line [string map {' ''} $line]
			$::Console1 insert end "abbr{$line}:\tname{$entryName};\n"
			append buffer "abbr{$line}:\tname{$entryName};\n"

#			$::Console1 insert end "=============== \n<$entryName>\n>$maker<\n"
		}
	set fl [open "./testExport.ixb" {WRONLY CREAT APPEND}]
	puts $fl "$buffer"
	close $fl
	}
}


proc setRLitemdefaults {} {;	# This will find NULL stat values and populate them with default: 0's
catch {
	set result [dbDATA eval "SELECT name FROM \"$::DBsys\" ORDER BY name ASC"]

	if {[dbSTAT exists "SELECT name FROM sqlite_master WHERE type='table' AND name=\"$::DBsys\" ";]} {
	} else {;	dbSTAT eval "CREATE TABLE \"$::DBsys\" (crc, playtime, playcounter, rating, lastplayed);";}


	dbSTAT transaction {
	foreach i $result {
		set statRate [dbSTAT eval "SELECT * FROM \"$::DBsys\" WHERE crc=\"$i\" "]
		if { [string length $statRate] > 1 } {
		} else {
			set i [string map {' ''} $i]
			dbSTAT eval "INSERT INTO \"$::DBsys\" (crc,playtime,playcounter,rating,lastplayed) values ('$i','0','0','0','');"
		}
	}}

}
}


proc lostandfound {} {
# Gathers all files in romdir not in db.
	if {[dbDATA exists "SELECT name FROM sqlite_master WHERE type='table' AND name=\"$::SelectedDB\" ";]} {
		set dbList [dbDATA eval "SELECT name FROM \"$::SelectedDB\" ORDER BY name ASC"]
	} else {
		set dbList ""
	}

	if {[dbCONF exists "SELECT System FROM systemconfig WHERE System='$::SelectedDB' ";]} {
		set systemconfRomRomDirecto [dbCONF eval "SELECT RomDirectory FROM systemconfig WHERE System='$::SelectedDB' ";]
	}

	set dir [string map {\} ""} [string map {\{ ""} $systemconfRomRomDirecto]]
	set itemList [lsort [glob -nocomplain -dir $dir *] ]
	set itemList2 ""

	if {[string length $itemList] > 0} {;										# clean list -- itemList2 -- only filenames from items found in dir

		foreach i $itemList {
			if {[file isfile $i]} {
				set i [string range $i 0 [string last {.} $i]-1]
				set i [string range $i [string last {/} $i]+1 end]
				lappend itemList2 $i
			}
		}

	listcomp $itemList2 $dbList
	}
}




proc listcomp {a b} {
	set diff {}
	foreach i $a {
		if {[lsearch -exact $b $i]==-1} {
			lappend diff $i
		}
	}
	$::Console1 insert end "LISTCOMP:\n"

	foreach i $diff {
		if { [string length $i] > 0} {
			# Added 026.1
			.n.f0.stattree insert {} end -id "$i" -text "$i" -tags "tagname"
			.n.f0.stattree move $i ~ end
		}
	}
}


proc ExportMissingImages {value} {

	# GET NAMES FROM PARSED DATFILE
	if {[dbDATA exists "SELECT name FROM sqlite_master WHERE type='table' AND name=\"$::DBsys\" ";]} {
		set ::StatisticDATA [dbDATA eval "SELECT name FROM \"$::DBsys\" ORDER BY name ASC"]
	} else {
		set ::StatisticDATA ""
	}

	set imageTitledir "$::HOMEDIR/IMG/systems/$::DBsys/Titles/"
	set imageSnapdir "$::HOMEDIR/IMG/systems/$::DBsys/Snaps/"
	set imageBoxdir "$::HOMEDIR/IMG/systems/$::DBsys/Boxarts/"
	set imageIcondir "$::HOMEDIR/IMG/systems/$::DBsys/Icons/"
	set extractTo "$::HOMEDIR/MOJO/$::DBsys (missing images).txt"

	set totTitles 0
	set totShots 0
	set totItems [llength $::StatisticDATA]
	set totSlaves 0
	
	# Stop loading if limit (2000 entries) is broken, unless Manually overriden.	$totItems < 2000 || 
	if { $value eq "Manual"} {
	
	# GET Container
	foreach i $::StatisticDATA {
			set master "0"
			catch {set master [dbCORP eval "SELECT locale FROM \"$::DBsys\" where name=\"$i\""]}
			#$::Console1 insert end "NAME -> $i <$master>\n"
			if {$master eq "*"} {
			incr totSlaves
			append buffer "SLAVES -> $i\n"
			}
	}
	
	# GET TITLES IMAGES
	set gamelistdat [list {*}$::StatisticDATA]
	set pathLength [string length $imageTitledir]
	foreach i $::StatisticDATA {
		set fileexists [glob -nocomplain -dir $imageTitledir $i.png]
		if { [string length $fileexists] < 3} {
		#	$::Console1 insert end "TITLE -> $i\n"
			incr totTitles
			append buffer "TITLE -> $i\n"
		}
	}

	# GET SNAP IMAGES
	set gamelistdat [list {*}$::StatisticDATA]
	set pathLength [string length $imageSnapdir]
	foreach i $::StatisticDATA {
		set fileexists [glob -nocomplain -dir $imageSnapdir $i.png]
		if { [string length $fileexists] < 3} {
		#	$::Console1 insert end "SNAP -> $i\n"
			incr totShots
			append buffer "SNAP -> $i\n"
		}
	}

	# GET BOX IMAGES
	set gamelistdat [list {*}$::StatisticDATA]
	set pathLength [string length $imageBoxdir]
	foreach i $::StatisticDATA {
		set fileexists [glob -nocomplain -dir $imageBoxdir $i.png]
		if { [string length $fileexists] < 3} {
			#$::Console1 insert end "BOX -> $i\n"
			append buffer "BOX -> $i\n"
		}
	}

	# GET ICON IMAGES
	set gamelistdat [list {*}$::StatisticDATA]
	set pathLength [string length $imageIcondir]
	foreach i $::StatisticDATA {
		set fileexists [glob -nocomplain -dir $imageIcondir $i.png]
		if { [string length $fileexists] < 3} {
		#	$::Console1 insert end "ICON -> $i\n"
			append buffer "ICON -> $i\n"
		}
	}
	
	
	if {$value eq "toText" || $value eq "Manual"} {
	
		$::Console1 insert end "Printing text to console...$totTitles / $totItems\n"
		if {$totItems eq "0"} {
		set totItems 1
		}
		
		set totTitles [expr $totItems - $totTitles]
		set totShots [expr $totItems - $totShots]
		set percTitles [expr double($totTitles) / $totItems]
		set percShots [expr double($totShots) / $totItems]
		#$::Console1 insert end "Missing Image list saved into: $extractTo (0)\n"
		#$::Console1 insert end "Titles:\t$totTitles /\t $totItems ($percTitles)\n"
		#$::Console1 insert end "Shots:\t$totShots /\t $totItems ($percShots)\n"
		#$::Console1 insert end "totSlaves:\t$totSlaves \n"
		#$::Console1 insert end "FINAL RESULTS: \n"
		set totItems [expr $totItems - $totSlaves]
		set percTitles [expr double($totTitles) / $totItems]
		set percShots [expr double($totShots) / $totItems]
		#$::Console1 insert end "Titles:\t$totTitles /\t $totItems ($percTitles)\n"
		#$::Console1 insert end "Shots:\t$totShots /\t $totItems ($percShots)\n"
		
		set percTitles [expr int($percTitles * 100)]
		if {$percTitles > 100} {
		set percTitles 100
		}
		set percShots [expr int($percShots * 100)]
		if {$percShots > 100} {
		set percShots 100
		}
		
		
		set ::varTitle "$totTitles/$totItems ( $percTitles % )"
		set ::varShots "$totTitles/$totItems ( $percShots % )"
		$::Console1 insert end "percTitles:\t ($percTitles)\n"
		
		.n.f1.exportframe.barTitle configure -value $percTitles
		.n.f1.exportframe.barShots configure -value $percShots
	}
	

	if {$value eq "toFile"} {
		$::Console1 insert end "Writing to file... $extractTo \n"
		set fl [open $extractTo {WRONLY CREAT APPEND}]
		puts $fl "$buffer"
		close $fl
	}

	} else {
		set ::varTitle "??/$totItems ( % )"
		set ::varShots "??/$totItems ( % )"
		
		.n.f1.exportframe.barTitle configure -value 0
		.n.f1.exportframe.barShots configure -value 0
	
	}
}

proc expandStats {} {
	# DANGER! DO NOT USE UNLESS YOU MAKE BACKUPS
	set unixTime [clock format [clock second] -format %s]
	$::Console1 insert end "Expanding stats for: $::DBsys\n"

	if {[dbSTAT exists "SELECT name FROM sqlite_master WHERE type='table' AND name=\"$::DBsys\" ";]} {;# onko systeemi masterDB:ssa
		$::Console1 insert end "EXISTS\n"
		dbSTAT eval "ALTER TABLE \"$::DBsys\" ADD COLUMN lastplayed;"
		#dbSTAT eval "ALTER TABLE \"$::DBsys\" ADD COLUMN ext1;"
		#dbSTAT eval "ALTER TABLE \"$::DBsys\" ADD COLUMN ext2;"
	}

}

proc clickDBSystemList {} {
    set idx [$::systemlistDB curselection]					;#get index
	set ::DBsys  [lindex $::db_systems_all $idx]			;#pre & post vars
#	set ::TimeStarted [clock format [clock second] -format %s];#	$::Console0 insert end "usrTime>$::TimeStarted\n"
#	$::Console1 insert end "Conv:$idx:$::DBsys $::TimeStarted\n"
	#expandStats

	EnableDatabaseEdit
	loadconfigDBentry
#	loadconfigDBdisplay
	CheckIfActive
	ExportMissingImages toText

	# show num rows TODO check table exists
#	set countRows [dbCORP eval "SELECT Count(*) FROM '$::DBsys' "]
#	$::Console1 insert end "Items:$countRows \n"
}


proc loadconfigDBentry {} {
#	$::Console1 insert end "Open DB-CONF : $::DBsys\n"
	set ::loadtypetxt ""
	set ::windoexe ""
	set ::linuxexe ""
	set ::rompreset ""
	set ::rompostset ""
	set ::romdirtxt ""
	set ::sysmetatype ""
	set ::sysmetadate ""
	set ::sysmetagene ""
	set ::sysmetamanuf ""
	set ::sysmetaorig ""
	set ::sysmetaSysHuman ""

	# EXIST CHECK
	if {[dbCONF exists "SELECT System FROM systemconfig WHERE System='$::DBsys' ";]} {
#	$::Console1 delete 1.0 end
#	$::Console1 insert end "System has line\n"
	set systemconfSystem [dbCONF eval "SELECT System FROM systemconfig WHERE System='$::DBsys' ";]
	set systemconfActive [dbCONF eval "SELECT Active FROM systemconfig WHERE System='$::DBsys' ";]
	set systemconfLoadType [dbCONF eval "SELECT LoadType FROM systemconfig WHERE System='$::DBsys' ";]
	set systemconfwemu [dbCONF eval "SELECT wemu FROM systemconfig WHERE System='$::DBsys' ";]
	set systemconflemu [dbCONF eval "SELECT lemu FROM systemconfig WHERE System='$::DBsys' ";]
	set systemconfRomPreset [dbCONF eval "SELECT RomPreset FROM systemconfig WHERE System='$::DBsys' ";]
	set systemconfRomPostset [dbCONF eval "SELECT RomPostset FROM systemconfig WHERE System='$::DBsys' ";]
	set systemconfRomRomDirecto [dbCONF eval "SELECT RomDirectory FROM systemconfig WHERE System='$::DBsys' ";]

	set systemconfMetaDate [dbCONF eval "SELECT MetaDate FROM systemconfig WHERE System='$::DBsys' ";]
	set systemconfMetaType [dbCONF eval "SELECT MetaType FROM systemconfig WHERE System='$::DBsys' ";]
	set systemconfMetaGeneration [dbCONF eval "SELECT MetaGeneration FROM systemconfig WHERE System='$::DBsys' ";]
	set systemconfMetaOrigin [dbCONF eval "SELECT MetaOrigin FROM systemconfig WHERE System='$::DBsys' ";]
	set systemconfMetaManufacturer [dbCONF eval "SELECT MetaManufacturer FROM systemconfig WHERE System='$::DBsys' ";]
	set systemconfMetaSystemHuman [dbCONF eval "SELECT SystemHuman FROM systemconfig WHERE System='$::DBsys' ";]
	set systemconfMetaSupport [dbCONF eval "SELECT EXT2 FROM systemconfig WHERE System='$::DBsys' ";]
	set systemconfMetaOrder [dbCONF eval "SELECT EXT1 FROM systemconfig WHERE System='$::DBsys'; "]

#	$::Console1 insert end "System: 	$systemconfSystem - $systemconfActive\n"
#	$::Console1 insert end "LoadType: 	$systemconfLoadType\n"
#	$::Console1 insert end "wemu: 		$systemconfwemu\n"
#	$::Console1 insert end "lemu: 		$systemconflemu\n"
#	$::Console1 insert end "RomPreset: 	$systemconfRomPreset\n"
#	$::Console1 insert end "RomPostset: $systemconfRomPostset\n"
#	$::Console1 insert end "RomDirecto: $systemconfRomRomDirecto\n"

	set ::loadtypetxt [string map {\} ""} [string map {\{ ""} $systemconfLoadType]]
	set ::windoexe [string map {\} ""} [string map {\{ ""} $systemconfwemu]]
	set ::linuxexe [string map {\} ""} [string map {\{ ""} $systemconflemu]]
	set ::rompreset [string map {\} ""} [string map {\{ ""} $systemconfRomPreset]]
	set ::rompostset [string map {\} ""} [string map {\{ ""} $systemconfRomPostset]]
	set ::romdirtxt [string map {\} ""} [string map {\{ ""} $systemconfRomRomDirecto]]

	set ::sysmetatype [string map {\} ""} [string map {\{ ""} $systemconfMetaType]]
	set ::sysmetadate [string map {\} ""} [string map {\{ ""} $systemconfMetaDate]]
	set ::sysmetagene [string map {\} ""} [string map {\{ ""} $systemconfMetaGeneration]]
	set ::sysmetamanuf [string map {\} ""} [string map {\{ ""} $systemconfMetaManufacturer]]
	set ::sysmetaorig [string map {\} ""} [string map {\{ ""} $systemconfMetaOrigin]]
	set ::sysmetaSysHuman [string map {\} ""} [string map {\{ ""} $systemconfMetaSystemHuman]]
	set ::sysmetaSupport [string map {\} ""} [string map {\{ ""} $systemconfMetaSupport]]
	set ::sysmetaOrder [string map {\} ""} [string map {\{ ""} $systemconfMetaOrder]]

# Disable this while editing... 
if {$::DEVELOPERMODE eq 0} {
	if {[file exists "./IMG/flags/$::sysmetaorig.png"]} {
		image create photo systemCountry -file "./IMG/flags/$::sysmetaorig.png" -height 32 -width 32
		.n.f1.systemframe.lorigT configure -image systemCountry -compound image
	} else {
		image create photo systemCountry -file "./IMG/flags/UNK.png" -height 32 -width 32
		.n.f1.systemframe.lorigT configure -image systemCountry -compound image
	}


if {$::sysmetaSupport > 0} {
		set stars ""
		for {set x 0} {$x<$::sysmetaSupport} {incr x} {
			set stars "$::ratingStar$stars"
		}
		for {set x 0} {$x<[expr 5-$::sysmetaSupport]} {incr x} {
			set stars "$stars$::ratingStar2"
		}
		set ::sysmetaSupport $stars
} else {
		set ::sysmetaSupport "$::ratingStar2$::ratingStar2$::ratingStar2$::ratingStar2$::ratingStar2"
}
}
# End disabling here

	#set sysSupp [.n.f1.systemframe.supprT get]
	} else {
	$::Console1 insert end "System has NO line, creating...\n"
	dbCONF eval "INSERT INTO systemconfig (System,Active,LoadType,wemu,lemu,RomPreset,RomPostset,RomDirectory) values ('$::DBsys','0','','','','','','');"
	}

	# Check directory
	checkDirectoryexists $::romdirtxt
}

proc checkDirectoryexists {dir} {
	if {[file exists "$dir"]} {
	.n.f1.setupframe.romdirCheck configure -image checkOK
	} else {
	.n.f1.setupframe.romdirCheck configure -image checkNO
	}
}

proc activeChanged {} {

#	if {![dbSTAT exists "SELECT name FROM sqlite_master WHERE type='table' AND name='$::DBsys' ";]} {
#		$::Console1 insert end "<DATABASE $::DBsys NOT FOUND> Parse a datfile before Activating.\n"
#		set ::activesystem 0;	# Disable checkbutton
#	} else {;	# db found in master, OK to activate
		set activecheck [dbCONF eval "SELECT Active FROM systemconfig WHERE System='$::DBsys' ";]
		if {$activecheck eq "1"} {
			$::Console1 insert end "Removing platform: $::DBsys from Library\n"
			dbCONF eval "UPDATE systemconfig SET Active='0' WHERE System='$::DBsys'; "
		} else {
			$::Console1 insert end "Adding platform: $::DBsys from Library.\n"
			dbCONF eval "UPDATE systemconfig SET Active='1' WHERE System='$::DBsys'; "
			setRLitemdefaults
		}
#	}
	clearSystemList
}


proc CheckIfActive {} {
	set activecheck [dbCONF eval "SELECT Active FROM systemconfig WHERE System='$::DBsys' ";]
	if {$activecheck eq "1"} {
		set ::activesystem 1
	} else {
		set ::activesystem 0
	}
}


proc savesetup {} {
	set linuxexe [.n.f1.setupframe.setlinexe get]
	set windoexe [.n.f1.setupframe.setwinexe get]
	set preset [.n.f1.setupframe.preset get]
	set postset [.n.f1.setupframe.postset get]
	set rompath [.n.f1.setupframe.romdir get]
	set loadtype [.n.f1.setupframe.loadtype get]


	set systype [.n.f1.systemframe.dbnameT get]
	set sysdate [.n.f1.systemframe.dateT get]
	set sysgene [.n.f1.systemframe.geneT get]
	set sysmanu [.n.f1.systemframe.manufT get]
	set sysorig [.n.f1.systemframe.origT get]
	set sysSysH [.n.f1.systemframe.sysHT get]
	set sysSupp [.n.f1.systemframe.supprT get]

# count stars.. pff a quick hack. .. TODO -- make ixbar3000 great again!
if {$sysSupp eq "$::ratingStar$::ratingStar$::ratingStar$::ratingStar$::ratingStar" || $sysSupp eq "5"} {
set sysSupp 5
} elseif {$sysSupp eq "$::ratingStar$::ratingStar$::ratingStar$::ratingStar$::ratingStar2" || $sysSupp eq "4"} {
set sysSupp 4
} elseif {$sysSupp eq "$::ratingStar$::ratingStar$::ratingStar$::ratingStar2$::ratingStar2" || $sysSupp eq "3"} {
set sysSupp 3
} elseif {$sysSupp eq "$::ratingStar$::ratingStar$::ratingStar2$::ratingStar2$::ratingStar2" || $sysSupp eq "2"} {
set sysSupp 2
} elseif {$sysSupp eq "$::ratingStar$::ratingStar2$::ratingStar2$::ratingStar2$::ratingStar2" || $sysSupp eq "1"} {
set sysSupp 1
} else {
set sysSupp 0
}


	set windoexe [string map {\\ /} $windoexe]
	set rompath [string map {\\ /} $rompath]

	#check if wemu and lemu are empty
	if {$linuxexe eq ""} {;	$::Console1 insert end "No Linux Exec... creating temp\n";	set linuxexe "fixme";}
	if {$windoexe eq ""} {;	$::Console1 insert end "No Windows Exec... creating temp\n";	set windoexe "fixme";}

	dbCONF eval "UPDATE systemconfig SET SystemHuman=\"$sysSysH\",LoadType=\"$loadtype\",wemu=\"$windoexe\",lemu=\"$linuxexe\",RomPreset=\"$preset\",RomPostset=\"$postset\",RomDirectory=\"$rompath\",MetaDate=\"$sysdate\",MetaType=\"$systype\",MetaGeneration=\"$sysgene\",MetaOrigin=\"$sysorig\",MetaManufacturer=\"$sysmanu\",EXT2=\"$sysSupp\" WHERE System='$::DBsys'; "

}

proc setupReturnFile {} {
# Sets the exe for windows emu
	set types {    {{Datfiles}        .exe             }}
	set filename [tk_getOpenFile -filetypes $types]
	if {$filename eq ""} {
		$::Console1 insert end "Cancel Loading!\n"
	} else {
		$::Console1 insert end "Load!\n"
		set ::windoexe $filename
	}
}

proc setupReturnDir {} {
	set dir [tk_chooseDirectory -title "Choose a directory"]
	if {$dir eq ""} {
		$::Console1 insert end "Cancel Loading!\n"
	} else {
		$::Console1 insert end "Load!\n"
		set ::romdirtxt $dir
		checkDirectoryexists $::romdirtxt
	}
}


proc setEmuPresets {} {
# CHK if DBsys is selected-->IF
	$::Console1 insert end "Open new window.\n"
	tk::toplevel .ecw
	wm title .ecw "Set Emulator Presets SYS: $::DBsys"
	wm geometry .ecw 800x600+100+50

# Make GUI
	ttk::label .ecw.system -text "System: $::DBsys";					grid .ecw.system -column 1 -row 2 -sticky ne
	ttk::button .ecw.presetbut -text "Create" -command {createPreset};	grid .ecw.presetbut -column 1 -row 20 -sticky ne
	ttk::label .ecw.presettex -textvariable createPreset -width 50;		grid .ecw.presettex -column 2 -row 20 -sticky ne
	ttk::button .ecw.presetsave -text "Save" -command {savePreset};		grid .ecw.presetsave -column 3 -row 20 -sticky ne

	# Load emustuff
	if {"$::DBsys" eq "SNES"} {
		$::Console1 insert end "Load SNES\n"
	#	ttk::label .ecw.fullscr -text "Fullscreen";		grid .ecw.fullscr -column 1 -row 3 -sticky ne
	# INIT
		set ::resolution ""
		ttk::checkbutton .ecw.fullscrcheck -text "Fullscreen"  -variable resolution -onvalue " --fullscreen" -offvalue "";							grid .ecw.fullscrcheck -column 1 -row 3 -sticky we

	} else {
		$::Console1 insert end "No system specs\n"
	}

	proc createPreset {} {
	#	set resolution $::resolution
		set ::createPreset "Preset-line: $::resolution"
	}

	proc savePreset {} {
		#save the preset
		set ::rompreset $::createPreset
		#destroy window
		destroy .ecw
	}
}

proc sortSysListByGeneration {} {
	$::Console1 delete 1.0 end
	$::Console1 insert end "by Generation\n"
	if {[dbCONF exists "SELECT name FROM sqlite_master WHERE type='table' AND name='systemconfig' ";]} {
		prioritizeSystemlist [dbCONF eval "SELECT System FROM systemconfig ORDER BY MetaGeneration ";];#SystemHuman
	}
}

proc sortSysListByManufacturer {} {
	$::Console1 delete 1.0 end
	$::Console1 insert end "by Manufacturer\n"
	if {[dbCONF exists "SELECT name FROM sqlite_master WHERE type='table' AND name='systemconfig' ";]} {
		prioritizeSystemlist [dbCONF eval "SELECT System FROM systemconfig ORDER BY MetaManufacturer ";]
	}
}

proc prioritizeSystemlist {orderedlist} {
	set systemorder 0
	foreach System $orderedlist {
		incr systemorder
		$::Console1 insert end ">$systemorder - $System\n"
		dbCONF eval "UPDATE systemconfig SET EXT1='$systemorder' WHERE System='$System'; "
	}

}


proc clearConsole {} {
	$::Console0 delete 1.0 end;	$::Console1 delete 1.0 end
}

proc hiscoredump {} {
	set aw "_award"
	set result [dbDATA eval "SELECT * FROM $::DBsys LIMIT 10";] ;#$aw
	$::Console1 insert end $result
}

proc locationdump {} {
	set result [dbLOCA eval "SELECT * FROM $::DBsys LIMIT 10";] 
	$::Console1 insert end $result
}

proc userdump {} {
	set result [dbSTAT eval "SELECT * FROM $::DBsys LIMIT 10";] 
	$::Console1 insert end $result
}

proc awarddump {} {
	set aw "_Award"
	set result [dbSTAT eval "SELECT * FROM $::DBsys$aw LIMIT 10";] 
	$::Console1 insert end $result
}

proc queryMasterDatabase {} {
	set dat_systems1 [dbSTAT eval "SELECT name FROM sqlite_master ";]
	set dat_systems2 [dbLOCA eval "SELECT name FROM sqlite_master ";]
	set dat_systems3 [dbDATA eval "SELECT name FROM sqlite_master ";]
#	set dat_systems [db1 eval "SELECT * FROM \"$::DBsys\" "]
	$::Console1 insert end "USR_1> $dat_systems1\n"
	$::Console1 insert end "LOC_2> $dat_systems2\n"
	$::Console1 insert end "TXT_3> $dat_systems3\n"
}

proc dropTable {} {
#	set dat_systems [db1 eval "SELECT name FROM sqlite_master ";]
#	$::Console1 insert end "> $dat_systems\n\n"
#	dbCORP eval "DROP TABLE \"NES\" ";

#	dbSTAT eval "DROP TABLE \"PC_WIN\" ";
	set dat_systems [dbCORP eval "SELECT name FROM sqlite_master ";]
	$::Console1 insert end "> $dat_systems\n\n"
}


# ===========
# C A C H E
# ===========

proc cacheManagerlist {} {
	$::Console1 insert end "<cacheManager>\n"
	set TEMP $::HOMEDIR/TMP/
	set TEMP_files [glob -nocomplain -dir $TEMP *]
	set tempTotalsize "0"
	foreach i $TEMP_files {
		set tempfilesize [file size $i]
		$::Console1 insert end "$tempfilesize>$i\n"
		set tempTotalsize [expr $tempTotalsize + $tempfilesize] 
	}

	if {$tempTotalsize > 1000000} {
	set tempTotalsize [expr $tempTotalsize / 1000000]
	$::Console1 insert end "Total size: $tempTotalsize Mb\n"
	} else {
	$::Console1 insert end "Total size: $tempTotalsize bytes\n"
	}
}

proc cacheManagerclear {} {
	set TEMP $::HOMEDIR/TMP/
	file delete {*}[glob -nocomplain -dir $TEMP *]
	$::Console1 insert end "<cacheManager:Clear>\n"
}

# 	=	=	=	=	=	=	=	=	=	=	=	=	=	=	=	=	DATABASE-PAGE (END)
