# GUI
ttk::frame .n.f5
.n add .n.f5 -text "Dat Explorer"

grid columnconfigure .n.f5 3 -weight 1
grid rowconfigure .n.f5 5 -weight 1

grid [tk::listbox .n.f5.datlist -yscrollcommand ".n.f5.scroll set"] 				-column 3 -row 0 -rowspan 3 -sticky news
grid [ttk::scrollbar .n.f5.scroll -orient vertical -command ".n.f5.datlist yview"] 	-column 3 -row 0 -rowspan 3 -sticky nes

grid [ttk::treeview .n.f5.datTree -selectmode "browse" -columns "crc archive flags" -yscrollcommand ".n.f5.scrdatTree set"] -column 3 -row 5 -sticky nsew
grid [ttk::scrollbar .n.f5.scrdatTree -orient vertical -command ".n.f5.datTree yview"] -column 3 -row 5 -sticky nse
.n.f5.datTree column #0 -width 400 -anchor e;		.n.f5.datTree heading #0 -text "Name"
.n.f5.datTree column crc -width 60 -anchor w;		.n.f5.datTree heading crc -text "crc"
.n.f5.datTree column archive -width 60 -anchor w;	.n.f5.datTree heading archive -text "Archive"
#.n.f5.datTree column md5 -width 70 -anchor w;		.n.f5.datTree heading md5 -text "md5"
#.n.f5.datTree column sha1 -width 100 -anchor w;		.n.f5.datTree heading sha1 -text "sha1"
.n.f5.datTree column flags -width 60 -anchor w -stretch 0;		.n.f5.datTree heading flags -text "flags"


grid [ttk::button .n.f5.sourceButton -text "set Source" -command {is_crc_present} -width 20 -state disabled]		-column 1 -row 2 -sticky we
grid [ttk::entry .n.f5.sourceEntry -textvariable sourceEntry -state disabled]										-column 1 -row 1 -sticky we

grid [ttk::button .n.f5.destinButton -text "set Destination" -command {auditDirectory} -width 20 -state disabled]	-column 5 -row 2 -sticky we
grid [ttk::entry .n.f5.destinEntry -textvariable destinEntry -state disabled]										-column 5 -row 1 -sticky we

grid [ttk::button .n.f5.compressButton -text "Rename" -command {ISOcompressor} -width 20]			-column 3 -row 3 -sticky news

bind .n.f5.datlist <<ListboxSelect>> "clickDatList"
set ::Console3 [tk::text .n.f5.text -width 70 -height 10];							grid $::Console3 -column 3 -row 10 -rowspan 1 -sticky we;# -columnspan 11

#$::HOMEDIR/MOJO/AUDIT/
$::Console3 insert end "WARNING! This is highly experimental area.\n At the moment you can only rename files to their names found in the selected datfile. Place files into: <./ixbar3000/MOJO/AUDIT/> \nThis will only work with files that end with <.iso>"

#set datfilelistsimple [list no datfiles present]
set datfiledir "$::HOMEDIR/MOJO/dat/"
set ::datfilelist [glob -nocomplain -dir $datfiledir *.dat]
#set datfilelistsimple [string range $datfilelist [string length $datfiledir] end]

# lets remove the dir and set the list
foreach i $::datfilelist {
	set cleani [string range $i [string length $datfiledir] end]
#	$::Console3 insert end "$i - $cleani\n"
	lappend datfilelistsimple $cleani
}
.n.f5.datlist configure -listvariable datfilelistsimple



# TEMP GLOBALS == TODO REMOVE
proc auditDirectory {} {
# 1. gets all zips into list -> auditfilelist

	set auditfiledir "$::HOMEDIR/MOJO/AUDIT/"
	set ::auditfilelist [glob -nocomplain -dir $auditfiledir *.zip]
	foreach i $::auditfilelist {
		set cleani [string range $i [string length $auditfiledir] end]
		set crc [GetCRCFromZip $i]

		set archiveName [string range $cleani 0 [string last "." $cleani]-1]
		$::Console3 insert end "= = = = = = = = = = = =\n"
		#$::Console3 insert end "AUDIT  : $cleani <$crc>\n"
		$::Console3 insert end "ARCHIVE: <$archiveName>\n"

		set fileCount 0
		set crcIndex 0
		foreach k $crc {
		set chdCount 0;
		set flagData 0;	# flagData:	crcFromdat
						# romId:	Blackthorne (USA).32x
		

		if {$crcIndex eq 0} {
			set romId $k
			#catch {set flagData [.n.f5.datTree item $romId -text]}
			#$::Console3 insert end "\nSRRAAAA:$romId <$flagData>\n"
		} elseif {$crcIndex eq 1} {; #get the crc of matching romId from dat
#			catch {set flagData [.n.f5.datTree item $romId -values]}
#			set flagData [lindex $flagData 1]
		}

		# get the slave count
		catch {set chdCount [llength [.n.f5.datTree children $archiveName]]}

		#catch {.n.f5.datTree set $romId flags "-?-"}
		catch {.n.f5.datTree set $romId flags "$flagData->$k"}
		$::Console3 insert end "<<$k>> "

		if {$crcIndex eq 1} {;set crcID $k ;searchParentByCRC $crcID;}

		incr crcIndex; if {$crcIndex > 1} {;set crcIndex 0;}
		incr fileCount
		}
		set fileCount [expr $fileCount / 2]
		$::Console3 insert end "COUNT: <$fileCount> ($chdCount)\n"

	# match with treeview
	# set ? as template, update if match found.
	#catch {.n.f5.datTree set $crcID flags "-?-"}
	#$::Console3 insert end "($flagData) s <$crcID>\n"
	catch {.n.f5.datTree set $crcID flags "OK"};}
	
}



proc searchParentByCRC {crc} {
#	$::Console3 insert end "\nsearching...<$crc>\n"
#	catch {$::Console3 insert end "ARR> $::crcArray($crc) \n"}	
}


proc is_crc_present {} {
set toInstall [expr ![catch {package present crc32}]]
	if {$toInstall eq 0} {
		tk_messageBox -message "$toInstall"
	}
}
#is_crc_present

proc clickDatList {} {
	set idx [.n.f5.datlist curselection]
	set dat [lindex $::datfilelist $idx];	#->megaman.nes
	$::Console3 insert end "Opening file...$dat\n"

	.n.f5.datTree delete [.n.f5.datTree children {}]
openDatfileExplore $dat
#openDatfileSimpleCRC $dat
}


proc openDatfileSimpleCRC {dat} {

	set fp [open "$dat" r]
	set file_data [read $fp]
	close $fp
	set data [split $file_data "\n"]
	foreach line $data {

# HEADER STUFF
		set result [regexp {comment \"no-intro} $line match]
		if {$result} {;			$::Console3 insert end "Tahis is a <No-Intro> datfile. OK.\n";		}

		set result [regexp {<clrmamepro/>} $line match]
		if {$result} {;			$::Console3 insert end "This is a <clrmamepro> datfile. OK.\n";		}

		set result [regexp {<author>redump.org</author>} $line match]
		if {$result} {;			$::Console3 insert end "This is a <redump> datfile. OK.\n";		}

		set result [regexp {author toseciso.org} $line match]
		if {$result} {;			$::Console3 insert end "This is a <toseciso> datfile. OK.\n";		}


# CMP
		set result [regexp {\t<game name=} $line match]
		if {$result} {
			set gamename [string range $line [string first {name=} $line]+6 [string first { sourcefile=} $line]-2]
			$::Console3 insert end ">>$gamename<<\n"
		}

		set result [regexp {\t<game name=} $line match]
		if {$result} {
			set gamemaster [string range $line [string first {cloneof=} $line]+9 [string first { romof=} $line]-2]
			$::Console3 insert end ">CLONE>$gamemaster<<\n"
		}

		set result [regexp {<description>} $line match]
		if {$result} {
			set gamedesc [string range $line [string first {<description>} $line]+13 [string first {</description>} $line]-1]
			$::Console3 insert end ">>$gamedesc\n"

#		set gameid "$gamedesc ($gamename)"
		catch {.n.f5.datTree insert {} end -id $gamedesc -text $gamedesc -tags "tagname"}
		}


		set result [regexp {<year>} $line match]
		if {$result} {
			set gamedate [string range $line [string first {<year>} $line]+6 [string first {</year>} $line]-1]
			$::Console3 insert end ">date>$gamedate<<\n"
		}

		set result [regexp {<manufacturer>} $line match]
		if {$result} {
			set gamemanu [string range $line [string first {<manufacturer>} $line]+13 [string first {</manufacturer>} $line]-1]
			$::Console3 insert end ">manufacturer>$gamemanu<<\n"
		}


		set result [regexp {\t<rom name=} $line match]
		if {$result} {

			set romname [string range $line [string first {<rom name=} $line]+11 [string first { size=} $line]-2]
			set romsize [string range $line [string first { size=} $line]+7 [string first { crc=} $line]-2]
			set romcrc  [string range $line [string first { crc=} $line]+6 [string first { sha1=} $line]-2]
			set romsha1 [string range $line [string first { sha1=} $line]+7 [string first { sha1=} $line]+46]
	#		$::Console3 insert end "romname>$romname\nromsize>$romsize\nromcrc_>$romcrc\nromsha1>$romsha1\n"
			set gameid "$gamename$romname"
			$::Console3 insert end ">$gameid\n"

			catch {.n.f5.datTree insert {} end -id $gameid -text $romname -tags "tagname"}
			.n.f5.datTree set $gameid size $romsize
			.n.f5.datTree set $gameid crc $romcrc
			.n.f5.datTree set $gameid sha1 $romsha1

			if {[string length $gamedesc] > 1} {
				set master $gamedesc
				set slave $gameid
				.n.f5.datTree move $slave $master end;# OK
			}
		}


# NO INTRO
		set result [regexp {game } $line match]
		if {$result} {;# next parse the gamedata
		}
		
		set result [regexp {\tname } $line match]
		if {$result} {
		set line [string map {"\tname " ""} $line]
		set line [string range $line 1 end-1]
	#	catch {.n.f5.datTree insert {} end -id $line -text $line -tags "tagname"} ;#ARCHIVENAME
		set subtype $line
		}


		set result [regexp {\trom } $line match]
		if {$result} {

	# TOSEC has no sha. NI does.
	set sha1test [string match *sha1* $line]
	if {$sha1test} {
		set romname [string range $line [string first { name } $line]+7 [string last \" $line]-1]
		set romsize [string range $line [string first { size } $line]+6 [string first { crc } $line]-1]
		set romcrc  [string range $line [string first { crc } $line]+5 [string first { md5 } $line]-1]
		set rommd5  [string range $line [string first { md5 } $line]+5 [string first { sha1 } $line]-1]
		set romsha1  [string range $line [string first { sha1 } $line]+6 end-2]
	} else {
		set romname [string range $line [string first { name } $line]+7 [string last \" $line]-1]
		set romsize [string range $line [string first { size } $line]+6 [string first { crc } $line]-1]
		set romcrc  [string range $line [string first { crc } $line]+5 [string first { md5 } $line]-1]
		set rommd5  [string range $line [string first { md5 } $line]+5 end-2]
		set romsha1 ""
	}
		#.n.f5.datTree insert {} end -id $romname -text $romname -tags "tagname"
		.n.f5.datTree insert {} end -id $romcrc -text $romname -tags "tagname"
		.n.f5.datTree set $romcrc crc $romcrc
		#$::Console3 insert end "\n<$subtype>\n$romcrc : $romname\n"
		set arrayname "$romcrc<::>$romname"
		set ::crcArray($romcrc) $arrayname
		#$::Console3 insert end "ARR> $::crcArray($romcrc) \n"

	if {[string length $subtype] > 1} {
		set master $subtype
		set slave $romname
		catch {.n.f5.datTree move $slave $master end};# OK
	}

		}

	}
}


proc ISOcompressor {} {
	$::Console3 insert end "COMPRESS>  \n"
	set ISOfiledir "/media/Gensokyo/WORK/PSP/ISO/"

#	set ISOfiledir "$::HOMEDIR/MOJO/AUDIT/"
	set ISOfilelist [glob -nocomplain -dir $ISOfiledir *]

	foreach i $ISOfilelist {
		set cleani [string range $i [string length $ISOfiledir] end]
		set crc [getCRCFromFile $i]
		set crc [string toupper $crc]
		$::Console3 insert end "COMPRESS> $i $crc\n"
#		set poi $::crcArray($crc)
#		$::Console3 insert end "REALNAME> $poi\n"
#set crc "e23d32f9"
		catch {
			#$::Console3 insert end "ARR> $::crcArray($crc) \n"; 
			set newName $::crcArray($crc)
			set newName [string range $newName [string first "<::>" $newName]+4 end]
			set newName $ISOfiledir$newName
			$::Console3 insert end "O:<$i>\n"; 
			$::Console3 insert end "N:<$newName>\n"; 
			file rename -force -- $i $newName
			
		}
	}
#	52321d57

}

proc getCRCFromFile {filename} {
	return [exec crc32 $filename]
}


proc openDatfileExplore {dat} {

	set fp [open "$dat" r]
	set file_data [read $fp]
	close $fp
	set data [split $file_data "\n"]
	foreach line $data {

# HEADER STUFF
		set result [regexp {comment \"no-intro} $line match]
		if {$result} {;			$::Console3 insert end "This is a <No-Intro> datfile. OK.\n";		}

		set result [regexp {<clrmamepro/>} $line match]
		if {$result} {;			$::Console3 insert end "This is a <clrmamepro> datfile. OK.\n";		}

		set result [regexp {<author>redump.org</author>} $line match]
		if {$result} {;			$::Console3 insert end "This is a <redump> datfile. OK.\n";		}

		set result [regexp {author toseciso.org} $line match]
		if {$result} {;			$::Console3 insert end "This is a <toseciso> datfile. OK.\n";		}


# CMP
		set result [regexp {\t<game name=} $line match]
		if {$result} {
			set gamename [string range $line [string first {name=} $line]+6 [string first { sourcefile=} $line]-2]
		#	$::Console3 insert end ">>$gamename<<\n"
		}

		set result [regexp {\t<game name=} $line match]
		if {$result} {
			set gamemaster [string range $line [string first {cloneof=} $line]+9 [string first { romof=} $line]-2]
		#	$::Console3 insert end ">CLONE>$gamemaster<<\n"
		}

		set result [regexp {<description>} $line match]
		if {$result} {
			set gamedesc [string range $line [string first {<description>} $line]+13 [string first {</description>} $line]-1]
		#	$::Console3 insert end ">>$gamedesc\n"

#		set gameid "$gamedesc ($gamename)"
	#	catch {.n.f5.datTree insert {} end -id $gamedesc -text $gamedesc -tags "tagname"}
		}


		set result [regexp {<year>} $line match]
		if {$result} {
	#		set gamedate [string range $line [string first {<year>} $line]+6 [string first {</year>} $line]-1]
	#		$::Console3 insert end ">date>$gamedate<<\n"
		}

		set result [regexp {<manufacturer>} $line match]
		if {$result} {
	#		set gamemanu [string range $line [string first {<manufacturer>} $line]+13 [string first {</manufacturer>} $line]-1]
	#		$::Console3 insert end ">manufacturer>$gamemanu<<\n"
		}


		set result [regexp {\t<rom name=} $line match]
		if {$result} {

			set romname [string range $line [string first {<rom name=} $line]+11 [string first { size=} $line]-2]
	#		set romsize [string range $line [string first { size=} $line]+7 [string first { crc=} $line]-2]
			set romcrc  [string range $line [string first { crc=} $line]+6 [string first { crc=} $line]+13]
	#		set romsha1 [string range $line [string first { sha1=} $line]+7 [string first { sha1=} $line]+46]
	#		$::Console3 insert end "romname>$romname\nromsize>$romsize\nromcrc_>$romcrc\nromsha1>$romsha1\n"
			set gameid "$gamename$romname"
	#		$::Console3 insert end ">$romcrc\n"

			catch {.n.f5.datTree insert {} end -id $romcrc -text $romname -tags "tagname"}
	#		.n.f5.datTree set $romcrc size $romsize
			.n.f5.datTree set $romcrc archive $gamename
			.n.f5.datTree set $romcrc crc $romcrc
		#	.n.f5.datTree set $romcrc sha1 $romsha1
		set romcrc [string toupper $romcrc]
		set arrayname "$romcrc<::>$romname"
		set ::crcArray($romcrc) $arrayname
		$::Console3 insert end "ARR><$romcrc> $::crcArray($romcrc) \n"

		#	if {[string length $gamedesc] > 1} {
		#		set master $gamedesc
		#		set slave $gameid
		#		.n.f5.datTree move $slave $master end;# OK
		#	}
		}


# NO INTRO
		set result [regexp {game } $line match]
		if {$result} {;# next parse the gamedata
		}
		
		set result [regexp {\tname } $line match]
		if {$result} {
		set line [string map {"\tname " ""} $line]
		set line [string range $line 1 end-1]
		#catch {.n.f5.datTree insert {} end -id $line -text $line -tags "tagname"}
		set subtype $line
		}


		set result [regexp {\trom } $line match]
		if {$result} {
	#	$::Console3 insert end "$line\n"

	# TOSEC has no sha. NI does.
	set sha1test [string match *sha1* $line]
	if {$sha1test} {
		set romname [string range $line [string first { name } $line]+7 [string last \" $line]-1]
	#	set romsize [string range $line [string first { size } $line]+6 [string first { crc } $line]-1]
		set romcrc  [string range $line [string first { crc } $line]+5 [string first { md5 } $line]-1]
	#	set rommd5  [string range $line [string first { md5 } $line]+5 [string first { sha1 } $line]-1]
	#	set romsha1  [string range $line [string first { sha1 } $line]+6 end-2]
	} else {
		set romname [string range $line [string first { name } $line]+7 [string last \" $line]-1]
	#	set romsize [string range $line [string first { size } $line]+6 [string first { crc } $line]-1]
		set romcrc  [string range $line [string first { crc } $line]+5 [string first { md5 } $line]-1]
	#	set rommd5  [string range $line [string first { md5 } $line]+5 end-2]
	#	set romsha1 ""
	}
		#set romdata "$romname"
		#catch {.n.f5.datTree insert {} end -id $romcrc -text $subtype -tags "tagname"}
		
		.n.f5.datTree insert {} end -id $romcrc -text $romname -tags "tagname"
		.n.f5.datTree set $romcrc crc $romcrc
		.n.f5.datTree set $romcrc archive $subtype
		#.n.f5.datTree set $romname md5 $rommd5
		#.n.f5.datTree set $romname sha1 $romsha1

		set arrayname "$romcrc<::>$romname"
		set ::crcArray($romcrc) $arrayname

#	if {[string length $subtype] > 1} {
#		set master $subtype
#		set slave $romname
#		catch {.n.f5.datTree move $slave $master end};# OK
#	}

#set subtype 0
#		.n.f5.datTree set $line value $year
#	rom ( name "Activision Decathlon, The (USA).a52" size 16384 crc F43E7CD0 md5 45F8841269313736489180C8EC3E9588 sha1 DB203973DF13B071DA46D52FDB078A76F4DB428D )

		}

#		$::Console3 insert end "$line\n"
	}
}

 
#source $::HOMEDIR/SYS/ext_nds.tcl

