proc testTheme {} {

set ::systemBGColorSel "#738b51"
set ::systemBGColor "#26271f"
set ::systemFGColorSel "#ffffff"
set ::systemFGColor "#738b51"
set ::systemBGGeneral "#26271f"

set darkBG "#26271f"
set selectionBG "#32405a"
set captionTXT "#738b51"
set disableTXT "#7c7b77"
set activeTXT "#ffffff"

# TTK BUTTONS
ttk::style configure TButton -background $darkBG -foreground $captionTXT
	ttk::style map TButton \
	-background [list disabled $darkBG active $selectionBG] \
	-foreground [list disabled $disableTXT active $activeTXT] \
	-relief [list {pressed !disabled} sunken]

ttk::style configure Treeview -background $darkBG -foreground $activeTXT -fieldbackground $darkBG

ttk::style map Treeview \
	-background [list selected $captionTXT] \
	-foreground [list selected $activeTXT]
ttk::style configure Heading -background $darkBG -foreground $captionTXT



# TTK NOTEBOOK
ttk::style configure TNotebook -background $darkBG -foreground $captionTXT
ttk::style configure TNotebook.Tab -background $darkBG -foreground $disableTXT
	ttk::style map TNotebook.Tab \
	-background [list selected $darkBG active $selectionBG disabled $selectionBG] \
	-foreground [list selected $activeTXT active $activeTXT disabled $darkBG]
#ttk::style configure TNotebook.Tab -font namedfont

#ttk::style configure TFrame -background $darkBG -foreground $captionTXT
ttk::style configure TFrame -background $darkBG -foreground $captionTXT
ttk::style configure TLabelframe -background $darkBG -foreground $captionTXT
ttk::style configure TLabelframe.Label -background $darkBG -foreground $captionTXT
ttk::style configure TLabel -background $darkBG -foreground $captionTXT
ttk::style configure TEntry -background $darkBG -foreground $captionTXT -fieldbackground $darkBG

ttk::style configure Horizontal.TScrollbar -background $darkBG -troughcolor $captionTXT
	ttk::style map Horizontal.TScrollbar \
	-background [list active $selectionBG disabled $selectionBG] \
	-foreground [list active $activeTXT disabled $darkBG]
ttk::style configure Vertical.TScrollbar -background $darkBG -troughcolor $captionTXT
	ttk::style map Vertical.TScrollbar \
	-background [list active $selectionBG disabled $selectionBG] \
	-foreground [list active $activeTXT disabled $darkBG]


ttk::style configure TProgressbar -background $captionTXT -troughcolor $darkBG

#Console1 tk::text .n.f1.text
$::Console0 configure -background $darkBG -foreground $captionTXT
$::Console1 configure -background $darkBG -foreground $captionTXT
$::Console2 configure -background $darkBG -foreground $captionTXT
$::Console3 configure -background $darkBG -foreground $captionTXT

#.n.f0.startframe.starticon configure -background $darkBG -foreground $captionTXT
.n.f0.start configure -background $darkBG -foreground $captionTXT
.n.f0.syslist configure -background $::systemBGGeneral ;#-family Courier
.n.f2.syslist configure -background $::systemBGGeneral

set fontstat [font actual [.n.f0.syslist cget -font]]
		$::Console0 insert end "font: $fontstat \n"

.n.f2.corpframe.logo configure -background $darkBG -foreground $captionTXT
.n.f2.corpframe.note.data.game configure -background $darkBG -foreground $captionTXT

.n.f5.datlist configure -background $darkBG -foreground $captionTXT
#.n.f0.3rd.subnote.user.star configure -background $darkBG -foreground $captionTXT
#.n.f0.3rd.subnote.user.star.star1 configure -background $darkBG -foreground $captionTXT
#.n.f0.3rd.subnote.user.star.star2 configure -background $darkBG -foreground $captionTXT
#.n.f0.3rd.subnote.user.star.star3 configure -background $darkBG -foreground $captionTXT
#.n.f0.3rd.subnote.user.star.star4 configure -background $darkBG -foreground $captionTXT
#.n.f0.3rd.subnote.user.star.star5 configure -background $darkBG -foreground $captionTXT

$::systemlistDB configure -background $darkBG -foreground $captionTXT
.n.f0.3rd.subnote.awa.awa configure -background $::systemBGGeneral

.n.f9.artbox.art configure -background $darkBG -foreground $captionTXT

# Refresh the GUI
refreshSelectedList
}
