package require Tk
package require img::png
package require sqlite3

# ===========================================================
# Hello, if you see this text: ixbar3000 did not launch!
# Have you installed ActiveTCL?
# ===========================================================

# VERSION					===========================================================
set ::ixbarversion "ixbar3000 v0.31 -- Suzaku"
wm title . "$::ixbarversion"
set ::loglevel 1;								# sets the loglevel. 1 is for user 9 for developer
set ::HOMEDIR [pwd]

# CONNECT DATABASES			===========================================================
sqlite3 dbSTAT $::HOMEDIR/SYS/db/usr.db;		# playcounts, awards and ratings
sqlite3 dbDATA $::HOMEDIR/SYS/db/text.db;		# datfiles
sqlite3 dbLOCA $::HOMEDIR/SYS/db/locations.db;	# windows location mappings
sqlite3 dbCORP $::HOMEDIR/SYS/db/maker.db;		# corporation data
sqlite3 dbCONF $::HOMEDIR/SYS/db/config.db;		# settings

#DB INIT
# MASTER CHECK
if {[dbCONF exists "SELECT name FROM sqlite_master WHERE type='table' AND name='systemconfig' ";]} {
} else {
dbCONF eval "CREATE TABLE systemconfig (System VARCHAR, SystemHuman VARCHAR, Active VARCHAR, LoadType VARCHAR, wemu VARCHAR, lemu VARCHAR, RomPreset VARCHAR, RomPostset VARCHAR, RomDirectory VARCHAR, MetaDate VARCHAR, MetaType VARCHAR, MetaGeneration VARCHAR, MetaOrigin VARCHAR, MetaManufacturer VARCHAR, EXT1 VARCHAR, EXT2 VARCHAR, EXT3 VARCHAR);"
}
source ./SYS/fn_init.tcl
source ./SYS/_config.tcl
source ./SYS/_gui.tcl
source ./SYS/logtext.tcl
source ./SYS/fn_sysloader.tcl

# KEYBINDINGS				===========================================================
bind $::systemlist <<ListboxSelect>> "clickSystemList"
bind $::romlist <<ListboxSelect>> "clickRomList"
#bind $::romlist <Double-1> {StartApp $::selectedEmu $::selectedRom};# bugittaa playcountit(?)
bind $::systemlistDB <<ListboxSelect>> "clickDBSystemList"

bind . <Alt-KeyPress-1> "VirtualLibrary"
bind . <Alt-KeyPress-2> "VirtualDatabase"
bind . <Alt-KeyPress-3> "VirtualStats"
bind . <Alt-KeyPress-4> "VirtualExplorer"
bind . <Alt-KeyPress-5> "VirtualAbout"

bind . <Alt-KeyPress-a> "VirtualPrevSYS"
bind . <Alt-KeyPress-z> "VirtualNextSYS"
bind . <Alt-KeyPress-x> "VirtualSetMode"
bind . <Alt-KeyPress-c> "VirtualStart"

set ::EXTERNALIMG "$::HOMEDIR/IMG/"; 		# Default directory
set ext_imgrepo "$::HOMEDIR/../ixb3k_IMG"; 	# Alternative directory
if {[file exists "$ext_imgrepo"]} {
	set ::EXTERNALIMG "$ext_imgrepo"
}

if {$::tcl_platform(platform) eq "Linux"} {
	$::Console0 insert end "LOAD Linux  variables...\n";# FAILS with Ubuntu(=unix)
} elseif {$::tcl_platform(platform) eq "windows"} {
	$::Console0 insert end "LOAD Windows variables...\n"
	set ::SYSTEMROOT "c:/"
	set ::DetectedOS "WIN"
	set ::drive1 "c:/"
	set ::drive2 "d:/"
	set ::drive3 "e:/"
	set ::drive4 "f:/"
	set ::drive5 "g:/"
#	set ::MusicPlayer "c:/vlc"
#	set ::MagazinePlayer "c:/vlc"
	#Show only windows -- n00b protekt (tm)
	grid .n.f1.setupframe.exewin		-column 3 -row 3 -sticky we
	grid .n.f1.setupframe.setwinexe		-column 4 -row 3 -sticky we
	grid .n.f1.setupframe.setwinexeb 	-column 5 -row 3 -sticky e
} else {
	$::Console0 insert end "LOAD UNIX variables...\n"
	set ::SYSTEMROOT "/"
	set ::DetectedOS "LIN"
	set ::drive1 "media/drivea/"
	set ::drive2 "media/driveb/"
	set ::drive3 "media/drivec/"
	set ::drive4 "media/drived/"
	set ::drive5 "media/drivee/"
	set ::MusicPlayer "audacious"
	#Show all
	grid .n.f1.setupframe.exelin		-column 3 -row 2 -sticky we
	grid .n.f1.setupframe.exewin		-column 3 -row 3 -sticky we
	grid .n.f1.setupframe.setlinexe		-column 4 -row 2 -sticky we 
	grid .n.f1.setupframe.setwinexe		-column 4 -row 3 -sticky we
	grid .n.f1.setupframe.setwinexeb	-column 5 -row 3 -sticky e

#.n.f1.setupframe.exewin configure -state disabled
#.n.f1.setupframe.setwinexe state disabled
#.n.f1.setupframe.setwinexeb state disabled
}
$::Console0 insert end "Initializing.. $::tcl_platform(platform)\nHomedir:$::HOMEDIR\nDrives:$::drive1;$::drive2\n"


DisableThirdPanel
DisableDatabaseEdit

# FUNCTION CALLS START HERE	===========================================================
source ./SYS/fn_joystick.tcl;	#	Joystick

source ./SYS/pg_database.tcl;	#	Adds Database-tab stuff
source ./SYS/pg_library.tcl;	#	Adds Library-tab stuff
source ./SYS/pg_statistic.tcl;	#	Adds Statustics-tab
source ./SYS/pg_datexplore.tcl;	#	Adds datexplore
source ./SYS/pg_mp.tcl;			#	Adds irc and mp
source ./SYS/pg_options.tcl;	#	Adds advanced options
source ./SYS/pg_about.tcl;		#	Adds credtist
source ./SYS/pg_manual.tcl;		#	Adds manual
source ./SYS/_context.tcl;		#	Adds contextMenu

#source ./SYS/fn_nice.tcl;		#		Unused atm. (should help to add foobar2000-like functionality)
source ./SYS/fn_timestat.tcl;	#	Tracks user time
source ./SYS/fn_parsers.tcl;	#	Various parsers

source ./SYS/fn_utility.tcl;	#	crc7zip, startup
source ./SYS/fn_resolve.tcl;	#	returns g_selectedRom
source ./SYS/fn_thirdpanelimg.tcl;# Code to enable images and extra exes.
source ./SYS/fn_award.tcl;		# 	Code to enable award functionality
source ./SYS/fn_stats.tcl;		# 	Code to enable statistics
source ./SYS/fn_editmeta.tcl;	#	Code to enable metadata editing
#InitNewSyslist
clearSystemList
historyView
#InitNewSyslistStat

proc VirtualLibrary {} {;.n select .n.f0;}
proc VirtualDatabase {} {;.n select .n.f1;}
proc VirtualStats {} {;.n select .n.f2;}
proc VirtualExplorer {} {;.n select .n.f5;}
proc VirtualAbout {} {;.n select .n.f9;}


proc VirtualNextLetter {} {

	set alphabets [list a b c d e f g h i j k l m n o p q r s t u v x y z å ä ö]
	set thisItem [.n.f0.stattree selection]
	
	if {$thisItem eq ""} {;set thisItem [lindex $::StatisticDATA 0];}
	set myId [string map {\{ "" \} ""} $thisItem]
	
	set letterNow [string range $myId 0 0]
	set letterNowidx [lsearch -nocase $alphabets "$letterNow*"]

	$::Console0 insert end "DING $myId<$letterNow> \n"

	set x 1
	set Nextidx -1
	while {$Nextidx eq -1 && $x < 30} {		;# skip empty letters
		set letterNextidx [expr $letterNowidx+$x]
		set letterNext [lindex $alphabets $letterNextidx]
		set Nextidx [lsearch -nocase $::StatisticDATA "$letterNext*"]
		incr x
	}
	set thisItem [lindex $::StatisticDATA $Nextidx]
	set thisItem "{$thisItem}"
		$::Console0 insert end "--- $thisItem> \n"

	set myId [string map {\{ "" \} ""} $thisItem]]
	set isMaster [lindex [dbCORP eval "SELECT locale FROM $::SelectedDB WHERE crc=\"$myId\" ";] 0]
	if {$isMaster ne ""} {;
		set myId $isMaster;
		$::Console0 insert end "SKIP AND DO ALSE \n"
		$::Console0 insert end "myId: <$myId> \n"
		# TODO -- Fails if master has different letter.
		set thisItem "{$myId}"
	}

	
	set myId [string map {\{ "" \} ""} $thisItem]
	.n.f0.stattree see $myId
	.n.f0.stattree selection set $thisItem
}


proc VirtualPrevLetter {} {
	set alphabets [list a b c d e f g h i j k l m n o p q r s t u v x y z å ä ö]
	set thisItem [.n.f0.stattree selection]
	
	if {$thisItem eq ""} {;set thisItem [lindex $::StatisticDATA 0];}
	set myId [string map {\{ "" \} ""} $thisItem]

	set letterNow [string range $myId 0 0]
	set letterNowidx [lsearch -nocase $alphabets "$letterNow*"]

	$::Console0 insert end "DING $myId<$letterNow> \n"

	set x 1
	set Nextidx -1
	while {$Nextidx eq -1 && $x < 30} {		;# skip empty letters
		set letterNextidx [expr $letterNowidx-$x]
		set letterNext [lindex $alphabets $letterNextidx]
		set Nextidx [lsearch -nocase $::StatisticDATA "$letterNext*"]
		incr x
	}
	set thisItem [lindex $::StatisticDATA $Nextidx]
	set thisItem "{$thisItem}"
		$::Console0 insert end "--- $thisItem> \n"

	set myId [string map {\} ""} [string map {\{ ""} $thisItem]]
	set isMaster [lindex [dbCORP eval "SELECT locale FROM $::SelectedDB WHERE crc=\"$myId\" ";] 0]
	if {$isMaster ne ""} {;
		set myId $isMaster;
		$::Console0 insert end "SKIP AND DO ALSE \n"
		$::Console0 insert end "myId: <$myId> \n"
		# TODO -- Fails if master has different letter.
		set thisItem "{$myId}"
	}

	set myId [string map {\{ "" \} ""} $thisItem]
	.n.f0.stattree see $myId
	.n.f0.stattree selection set $thisItem
}

proc VirtualNextSYS {} {
	set count [llength $::db_systems]

	if {![info exists ::selectedSystemID]} {;		set ::selectedSystemID 0;	}
	set newSys [expr $::selectedSystemID+1]
	if {$newSys < $count} {;populateRomView $newSys;}

#	$::Console0 insert end "VnextS> $::selectedSystemID < $newSys > \n"
}

proc VirtualPrevSYS {} {
	if {![info exists ::selectedSystemID]} {;		set ::selectedSystemID 1;	}
	set newSys [expr $::selectedSystemID-1]
	if {$newSys >= 0} {;populateRomView $newSys;}

#	$::Console0 insert end "VprevS> $::selectedSystemID < $newSys > \n"
}

proc VirtualThisROM {} {

#	set SDB [lindex $::db_systems $::selectedSystemID]	;# History broken
#	set DATA [dbDATA eval "SELECT name FROM \"$SDB\" ORDER BY name ASC"]
#	set firstRom [lindex $DATA 1]
#	set firstRom "\{$firstRom\}"

#	$::Console0 insert end "THISROM> $firstRom <--> \n"
	#.n.f0.stattree selection set $firstRom		;# mouse click broken
	set ::cabinetCtrl "RL"
	set ::RLentry $::selectedRom
#	$::Console0 insert end "RLentry> $::RLentry <--> \n"
#	set isMaster [lindex [dbCORP eval "SELECT locale FROM $::SelectedDB WHERE name=\"$firstRom\" ";] 0]
#	if {$isMaster ne ""} {;				set ::RLentry $isMaster;			}
#	$::Console0 insert end "RLentry> $::RLentry <-$::SelectedDB-> \n"

	if {![info exists ::RLentry]} {
		if {![info exists ::StatisticDATA]} {; return;	}
		#set ::RLentry [lindex $::StatisticDATA 0] 
		$::Console0 insert end "> $::RLentry <----> \n"
		set isMaster [lindex [dbCORP eval "SELECT locale FROM $::SelectedDB WHERE crc=\"$::RLentry\" ";] 0]
			if {$isMaster ne ""} {;				set ::RLentry $isMaster;			}
	}
	set ::RLentry [string map {" " "\ "} $::RLentry]
	set ::RLentryNoBrak $::RLentry
	set ::RLentry "\{$::RLentry\}"

	catch {
		set ::RLnext [.n.f0.stattree next $::RLentryNoBrak]
		set ::RLprev [.n.f0.stattree prev $::RLentryNoBrak]
		#set ::RLnext [.n.f0.stattree next 0]
#		$::Console0 insert end "Prev:<$::RLprev>\nNext:>$::RLnext<\n\n"
#		set myId [string map {\{ ""} $thisItem]
#		set myId [string map {\} ""} $myId]
#		.n.f0.stattree see $::RLentryNoBrak
#		.n.f0.stattree selection set $::RLentry
	}
#	$::Console0 insert end "> $::RLnext <-> \n"

}

proc VirtualNextROM {} {
	#TODO get name of 1st entry -- set that as default
	#set RLentry [lindex [list {*}$::StatisticDATA] 0]
	#TODO -- [lindex $::StatisticDATA 0] gives 1st in the list, NOT the visible one 007 is hidden under bond

	if {![info exists ::RLentry]} {;	
		if {![info exists ::StatisticDATA]} {; return;	}
		set ::RLentry [lindex $::StatisticDATA 0]
	#	set ::RLentry [lindex [list {*}$::StatisticDATA] 0]
		$::Console0 insert end "***> <entry: $::RLentry >\n"
		set isMaster [lindex [dbCORP eval "SELECT locale FROM $::SelectedDB WHERE crc=\"$::RLentry\" ";] 0]
			if {$isMaster ne ""} {;		set ::RLentry $isMaster;	}
	} else {;							set ::RLentry $::RLnext;	}
	set ::RLentry [string map {" " "\ "} $::RLentry]
	set ::RLentryNoBrak $::RLentry 
	set ::RLentry "\{$::RLentry\}"

	catch {
		set ::RLnext [.n.f0.stattree next $::RLentryNoBrak]
		set ::RLprev [.n.f0.stattree prev $::RLentryNoBrak]

		if {$::RLnext eq ""} {;set ::RLnext $::RLentry;}

		.n.f0.stattree selection set $::RLentry
		.n.f0.stattree focus $::RLentryNoBrak
	#	.n.f0.stattree see $::RLentryNoBrak

	}

	$::Console0 insert end "VnextR> $::RLprev \n<entry: $::RLentry > \nnxt: $::RLnext\n"
}

proc VirtualPrevROM {} {

	if {![info exists ::RLentry]} {;	
		if {![info exists ::StatisticDATA]} {; return;	}
		set ::RLentry [lindex $::StatisticDATA 0]
		set isMaster [lindex [dbCORP eval "SELECT locale FROM $::SelectedDB WHERE crc=\"$::RLentry\" ";] 0]
			if {$isMaster ne ""} {;		set ::RLentry $isMaster;	}
	} else {;							set ::RLentry $::RLprev;	}
	set ::RLentry [string map {" " "\ "} $::RLentry]
	set ::RLentryNoBrak $::RLentry 
	set ::RLentry "\{$::RLentry\}"

	#.n.f0.stattree selection set $RLentry
	catch {
	set ::RLnext [.n.f0.stattree next $::RLentryNoBrak]
	set ::RLprev [.n.f0.stattree prev $::RLentryNoBrak]

	if {$::RLprev eq ""} {;set ::RLprev $::RLentry;}

		.n.f0.stattree selection set $::RLentry
		.n.f0.stattree focus $::RLentryNoBrak
#		.n.f0.stattree see $::RLentryNoBrak
	}

	$::Console0 insert end "VprevR> $::RLprev < $::RLentry > $::RLnext\n"
}

proc VirtualSetMode {} {
	if {$::cabinetCtrl eq "SL"} {
		$::Console0 insert end "Controlling SL... \n"
		bind . <Alt-KeyPress-a> "VirtualPrevSYS"
		bind . <Alt-KeyPress-z> "VirtualNextSYS"
		set ::cabinetCtrl "RL"
	} elseif {$::cabinetCtrl eq "RL"} {
		$::Console0 insert end "Controlling RL...\n"
		bind . <Alt-KeyPress-a> "VirtualPrevROM"
		bind . <Alt-KeyPress-z> "VirtualNextROM"
		set ::cabinetCtrl "SL"
	}
}

proc VirtualStart {} {
	if {$::cabinetCtrl eq "SL"} {
		StartApp $::selectedEmu $::selectedRomFast
	} else {
		$::Console0 insert end "RL is not active.\n"
	}

}

#set ::cabinetCtrl "SL"
#VirtualPrevSYS
VirtualSetMode

# =================================================


proc joySetMode {} { ; # UNUSED
	if {$::cabinetCtrl eq "SL"} {
		logtext "Control: SL" 1
		set ::cabinetCtrl "RL"
	} elseif {$::cabinetCtrl eq "RL"} {
		logtext "Control: RL" 1
		set ::cabinetCtrl "SL"
	}
}


proc joyCheckParent {} {;						# Check if item has parent, drop level if so
	set parent [.n.f0.stattree parent $::RLitem]	
	if {$parent ne ""} {
		logtext "Parent: $parent" 1
		catch {
			set ::RLitem $parent
			set ::RLnext [.n.f0.stattree next $parent]
			set ::RLprev [.n.f0.stattree prev $parent]
			.n.f0.stattree selection set "\{$parent\}" 
		}
	}
}


proc joyCanvas {} {
	set ::textfromRomlist "$::RLitem"
	set ::gameplaycount "1337"
	LoadROMImages 0
	updateGamecanvas
}


proc joyUpdateSelection {} {
	logtext "Control: joyUpdateSelection" 1
	
	catch {
		set ::RLnext [.n.f0.stattree next $::RLitem]
		set ::RLprev [.n.f0.stattree prev $::RLitem]
	}

	joyCheckParent
	joyCanvas
}


proc joyFirstItem {} {
	logtext "Control: joyFirstItem" 1
	
	if {![info exists ::selectedSystemID]} {;
		# TODO -- Browse history!! 
		#      -- "NEC98>Game" != "Game"
		set ::CANVASDATA [dbSTAT eval "SELECT name FROM history WHERE lastplayed>1479000000 ORDER BY lastplayed DESC LIMIT 100";];# , system,lastplayed
		logtext "CANVASDATA: $::CANVASDATA" 1
	} else {
		set SDB [lindex $::db_systems $::selectedSystemID]	;# History broken
		set ::CANVASDATA [dbDATA eval "SELECT name FROM \"$SDB\" ORDER BY name ASC"]
	}
	set firstRom [lindex $::CANVASDATA 1]
	set firstRomBrace "\{$firstRom\}"

	logtext "Control: $firstRom" 1
	.n.f0.stattree selection set $firstRomBrace		;# mouse click broken
	
	catch {
		set ::RLitem $firstRom
		set ::RLnext [.n.f0.stattree next $firstRom]
		set ::RLprev [.n.f0.stattree prev $firstRom]
	}
	joyCheckParent
	
	logtext "Control NX: $::RLnext" 1
	logtext "Control PR: $::RLprev" 1
	joyCanvas
}

proc joyNextItem {} {
	logtext "Control: joyNextItem" 1
	logtext "Control>NX: $::RLnext" 1
	logtext "Control PR: $::RLprev" 1
	if {$::RLnext ne ""} {
		set ::RLitem $::RLnext
		.n.f0.stattree selection set \{$::RLnext\}		;# mouse click broken
		joyUpdateSelection
	}
}

proc joyPrevItem {} {
	logtext "Control: joyPrevItem" 1
	logtext "Control NX: $::RLnext" 1
	logtext "Control>PR: $::RLprev" 1
	
	if {$::RLprev ne ""} {
		set ::RLitem $::RLprev
		.n.f0.stattree selection set \{$::RLprev\}		;# mouse click broken
		joyUpdateSelection
	}
}

proc joyNextSys {} {
	logtext "Control: joyNextSys" 1
	set count [llength $::db_systems]

	if {![info exists ::selectedSystemID]} {;
		set ::selectedSystemID 0;
	}
	set newSys [expr $::selectedSystemID+1]
	if {$newSys < $count} {;populateRomView $newSys;}
}

proc joyPrevSys {} {
	logtext "Control: joyPrevSys" 1
	if {![info exists ::selectedSystemID]} {;
		set ::selectedSystemID 1;
	}
	set newSys [expr $::selectedSystemID-1]
	if {$newSys >= 0} {;populateRomView $newSys;}
}



proc joyNextLetter {type} {
	if {![info exists ::CANVASDATA]} {;	joyFirstItem;	}
	if {![info exists ::RLitem]} {;	joyFirstItem;	}
	set alphabets [list 0 1 2 3 4 5 6 7 8 9 a b c d e f g h i j k l m n o p q r s t u v x y z å ä ö]
	set thisItem [.n.f0.stattree selection]
	
	if {$thisItem eq ""} {;set thisItem [lindex $::CANVASDATA 0];}
	set myId [string map {\{ "" \} ""} $thisItem]

	set letterNow [string range $myId 0 0]
	set letterNowidx [lsearch -nocase $alphabets "$letterNow*"]

	set x 1
	set Nextidx -1
	while {$Nextidx eq -1 && $x < 40} {		;# skip empty letters
	
		if { $type eq "1" } {
			set letterNextidx [expr $letterNowidx-$x] ;# prev
		} elseif { $type eq "2" } {
			set letterNextidx [expr $letterNowidx+$x] ;# next
		}
		
		set letterNext [lindex $alphabets $letterNextidx]
		set Nextidx [lsearch -nocase $::CANVASDATA "$letterNext*"]
		incr x
	}
	
	
	set thisItem [lindex $::CANVASDATA $Nextidx]
	set parentLetter [.n.f0.stattree parent $thisItem]
	set parentLetter [string range $parentLetter 0 0]
	
	if { $parentLetter ne $letterNow  } {;				# Parent letter is different -> use next item
		set z 0
		set parentOK ""
		
		while { $z < 4 } {
			set thisItem [lindex $::CANVASDATA $Nextidx+$z]
			logtext "TRY ($z): $thisItem/$Nextidx" 1
			set parentLetter [.n.f0.stattree parent $thisItem]
			
			if { $parentLetter eq "" } {
				break
			}
			incr z
		}
	}
	
	
	set ::RLitem $thisItem
	set thisItem "{$thisItem}"

	.n.f0.stattree selection set $thisItem

	joyCheckParent
	joyUpdateSelection
}


# =================================================


