ttk::notebook .n;	grid .n  -column 0 -row 0 -sticky nwes
ttk::frame .n.f0;	.n add .n.f0 -text "Library";	#grid .n.f0  -column 0 -row 0 -sticky nwes
ttk::frame .n.f1 -padding 2;	.n add .n.f1 -text "Database"


#======
if {[info exists geowidth]} {
	set x x
	set libraryheight [expr $geoheight-100]
	wm geometry . $geowidth$x$geoheight+0+0
} else {
	set libraryheight [expr $geoheight-100]
}
#======
grid [ttk::frame .n.f0.3rd -width 400 -height $libraryheight] -column 2 -row 0 -sticky ns -rowspan 2

grid propagate .n.f0.3rd 0

grid columnconfigure . 0 -weight 1
grid rowconfigure . 0 -weight 1
grid columnconfigure .n.f0 0 -weight 0
grid columnconfigure .n.f0 1 -weight 1
grid columnconfigure .n.f0 2 -weight 0
grid rowconfigure .n.f0 0 -weight 1
grid rowconfigure .n.f0 1 -weight 1
grid rowconfigure .n.f0 2 -weight 0
grid rowconfigure .n.f0 3 -weight 0
#grid rowconfigure .editwindow 50 -weight 1
grid rowconfigure .n.f0.3rd 0 -weight 1

grid rowconfigure .n.f1 0 -weight 0
grid rowconfigure .n.f1 1 -weight 0
grid rowconfigure .n.f1 2 -weight 1
grid rowconfigure .n.f1 3 -weight 0
grid columnconfigure .n.f1 0 -weight 1
grid columnconfigure .n.f1 1 -weight 0
grid columnconfigure .n.f1 2 -weight 3
grid columnconfigure .n.f1 3 -weight 9
#1.col 0,0,1,3

grid [ttk::notebook .n.f0.3rd.subnote -width 390]	-column 2 -row 0 -sticky ns
ttk::frame .n.f0.3rd.subnote.images;			.n.f0.3rd.subnote add .n.f0.3rd.subnote.images -text "Images"
ttk::frame .n.f0.3rd.subnote.data -padding 10;	.n.f0.3rd.subnote add .n.f0.3rd.subnote.data -text "Metadata"
ttk::frame .n.f0.3rd.subnote.user ;	.n.f0.3rd.subnote add .n.f0.3rd.subnote.user -text "Media"
ttk::frame .n.f0.3rd.subnote.awa;				.n.f0.3rd.subnote add .n.f0.3rd.subnote.awa -text "Awards" ;#-state disabled
ttk::frame .n.f0.3rd.subnote.text;				.n.f0.3rd.subnote add .n.f0.3rd.subnote.text -text "Console"

# Set button images
image create photo btnIconClear -file "./IMG/clear.png"
image create photo toggleRight -file "./IMG/toggleRight.png"
image create photo toggleLeft -file "./IMG/toggleLeft.png"
set searchstring ""


set ::systemlist [tk::listbox .n.f0.systemlist -listvariable db_systems_human ];	#	grid .n.f0.systemlist -column 0 -row 0 -rowspan 2 -sticky ns
set ::romlist [tk::listbox .n.f0.romlist -yscrollcommand ".n.f0.scroll set" ];		#grid .n.f0.romlist -column 1 -row 0 -rowspan 2 -sticky ns
ttk::scrollbar .n.f0.scroll -orient vertical -command ".n.f0.romlist yview";		#grid .n.f0.scroll -column 1 -row 0 -rowspan 2 -sticky nse
set ::image1 .n.f0.3rd.subnote.images.imageSlot1;	ttk::label $::image1;		grid $::image1 -column 2 -row 1  ;#-ipady 300
set ::image2 .n.f0.3rd.subnote.images.imageSlot2;	ttk::label $::image2;		grid $::image2 -column 2 -row 2 -sticky s

# -columnspan 3  -state disabled   -width 300 -height 500
#grid [tk::labelframe .n.f0.3rd.subnote.text.frame]	-column 0 -row 0 -sticky news
#set ::Console0 [tk::text .n.f0.text ];		 -width 50 -height 30											grid $::Console0 -column 0 -row 1 -columnspan 2 -sticky wes;# -columnspan 2
#set ::Console0 [tk::text .n.f0.3rd.subnote.text.frame.c -width 50 -height 30];						grid $::Console0 -column 0 -row 2 -sticky news;# -columnspan 2
set ::Console0 [tk::text .n.f0.3rd.subnote.text.c -width 50 -height 30];						grid $::Console0 -column 0 -row 0 -sticky news;# -columnspan 2
grid [ttk::button .n.f0.3rd.subnote.text.clearConsole0 -text "clearConsole" -command {clearConsole}]		-column 0 -row 3 -sticky w
grid [ttk::button .n.f0.3rd.subnote.text.awddata -text "TEST Theme!" -command {testTheme} ]	-column 0 -row 4 -sticky w
grid [ttk::button .n.f0.listallRL -text "OMNI \u03A9" -command {listAllToRomlist}]	-column 0 -row 3 -rowspan 2 -sticky news


# CANVAS TEST AREA
grid [tk::canvas .n.f0.syslistcanvas -width 250 -scrollregion "0 0 200 600" -yscrollcommand ".n.f0.syslistcanvasscr set"] -column 0 -row 0 -rowspan 2 -sticky nwes
grid [ttk::scrollbar .n.f0.syslistcanvasscr -orient vertical -command ".n.f0.syslistcanvas yview" ] -column 0 -row 0 -rowspan 2 -sticky nes
grid remove .n.f0.syslistcanvas
grid remove .n.f0.syslistcanvasscr


source ./SYS/th_steam.tcl;#TODO improve the theme loader.


grid [ttk::frame .n.f0.searchBox -relief flat] -column 1 -row 3  -sticky we 
grid [ttk::entry .n.f0.searchBox.search -textvariable searchstring]												-column 0 -row 2 -sticky wens -columnspan 7 -padx 4 -pady 2
grid [ttk::button .n.f0.searchBox.searchButton -text "Search" -command {searchThis $searchstring}]				-column 7 -row 2 -sticky we -columnspan 2
grid [ttk::button .n.f0.searchBox.searchButtonClear -text "Clear" -command {searchClear} -compound image -image "btnIconClear"]						-column 9 -row 2 -sticky w
#grid [ttk::button .n.f0.searchBox.buttonClearMissing -text "Hide missing" -command {ClearMissing}]			-column 7 -row 4 -sticky w
#grid [ttk::button .n.f0.searchBox.buttonClearHaves -text "Show only missing" -command {ClearHaves}]				-column 6 -row 4 -sticky e
#grid [ttk::button .n.f0.searchBox.testfunctionzwei -text "testfunctionzwei" -command {testfunctionzwei}]		-column 1 -row 4 -sticky w
grid [ttk::button .n.f0.searchBox.buttoniconify -text "Iconify" -command {toggleLibraryLeft} -compound image -image "toggleLeft"]			-column 7 -row 4 -sticky w
grid [ttk::button .n.f0.searchBox.testfunctionzwei -command "toggleLibraryRight" -compound image -image "toggleRight"]		-column 9 -row 4 -sticky w

grid [ttk::button .n.f0.searchBox.buttongamecanvas -width 2 -text "\u2318" -command {toggleLibraryCenter} ]			-column 8 -row 4 -sticky wns


grid [ttk::button .n.f0.searchBox.sysUP -width 2 -text "\u25B2" -command {VirtualPrevSYS} ]			-column 2 -row 4 -sticky wns
grid [ttk::button .n.f0.searchBox.sysDW -width 2 -text "\u25BC" -command {VirtualNextSYS} ]			-column 3 -row 4 -sticky wns

grid [ttk::button .n.f0.searchBox.sysPR -width 2 -text "\u21E6" -command {VirtualPrevROM} ]			-column 4 -row 4 -sticky wns
grid [ttk::button .n.f0.searchBox.sysNE -width 2 -text "\u21E8" -command {VirtualNextROM} ]			-column 5 -row 4 -sticky wns
#-compound image -image "toggleLeft"



# ======================================


grid rowconfigure .n.f0.searchBox 0 -weight 2
grid columnconfigure .n.f0.searchBox 1 -weight 2

grid [ttk::combobox .n.f0.searchBox.romlisttype -textvariable romlisttype] 							-column 0 -row 4 -sticky w -padx 4
.n.f0.searchBox.romlisttype configure -values [list {Hide Missing} {Hide Available}] ;#-state disabled  toggleRomlistType
bind .n.f0.searchBox.romlisttype <<ComboboxSelected>> { toggleFilterList }

#grid [ttk::button .n.f0.testertwat -text "ClearSL" -command {clearSystemList}]						-column 0 -row 3 -sticky e


image create photo systemicon -file "$::HOMEDIR/IMG/icon_noicon.png" -height 48 -width 48

set ::imageromlist [tk::text .n.f0.texttest]; 	#					grid .n.f0.texttest -column 1 -row 2 -sticky wes
#ttk::scrollbar .n.f0.scrolltext -orient vertical -command ".n.f0.texttest yview";		grid .n.f0.scrolltext -column 1 -row 2 

ttk::scale .n.f0.scrolltext -orient horizontal -from 0.0 -to 1.0 -length 450 -command {setTextPage};#	grid .n.f0.scrolltext -column 1 -row 2 -sticky sew

grid [tk::button .n.f0.start -text "     S T A R T  G A M E" -anchor w -image systemicon -compound left -relief groove -command {StartApp $::selectedEmu $::selectedRomFast} ]	-column 2 -row 3 -sticky news;#REMOVE THIS	grid [}]	-column 3 -row 3 -sticky nsw;# -ipadx 30


image create photo corplogoextraDev -file "$::HOMEDIR/IMG/corp/noLogo.png" -height 64 -width 300
image create photo corplogoextraPub -file "$::HOMEDIR/IMG/corp/noLogo.png" -height 64 -width 300
ttk::labelframe .n.f0.3rd.extrapanel -text "Extra Panel" -height 200 -padding 00
tk::label .n.f0.3rd.extrapanel.dev -image corplogoextraDev -anchor center
tk::label .n.f0.3rd.extrapanel.pub -image corplogoextraPub -anchor center
toggleExtraPanel

# 2015 add DEVLOGO26
#grid [ttk::labelframe .n.f0.upperpanel -text "U Panel"]	-column 1 -row 0 -sticky ns
#ttk::labelframe .n.f0.upperpanel -text "U Panel"
#tk::label .n.f0.upperpanel.dev -image corplogoextraDev -anchor center -height 64
#grid [ttk::notebook .n.f0.3rd.subnote -width 390]	-column 2 -row 0 -sticky ns
#grid .n.f0.upperpanel -column 2 -row 0 -columnspan 0 -sticky wes -padx 5

#grid [tk::button .n.f0.start1 -text "  E" -anchor w -image systemicon -compound left -relief groove -command {} ]	-column 2 -row 4 -sticky news
#grid [tk::label .n.f0.upperpanel_dev -image corplogoextraDev -anchor center -height 64 ]	-column 1 -row 0 -sticky news;# -rowspan 2




set buttonwidth 18
grid [ttk::button .n.f0.3rd.subnote.user.manual -text "Manual" -command {openManual}]		-column 2 -row 6 -columnspan 2 -sticky wes -padx 10
grid [ttk::button .n.f0.3rd.subnote.user.ost -text "Soundtrack" -command {playPlaylist}]	-column 2 -row 7 -columnspan 2 -sticky wes -padx 10
grid [ttk::button .n.f0.3rd.subnote.user.vid -text "Video" -command {playVideo}]			-column 2 -row 8 -columnspan 2 -sticky wes -padx 10
grid [ttk::button .n.f0.3rd.subnote.user.setexe -text "Entry Editor" -command {addExe}]			-column 2 -row 20 -columnspan 2 -sticky wes -padx 10




# DATABASE PAGE =========================================================================
# Frames
grid [ttk::labelframe .n.f1.setupframe -text "Emulator Setup" -labelanchor n -padding 5]		-column 1 -columnspan 3 -row 0 -sticky new -padx 5
grid [ttk::labelframe .n.f1.systemframe -text "System Info"   -labelanchor n -padding 5]		-column 1 -columnspan 2 -row 2 -sticky news -padx 5
grid [ttk::labelframe .n.f1.exportframe -text "Images"        -labelanchor n -padding 5]		-column 1 -columnspan 2 -row 1 -sticky new -padx 5

grid [ttk::labelframe .n.f1.sorlibframe -text "Sort Library by" -labelanchor n -padding 5]				-column 3 -columnspan 1 -row 2 -sticky nw -padx 5

grid [ttk::labelframe .n.f1.parser -text "Parsers" -labelanchor n -padding 5]							-column 1 -row 3 -sticky nw -padx 5
grid [ttk::labelframe .n.f1.cacheframe -text "Cache" -labelanchor n -padding 5]						-column 1 -row 5 -sticky nw -padx 5
grid [ttk::button .n.f1.clearConsole -text "Clear Console" -command {clearConsole}]			-column 1 -row 6 -sticky we -padx 5
grid [ttk::labelframe .n.f1.infoframe -text "Infobox" -labelanchor n -width 300]			-column 3 -row 1 -rowspan 2 -columnspan 2 -sticky news


grid [ttk::label .n.f1.exportframe.txtTitle -text "Titles"] 																-column 2 -row 2 -sticky new
grid [ttk::progressbar .n.f1.exportframe.barTitle -orient horizontal -mode determinate -length 150 -value 0 -maximum 100]	-column 3 -row 2 -sticky new -padx 5 
set ::varTitle "0";	grid [ttk::label .n.f1.exportframe.varTitle -textvariable varTitle] 									-column 4 -row 2 -sticky new

grid [ttk::label .n.f1.exportframe.txtShots -text "Shots"] 																	-column 2 -row 3 -sticky new 
grid [ttk::progressbar .n.f1.exportframe.barShots -orient horizontal -mode determinate -length 150 -value 0 -maximum 100]	-column 3 -row 3 -sticky new -padx 5 
set ::varShots "0";	grid [ttk::label .n.f1.exportframe.varShots -textvariable varShots] 									-column 4 -row 3 -sticky new 

grid [ttk::button .n.f1.exportframe.toConsole -text "Check Images" -command {ExportMissingImages Manual}]				-column 3 -row 11 -sticky new -padx 5
grid [ttk::button .n.f1.exportframe.toFile -text "Export Missing to File" -command {ExportMissingImages toFile}]		-column 3 -row 12 -sticky new -padx 5

# TODO
#grid rowconfigure .n.f1.text 0 -weight 1

#grid [ttk::button .n.f1.makeAppend -text "Make file" -command {lostandfound}]		-column 3 -row 1 -sticky new -padx 5

#grid [ttk::button .n.f1.exportframe.setRLitemdefaults -text "RL Def" -command {setRLitemdefaults}]	-column 1 -columnspan 2 -row 2 -sticky new -padx 5 


grid [ttk::button .n.f1.cacheframe.cachelist -text "Cache Size?" -command {cacheManagerlist} -width $buttonwidth]		-column 1 -row 3 -sticky we
grid [ttk::button .n.f1.cacheframe.cacheclear -text "Cache Clear!" -command {cacheManagerclear} -width $buttonwidth]	-column 1 -row 4 -sticky we

grid [ttk::button .n.f1.parser.clExport -text "Export to CustomList" -command {clExport} -width $buttonwidth]	-column 1 -row 10 -sticky we
grid [ttk::button .n.f1.parser.gbImport -text "txtImport" -command {txtImport} -width $buttonwidth -state disabled]	-column 1 -row 0 -sticky we
grid [ttk::button .n.f1.parser.addDat -text "Import Datfile" -command {openDatfile} -width $buttonwidth]	-column 1 -row 1 -sticky we
#grid [	]	-column 1 -row 2 -sticky we;# -state disabled
ttk::button .n.f1.parser.parseRD -text "(Re:Dump & MAME)" -command {openRDDatfile} -width $buttonwidth

#grid []	-column 1 -row 3 -sticky we;
ttk::button .n.f1.parser.addCustom -text "Import CustomList" -command {addCustomList} -width $buttonwidth

#source ./SYS/fn_exodos.tcl;#exometaimport exodosParser
#grid [ttk::button .n.f1.parser.exodos -text "exodos dir" -command {exometaimport} -width $buttonwidth]	-column 1 -row 4 -sticky we;
#grid [ttk::button .n.f1.parser.gamebase -text "gamebase" -command {gamebaseParser} -width $buttonwidth -state disabled]	-column 1 -row 5 -sticky we;
#grid [ttk::button .n.f1.parser.gamebase -text "SteamGET" -command {steamParser} -width $buttonwidth]	-column 1 -row 5 -sticky we;


#ttk::button .n.f1.redButton -text "red" -command {parseReDumpDatfile};												#grid .n.f1.redButton -column 1 -row 2 -sticky w

if {$::DEVELOPERMODE} {
grid [ttk::labelframe .n.f1.dbqframe -text "DB Queries" -labelanchor n]						-column 1 -row 4 -sticky nw
grid [ttk::button .n.f1.dbqframe.masterDBqButton -text "masterDBq" -command {queryMasterDatabase} -width $buttonwidth] -column 1 -row 3 -sticky we;#UpdateLists
grid [ttk::button .n.f1.dbqframe.hiscoredump -text "Dump selDB (10asc)" -command {hiscoredump} -width $buttonwidth] -column 1 -row 4 -sticky we
grid [ttk::button .n.f1.dbqframe.locationdump -text "Dump usrDB (10asc)" -command {userdump} -width $buttonwidth] -column 1 -row 5 -sticky we;	#locationdump
#ttk::button .n.f1.dbqframe.hiscoredump -text "hiscoredump" -command {hiscoredump} userdump locationdump
}

# Infoframe textchanges							
grid [ttk::label .n.f1.infoframe.infox -textvariable infobox] -column 4 -row 2 -sticky nse -columnspan 3
# Deprecated ?
bind .n.f1.parser.addDat <Enter> {set ::infobox "No-Intro & TOSEC & Re:Dump & MAME>\nUniversal parser for datfiles\n=BEFORE YOU USE THIS\nMAKE BACKUPS OF YOUR DATABASES=\n"}
bind .n.f1.parser.parseRD <Enter> {set ::infobox "Re:Dump & MAME>\nparser for certain datfiles\n=BEFORE YOU USE THIS\nMAKE BACKUPS OF YOUR DATABASES=\n"}
bind .n.f1.parser.addCustom <Enter> {set ::infobox "Add CustomList>\nParser for any custom datfile\n=BEFORE YOU USE THIS\nMAKE BACKUPS OF YOUR DATABASES=\n"}

bind .n.f1.cacheframe.cachelist <Enter> {set ::infobox "Cache size?>\nChecks the size of your temporary files at /TMP\n"}
bind .n.f1.cacheframe.cacheclear <Enter> {set ::infobox "Cache Clear!>\nWill delete every file in /TMP\n"}
bind .n.f1.clearConsole <Enter> {set ::infobox "clearConsole>\nClears consoles 1 and 2.\n"}
#bind .n.f1.dbqframe.masterDBqButton <Enter> {set ::infobox "masterDBq>\nDisplays the tables in the master db\n"}
#bind .n.f1.dbqframe.hiscoredump <Enter> {set ::infobox "Dump selDB (10asc)>\nDisplays first 10 entries in the text.db\n"}
#bind .n.f1.dbqframe.locationdump <Enter> {set ::infobox "Dump usrDB (10asc)>\nDisplays first 10 entries in the usr.db\n"}
#bind .n.f1.setupframe.setwinexeb <Enter> {set ::infobox ">\nSelect windows executable\n"}
#bind .n.f1.setupframe.setromdirb <Enter> {set ::infobox ">\nSelect rom directory\n"}

ttk::label .n.f1.setupframe.exelin -text "Linux binary: " -anchor w
ttk::label .n.f1.setupframe.exewin -text "Windows executable: " -anchor w
ttk::entry .n.f1.setupframe.setlinexe -textvariable linuxexe -width 50
ttk::entry .n.f1.setupframe.setwinexe -textvariable windoexe
ttk::button .n.f1.setupframe.setwinexeb -text "Set" -command {setupReturnFile} -width 3;# grid in ixbar3000.tcl



grid [ttk::button .n.f1.setupframe.save -text "Save" -command {savesetup}] -column 4 -row 7 -sticky we
grid [ttk::checkbutton .n.f1.setupframe.activecheck -text "Active" -command "activeChanged" -variable activesystem -onvalue "1" -offvalue "0"] -column 3 -row 7 -sticky we

grid [ttk::label .n.f1.setupframe.presetF -text "Preset: " -anchor w]	-column 3 -row 4 -sticky we
grid [ttk::entry .n.f1.setupframe.preset -textvariable rompreset]		-column 4 -row 4 -sticky we
#grid [ttk::label .n.f1.setupframe.postsetF -text "Postset: " -anchor w]	-column 3 -row 5 -sticky we
ttk::entry .n.f1.setupframe.postset -textvariable rompostset		;#  grid .n.f1.setupframe.postset -column 4 -row 5 -sticky we
#grid [] -column 5 -row 4 -sticky e
ttk::button .n.f1.setupframe.presetG -text "GUI " -command {setEmuPresets} -width 3 -state disabled

grid [ttk::label .n.f1.setupframe.loadtypeF -text "Loadtype: " -anchor w]	-column 3 -row 5 -sticky we
grid [ttk::combobox .n.f1.setupframe.loadtype -textvariable loadtypetxt]	-column 4 -row 5 -sticky we
.n.f1.setupframe.loadtype configure -values [list 7z-iso 7z-bin Direct Unzip WINDOWS LINUX EXODOS2 WIN3X AMIGA MAME 7z-gdi TruRipISO NK6k1 NK8k1 NKFM7 NKFMT NKPC88 NKPC98]

image create photo checkNO -file "$::HOMEDIR/IMG/check_r.png" -height 16 -width 16
image create photo checkOK -file "$::HOMEDIR/IMG/check_g.png" -height 16 -width 16
grid [ttk::label .n.f1.setupframe.romdirCheck -image checkNO -anchor w]		-column 6 -row 6 -sticky we
grid [ttk::label .n.f1.setupframe.romdirF -text "RomDir: " -anchor w]		-column 3 -row 6 -sticky we
grid [ttk::entry .n.f1.setupframe.romdir -textvariable romdirtxt]			-column 4 -row 6 -sticky we
grid [ttk::button .n.f1.setupframe.setromdirb -text "Set" -command {setupReturnDir} -width 3]	-column 5 -row 6 -sticky e

grid [ttk::label .n.f1.systemframe.dbname -text "Type" -anchor w]			-column 0 -row 0 -sticky we
grid [ttk::label .n.f1.systemframe.date -text "Date" -anchor w]				-column 0 -row 1 -sticky we
grid [ttk::label .n.f1.systemframe.manuf -text "Manufacturer" -anchor w]	-column 0 -row 3 -sticky we
grid [ttk::label .n.f1.systemframe.orig -text "Origin" -anchor w]			-column 0 -row 4 -sticky we
grid [ttk::label .n.f1.systemframe.suppr  -text "Support" -anchor w]		-column 2 -row 0 -sticky we
grid [ttk::label .n.f1.systemframe.gene -text "Generation" -anchor w]		-column 2 -row 1 -sticky we
grid [ttk::label .n.f1.systemframe.sysH -text "System" -anchor w]			-column 2 -row 3 -sticky we
grid [ttk::label .n.f1.systemframe.ordH -text "Order" -anchor w]			-column 2 -row 4 -sticky we


if {$::DEVELOPERMODE} {
source ./SYS/gui_edit.tcl
grid [ttk::button .n.f0.searchBox.makeRelease -text "makeRelease" -command "makeRelease"]		-column 1 -row 4 -sticky w;# util
} else {
source ./SYS/gui_rele.tcl
}

grid [ttk::button .n.f1.sorlibframe.sortSLGen -text "Generation" -command {sortSysListByGeneration} ]		-column 2 -row 0 -sticky we -padx 5
grid [ttk::button .n.f1.sorlibframe.sortSLMan -text "Manufacturer" -command {sortSysListByManufacturer} ]	-column 2 -row 1 -sticky we -padx 5




set ::Console1 [tk::text .n.f1.text -width 80 -height 20];					grid $::Console1 -column 2 -row 3 -sticky wens -rowspan 4 -columnspan 3 -padx 5 -pady 5
#set ::systemlistDB [tk::listbox .n.f1.systemlistDB -listvariable db_systems -height 10 -width 30];					grid $::systemlistDB -column 0 -row 0 -rowspan 10 -sticky nsew
source ./SYS/fn_sysloader_all.tcl
set ::systemlistDB [tk::listbox .n.f1.systemlistDB -listvariable db_systems_human_all -height 10 -width 30 -yscrollcommand ".n.f1.systemlistDBscr set"];		grid $::systemlistDB -column 0 -row 0 -rowspan 10 -sticky nsew
grid [ttk::scrollbar .n.f1.systemlistDBscr -orient vertical -command ".n.f1.systemlistDB yview"] -column 0 -row 0 -rowspan 10 -sticky nse
#
set ::gameplaycount "Time:\t0 h 0 min 0 sec\nPlaycount:\t0 times"

#=================== information
grid [ttk::button .n.f0.3rd.subnote.data.edit -text "Edit" -command {editInformation}	-width 30] -column 1 -row 50 -sticky new
grid [ttk::panedwindow .n.f0.3rd.subnote.data.p -orient vertical -width 350] -column 1 -row 45 -sticky new

ttk::labelframe .n.f0.3rd.subnote.data.p.corp -text "\[ Corporate info \]" ;	.n.f0.3rd.subnote.data.p add .n.f0.3rd.subnote.data.p.corp
grid [ttk::label .n.f0.3rd.subnote.data.p.corp.developer -text " Developer:\t"]			-column 1 -row 2 -sticky new
grid [ttk::label .n.f0.3rd.subnote.data.p.corp.developeri -textvariable infoDeveloper]	-column 2 -row 2 -sticky new
grid [ttk::label .n.f0.3rd.subnote.data.p.corp.publisher -text " Publisher:"]			-column 1 -row 3 -sticky new
grid [ttk::label .n.f0.3rd.subnote.data.p.corp.publisheri -textvariable infoPublisher]	-column 2 -row 3 -sticky new
grid [ttk::label .n.f0.3rd.subnote.data.p.corp.year -text " Year: "]					-column 1 -row 4 -sticky new
grid [ttk::label .n.f0.3rd.subnote.data.p.corp.yeari -textvariable infoYear]			-column 2 -row 4 -sticky new

ttk::labelframe .n.f0.3rd.subnote.data.p.peeps -text "\[ Key Personnel \]" ;	.n.f0.3rd.subnote.data.p add .n.f0.3rd.subnote.data.p.peeps
grid [ttk::label .n.f0.3rd.subnote.data.p.peeps.designer -text " Design:\t\t"]		-column 1 -row 10 -sticky new
grid [ttk::label .n.f0.3rd.subnote.data.p.peeps.designeri -textvariable infoDesign]	-column 2 -row 10 -sticky new
grid [ttk::label .n.f0.3rd.subnote.data.p.peeps.music -text " Music: "]				-column 1 -row 11 -sticky new
grid [ttk::label .n.f0.3rd.subnote.data.p.peeps.musici -textvariable infoMusic]		-column 2 -row 11 -sticky new
grid [ttk::label .n.f0.3rd.subnote.data.p.peeps.program -text " Program: "]			-column 1 -row 12 -sticky new
grid [ttk::label .n.f0.3rd.subnote.data.p.peeps.programi -textvariable infoProgram]	-column 2 -row 12 -sticky new

ttk::labelframe .n.f0.3rd.subnote.data.p.game -text "\[ Game \]";		.n.f0.3rd.subnote.data.p add .n.f0.3rd.subnote.data.p.game
grid [ttk::label .n.f0.3rd.subnote.data.p.game.type -text " Theme: "]				-column 1 -row 21 -sticky new
grid [ttk::label .n.f0.3rd.subnote.data.p.game.typei -textvariable infoType]		-column 2 -row 21 -sticky new
grid [ttk::label .n.f0.3rd.subnote.data.p.game.genre -text " Genre: "]				-column 1 -row 23 -sticky new
grid [ttk::label .n.f0.3rd.subnote.data.p.game.genrei -textvariable infoGenre]		-column 2 -row 23 -sticky new
grid [ttk::label .n.f0.3rd.subnote.data.p.game.series -text " Series:\t\t"]			-column 1 -row 24 -sticky new
grid [ttk::label .n.f0.3rd.subnote.data.p.game.seriesi -textvariable infoSeries]	-column 2 -row 24 -sticky new
grid [ttk::label .n.f0.3rd.subnote.data.p.game.locale -text " Master: "]			-column 1 -row 25 -sticky new
grid [ttk::label .n.f0.3rd.subnote.data.p.game.localei -textvariable infoLocale]	-column 2 -row 25 -sticky new

grid [tk::text .n.f0.3rd.subnote.data.gname -height 2 -width 40	] -column 1 -row 60 -sticky news -columnspan 22;# -columnspan 2;# ENABLE EDITBOX

# IPS patch Button
grid [ttk::label .n.f0.3rd.subnote.data.patchtxt -textvariable IPSPatchtxt]	-column 1 -row 55 -sticky new
grid [ttk::button .n.f0.3rd.subnote.data.patch -text "Apply IPS" -command {IPSPatchSet}	-width 15] -column 1 -row 55 -sticky ne

set ::IPSPatchtxt "No Patch Applied"


#=================== user


grid [ttk::progressbar .n.f0.3rd.subnote.awa.progress -orient horizontal -mode determinate]		-column 0 -row 0 -sticky new
grid [tk::text .n.f0.3rd.subnote.awa.awa -background lightgray -width 50 -yscrollcommand ".n.f0.3rd.subnote.awa.scr set" -cursor arrow]	-column 0 -row 1 -sticky news -rowspan 2
grid [ttk::scrollbar .n.f0.3rd.subnote.awa.scr -orient vertical -command ".n.f0.3rd.subnote.awa.awa yview"] -column 1 -row 1 -sticky nse

grid [ttk::button .n.f0.3rd.subnote.awa.clearAwards -text "Clear Awards from database" -command {clearAwards}]		-column 0 -row 2 -sticky sew;# -pady 25
grid [ttk::button .n.f0.3rd.subnote.awa.openAwardeditor -text "Open Awardfile editor" -command {openAwardeditor}]	-column 0 -row 3 -sticky sew

grid [ttk::labelframe .n.f0.3rd.subnote.data.playcount -text "\[ Stats \]" -labelanchor nw -padding 5] -column 1 -row 10 -sticky we
grid [ttk::label      .n.f0.3rd.subnote.data.playcount.box -textvariable gameplaycount]	-column 1 -row 1 -sticky ne

image create photo gameboxcover -file "./IMG/icon_noicon.png" -height 400 -width 380
grid [ttk::label .n.f0.3rd.subnote.user.box -image gameboxcover] -column 2 -row 5 -sticky ne -columnspan 2
	
grid rowconfigure .n.f0.3rd.subnote.awa 1 -weight 2
grid rowconfigure .n.f0.3rd.subnote.text 0 -weight 1
grid columnconfigure .n.f0.3rd.subnote.awa 0 -weight 1
grid columnconfigure .n.f0.3rd.subnote.text 0 -weight 1
#================= award
image create photo star_off -file "./AWA/star0.png"
image create photo star_onn -file "./AWA/star1.png"

grid [ttk::labelframe .n.f0.3rd.subnote.data.star -text "\[ Rating \]" -labelanchor nw -padding 5] -column 1 -row 5 -sticky we

for {set x 1} {$x<6} {incr x} {
tk::button .n.f0.3rd.subnote.data.star.star$x -image "star_off" -relief flat -command "dynamicStar $x"
grid .n.f0.3rd.subnote.data.star.star$x -column [expr 0+$x] -row 0 -sticky ne
}

tk::button .n.f0.3rd.subnote.data.star.starnon -text "remove" -relief flat -command "setRating 0"
grid .n.f0.3rd.subnote.data.star.starnon -column 6 -row 0 -sticky ne


