# Main Parser
# It parses a given datfile into sqlite databases supported by ixbar3000
# ----------------------
# Supported formats     an
# -1 No-Intro (NI)      *
# -5 MAME (MAME)        -
# -5 Re:Dump (RD)       *
# -1 The Old School Emulation Collection (TOSEC)
# -2 Neo Kobe (NK)      -
# -3 Trurip (TR)        -
# -4 Customlist (CL)    -
# - [HyperSpin (HS)]    -
# + SuperDAT            -
# ----------------------

# HANDLERS for PARSERS -- pass the file to the parser dat
proc openDatfile {} {
	set types {    {{Datfiles}        .dat             } {{Datfiles}        .ixb             }}
	set filename [tk_getOpenFile -filetypes $types]
	$::Console1 insert end "Opened:_$filename\n"
	if {$filename eq ""} {
		$::Console1 insert end "Cancel Loading!\n"
	} else {
		$::Console1 insert end "File Selection OK.\n"
		univParser "$filename"
#		MAMEmech "$filename"
#		getStatsHS "$filename"
	}
}

proc openMAMEMechanical {} {
	set types {    {{Datfiles}        .dat             }}
	set filename [tk_getOpenFile -filetypes $types]
	$::Console1 insert end "Opened:_$filename\n"
	if {$filename eq ""} {
		$::Console1 insert end "Cancel Loading!\n"
	} else {
		$::Console1 insert end "File Selection OK.\n"
		MAMEmech "$filename"
	}
}

proc marshall {oddchara} {
#	$::Console1 insert end "Marshalling:$oddchara.\n"
	set oddchara [string map {&amp; &} $oddchara]
	set oddchara [string map {&apos; '} $oddchara]
	set oddchara [string map {' ''} $oddchara]
	set fix $oddchara
	return $fix
}
# ----------------------------------------------------------------------------
# CODE for the PARSER -- Awesomest universal parser, MacGyver like epicness here!
# ----------------------------------------------------------------------------
proc univParser {dat} {
	$::Console1 insert end "==== UNIVERSAL PARSER ====\n"

	$::Console1 insert end "> Loading file...\n"
	$::Console1 insert end "> File:<$dat> opened\n"
	set fp [open "$dat" r]
	set file_data [read $fp]
	close $fp

	set num 0
	set parser "0"
	set version "0"
	set ::superDAT "0";
	$::Console1 insert end "> Checking header...\n"
	set data [split $file_data "\n"]
	foreach line $data {
		# HEADER
		# This looks unique line from the datfile and chooses the parser accordingly.
		# There may be a possibility that this way fails, but so far so good.
		set result [regexp {<version>1.1</version>} $line match];	#	Quick hack for the new NeoKobes
		if {$result} {; 		set version "1.1";		};			# 	TODO -- get actual version and pass that as variable for futureproofing

		set result [regexp {comment \"no-intro} $line match]
		if {$result} {;			set parser "NI";		}

		set result [regexp {<clrmamepro/>} $line match]
		if {$result} {;			set parser "MAME";		}

		set result [regexp {<author>redump.org</author>} $line match]
		if {$result} {;			set parser "RD";		}

		set result [regexp {author toseciso.org} $line match]
		if {$result} {;			set parser "TOSEC";		}
		set result [regexp {<category>Neo Kobe</category>} $line match]
		if {$result} {;			set parser "NK";		}
		set result [regexp {<category>Trurip</category>} $line match]
		if {$result} {;			set parser "TR";		}
		set result [regexp {<CUSTOMLIST>} $line match]
		if {$result} {;			set parser "CL";		}
		
#		$::Console1 insert end "<$parser> datfile detected..."

		set result [regexp {<type>SuperDAT</type>} $line match]
		if {$result} {;			set ::superDAT "1";		}
		
	}

		$::Console1 insert end "<superDAT> $::superDAT \n"

	# PREPARE THE DB
	$::Console1 insert end "Database:$::DBsys\n";
	if {[dbDATA exists "SELECT name FROM sqlite_master WHERE type='table' AND name=\"$::DBsys\" ";]} {
	dbDATA eval "DROP TABLE \"$::DBsys\" "
#	dbCORP eval "DROP TABLE \"$::DBsys\" "
	dbDATA eval "CREATE TABLE \"$::DBsys\" (name VARCHAR, description VARCHAR, romname VARCHAR, crc VARCHAR);"
#	dbCORP eval "CREATE TABLE \"$::DBsys\" (name, crc, series, genre, year, developer, publisher, design, music, program, type, locale);"
#	Uncomment to drop corpdata from db while importing.

#	catch {	dbCORP eval "DROP TABLE \"$::DBsys\" " }
#	dbCORP eval "CREATE TABLE \"$::DBsys\" (name, crc, series, genre, year, developer, publisher, design, music, program, type, locale);"
	} else {
	dbDATA eval "CREATE TABLE \"$::DBsys\" (name VARCHAR, description VARCHAR, romname VARCHAR, crc VARCHAR);"
#	dbCORP eval "CREATE TABLE \"$::DBsys\" (name, crc, series, genre, year, developer, publisher, design, music, program, type, locale);"
	}



# BODY
if {$parser eq "NI" || $parser eq "TOSEC"} {
	$::Console1 insert end "Switch to NI.\n";# PARSER 1 STARTS HERE (NI & TOSEC) ==================================
dbDATA transaction {
dbCORP transaction {
	foreach line $data {
		set result [regexp {\tname \"} $line match]
		if {$result} {
			set rippedname [string range $line 7 end-1]
		}
		set result [regexp {\tdescription } $line match]
		if {$result} {
			set rippeddesc [string range $line 14 end-1]
			set rippeddesc [string map {' ''} $rippeddesc]
			set rippedname [string map {' ''} $rippedname]
	#		dbDATA eval "INSERT INTO \"$::DBsys\" (name,description,romname,crc) values ('$rippedname','$rippeddesc','$rippeddesc','$rippeddesc');"
			$::Console1 insert end "====\n$rippedname\n$rippeddesc<>\n"
			bindNodes "$rippedname" "$rippeddesc"

		}
	};#FOREACHEND
}
}
} elseif {$parser eq "NK"} {
	$::Console1 insert end "Switch to Neokobe.\n";# PARSER 2 STARTS HERE (NK) ==================================
	$::Console1 insert end "Version: $version\n";
dbDATA transaction {
dbCORP transaction {
	foreach line $data {

if {$version eq "1.1"} {;		# 2017 version


	set result [regexp {<game name=} $line match]
	if {$result} {
		set edit [string range $line [string first {game name="} $line]+11 [string last {"} $line]-1]
		set path [string range $line [string first {"} $line]+1 [string last "\\" $line]-1]
		set dev  [string range $line [string first {"} $line]+1 [string first "\\" $line]-1]
		set line "$line \["
		set name [string range $line [string last "\\" $line]+1 [string first {[} $line]-2]

		set path [string map {&amp; &} $path];	set path [string map {&apos; '} $path];	set path [string map {' ''} $path]
		set dev [string map {&amp; &} $dev];	set dev [string map {&apos; '} $dev];	set dev [string map {' ''} $dev]
		set name [string map {&amp; &} $name];	set name [string map {&apos; '} $name];	set name [string map {' ''} $name]

		if {$dev eq {[Doujin & Homebrew]}} {
			set pad [expr [string length $path]-[string length $dev]]
			set name [string range $edit 20+$pad end]
			set name [string range $name [string last "\\" $name]+1 [string first {[} $name]-2]
		}
	}

	set result [regexp {<description>} $line match]
	if {$result} {
		set gamedesc ""
		set gamedesc $line
		set gamedesc [string range $line [string first {<description>} $line]+13 [string first {</description>} $line]-1]
		set gamedesc [string map {&amp; &} $gamedesc];	set gamedesc [string map {&apos; '} $gamedesc];	set gamedesc [string map {' ''} $gamedesc]
#		$::Console1 insert end "desc>$gamedesc<\n"
#		$::Console1 insert end "path>$path<\n";	# TODO -- put this into locations.db
#		$::Console1 insert end "dev>$dev<\n"

# TODO -- skip bios etc
		if { $dev eq {[BIOS]} } {
			# [BIOS] has [] -chars that are parsed. It doesn't get processed.
			$::Console1 insert end "SKIP name>$name<\n"
		} else {

			if { ![dbDATA exists "SELECT name FROM $::DBsys WHERE crc='$name' ";] } {
				incr num
				$::Console1 insert end "# $num name>$name<\n"
				dbDATA eval "INSERT INTO $::DBsys (name,description,romname,crc) values ('$name','$gamedesc','$path','$name');"
			}

			if { ![dbCORP exists "SELECT name FROM $::DBsys WHERE crc='$name' ";] } {
				dbCORP eval "INSERT INTO $::DBsys (name,crc,year,developer,publisher,locale) values ('$name','$name','','$dev','$dev','');"
			}
		}
	}

} else {;																# ------ 2014-2016 NeoKobe ------
	logtext "-> Using Old NeoKobe Parser" 3

	set result [regexp {<game name=} $line match]
	if {$result} {
		set gamename ""
		set gamename [string range $line [string first {"} $line]+1 [string first "\\" $line]-1]
		set path     [string range $line [string first {"} $line]+1 [string last "\\" $line]-1]
#			$::Console1 insert end "--path>$path\n"
#		if { [lsearch -nocase $gamename "*OS]*"] > -1 } {;	#			$::Console1 insert end "-SKIP- $gamename\n";	#			set gamename "";#		}
#		if { [lsearch -nocase $gamename "*Utility]*"] > -1 } {;	#$::Console1 insert end "-SKIP- $gamename\n";	set gamename "";}

		set gamename [string range $gamename 0 [string first " (" $gamename]-1] ;# "\\
		set gamename [marshall $gamename]
	}

	set result [regexp {<description>} $line match];					# GET DESC -- START
	if {$result} {
		set gamedesc ""
		set gamedesc $line
		set gamedesc [string range $line [string first {<description>} $line]+13 [string first {</description>} $line]-1]
		set gamedesc [marshall $gamedesc]
#		$::Console1 insert end "INSERT1:desc>$gamename / $gamedesc\n"

		if { ![dbDATA exists "SELECT name FROM $::DBsys WHERE name='$gamename' ";] } {;# Insert values
			$::Console1 insert end "INSERT:name>$gamename / $gamedesc ($path)\n"
			dbDATA eval "INSERT INTO \"$::DBsys\" (name,description,romname,crc) values ('$gamename','$gamedesc','$path','$gamename');"
		}
	};																	# GET DESC -- END
	};																	# 1.0 -- END 

}
$::Console1 insert end "end Neokobe.\n"
};# Transaction 1
};# Transaction 2

} elseif {$parser eq "TR"} {
	$::Console1 insert end "Switch to Trurip.\n";# PARSER 3 STARTS HERE (TR) ==================================
dbDATA transaction {
# if a Super Dat is found parse that differently.
if {$::superDAT eq "1"} {
	foreach line $data {
	set result [regexp {<game name=} $line match]
	if {$result} {
		set gamename ""
		set gamename [string range $line [string first "\\" $line]+1 end]
		set gamename [string range $gamename 0 [string first {)} $gamename]]
		set gamename [string map {&amp; &} $gamename]
		set gamename [string map {&apos; '} $gamename]
		set gamename [string map {' ''} $gamename]
		$::Console1 insert end ">$gamename\n"
		dbDATA eval "INSERT INTO \"$::DBsys\" (name,description,romname,crc) values ('$gamename','$gamename','$gamename','$gamename');"
	}
	}
	$::Console1 insert end "end Trurip (SUPERDAT).\n"
} else {

	foreach line $data {
	set result [regexp {<game name=} $line match]
	if {$result} {
		set gamename ""
		set gamename [string range $line [string first {name=} $line]+6 [string first {)} $line]]
		set gamename [string map {&amp; &} $gamename]
		set gamename [string map {&apos; '} $gamename]
		set gamename [string map {' ''} $gamename]
		$::Console1 insert end ">$gamename\n"
		dbDATA eval "INSERT INTO \"$::DBsys\" (name,description,romname,crc) values ('$gamename','$gamename','$gamename','$gamename');"
	}
	}
	$::Console1 insert end "end Trurip (DAT).\n"
};# end IF
};# end Trans
	
} elseif {$parser eq "CL"} {
	$::Console1 insert end "Switch to CustomList.\n";# PARSER 4 STARTS HERE (CL) ==================================
dbDATA transaction {
	foreach line $data {
		set result [regexp {abbr} $line match]
		if {$result} {
			set abbr [string range $line [string last "abbr{" $line]+5 [string last "}:" $line]-1]			
			set name [string range $line [string last "name{" $line]+5 [string last "};" $line]-1]
			set name [string map {' ''} $name]
			set abbr [string map {' ''} $abbr]
			set name [checkMultiCD $name]
			$::Console1 insert end "<+1>$abbr<><+2>$name<>\n"
			dbDATA eval "INSERT INTO \"$::DBsys\" (name,description,romname,crc) values ('$name','$name','$name','$abbr');"
		}
	}
}
	
} elseif {$parser eq "MAME" || $parser eq "RD"} {
	$::Console1 insert end "Switch to MAME / RD.\n";# PARSER 5 STARTS HERE (MAME & RD) ==================================

dbDATA transaction {
dbCORP transaction {
		set thisRom ""
	foreach line $data {
		set gamename ""
		set gamemaster ""
		set gamedesc ""
		set gamedate ""
		set gamemanu ""

		# MAME == 
		set result [regexp {\t<game name=} $line match]
		if {$result} {
		set thisRom ""
			set gamename [string range $line [string first {name=} $line]+6 [string first { sourcefile=} $line]-2]
			set gamename [string map {&amp; &} $gamename]
			set gamename [string map {&apos; '} $gamename]
			set gamename [string map {' ''} $gamename]

		}

		set result [regexp {\t<game name=} $line match]
		if {$result} {
			set gamemaster [string range $line [string first {cloneof=} $line]+9 [string first { romof=} $line]-2]

			if {[string range $gamemaster 0 3] eq "ame="} {
				set gamemaster ""
			}
			set gamemaster [string map {&amp; &} $gamemaster]
			set gamemaster [string map {&apos; '} $gamemaster]
			set gamemaster [string map {' ''} $gamemaster]

		}

		set result [regexp {<description>} $line match]
		if {$result} {
			set gamedesc [string range $line [string first {<description>} $line]+13 [string first {</description>} $line]-1]
			set gamedesc [string map {&amp; &} $gamedesc]
			set gamedesc [string map {&apos; '} $gamedesc]
			set gamedesc [string map {' ''} $gamedesc]
		}

		set result [regexp {<year>} $line match]
		if {$result} {
			set gamedate [string range $line [string first {<year>} $line]+6 [string first {</year>} $line]-1]
		}

		set result [regexp {<manufacturer>} $line match]
		if {$result} {
			set gamemanu [string range $line [string first {<manufacturer>} $line]+14 [string first {</manufacturer>} $line]-1]
			set gamemanu [string map {&amp; &} $gamemanu]
			set gamemanu [string map {&apos; '} $gamemanu]
			set gamemanu [string map {' ''} $gamemanu]
		}

		# Merge lines into one variable
		if {$gamename ne "" || $gamedesc ne ""|| $gamedate ne ""|| $gamemanu ne "" && $parser eq "MAME" } {
			if {$gamename ne ""} {
			lappend thisRom $gamename
			lappend thisRom $gamemaster
			} 
			if {$gamedesc ne ""} {
			lappend thisRom $gamedesc
			}
			if {$gamedate ne ""} {
			lappend thisRom $gamedate
			}
			if {$gamemanu ne ""} {
			lappend thisRom $gamemanu
			set thisRomname [lindex $thisRom 0];#sfiii
			set thisRommast [lindex $thisRom 1];#sfii
			set thisRomdesc [lindex $thisRom 2];#Street F...
			set thisRomdate [lindex $thisRom 3]
			set thisRommanu [lindex $thisRom 4]
			$::Console1 insert end ">$thisRomname $thisRommast <$thisRomdate>:$thisRommanu<$thisRomdesc\n"
			dbDATA eval "INSERT INTO \"$::DBsys\" (name,description,romname,crc) values ('$thisRomdesc','$thisRomdesc','$thisRomname','$thisRomname');"
			dbCORP eval "INSERT INTO \"$::DBsys\" (name,crc,year,developer,publisher,locale) values ('$thisRomdesc','$thisRomdesc','$thisRomdate','$thisRommanu','$thisRommanu','$thisRommast');"
			}

			# == RD!
			if {$gamedesc ne "" && $parser eq "RD" } {
			#$::Console1 insert end ">$gamename <$gamedesc>:$gamedate<$gamemanu\n"
			set gamedesc [checkMultiCD $gamedesc]
			bindNodes "$gamedesc" "$gamedesc"
			}
		}
		# CMP END
	}
	finalizer
}
}

# ======================

#TODO-IFMAME
if {$parser eq "MAME"} {;fixMAMEMasters;}
	} else {
		$::Console1 insert end "END.\n";# THE END
	}
}




proc replacer {x} {

	$::Console1 insert end "relocate-> <$x>\n";
	set value $x
	set mapper "none"
	set sys $::DBsys

	if {[file exists "$::HOMEDIR/SYS/mappers/$sys"]} {
		$::Console1 insert end "$sys mapper found\n";
		source "$::HOMEDIR/SYS/mappers/$sys"
	} else {
		$::Console1 insert end "No mapper found\n";
	}

	foreach item $mapper {;		# Iterale list and return proper name
		set item [string map {\( "" \) ""} $item]
		if { [regexp $x $item match] } {;	
			$::Console1 insert end ">> $item\n";
			set value [string range $item [string first ">" $item]+1 end ];
			return $value ;	
		}
	}
	return $value

}

proc finalizer {} {
# get all from db -> if no locale=master -> if no children -> delete from db
# TODO -- MST is left if orphan slaves exists in dbCORP... 
# 		-> drop table, will clear ALL metadata!

	$::Console1 insert end "Parser finalizer\n"
	set myData [dbDATA eval "SELECT name FROM $::DBsys ";]

	foreach name $myData {
		#set isNode [string length [dbCORP eval "SELECT locale FROM $::DBsys WHERE name=\"$name\""]]

		set isNode [string length [string map {\{ "" \} ""} [dbCORP eval "SELECT locale FROM $::DBsys WHERE name=\"$name\""]]]
		if {!$isNode} {
				set wry [dbCORP eval "SELECT name FROM $::DBsys WHERE locale=\"$name\" "]
			$::Console1 insert end "MST $name -- got nodes?\n$wry\n"

			if { [string length [dbCORP eval "SELECT name FROM $::DBsys WHERE locale=\"$name\" "]] eq 0 } {

				$::Console1 insert end "DELETE> <$name>\n";
				dbCORP eval "DELETE FROM $::DBsys WHERE name=\"$name\""
				dbDATA eval "DELETE FROM $::DBsys WHERE name=\"$name\""
			}
		}
#	$::Console1 insert end "SLA $name\n"
	}
}

proc checkMultiCD {name} {
	# Returns name in new format -- removes the disc -- works only for singledigit items AND expects that the (Disc x) is the last substr
	set result [regexp {\(Disc [0-9]} $name match]
	if {$result} {
		$::Console1 insert end "$name\nPossible MultiCD!\n"

		set anchor [string last "(Disc " $name]
		set disk [string range $name $anchor $anchor+7]
		set ending [string index $disk end]

		if {$ending eq ")"} {
			set pre  [string range $name 0 $anchor]
			set tag "~"
			set post [string range $name [string length $pre]+6 end]
			set name "$pre$tag$post"
		}
		$::Console1 insert end "New Name -> $name\n"
		return $name
	} else {
		return $name
	}
}

proc fixMAMEMasters {} {
		$::Console1 insert end "\n===============\n"

	set listOfNames [dbCORP eval "SELECT locale FROM $::DBsys ";]

	foreach shortname $listOfNames {
		if {[string length $shortname] > 1} {
#		$::Console1 insert end ">$shortname\n"
		# Resolve the name
		set MAMEromName [dbDATA eval "SELECT description FROM $::DBsys WHERE crc='$shortname' ";]
#		$::Console1 insert end "->$MAMEromName\n"
		set MAMEromName [string map {' ''} $MAMEromName]
		set MAMEromName [string map {\{ ""} $MAMEromName]
		set MAMEromName [string map {\} ""} $MAMEromName]
		dbCORP eval "UPDATE $::DBsys SET locale='$MAMEromName' WHERE locale='$shortname' "
		}
	}
#$::Console1 insert end "\n===============\n"
#set sraa [dbCORP eval "SELECT * FROM $::DBsys ";]
#$::Console1 insert end "$sraa\n"
}


proc MAMEmech {dat} {
# Opens a datfila and finds mechanical sets and puts those into a container.
# TODO merge this with the mamefix
	$::Console1 insert end "==== PUT MAME MACHANICAL INTO CONTAINER ====\n"
	$::Console1 insert end "> Loading file...\n> File:<$dat> opened\n"
	set fp [open "$dat" r]
	set file_data [read $fp]
	close $fp	

	set data [split $file_data "\n"]
	foreach line $data {

		# GET THE isMECH
		set result [regexp {ismechanical="yes"} $line match]
		if {$result} {
			set gamename [string range $line [string first {name=} $line]+6 [string first { sourcefile=} $line]-2]

			# CHECK IF LOCALE IS EMPRY
			set MAMElocale [dbCORP eval "SELECT locale FROM $::DBsys WHERE crc='$gamename' ";]
			if {$MAMElocale eq ""} {
				# 
				set realName [dbDATA eval "SELECT name FROM $::DBsys WHERE crc='$gamename' ";]
				set realName [string map {' ''} $realName]
				set realName [string map {\{ ""} $realName]
				set realName [string map {\} ""} $realName]
				$::Console1 insert end "$::DBsys> $gamename - $realName\n"
				dbCORP eval "UPDATE $::DBsys SET locale='*' WHERE crc='$realName' "		

			#	set MAMESA [dbCORP eval "SELECT locale FROM $::DBsys WHERE crc='$realName' ";]
			#	$::Console1 insert end "> $gamename - $MAMESA ... $realName\n"

			}
		}
	}
}

# PARSER X STARTS HERE ==================================
proc bindNodes {name desc} {
	$::Console1 insert end "\nBinding->$name <$desc>\n";

	set gamenaked [string range $desc 0 [string first "(" $desc]-2 ]
	if { [string length $gamenaked ] > 1 } {
		# TODO -- Check db integrity, too many entries?
		dbDATA eval "INSERT INTO $::DBsys (name,description,romname,crc) values ('$gamenaked','$gamenaked','$gamenaked','$gamenaked');";	# Empty MST
		dbDATA eval "INSERT INTO $::DBsys (name,description,romname,crc) values ('$name','$desc','$desc','$desc');";						# Item NODE

		# Bind NODE to MST -- if exists in dbCORP -> update -> else insert
		set myData [dbCORP eval "SELECT name FROM $::DBsys WHERE name='$desc' ";]
		if { [string length $myData ] >0 } {
			$::Console1 insert end "CORP-> <UPDATE>\n";
			dbCORP eval "UPDATE $::DBsys SET locale='$gamenaked' WHERE name='$desc';"

			set main_rating [dbSTAT eval "SELECT rating FROM $::DBsys WHERE crc=\"$gamenaked\" "];#		main_data
			set main_time  [dbSTAT eval "SELECT playtime FROM $::DBsys WHERE crc=\"$gamenaked\" "];#	main_data
			set main_count [dbSTAT eval "SELECT playcounter FROM $::DBsys WHERE crc=\"$gamenaked\" "];#	main_data
			set main_year  [dbCORP eval "SELECT year FROM $::DBsys WHERE crc=\"$gamenaked\" "];#		main_data

			set sub_rating [dbSTAT eval "SELECT rating FROM $::DBsys WHERE crc=\"$desc\" "];#		sub_data
			set sub_time   [dbSTAT eval "SELECT playtime FROM $::DBsys WHERE crc=\"$desc\" "];#		sub_data
			set sub_count  [dbSTAT eval "SELECT playcounter FROM $::DBsys WHERE crc=\"$desc\" "];#	sub_data
			set sub_year   [dbCORP eval "SELECT year FROM $::DBsys WHERE crc=\"$desc\" "];#			sub_data
# TODO FIXME -- mapped items update wrong master!
# TODO FIXME -- mapped items kees old master!
# TODO -- also get pub,dev,mus,etc from slaves

			# Rating
			if { $main_rating > $sub_rating } {;	set newRating $main_rating
			} else {;	set newRating $sub_rating;}
			$::Console1 insert end "Rating: m$main_rating s$sub_rating -> <$newRating>\n";

			# Playtime
			if { $main_time > $sub_time } {;	set newTime $main_time
			} else {;	set newTime $sub_time;}
			$::Console1 insert end "Playtime: m$main_time s$sub_time -> <$newTime>\n";

			# Playcount
			if { $main_count > $sub_count } {;	set newCount $main_count
			} else {;	set newCount $sub_count;}
			$::Console1 insert end "Playcount: m$main_count s$sub_count -> <$newCount>\n";


			# Year
			set isYearOK [string first \{ $sub_year];# assumes that first char is curlybrac; 
			if {$isYearOK eq -1} {
				if { $main_year > $sub_year } {;
					set newYear $main_year
				} else {;
					set newYear $sub_year;
				}
				$::Console1 insert end "YEAR: m$main_year s$sub_year -> <$newYear>\n";
				if { [dbCORP exists "SELECT year FROM $::DBsys WHERE crc='$gamenaked' ";] } {
					dbCORP eval "UPDATE $::DBsys SET year='$newYear' WHERE crc='$gamenaked';"
				} else {
					dbCORP eval "INSERT INTO $::DBsys (name,crc,year,developer,publisher,locale) values ('$gamenaked','$gamenaked','$newYear','','','');"
				}
			} else {
				$::Console1 insert end "sub_year is empty-> SKIP \n";
			}



	# UPDATE master
	dbSTAT eval "UPDATE $::DBsys SET rating='$newRating',playtime='$newTime',playcounter='$newCount' WHERE crc='$gamenaked';"


		} else {
			$::Console1 insert end "CORP-> <INSERT>\n";
			dbCORP eval "INSERT INTO $::DBsys (name,crc,year,developer,publisher,locale) values ('$desc','$desc','','','','$gamenaked');"
		}

	} else {
		$::Console1 insert end "SKIP-> <$desc>\n";
	}

	source "$::HOMEDIR/SYS/mappers/exeptions"
	if { [lsearch $exeptionList $desc] >-1 } {;	# Needs to be replaced
		set real [replacer $desc]
		$::Console1 insert end "NEW-> <$real>\n";
		dbCORP eval "UPDATE $::DBsys SET locale='$real' WHERE name='$desc';"
	}
#lappend ::testMasterspossibleempty $gamenaked
#cleanup $gamenaked
};	# PARSER X ENDS HERE ==================================

proc cleanup {gn} {

	$::Console1 insert end "Cleanup... < $gn >\n";
#	set possibleEmpty [dbCORP eval "SELECT name FROM $::DBsys WHERE locale='';"]
#	set possibleEmpty [dbCORP eval "SELECT name FROM $::DBsys;"]
	#$::Console1 insert end "dbCORP> $possibleEmpty\n";

}
