# LoadROMImages {}	-- loads box, title, icon and gameplay images
# addExe {}			-- setup exe for windows
#================================


proc LoadROMImages {num} {
#	set imageRoot "$::HOMEDIR/IMG/";
	set imageRoot "$::EXTERNALIMG/";	# Set in ixbar3000.tcl
	set systemRootdir "systems/"
	set imageTitledir "$imageRoot$systemRootdir$::SelectedDB/Titles/"
	set imageSnapdir "$imageRoot$systemRootdir$::SelectedDB/Snaps/"
	set imageBoxdir "$imageRoot$systemRootdir$::SelectedDB/Boxarts/"
	set imageIcondir "$imageRoot$systemRootdir$::SelectedDB/Icons/"
	set ::imageCRC "S"
	set firstLetter "A"

	# -- Get proper image based on set region
	set isMaster 0
	set regionList [list USA (US) Japan (JP) Europe (EU)]

	if {[dbSTAT exists "SELECT name FROM sqlite_master WHERE type='table' AND name='$::SelectedDB' ";]} {; # update only if db exists
		set isMaster [string length [dbCORP eval "SELECT locale FROM \"$::SelectedDB\" WHERE name=\"$::selectedRomFast\""]]
	}
	set found ""
	set nodes ""
	if {!$isMaster && $num eq 1 } {
		logtext "- MST?: <Yes>" 1
		catch { set nodes [.n.f0.stattree children $::selectedRomFast] }
		set myMatch ""

		foreach region $regionList {;													# Get node by region priority
			foreach node $nodes {
				if { [regexp $region $node match] } {
					if { [string length $myMatch] eq 0 } {
						if { [string length $found] < 1 } {
							set found "$node"
							logtext "$region> node: <$node>" 1
							set ::selectedRomFast $node
						};	break
					};	
				}
			}
		}
		if { [string length $myMatch] eq 0 } {;		set myMatch [lindex $nodes 0];	};	# Region not found, take 1st node
	} else {
		logtext "- MST?: <No>" 1;# exec normally
	}


	set firstLetter [string range $::selectedRomFast 0 0]
	if {![string is alpha $firstLetter]} {
		set firstLetter 0
	}

	set romimage [string length $::selectedRomFast]
	if {$romimage > 0} {
		set ::imageCRC $::selectedRomFast
	}

	if {$::SelectedDB eq "PC_WIN" || $::SelectedDB eq "PC_DOS" || $::SelectedDB eq "MAME"} {
		set ::imageCRC $::selectedRom
	}

	if {[file exists "$imageTitledir$::imageCRC.png"]} {
		image create photo imgobj1 -file "$imageTitledir$::imageCRC.png" -height 300 -width 400
		$::image1 configure -image imgobj1 -compound image;# -relief raised
	} elseif {[file exists "$imageTitledir$firstLetter/$::imageCRC.png"]} {
		image create photo imgobj1 -file "$imageTitledir$firstLetter/$::imageCRC.png" -height 300 -width 400
		$::image1 configure -image imgobj1 -compound image
	} elseif {[file exists "$imageRoot/defaults/$::SelectedDB/300.png"]} {
		image create photo imgobj1 -file "$imageRoot/defaults/$::SelectedDB/300.png" -height 300 -width 400
		$::image1 configure -image imgobj1 -compound image
	} else {
		image create photo imgobj1 -file "$imageRoot/icon_noicon.png" -height 300 -width 400
		$::image1 configure -image imgobj1 -compound image
	}
	
	if {[file exists "$imageSnapdir$::imageCRC.png"]} {
		image create photo imgobj2 -file "$imageSnapdir$::imageCRC.png" -height 300 -width 400
		$::image2 configure -image imgobj2 -compound image
	} elseif {[file exists "$imageSnapdir$firstLetter/$::imageCRC.png"]} {
		image create photo imgobj2 -file "$imageSnapdir$firstLetter/$::imageCRC.png" -height 300 -width 400
		$::image2 configure -image imgobj2 -compound image
	} elseif {[file exists "$imageRoot/defaults/$::SelectedDB/200.png"]} {
		image create photo imgobj2 -file "$imageRoot/defaults/$::SelectedDB/200.png" -height 300 -width 400
		$::image2 configure -image imgobj2 -compound image
	} else {
		image create photo imgobj2 -file "$imageRoot/icon_noicon.png" -height 300 -width 400
		$::image2 configure -image imgobj2 -compound image
	}
	

	if {[file exists "$imageBoxdir$::imageCRC.png"]} {
		image create photo gameboxcover -file "$imageBoxdir$::imageCRC.png" -height 400 -width 380
		.n.f0.3rd.subnote.user.box configure -image gameboxcover -compound image
	} elseif {[file exists "$imageRoot/defaults/$::SelectedDB/400.png"]} {
		image create photo gameboxcover -file "$imageRoot/defaults/$::SelectedDB/400.png" -height 400 -width 380
		.n.f0.3rd.subnote.user.box configure -image gameboxcover -compound image
	} else {
		image create photo gameboxcover -file "$imageRoot/icon_noicon.png" -height 400 -width 380
		.n.f0.3rd.subnote.user.box configure -image gameboxcover -compound image
	}
	# Sets icon
	if {[file exists "$imageIcondir$::imageCRC.png"]} {
		image create photo systemicon -file "$imageIcondir$::imageCRC.png" -height 48 -width 48
	} elseif {[file exists "$imageRoot/defaults/$::SelectedDB/100.png"]} {
		image create photo systemicon -file "$imageRoot/defaults/$::SelectedDB/100.png" -height 48 -width 48
	} else {
		image create photo systemicon -file "$imageRoot/icon_noicon.png" -height 48 -width 48
	}

	# Get images for next item
	if {[info exists ::RLnext]} {
		set ::nextImage1 $::RLnext
		if {[file exists "$imageTitledir$::nextImage1.png"]} {
			image create photo imgNext1 -file "$imageTitledir$::nextImage1.png" -height 200 -width 300
		} elseif {[file exists "$imageTitledir$firstLetter/$::nextImage1.png"]} {
			image create photo imgNext1 -file "$imageTitledir$firstLetter/$::nextImage1.png" -height 300 -width 400
		} elseif {[file exists "$imageRoot/defaults/$::SelectedDB/300.png"]} {
			image create photo imgNext1 -file "$imageRoot/defaults/$::SelectedDB/300.png" -height 300 -width 400
		} else {
			image create photo imgNext1 -file "$imageRoot/icon_noicon.png" -height 300 -width 400
		}
	}
}


proc addExe {} {
	# CREATE NEW EDIT WINDOW
	tk::toplevel .editexe
	wm title .editexe "Executable Editor"
	wm geometry .editexe 800x500+100+50

	#TODO this can be opened twice -> E
	set ::nameE ""
	set ::pathE ""

	if {$::selectedRomFast ne ""} {
		wm title .editexe "Executable Editor: $::selectedRomFast $::SelectedDB"
	} 

	# MAKE location TABLE IF IT DOESNT EXIST
	if {![dbLOCA exists "SELECT name FROM sqlite_master WHERE type='table' AND name=\"$::SelectedDB\" ";]} {
		dbLOCA eval "CREATE TABLE \"$::SelectedDB\" (name, crc, path);"
	}

	# CREATE GUI
	ttk::labelframe .editexe.editframe -text "" -labelanchor n -width 600;	grid .editexe.editframe -column 1 -columnspan 4 -row 10 -sticky w
	ttk::label .editexe.editframe.nameL -text "Name: " -anchor w;			grid .editexe.editframe.nameL -column 1 -row 2 -sticky we
	ttk::label .editexe.editframe.pathL -text "Path to exe: " -anchor w;			grid .editexe.editframe.pathL -column 1 -row 3 -sticky we
	ttk::entry .editexe.editframe.nameE -textvariable nameE;			grid .editexe.editframe.nameE -column 2 -row 2 -sticky we
	ttk::entry .editexe.editframe.pathE -textvariable pathE -width 60;			grid .editexe.editframe.pathE -column 2 -row 3 -sticky we
	ttk::button .editexe.editframe.setpath -text "Choose exe" -command {getExe}  ;	grid .editexe.editframe.setpath -column 3 -row 3 -sticky new
	ttk::button .editexe.save -text "Save" -command {winEntrySave}  ;		grid .editexe.save -column 3 -row 30 -sticky new -columnspan 2
	ttk::button .editexe.new -text "New Entry" -command {winEntryNew}  ;	grid .editexe.new -column 1 -row 30 -sticky new -columnspan 2
	ttk::button .editexe.del -text "Delete" -command {winEntryDel}  ;	grid .editexe.del -column 1 -row 32 -sticky new -columnspan 2

	set ::pathE [dbLOCA eval "SELECT path FROM \"$::SelectedDB\" WHERE name=\"$::selectedRomFast\" ";]

	if {[string range $::selectedRomFast 0 1] eq "*"} {
		set ::nameE ""
	} else {
		set ::nameE $::selectedRomFast
	}

}


proc getExe {} {
	set types {    {{Executable}        .exe} {{Executable}        .EXE} {{Batch}        .bat} }

	set filename [tk_getOpenFile -filetypes $types]
	if {$filename eq ""} {
	} else {
		set ::pathE $filename
	}
	focus .editexe;# windows fix
}

proc winEntryDel {} {
	if {$::SelectedDB eq "PC_LIN"} {
		dbCORP eval "DELETE FROM \"$::SelectedDB\" WHERE name='$::nameE' ;"
		dbDATA eval "DELETE FROM \"$::SelectedDB\" WHERE name='$::nameE' ;"
	} else {
		$::Console0 insert end "Delete This: $::nameE\n"
		dbCORP eval "DELETE FROM \"$::SelectedDB\" WHERE crc='$::nameE' ;"
		dbDATA eval "DELETE FROM \"$::SelectedDB\" WHERE crc='$::nameE' ;"
		dbSTAT eval "DELETE FROM \"$::SelectedDB\" WHERE crc='$::nameE' ;"
		dbLOCA eval "DELETE FROM \"$::SelectedDB\" WHERE crc='$::nameE' ;"
	}
	destroy .editexe
	refreshSelectedList
}


proc winEntryNew {} {
	wm title .editexe "Executable Editor: NEW ENTRY"
	set ::nameE ""
	set ::pathE ""
}


proc winEntrySave {} {

	# If entryname is less than 2 char do not proceed
	if { [string length $::nameE] < 2 } {;return;}

		if {$::SelectedDB eq "PC_WIN"} {
			#TODO rm these peronal variavles
			set ::drive1 "media/Alice/"
			set ::drive2 "media/REIMU/"
			# Changes C: -> DRIVE1 LIN
			set fakepath [string map [list $::drive1 DRIVE1/ $::drive2 DRIVE2/] $::pathE]
		} elseif {$::SelectedDB eq "PC_LIN"} {
			set fakepath $::pathE
		}

		set magicname [string map {' ''} $::nameE]
		set fakepath [string map {' ''} $fakepath]

	# get name from textDB
	set nameFromDATA [dbDATA eval "SELECT name FROM \"$::SelectedDB\" WHERE name=\"$::nameE\" ";]

	if {[string length $nameFromDATA] > 0 } {
		# HMM! TODO -- FIXME
	} else {;			# make new entry to DATA
		$::Console0 insert end "fixed name is: <$magicname>\n"
		if {$::SelectedDB eq "PC_WIN"} {
		dbDATA eval "INSERT INTO \"$::SelectedDB\" (name,description,romname,crc) values ('$magicname','$magicname','$magicname','$magicname');"
		} elseif {$::SelectedDB eq "PC_LIN"} {
		dbDATA eval "INSERT INTO \"$::SelectedDB\" (name,description,romname,crc) values ('$magicname','$::pathE','$magicname','$::pathE');"
		}
	}


	if {$::SelectedDB eq "PC_WIN" || $::SelectedDB eq "PC_DOS"} {

		if {[dbLOCA exists "SELECT name FROM sqlite_master WHERE type='table' AND name=\"$::SelectedDB\" "]} {
			tk_messageBox -message "$nameFromDATA\n$::SelectedDB>------\n$::nameE\n$::pathE\n$fakepath\n$magicname\n"
			if {[dbLOCA exists "SELECT name FROM \"$::SelectedDB\" WHERE crc=\"$magicname\" "]} {
				#tk_messageBox -message "Update"
				dbLOCA eval "UPDATE \"$::SelectedDB\" SET path='$fakepath', name='$magicname' WHERE crc='$::selectedRomFast'; " ;# mod exe
			} else {
				#tk_messageBox -message "New"
				dbLOCA eval "INSERT INTO \"$::SelectedDB\" (name,crc,path) values ('$magicname','$magicname','$fakepath');"	;# new exe
			}
		}
	}

	destroy .editexe;		# Close window
	refreshSelectedList;	# refresh current system
}



proc addExe_old {} {
# sets the exe for a selected rom
	set types {    {{Executable}        .exe} {{Executable}        .EXE} {{Batch}        .bat} }

	set filename [tk_getOpenFile -filetypes $types]
	if {$filename eq ""} {
		$::Console0 insert end "Cancel Loading!\n"
	} else {
		$::Console0 insert end "Binding exec with game: $::selectedRomCRC_db1 - $filename.\n"
	
		if {[dbLOCA exists "SELECT name FROM sqlite_master WHERE type='table' AND name=\"$::SelectedDB\" ";]} {
			$::Console0 insert end "MOD TABLE\n"
			#dbLOCA eval "DROP TABLE \"$::SelectedDB\" "
			#dbLOCA eval "CREATE TABLE \"$::SelectedDB\" (name VARCHAR(64), crc VARCHAR(8), path VARCHAR);"
			$::Console0 insert end "$::SelectedDB>\n$::textfromRomlist,$::selectedRomCRC_db1,$filename\n"

			# Changes C: -> DRIVE1 LIN
			set fakepath [string map [list $::drive1 DRIVE1/ $::drive2 DRIVE2/] $filename]
			set magicname [string map {' ''} $::textfromRomlist]
			$::Console0 insert end "$fakepath ><rom >$::textfromRomlist\n"
			# $::selectedRom is empty @ubuntu; 012:$::selectedRom contains //media... !
				if {[dbLOCA exists "SELECT name FROM \"$::SelectedDB\" WHERE crc=\"$::selectedRomFast\" ";]} {
					$::Console0 insert end "$::SelectedDB !loyty!$::selectedRomCRC_db1\npath$filename- $::selectedRom"
					dbLOCA eval "UPDATE \"$::SelectedDB\" SET path='$fakepath', name='$magicname' WHERE crc='$::selectedRomFast'; " ;# mod exe
				} else {
					$::Console0 insert end "!Path not found, creatting entry!\n"
					dbLOCA eval "INSERT INTO \"$::SelectedDB\" (name,crc,path) values ('$magicname','$::selectedRomFast','$fakepath');"	;# new exe
				}
		
		} else {
		$::Console0 insert end "CREATE DB -- Please Retry>\n"
		dbLOCA eval "CREATE TABLE \"$::SelectedDB\" (name, crc, path);"
		}
	}


		# Transforms system mountpoint into DRIVE1 -> used in multiplatform loader
#		$::Console0 insert end "CRC_db2 .>$::selectedRomCRC_db2 - rom $::selectedRom _ $::drive2 _\n"
#		set ::selectedRom [string map [list $::drive2 DRIVE1/] $::selectedRom]
#		$::Console0 insert end ">> $::selectedRom\n"
}
