#==============================
# StartApp {emu rom}		-- starts the selected system with parameters if exists
# GetCRCFromZip {zipped}	-- give zip, returns crc. TODO crc from multiple files
# searchThis {value}
# RomListSearched {}
# clearSystemList {}
# populateSystemList {}
#==============================
# Regions: 
# TODO -- potential fail if title has region in it
# Japan USA Europe World Australia Korea Asia France Germany Spain Italy Netherlands Taiwan Brazil 
# (US) (JP) (EU)

proc StartApp {emu rom} {
clearConsole
closeIRC
logtext "===== START =====" 1
logtext "- Exec: <$::selectedEmu>" 1
logtext "- Item: <$::selectedRom>" 1


# TODO -- exlude from regionList ->Beta Proto Alt Preview Sample
# TODO -- update databases! 
set regionList [list USA (US) Japan (JP) Europe (EU)]
set isMaster [string length [dbCORP eval "SELECT locale FROM \"$::SelectedDB\" WHERE name=\"$::selectedRomFast\""]]

if {!$isMaster} {;# 													Chech whether node or leaf is selected
	logtext "- MST?: <Yes>" 1
	set nodes [.n.f0.stattree children $::selectedRomFast]
	set myMatch ""

	foreach region $regionList {;# 										Get node by region priority
		foreach node $nodes {
			if { [regexp $region $node match] } {
				if { [string length $myMatch] eq 0 } {
					set myMatch $node
				};	break
			}
		}
	}
	if { [string length $myMatch] eq 0 } {;	#				 			Region not found, take 1st node
		set myMatch [lindex $nodes 0];#									obsolete?
	}
	set ::selectedRomFast $::selectedRomFast
} else {
	logtext "+ MST?: <No>" 1;# 											exec normally
}


set validRomdir [string length [list [glob -nocomplain -dir $::RomDirectory *]]];# Check if sufficient parameters, if not - return


if { $emu eq "fixme" && $::LoadType ne "LINUX" } {;# 					Error case: Halts if notLinux and exe not set
	tk_messageBox -message "ERROR\nEmulator exe is not set!";			return
} elseif {$validRomdir < 5 && $::LoadType ne "LINUX"} {;# 				Error case: Halts if notLinux and validRomdir fails
	tk_messageBox -message "ERROR\nRomDirectory is not set or empty!";	return

} else {;#																OK to load
	source $::HOMEDIR/SYS/loaders/LD_common.tcl;#						Load common loader helpers
	if {$::LoadType eq "WINDOWS"} {;#									[ Native WINDOWS ]
		set ::selectedRomCRC_db2 $::selectedRomFast

		if {$::DetectedOS eq "WIN"} {
			timeStart
		
			set rom [dbLOCA eval "SELECT path FROM \"$::SelectedDB\" WHERE name=\"$::selectedRomFast\" ";]
			set rom [string map {\} ""} [string map {\{ ""} $rom]]
			set path [string range $rom 0 [string last "/" $rom]-1]
			set exe  [string range $rom [string last "/" $rom]+1 end] 
			cd $path

			catch {exec $exe}
		} elseif {$::DetectedOS eq "LIN"} {
			timeStart
			set pathtoexe [dbLOCA eval "SELECT path FROM \"$::SelectedDB\" WHERE name=\"$::selectedRomFast\" ";]
			set unfakepath [string map [list DRIVE1/ $::drive1 DRIVE2/ $::drive2] $pathtoexe]
			$::Console0 insert end "=WINE LOADER= \n $emu -> $::selectedRom -- $unfakepath"
			catch {exec $emu $unfakepath}
		}

	} elseif {$::LoadType eq "LINUX"} {;#								[ Native LINUX ]
		set ::selectedRomCRC_db2 $::selectedRomFast
		timeStart
		catch {exec $::selectedRomCRC_db1}

	} elseif {$::LoadType eq "7z-cue"} {;#								[ PSX ]
		set ::selectedRomCRC_db2 $::selectedRomFast
		source $::HOMEDIR/SYS/loaders/fn_LD_ISO_cue.tcl;
		timeStart
		catch {exec $::selectedEmu {*}$::RomPreset $match {*}$::RomPostset}
		
	} elseif {$::LoadType eq "MAME"} {;#								[ MAME ]
		set rom $::selectedRom
		set ::selectedRomCRC_db2 $::selectedRomFast
		timeStart
		catch {exec $emu $rom -rompath $::RomDirectory}

	} elseif {$::LoadType eq "Unzip"} {;#								[ PARAMZ -- unzips ]		
		set ::selectedRomCRC_db2 $::selectedRomFast
		source $::HOMEDIR/SYS/loaders/fn_LD_PARAMZ.tcl;
		IPSPatchApply $newName
		timeStart
		set ::selectedEmu [string map {\{ ""} [string map {\} ""} $::selectedEmu] ]
		catch {exec $::selectedEmu {*}$::RomPreset $match {*}$::RomPostset}
		
	} elseif {$::LoadType eq "7z-gdi"} {;#								[ 7z-gdi -- Dreamcast ]
		set ::selectedRomCRC_db2 $::selectedRomFast
		source $::HOMEDIR/SYS/loaders/fn_LD_ISO_gdi.tcl;
		timeStart
		catch {exec $::selectedEmu {*}$::RomPreset $match {*}$::RomPostset}
		
	} elseif {$::LoadType eq "TruRipISO"} {;#							[ TruRip ]			
		set ::selectedRomCRC_db2 $::selectedRomFast
		source $::HOMEDIR/SYS/loaders/fn_LD_ISO_TRiso.tcl;
		if {$::DetectedOS eq "WIN"} {;			GOTOwinDir;		}; 					# Changes path to where the emu is. 
		if {$::DetectedOS eq "LIN"} {;	set match [string map {\\ \/} $match];	}; 	# Quick fix for the loader. 
		timeStart
		catch {exec $::selectedEmu {*}$::RomPreset $match {*}$::RomPostset}
		
	} elseif {$::LoadType eq "NKFMT"} {;#								[ NEOKOBE ]
		set ::selectedRomCRC_db2 $::selectedRomFast
		source $::HOMEDIR/SYS/loaders/fn_LD_ISO_fmt.tcl;
		if {$::DetectedOS eq "WIN"} {;			GOTOwinDir;		};		# Changes path to where the emu is. 
		timeStart
		exec $::selectedEmu

	} elseif {$::LoadType eq "EXODOS2"} {;#								[ fn_LD_EXODOSv2 ]
		set ::selectedRomCRC_db2 $::selectedRomFast
		source $::HOMEDIR/SYS/loaders/fn_LD_EXODOS2.tcl;
		set ::selectedEmu [string map {\{ ""} [string map {\} ""} $emu] ]
		timeStart
		catch {exec $::selectedEmu -conf "$::HOMEDIR/MOJO/userconf.conf" -conf "$::HOMEDIR/SYS/dosbox.conf"}

	} elseif {$::LoadType eq "WIN3X"} {;#								[ WIN3x0 ]
		set ::selectedRomCRC_db2 $::selectedRomFast
		source $::HOMEDIR/SYS/loaders/fn_LD_EXOWIN.tcl;
		set ::selectedEmu [string map {\{ ""} [string map {\} ""} $emu] ]
		$::Console0 insert end "\n=======\nsetup OK!\nSTART $match\nWITH $::selectedEmu\n"
		timeStart
		catch {exec $::selectedEmu -conf "$::HOMEDIR/MOJO/userconf.conf" -conf "$::HOMEDIR/SYS/dosbox.conf"}

	} elseif {$::LoadType eq "STEAM"} {;#								[ STEAM -- Highly experimental ! ]
	# it seems that valve has changed stuff; so this doesn't work.
		set ::selectedRomCRC_db2 $::selectedRomFast
		set steamid [dbDATA eval "SELECT crc FROM \"$::SelectedDB\" WHERE name=\"$::selectedRomFast\" ";]
	#	tk_messageBox -message "STEAM\nsteam://run/$steamid\n"
	#	timeStart
		catch {exec $emu " -applaunch $steamid"}
	#steam.exe -applaunch <AppID> (Command Line) 
	#steam://run/<AppID> (Steam browser protocol) -- fails
		
	} elseif {$::LoadType eq "7z-bin"} {;#								[ arch(7z) file(bin) ]	TODO:Check w/ spaces
		set ::selectedRomCRC_db2 $::selectedRomFast
		source $::HOMEDIR/SYS/loaders/fn_LD_ISO.tcl;
		if {$::DetectedOS eq "WIN"} {;			GOTOwinDir;		}; #Changes path to where the emu is. 
		timeStart
		catch {exec $::selectedEmu {*}$::RomPreset $rom {*}$::RomPostset}

	} elseif {$::LoadType eq "NK6k1"} {;#								[ NEOKOBE / PC-6001 ]
		set ::selectedRomCRC_db2 $::selectedRomFast
		source $::HOMEDIR/SYS/loaders/LD_NEOKOBE6001.tcl;
		if {$::DetectedOS eq "WIN"} {;			GOTOwinDir;		}; #Changes path to where the emu is. 
		set ::selectedEmu [string map {\{ ""} $::selectedEmu]; set ::selectedEmu [string map {\} ""} $::selectedEmu];
		timeStart
		exec $::selectedEmu {*}$::RomPreset $rom {*}$::RomPostset

	} elseif {$::LoadType eq "NK8k1"} {;#								[ NEOKOBE / PC-8001 ]
		set ::selectedRomCRC_db2 $::selectedRomFast
		source $::HOMEDIR/SYS/loaders/LD_NEOKOBE8001.tcl;
		if {$::DetectedOS eq "WIN"} {;			GOTOwinDir;		}; #Changes path to where the emu is. 
		set ::selectedEmu [string map {\{ ""} $::selectedEmu]; set ::selectedEmu [string map {\} ""} $::selectedEmu];
		timeStart
		exec $::selectedEmu {*}$::RomPreset $rom {*}$::RomPostset

	} elseif {$::LoadType eq "NKFM7"} {;#								[ NEOKOBE / Fujitsu FM-7 ]
		set ::selectedRomCRC_db2 $::selectedRomFast
		source $::HOMEDIR/SYS/loaders/LD_NEOKOBEFM7.tcl;
		if {$::DetectedOS eq "WIN"} {;			GOTOwinDir;		}; #Changes path to where the emu is. 
		set ::selectedEmu [string map {\{ ""} $::selectedEmu]; set ::selectedEmu [string map {\} ""} $::selectedEmu];
		timeStart
		exec $::selectedEmu {*}$::RomPreset $rom {*}$::RomPostset
	} elseif {$::LoadType eq "NKX1"} {;#									[ NEOKOBE / X1 ]
		set ::selectedRomCRC_db2 $::selectedRomFast
		source $::HOMEDIR/SYS/loaders/LD_NEOKOBEX1.tcl;
		if {$::DetectedOS eq "WIN"} {;			GOTOwinDir;		}; #Changes path to where the emu is. 
		set ::selectedEmu [string map {\{ ""} $::selectedEmu]; set ::selectedEmu [string map {\} ""} $::selectedEmu];
		timeStart
		exec $::selectedEmu {*}$::RomPreset $rom {*}$::RomPostset
				
	} elseif {$::LoadType eq "NKPC88"} {;#									[ NEOKOBE / PC-88 ]
		set ::selectedRomCRC_db2 $::selectedRomFast
		source $::HOMEDIR/SYS/loaders/LD_NEOKOBEPC88.tcl;
		if {$::DetectedOS eq "WIN"} {;			GOTOwinDir;		}; #Changes path to where the emu is. 
		set ::selectedEmu [string map {\{ ""} $::selectedEmu]; set ::selectedEmu [string map {\} ""} $::selectedEmu];
		timeStart
		exec $::selectedEmu {*}$::RomPreset $rom {*}$::RomPostset
				
	} elseif {$::LoadType eq "NKPC98"} {;#									[ NEOKOBE / PC-98 ]
		set ::selectedRomCRC_db2 $::selectedRomFast
		source $::HOMEDIR/SYS/loaders/LD_NEOKOBEPC98.tcl;
		if {$::DetectedOS eq "WIN"} {;			GOTOwinDir;		}; # Changes path to where the emu is. 
		set ::selectedEmu [string map {\{ "" \} ""} $::selectedEmu];
		timeStart
		logtext "RUN1>>$::selectedEmu $::RomPreset $rom $::RomPostset" 1
		catch {exec $::selectedEmu {*}$::RomPreset {*}$rom}

	} elseif {$::LoadType eq "7z-iso"} {;#								[ PSP&PS2&NGC ]
		set ::selectedRomCRC_db2 $::selectedRomFast
		source $::HOMEDIR/SYS/loaders/fn_LD_ISO2.tcl;
		if {$::DetectedOS eq "WIN"} {;			GOTOwinDir;		}; #Changes path to where the emu is. 
		#set ::selectedEmu [string map {\{ ""} [string map {\} ""} $::selectedEmu] ]
		timeStart
		catch {exec $::selectedEmu {*}$::RomPreset $rom {*}$::RomPostset}
		
	} elseif {$::LoadType eq "7z-cue-bin"} {;#							[ PCFX ]
		set ::selectedRomCRC_db2 $::selectedRomFast
		source $::HOMEDIR/SYS/loaders/fn_LD_ISO_cue.tcl;
		if {$::DetectedOS eq "WIN"} {;			GOTOwinDir;		}; #Changes path to where the emu is. 
		timeStart
		catch {exec $::selectedEmu {*}$::RomPreset $rom {*}$::RomPostset}

	} elseif {$::LoadType eq "AMIGA"} {;#								[ Gamebase Amiga ]	TODO:Check w/ spaces
		set ::selectedRomCRC_db2 $::selectedRomFast
		source $::HOMEDIR/SYS/loaders/LD_AMIGA.tcl;
		if {$::DetectedOS eq "WIN"} {;			GOTOwinDir;		}; #Changes path to where the emu is. 
		timeStart
		catch {exec $::selectedEmu {*}$::RomPreset $rom {*}$::RomPostset}
		
	} elseif {$::LoadType eq "Direct"} {;#								[ Pass archive directly ]
		set ::selectedRomCRC_db2 $::selectedRomFast;					# sets the id for timestats, nothing to do with crc

	#check if map-file exists -> then find mapped directory TODO:MAKE AVAILABLE FOR ALL
	set mapfile "$::HOMEDIR/MOJO/$::SelectedDB.map"
		if {[file exists $mapfile]} {
		$::Console0 insert end "MAPFILE found!\n"
		
		set fp [open "$mapfile" r]
		set file_data [read $fp]
		close $fp
		set data [split $file_data "\n"]
			foreach line $data {
				set nameMap [string range $line 0 [string first ">" $line]-1]
				set dirMap [string range $line [string first ">" $line]+1 end]
				if {"$nameMap" eq "$::selectedRom"} {;	$::Console0 insert end "DIR:$::RomDirectory/$dirMap\n";set match "$::RomDirectory/$dirMap";		}
			}
		} else {
			# Searched ganemane.zip from the set directory -> passes that as a parameter
			set match [glob -dir $::RomDirectory $::selectedRomFast.zip]
			set match [string map {\{ ""} $match]
			set match [string map {\} ""} $match]
		}

		set ::selectedEmu [string map {\{ ""} [string map {\} ""} $::selectedEmu] ]
		timeStart
		$::Console0 insert end "\n=======\nsetup OK!\nSTART $match\nWITH $::selectedEmu\n"
		catch {exec $::selectedEmu {*}$::RomPreset $match {*}$::RomPostset}
	} else {
		tk_messageBox -message "Please set a LoadType.";				# [ Failed to load ]
	}

	#tk_messageBox -message "Game Over, man. Game Over!\nYou played\n$::SelectedDB>\n$::selectedRomCRC_db2"
	cd $::HOMEDIR
	WriteGamelog
	set ::IPSPatchtxt "No Patch Applied"

	if {$::mpjoinonstart eq "1" && $::mprejoin eq "1"} {;				# Re-joins the lobby
		connectToIRC
	}

}
}

proc GOTOwinDir {} {;		 #Changes path to where the emu is. 
	set emupath [string range $::selectedEmu 0 [string last "/" $::selectedEmu] ];
	set emupath [string map {\{ ""} $emupath]; set emupath [string map {\} ""} $emupath]; 			cd $emupath
	set ::selectedEmu [string map {\{ ""} $::selectedEmu]; set ::selectedEmu [string map {\} ""} $::selectedEmu];
}


proc recursiveMatch {} {
	$::Console0 insert end "NOT FOUND -- try searching recursively\n"
	set match [glob -nocomplain -types d -dir $::RomDirectory *]
	
		foreach i $match {
			set matchSub [glob -nocomplain -dir $i $::selectedRomFast*]
			$::Console0 insert end "dir:<$i> - $matchSub -\n"
			
			if {[llength $matchSub] ne "0"} {						;# Match found
#			set match $matchSub
			$::Console0 insert end ":: return: $matchSub ::\n"
			return $matchSub
			#break
			}
		}
}


proc WriteGamelog {} {
	set logfile "$::HOMEDIR/MOJO/gamelog.txt"

    set timestamp [clock format [clock seconds] -format "%Y-%m-%dT%H:%M:%S"]
    set fl [open $logfile {WRONLY CREAT APPEND}]
    puts $fl "$timestamp <$::SelectedDB>\t$::selectedRomCRC_db2"
    close $fl
}


proc GetCRCFromZip {zipped} {
#	INFO returns the crc from within the zip file.
#	TODO returns only one value!! -- FIXTHIS if need for multiple files inside a zip

if {$::DetectedOS eq "WIN"} {
	exec $::HOMEDIR/SYS/sraa.bat "$zipped"	
}
if {$::DetectedOS eq "LIN"} {	
set archiver "7za"
set param1 "l"
set param2 "-slt"
set operand ">"
set destination "$::HOMEDIR/SYS/zdata.txt"
	exec $archiver $param1 $param2 $zipped $operand $destination
	};
	set path ""
	set fp [open "$::HOMEDIR/SYS/zdata.txt" r];# talla saa crc:n data.txt filesta
	set file_data [read $fp]
	close $fp
	set data [split $file_data "\n"]
	foreach line $data {
		set result [regexp {CRC = } $line match]
		if {$result} {
			lappend crc [string range $line 6 end]
		}
		set result_path [regexp {Path = } $line match]
		if {$result_path} {
			lappend crc [string range $line 7 end]
		}
	}
#	return "$crc:$path"
	set crc [lreplace $crc 0 0]
	return "$crc"
}


proc searchThis {value} {
if {$value eq "" || ![info exists ::StatisticDATA]} {
	$::Console0 insert end "NULL VALUE CANNOT BE SEARCHED>EXIT\n"
	return 0
}
	.n.f0.stattree delete [.n.f0.stattree children {}]
	$::Console0 insert end "Searching: -$value-\n"
	set value "*$value*"

	set sources $::StatisticDATA;# for new version
	set ::NewRomlist [lsearch -inline -all -nocase $sources $value]	;#	matched values are stored into romlist

	if {$::RomListMode eq "OMNI"} {;#									Quick fix for OMNI, removes non omni entrys.
		set ::NewRomlist [lsearch -inline -all -nocase $::NewRomlist "*>*"]
	}
	#new search action
	RomListSearched
}


proc RomListSearched {} {
	set ld [list {*}$::NewRomlist]
	set ::TotalSelectedItems 0
	set j 0

	#	tk_messageBox -message "Known bug #005: No default DB, select a system and try again."
	if {$::SelectedDB eq "DB"} {;		set ::SelectedDB "PC_LIN";	}

	# MAKE A CORPTABLE IF NOT EXIST ALREADY
	if {![dbCORP exists "SELECT name FROM sqlite_master WHERE type='table' AND name=\"$::SelectedDB\" "] } {
	dbCORP eval "CREATE TABLE \"$::SelectedDB\" (name, crc, series, genre, year, developer, publisher, design, music, program, type, locale);";}


	foreach i $ld {
	incr ::TotalSelectedItems
#	$::Console0 insert end ":::$i \n"
	catch {	.n.f0.stattree insert {} end -id $i -text $i -tags "tagname" }

		# time function

if {$::RomListMode eq "OMNI"} {
	if {$::enableOMNIsearch eq 1} {
		set OMNIDB [string range $i 0 [string first {>} $i]-1]
		set OMNIROM [string range $i [string first {>} $i]+1 end]
	#	$::Console0 insert end "===\nO:$i \n$OMNIDB - $OMNIROM\n"
		catch {	set j [dbSTAT eval "SELECT playtime FROM $OMNIDB WHERE crc=\"$OMNIROM\" ";]}
		set tim ""
		if {$j > 0} {;		set tim [getHumanTime $j];		}
		.n.f0.stattree set $i time $tim

		catch {	.n.f0.stattree set $i count [dbSTAT eval "SELECT playcounter FROM $OMNIDB WHERE crc=\"$OMNIROM\" ";]}
		set stars ""
		catch {
			set j [dbSTAT eval "SELECT rating FROM $OMNIDB WHERE crc=\"$OMNIROM\" ";]
			for {set x 0} {$x<$j} {incr x} {;		set stars "$::ratingStar$stars";	}
			catch {for {set x 0} {$x<[expr 5-$j]} {incr x} {;			set stars "$stars$::ratingStar2";		}}
			.n.f0.stattree set $i rating $stars
		}
		catch {
			set year [string map {\} ""} [string map {\{ ""} [dbCORP eval "SELECT year FROM $OMNIDB WHERE crc=\"$OMNIROM\" ";] ]]
			.n.f0.stattree set $i year $year
		}
	}
} else {
	catch {	set j [dbSTAT eval "SELECT playtime FROM $::SelectedDB WHERE crc=\"$i\" ";] }
	set tim ""
	if {$j > 0} {;		set tim [getHumanTime $j];		}
	.n.f0.stattree set $i time $tim
	catch { .n.f0.stattree set $i count [dbSTAT eval "SELECT playcounter FROM $::SelectedDB WHERE crc=\"$i\" ";] }
	set stars ""
	catch {
		set j [dbSTAT eval "SELECT rating FROM $::SelectedDB WHERE crc=\"$i\" ";]
		for {set x 0} {$x<$j} {incr x} {;		set stars "$::ratingStar$stars";	}
		catch {for {set x 0} {$x<[expr 5-$j]} {incr x} {;			set stars "$stars$::ratingStar2";		}}
		.n.f0.stattree set $i rating $stars
	}
	set year [string map {\} ""} [string map {\{ ""} [dbCORP eval "SELECT year FROM $::SelectedDB WHERE crc=\"$i\" ";] ]]
	.n.f0.stattree set $i year $year
	}
}
	#	set ::StatisticDATA ""
	wm title . "$::ixbarversion : ($::TotalSelectedItems) search results"
}

proc getHumanTime {j} {
	set timeh [expr $j / 3600]
	set timemin [expr $j / 60]
	if {$timemin > 59} {
		set timemin [expr $timemin-($timeh*60)]
	}
	set timesec [expr $j % 60]

	set minpad [string length $timemin]
	if {$minpad < 2} {
		set minpad "0"
	} else {
		set minpad ""
	}

	set secpad [string length $timesec]
	if {$secpad < 2} {
	set secpad "0"
	} else {
	set secpad ""
	}
	return "$timeh:$minpad$timemin:$secpad$timesec"
}

proc clearSystemList {} {
	$::Console0 insert end "CLEAR SL\n"
	.n.f0.syslist delete 1.0 end
	.n.f2.syslist delete 1.0 end
	populateSystemList
}

proc populateSystemList {} {
	updateSystemList
	InitNewSyslist
	InitNewSyslistStat
}


proc IPSPatchSet {} {
	set types {    {{Archive}        .zip             } {{IPS-file}        .ips             }}
	set IPSPatchtxt [tk_getOpenFile -filetypes $types]	

	if {$IPSPatchtxt eq ""} {
	# cancel
	} else {
	set ::IPSPatchtxt $IPSPatchtxt
	}
}

proc IPSPatchApply {newName} {
	# if file exists - extract
	if {[file exists $::IPSPatchtxt]} {
		$::Console0 insert end "found <$::IPSPatchtxt> \n"

	# Extract archive
	exec 7za e "$::IPSPatchtxt" -o$::HOMEDIR/TMP/PZ/ -aos

	# rename ips to selectedRom.ips
	set findIPS [glob -dir $::HOMEDIR/TMP/PZ/ *.ips]
	set newName [string map {\} ""} [string map {\{ ""} $newName]]

	set tempTarget $::HOMEDIR/TMP/PZ/$::selectedRomFast
	file copy -- $findIPS $tempTarget.ips;#	zsnes, etc
	file rename -force -- $findIPS $newName.ips	;# mednafen
	}
}



proc convertDatabase {} {
	set ModDB "IBMPC"
	$::Console0 insert end "convertDatabase $ModDB\n"

	if {[dbCORP exists "SELECT name FROM sqlite_master WHERE type='table' AND name='$ModDB' ";]} {
		$::Console0 insert end "CORP OK\n"

		set result [dbCORP eval "SELECT name FROM $ModDB";] 
#		$::Console0 insert end $result

		foreach i $result {
			set singleValueX [dbCORP eval "SELECT locale FROM $ModDB WHERE name='$i'";]
			if {$singleValueX == 0} {
			$::Console0 insert end "$i > $singleValueX\n"
#			dbCORP eval "UPDATE '$ModDB' SET locale='' WHERE name='$i'; "
		#	$::Console0 insert end "XXX\n"
			}
			dbCORP eval "UPDATE '$ModDB' SET music='' ; "
			dbCORP eval "UPDATE '$ModDB' SET program='' ; "
			dbCORP eval "UPDATE '$ModDB' SET series='' ; "
			dbCORP eval "UPDATE '$ModDB' SET type=''; "
		}
#		locale
#		 [dbCORP eval "SELECT System FROM systemconfig WHERE System='$::DBsys' ";]
	}
}

proc refreshSelectedList {} {
	if { ![info exists ::selectedSystemID] } {;set ::selectedSystemID 0;}
	populateRomView $::selectedSystemID
}

proc clExport {} {
	set result [dbDATA eval "SELECT name FROM $::DBsys ";]

	set ixbfile "$::HOMEDIR/MOJO/$::DBsys.ixb"
    set fl [open $ixbfile {WRONLY CREAT}]
    puts $fl "<CUSTOMLIST> <$::DBsys> EXPORTED WITH $::ixbarversion\n"

#	$::Console1 insert end "CUSTOMLIST EXPORTED WITH $::ixbarversion\n" 
	foreach name $result {
		set resultCRC [dbDATA eval "SELECT crc FROM $::DBsys WHERE name=\"$name\"";]

		set resultCRC [string map {\} ""} $resultCRC]
		set resultCRC [string map {\{ ""} $resultCRC]
#		$::Console1 insert end "abbr{$resultCRC}:\tname{$name};\n" 
		puts $fl "abbr{$resultCRC}:\tname{$name};"
	}
    close $fl
}



proc txtImport3 {} {
#moveSuffixFromPNG /media/REIMU/E/GB64v10/Screenshots/_1/0/
}

#source ./SYS/ext_txtimpot.tcl

proc moveSuffixFromPNG {imagedir} {
	# Takes in a directory -> runs all files through fixPrefix
	$::Console1 insert end "TITLEFIXER\n"

	set filelist [glob -nocomplain -dir $imagedir *.png]
	set pathLength [string length $imagedir]
	foreach i $filelist {
		set originalName $i
		set i [string map {"_" " "} $i]
		set i [string range $i $pathLength [string first ".png" $i]-1]
		set newName [fixPrefix $i]
		set newName "$imagedir$newName.png"
		file rename -force -- $originalName $newName
		$::Console1 insert end "$originalName\n$newName\n"
	}
}




proc echoChamber {echo} {
	# notify system only works with linux and is currently unused.
	exec notify-send "$echo"
}


proc makeRelease {} {
	# Clear configuration	,RomPreset=''
	dbCONF eval "UPDATE ixbarconfig SET EXT1='0',EXT2='0',EXT3='0'; "
	dbCONF eval "UPDATE systemconfig SET wemu='',RomDirectory=''; "
}


proc testfunctionzwei {} {
#	dbCORP eval "DROP TABLE \"$::SelectedDB\" "
}


