
#searchClear
#playPlaylist
#openManual
#InitNewSyslist
#clickSystemListStat
#populateRomView
#populateRomViewData
#itemclicked
#updateinfogname
#ClearStats

set ::librarytreeHidden 0
set ::midcolspan 1
set ::toggleLibraryMid 0

proc toggleLibraryRight {} {
	if {$::toggleLibraryRight eq "1"} {
		set ::midcolspan 2
		grid remove .n.f0.3rd
		grid remove .n.f0.3rd.extrapanel
		grid .n.f0.treeviewscroll -column $::midcolspan
		grid .n.f0.stattree -columnspan $::midcolspan
		set ::toggleLibraryRight 0
	} elseif {$::toggleLibraryRight eq "0"} {
		set ::midcolspan 1
		grid .n.f0.3rd
		grid .n.f0.3rd.extrapanel
		grid .n.f0.treeviewscroll -column $::midcolspan
		grid .n.f0.stattree -columnspan $::midcolspan
		set ::toggleLibraryRight 1
	}

#	if {$::librarytreeHidden eq "1"} {
#		grid remove .n.f0.treeviewscroll
#		grid remove .n.f0.stattree
#	} else {
#		grid remove .n.f0.gamecanvas
#	}
}


proc toggleLibraryCenter {} {
# DaFuq?!
toggleLibraryRight
toggleLibraryCenterF

#toggleLibraryCenterF
#toggleLibraryCenterF
}

proc toggleLibraryCenterF {} {
	$::Console0 insert end "toggleLibraryCenterF"
	
	if {$::toggleLibraryMid eq "0"} {
		grid .n.f0.gamecanvas -column 1 -row 0 -sticky nwes -columnspan $::midcolspan
		grid remove .n.f0.treeviewscroll
		grid remove .n.f0.stattree
		grid remove .n.f0.listallRL
		.n.f0.syslistcanvas configure -width 64
		set ::toggleLibraryMid 1
	} elseif {$::toggleLibraryMid eq "1"} {
		grid .n.f0.gamecanvas -column 1 -row 0 -sticky nwes -columnspan $::midcolspan
		grid remove .n.f0.gamecanvas
		.n.f0.syslistcanvas configure -width 250
		set ::toggleLibraryMid 0
	}
}

proc updateGamecanvas {} {
	.n.f0.gamecanvas itemconfigure GCgamename -text "$::textfromRomlist\n$::gameplaycount";#	Update GAMECANVAS
	.n.f0.gamecanvas itemconfigure "GCtitle" -image imgobj1
	.n.f0.gamecanvas itemconfigure "GCsshot" -image imgobj2
	.n.f0.gamecanvas itemconfigure "GCdev" -image corplogoextraDev
	.n.f0.gamecanvas itemconfigure "GCpub" -image corplogoextraPub

	catch {	.n.f0.gamecanvas itemconfigure "GCtitleNext" -image imgNext1 };#	history doesn't have next.
	#.n.f0.gamecanvas scale "GCtitleNext" 0 0 0.5 0.5
}


proc searchClear {} {
	set ::searchstring ""
	if {[info exists ::selectedSystemID]} {
	populateRomView $::selectedSystemID
	}
}

proc playPlaylist {} {
	set dummyhax " (.";# for those entries without comma or bracet
	set id $::selectedRomFast$dummyhax
	set id [string range $id 0 [string first " (" $id]-1 ]

	set filex "$::HOMEDIR/EXT/OST/$::SelectedDB/$id/all.pls"
	if {[file exists "$filex"]} {
	exec $::MusicPlayer $filex &
	}
}

proc openManual {} {
	set filex "$::HOMEDIR/EXT/MAN/$::SelectedDB/$::selectedRomFast.pdf"
	if {[file exists "$filex"]} {
	exec $::MagazinePlayer $filex &
	}
}

proc playVideo {} {
#	set dummyhax " (.";# for those entries without comma or bracet
#	set id $::selectedRomFast$dummyhax
#	set id [string range $id 0 [string first " (" $id]-1 ]

	set filex "$::HOMEDIR/EXT/VID/$::SelectedDB/$::selectedRomFast.flv"
	if {[file exists "$filex"]} {
	exec $::VideoPlayer $filex &
	}
}

#===========================================


tk::text .n.f0.syslist -width 35 -height 30 -background LightGrey -yscrollcommand ".n.f0.syslistscroll set" -cursor arrow;					grid .n.f0.syslist -column 0 -row 0 -rowspan 2 -sticky nwes
ttk::scrollbar .n.f0.syslistscroll -orient vertical -command ".n.f0.syslist yview";						grid .n.f0.syslistscroll -column 0 -row 0 -rowspan 2 -sticky nse

# DEVLOGO26 SET ROW TO 0
ttk::treeview .n.f0.stattree -selectmode "browse" -columns "time count rating year" -yscrollcommand ".n.f0.treeviewscroll set";	grid .n.f0.stattree -column 1 -row 0 -rowspan 2 -sticky nsew
ttk::scrollbar .n.f0.treeviewscroll -orient vertical -command ".n.f0.stattree yview";											grid .n.f0.treeviewscroll -column 1 -row 0 -rowspan 2 -sticky nse

.n.f0.stattree column #0 -width 400 -anchor e;		.n.f0.stattree heading #0 -text "Name"
.n.f0.stattree column time -stretch 0 -width 60 -anchor e;		.n.f0.stattree heading time -text "Time" -command "sortBy time 0"
.n.f0.stattree column count -stretch 0 -width 20 -anchor e;		.n.f0.stattree heading count -text "Count" -command "sortBy count 0"
.n.f0.stattree column rating -stretch 0 -width 55 -anchor center;	.n.f0.stattree heading rating -text "Rating" -command "sortBy rating 0"
.n.f0.stattree column year -stretch 0 -width 60 -anchor w;	.n.f0.stattree heading year -text " Year" -anchor w -command "sortBy year 0"

.n.f0.stattree tag bind tagname <<TreeviewSelect>> "itemclicked";# [.n.f0.stattree identify item]

# TODO -- GET (window size -250)
set canvasWidth 1000
tk::canvas .n.f0.gamecanvas  -width $canvasWidth -height 500
#grid .n.f0.gamecanvas -column 1 -row 1 -rowspan 1 -sticky nwes
set canvasMid [expr $canvasWidth/2-200]
#.n.f0.derp coords GCgamename $canvasMid 30
.n.f0.gamecanvas create text 55 30 -text "Experimental Gamecanvas -- Use the arrows below to control. (or:)\nwin+a - up\nwin+z - down\nwin+x - mode change" -anchor w -tags "GCgamename" -fill black

.n.f0.gamecanvas create image $canvasMid 230 -image corplogoextraDev -anchor w -tags "GCtitle"
.n.f0.gamecanvas create image $canvasMid 530 -image corplogoextraDev -anchor w -tags "GCsshot"

.n.f0.gamecanvas create image 100 530 -image corplogoextraDev -anchor w -tags "GCdev"
.n.f0.gamecanvas create image 530 530 -image corplogoextraDev -anchor w -tags "GCpub"

.n.f0.gamecanvas create image [expr $canvasWidth-200] 230 -image corplogoextraDev -anchor w -tags "GCtitleNext"
#corplogoextraDev

#ENABLE
#grid [tk::label .n.f0.upperpanel_dev -image corplogoextraDev -anchor center -height 64 ]	-column 1 -row 0 -sticky news;# -rowspan 2

# DEVLOGO26 SET ROW TO 1
#ttk::treeview .n.f0.stattree -selectmode "browse" -columns "time count rating year" -yscrollcommand ".n.f0.treeviewscroll set";	grid .n.f0.stattree -column 1 -row 0 -rowspan 2 -sticky nsew
#ttk::scrollbar .n.f0.treeviewscroll -orient vertical -command ".n.f0.stattree yview";											grid .n.f0.treeviewscroll -column 1 -row 0 -rowspan 2 -sticky nse

#grid rowconfigure .n.f0 0 -weight 0

grid [ttk::button .n.f0.searchBox.upTog -width 1 -text "\u2692" -command {upperPanelToggle} ]			-column 1 -row 4 -sticky w

tk::label .n.f0.upperpanel_dev -image corplogoextraDev -anchor center -height 64;	# Init upperPanel
set ::upperPanelState 0

proc upperPanelToggle {} {

	if {$::upperPanelState eq "1"} {
		grid remove .n.f0.upperpanel_dev
	set ::upperPanelState 0
	} else {
	grid configure .n.f0.stattree -row 1
	grid configure .n.f0.treeviewscroll -row 1

	
	#grid [tk::label .n.f0.upperpanel_dev -image corplogoextraDev -anchor center -height 64 ]	-column 1 -row 0 -sticky news;# -rowspan 2
	grid .n.f0.upperpanel_dev -column 1 -row 0 -sticky news;# -rowspan 2
	grid rowconfigure .n.f0 0 -weight 0
	set ::upperPanelState 1
	}
}

#===========================================
proc InitNewSyslist {} {
	.n.f0.syslistcanvas delete SL_E
#BG SLAB
	if {[file exists "./IMG/BGSlab.png"]} {
		image create photo BGSlab -file "./IMG/BGSlab.png"
	} else {
		image create photo BGSlab -file "./IMG/icon_noicon.png"
	}
	if {[file exists "./IMG/BGSlab1.png"]} {
		image create photo BGSlab1 -file "./IMG/BGSlab1.png"
	} else {
		image create photo BGSlab1 -file "./IMG/icon_noicon.png"
	}

	set i [llength $::db_systems_human]
# hakee arvot fn_sysloader_all:sta
#	.n.f0.syslist window create 0.0 -window .n.f0.syslist.row0
	for {set x 0} {$x<$i} {incr x} {
	set dbName [lindex $::db_systems_human $x]
	set dbNamenonH [lindex $::db_systems $x]
	set dbYear [lindex $::db_systems_date $x]
	set dbType [lindex $::db_systems_type $x]


#	$::Console0 insert end "-* $dbNamenonH\n"
	if {[file exists "./IMG/defaults/$dbNamenonH/100.png"]} {
		image create photo sysicon$x -file "./IMG/defaults/$dbNamenonH/100.png"
	} else {
		image create photo sysicon$x -file "./IMG/icon_noicon.png"
	}

	# Textmode
	set imgLine1 [string range [lindex $::db_systems_human $x] 0 30]
	set imgLine1 [string map {\} ""} [string map {\{ ""} $imgLine1]]
	set imgLine2 [string range "\n$dbYear ($dbType)" 0 30]
	set imgLine3 [string range "\n\t\t\t." 0 30]
	tk::button .n.f0.syslist.row$x -width 220 -height 40 -justify left -relief flat -compound left -image "sysicon$x" -text "$imgLine1$imgLine2$imgLine3" -command "populateRomView $x"
	.n.f0.syslist window create [expr $x+1].0 -window .n.f0.syslist.row$x
	
	
	# Canvasmode
#		.n.f0.syslistcanvas create rectangle 10 [expr [expr $x*50]+15] 180 [expr [expr $x*50]+60] -tags "SL_E SLcrect$x SL_En$x"
		# or
		.n.f0.syslistcanvas create image 0 [expr [expr $x*50]+30] -image BGSlab -anchor w    -tags "SL_E SL_En$x SL_Ebg$x"
		.n.f0.syslistcanvas create image 0 [expr [expr $x*50]+30] -image sysicon$x -anchor w -tags "SL_E SL_En$x"
		
		set dbName [string map {\} ""} [string map {\{ ""} [lindex $::db_systems_human $x]]]
		.n.f0.syslistcanvas create text 55 [expr [expr $x*50]+30] -text "$dbName$imgLine2" -anchor w -tags "SL_E SL_En$x" -fill black
	}
	

	iconcanvas;	set ::toggleLibraryLeft 3;										#	set the Default mode. -- unneeded once textmode depr.
	.n.f0.syslistcanvas configure -scrollregion "0 0 200 [expr ($i*40)+150]";	#	set scrollregion according to systems
		
		
	
#emiliano:	foreach btn {4 5} {---# {bind $child <Button-$btn> {event generate $text <Button-$btn>}}}
		if {$::DetectedOS eq "LIN"} {
			foreach child [winfo children .n.f0.syslist] {
				bind $child <Button-4> {event generate .n.f0.syslist <Button-4>}
				bind $child <Button-5> {event generate .n.f0.syslist <Button-5>}
			}
		} elseif {$::DetectedOS eq "WIN"} {
			foreach child [winfo children .n.f0.syslist] {
				bind $child <Button-1> {event generate .n.f0.syslist <Button-1>}
			}
		} else {
			$::Console0 insert end "Scroll fail\n"
		}
}


proc clickSystemListStat {} {;	# Empty stats!

	.n.f0.stattree delete [.n.f0.stattree children {}]
	set ::RomListMode "NULL"

	set idx [$::systemlist2 curselection]
	set ::SelectedDBStat [lindex $::db_systems $idx]

	if {[dbSTAT exists "SELECT name FROM sqlite_master WHERE type='table' AND name=\"$::SelectedDBStat\" ";]} {
		set ::StatisticList [dbSTAT eval "SELECT crc,playtime,playcounter,rating FROM \"$::SelectedDBStat\" ORDER BY playtime DESC"]
		$::Console0 insert end "STATDB> 1 $idx $::SelectedDBStat\n"
	} else {
		set ::StatisticList ""
	}
	if {[dbCORP exists "SELECT name FROM sqlite_master WHERE type='table' AND name=\"$::SelectedDBStat\" ";]} {
		set ::StatisticCORP [dbCORP eval "SELECT name,year FROM \"$::SelectedDBStat\""]
	} else {
		set ::StatisticCORP ""
	}
	populateRomViewData 0

}


proc hideItems {} {

	set ::hiddenItems ""
	set m 0
	foreach i $::StatisticCORP {
		if {$m == 0} {
			set ::hiddenItemsTMP $i
		} elseif {$m == 3} {

			if {$i == "Adult"} {
				$::Console0 insert end "Removing <$i>\n"
				lappend ::hiddenItems $::hiddenItemsTMP 
			}
		}

		incr m
		if {$m == 4} {
			set m 0
		}
	}


}

proc populateRomView {idx} {;# 									SYSLIST KLIK
	.n.f0.3rd.subnote.data.star.star1 configure -image "star_off";
	.n.f0.3rd.subnote.data.star.star2 configure -image "star_off";
	.n.f0.3rd.subnote.data.star.star3 configure -image "star_off";
	.n.f0.3rd.subnote.data.star.star4 configure -image "star_off";
	.n.f0.3rd.subnote.data.star.star5 configure -image "star_off";
	set ::gameplaycount "Time:\t0 h 0 min 0 sec\nPlaycount:\t0 times\nLast Play:\tN/A"
	set ::infoDeveloper ""
	set ::infoPublisher ""
	set ::infoYear ""
	set ::infoDesign ""
	set ::infoMusic ""
	set ::infoProgram ""
	set ::infoType ""
	set ::infoGenre ""
	set ::infoSeries ""
	set ::infoLocale ""
	image create photo gameboxcover -file "./IMG/icon_noicon.png" -height 400 -width 380
	image create photo corplogoextraDev -file "$::HOMEDIR/IMG/corp/noLogo.png" -height 64 -width 300
	image create photo corplogoextraPub -file "$::HOMEDIR/IMG/corp/noLogo.png" -height 64 -width 300
	.n.f0.3rd.subnote.user.box configure -image gameboxcover -compound image
	.n.f0.3rd.extrapanel.dev configure -image corplogoextraDev -anchor center
	.n.f0.3rd.extrapanel.pub configure -image corplogoextraPub -anchor center


	.n.f0.stattree delete [.n.f0.stattree children {}]
	set ::RomListMode "NULL"
	set ::selectedSystemID $idx

	set ::SelectedDBStat [lindex $::db_systems $idx]

	if {[dbDATA exists "SELECT name FROM sqlite_master WHERE type='table' AND name=\"$::SelectedDBStat\" ";]} {
		set ::StatisticDATA [dbDATA eval "SELECT name FROM \"$::SelectedDBStat\" ORDER BY name ASC"]
	} else {
		set ::StatisticDATA ""
	}
	if {[dbSTAT exists "SELECT name FROM sqlite_master WHERE type='table' AND name=\"$::SelectedDBStat\" ";]} {
		set ::StatisticList [dbSTAT eval "SELECT crc,playtime,playcounter,rating FROM \"$::SelectedDBStat\" ORDER BY playtime DESC"]
	} else {
		set ::StatisticList ""
	}
	if {[dbCORP exists "SELECT name FROM sqlite_master WHERE type='table' AND name=\"$::SelectedDBStat\" ";]} {
		set ::StatisticCORP [dbCORP eval "SELECT name,year,locale,type FROM \"$::SelectedDBStat\""]
	} else {
		set ::StatisticCORP ""
	}

	#logtext "PopulateRL> $wryy" 1

	set ::selectedRom ""
	set ::SelectedDB [lindex $::db_systems $idx]		;#post vars
	set ::selectedRomFast 0
	set ::hiddenItems ""
	if {$::ADULTMODE eq 0} {;						# hide adult games
		hideItems
	}

#catch {
	LoadROMImages 0
#}
	DisableThirdPanel
	populateRomViewData 0
	.n.f0.3rd.subnote.user.setexe configure -state disabled

	setSelectedSystemBG $idx
	#mergeSlavenodes
	#tk_messageBox -message "ping $idx"
}


proc mergeSlavenodes {} {;#					Merge statistics from slaves to master -- WIP
	logtext "mergeSlavenodes" 1

foreach all $::StatisticDATA {
#	logtext "$all" 1;# 	lists masters and slaves

	# Get all Masters
	set masters [.n.f0.stattree parent $all]
	if { 1 < [string length $masters]} {
		lappend masterList $masters;	# TODO -- clean duplicas FIXME !!
	#	logtext "<$masters>" 1
	}

	# Get all Slaves
	set slaves [.n.f0.stattree children $all]
	if { 1 < [string length $slaves]} {
		lappend slaveList $slaves
	}
}


foreach i $masterList {
#	logtext "<$i>" 1
	set slave [.n.f0.stattree children $i]
#	logtext "*Get data: $slave*" 1

#	FIXME -- works but SLOW / ~30-40s
#	TODO -- don't do this dynamic, but use saved db data.
#	set slaveDataTest [dbSTAT eval "SELECT crc,playtime,playcounter,rating FROM \"$::SelectedDBStat\" WHERE crc=\"$i\" "]
#	logtext "~ $slaveDataTest" 1

# 	TODO -- Fix format
#	.n.f0.stattree set $i time "900"
#	.n.f0.stattree set $i count "10"
#	.n.f0.stattree set $i rating "3"
#	.n.f0.stattree set $i year "3000"
}




#	catch { .n.f0.stattree delete $slaveList }

# [*] get master.
# [*] get slaves
# get slavedata
# merge

}


proc setSelectedSystemBG {idx} {
# TODO - canvasmode is initialized onload.
	set count [llength $::db_systems]
	for {set x 0} {$x<$count} {incr x} {
		.n.f0.syslist.row$x configure -background $::systemBGColor -foreground $::systemFGColor
		.n.f0.syslistcanvas itemconfigure "SL_Ebg$x" -image BGSlab
	}
		.n.f0.syslist.row$idx configure -background $::systemBGColorSel -foreground $::systemFGColorSel
		.n.f0.syslistcanvas itemconfigure "SL_Ebg$idx" -image BGSlab1
}


#proc bgerror {message} {
#    set timestamp [clock format [clock seconds]]
#    set fl [open mylog.txt {WRONLY CREAT APPEND}]
#    puts $fl "$timestamp: bgerror in $::argv '$message'"
#    close $fl
#}

proc populateRomViewData {search} {;		# SYSTEM selected.
set ::TotalSelectedItems 0
set slaveCount 0

set ld [list {*}$::StatisticDATA]
set lc [list {*}$::StatisticCORP]
set l [list {*}$::StatisticList]
set m 0
set ::StatEntry ""

	foreach i $ld {
		catch {	.n.f0.stattree insert {} end -id $i -text $i -tags "tagname" }
		incr ::TotalSelectedItems
	}
	.n.f0.stattree insert {} end -id "*" -text "*** CONTAINER ***" -tags "tagname"
	.n.f0.stattree insert {} end -id "~" -text "*** Lost and Found ***" -tags "tagname"
	catch { .n.f0.stattree delete $::hiddenItems }

	foreach i $l {
		incr m

		if {$m == "1"} {;#Name
			set id $i
			set name [string map {\{ ""} $i]
			set name [string map {\} ""} $name]

		} elseif {$m == "2"} {;# TIME

		if {$i > 0} {
			#$::Console0 insert end "i:$i "
			set timeh [expr $i / 3600]
			set timemin [expr $i / 60]
			if {$timemin > 59} {
				set timemin [expr $timemin-($timeh*60)]
			}
			set timesec [expr $i % 60]

			set minpad [string length $timemin]
			if {$minpad < 2} {
				set minpad "0"
			} else {
				set minpad ""
			}

			set secpad [string length $timesec]
			if {$secpad < 2} {
				set secpad "0"
			} else {
				set secpad ""
			}

			set i "$timeh:$minpad$timemin:$secpad$timesec"
		}

# SET COUNT TO 0 and MAME will fail
# if {[string length $i] > 0} {

		catch {	.n.f0.stattree set $id time $i }

#}

		#.n.f0.stattree set $id time "12"
		} elseif {$m == "3"} {;# PLAYCOUNT

#if {[string length $i] > 1} {
		catch {	.n.f0.stattree set $id count $i }
#}
		#.n.f0.stattree set $id count "34"
		} elseif {$m == "4"} {;# RATING
		set stars ""
		for {set x 0} {$x<$i} {incr x} {
			set stars "$::ratingStar$stars"
		}
		for {set x 0} {$x<[expr 5-$i]} {incr x} {
			set stars "$stars$::ratingStar2"
		}

#if {[string length $stars] > 0} {
		catch {	.n.f0.stattree set $id rating $stars }
#}
		#.n.f0.stattree set $id rating "56"
		set m 0
		}
	}

# Handles the metadata 1=id;2=year
	set luku "1"
	foreach i $lc {

	if {$luku == "1"} {
		set id $i
	} elseif {$luku == "2"} {
		set year $i
#if {[string length $i] > 1} {
	catch {	.n.f0.stattree set $id year "$year" }
#}
	} elseif {$luku == "3"} {
		set master $i
		set slave $id
		if {[string length $master] > 0} {
		incr slaveCount
		catch {	.n.f0.stattree move $slave $master end };# TODO this could seek orphans!
		}
	}

	incr luku
	if {$luku > 4} {;set luku "1";}
	}
	set ::TotalSelectedItems [expr $::TotalSelectedItems - $slaveCount]
	wm title . "$::ixbarversion : ($::TotalSelectedItems)"


	# insert items to lostandfound, skip non-datfiles	 
	if {$::SelectedDB ne "PC_LIN" && $::SelectedDB ne "PC_WIN" && $::SelectedDB ne "CAMIGAGB" \
		 && $::SelectedDB ne "C64" && $::SelectedDB ne "SHARPX1" && $::SelectedDB ne "SHARPX68" \
		 && $::SelectedDB ne "NEC6k1" && $::SelectedDB ne "NEC8k1" && $::SelectedDB ne "FUJFM7" && $::SelectedDB ne "MAME" } {

	if {[dbCONF exists "SELECT System FROM systemconfig WHERE System='$::SelectedDB' ";]} {
		set systemconfRomRomDirecto [dbCONF eval "SELECT RomDirectory FROM systemconfig WHERE System='$::SelectedDB' ";]
		if {[string length $systemconfRomRomDirecto] > 3} {
			lostandfound
		}

	}



	}
}

proc itemclicked {} {

	# NULL VALUES
	set ::RomPreset ""
	set ::RomPostset ""
	set emu ""
#	set post "$::SelectedDB"
		
	if {[dbCONF exists "SELECT System FROM systemconfig WHERE System='$::SelectedDB' ";]} {
		# GET VALUES FROM DB
		set systemconfLoadType [dbCONF eval "SELECT LoadType FROM systemconfig WHERE System='$::SelectedDB' ";]
		set systemconfwemu [dbCONF eval "SELECT wemu FROM systemconfig WHERE System='$::SelectedDB' ";]
		set systemconflemu [dbCONF eval "SELECT lemu FROM systemconfig WHERE System='$::SelectedDB' ";]
		set systemconfRomPreset [dbCONF eval "SELECT RomPreset FROM systemconfig WHERE System='$::SelectedDB' ";]
		set systemconfRomPostset [dbCONF eval "SELECT RomPostset FROM systemconfig WHERE System='$::SelectedDB' ";]
		set systemconfRomRomDirecto [dbCONF eval "SELECT RomDirectory FROM systemconfig WHERE System='$::SelectedDB' ";]

		#SET VALUES
		set ::LoadType $systemconfLoadType
		set wemu $systemconfwemu
		set lemu $systemconflemu
		set ::RomPreset [string map {\} ""} [string map {\{ ""} $systemconfRomPreset]]
		set ::RomPostset [string map {\} ""} [string map {\{ ""} $systemconfRomPostset]]
		set ::RomDirectory [string map {\} ""} [string map {\{ ""} $systemconfRomRomDirecto]]

		# SET EMU
		if {$::DetectedOS eq "WIN"} {
			set emu $wemu
		} else {
			set emu $lemu
		}
	}

	

	if {$::RomListMode eq "OMNI" || $::RomListMode eq "HISTORY"} {
		set idx [.n.f0.stattree selection]

		set selectedRomNAME_brackets $idx;# -> {1943 - The Battle of Valhalla (Japan)}
		set ::selectedRomNAME [string map {\{ ""} $selectedRomNAME_brackets]
		set ::selectedRomNAME [string map {\} ""} $::selectedRomNAME];# -> 1943 - The Battle of Valhalla (Japan)

		set ::SelectedDB [string range $::selectedRomNAME 0 [string first {>} $::selectedRomNAME]-1]
		set ::selectedRomNAME [string range $::selectedRomNAME [string first {>} $::selectedRomNAME]+1 end]

		set ::RomDirectory [dbCONF eval "SELECT RomDirectory FROM systemconfig WHERE System='$::SelectedDB' ";]
		set ::RomDirectory [string map {\} ""} [string map {\{ ""} $::RomDirectory]]

		# SET EMU
		if {$::DetectedOS eq "WIN"} {
			set emu [dbCONF eval "SELECT wemu FROM systemconfig WHERE System='$::SelectedDB' ";]
		} else {
			set emu [dbCONF eval "SELECT lemu FROM systemconfig WHERE System='$::SelectedDB' ";]
		}
		set ::LoadType [dbCONF eval "SELECT LoadType FROM systemconfig WHERE System='$::SelectedDB' ";]

	} else {
		set idx [.n.f0.stattree selection]

		set selectedRomNAME_brackets $idx;# -> {1943 - The Battle of Valhalla (Japan)}
		set ::selectedRomNAME [string map {\{ ""} $selectedRomNAME_brackets]
		set ::selectedRomNAME [string map {\} ""} $::selectedRomNAME];# -> 1943 - The Battle of Valhalla (Japan)
	}
	set rom $::selectedRomNAME

	set ::selectedEmu "$emu"
	set ::selectedRom "$rom"
	set ::textfromRomlist "$rom";# -> 1943 - The Battle of Valhalla (Japan).nes # DO NOT TOUCH!
	set ::selectedRomFast "$rom"
#	$::Console0 insert end "STATDB>$::SelectedDB! \n"
	catch {	set ::selectedRomCRC_db1 [dbDATA eval "SELECT crc FROM \"$::SelectedDB\" WHERE romname=\"$::selectedRom\" ";] };# Empty database -> E!

	if {$::SelectedDB eq "MAME"} {
		set ::selectedRom [dbDATA eval "SELECT crc FROM \"$::SelectedDB\" WHERE name=\"$::selectedRom\" ";]
		$::Console0 insert end "MAME SELECTED: $::selectedRom\n"
	}

	if {$::SelectedDB eq "PC_DOS" || $::SelectedDB eq "PC_WIN" || $::SelectedDB eq "PC_LIN"} {
		.n.f0.3rd.subnote.user.setexe configure -state normal
	}


	VirtualThisROM;	# update joystick

#	set myYearTest "0"
#	set myYearTest [dbCORP eval "SELECT year FROM $::SelectedDB WHERE crc=\"$::selectedRomFast\" "]
#	set mstExist [dbCORP exists "SELECT year FROM $::SelectedDB WHERE crc=\"$::selectedRomFast\" ";]
#if { $mstExist } {
#	logtext "++ YEAR?: <$myYearTest> $mstExist" 1
#} else {
#	logtext "-- YEAR?: <$myYearTest> $mstExist" 1
#}
	#.n.f0.gamecanvas itemconfigure GCgamename -text "$::textfromRomlist";#	Update GAMECANVAS
	"getPlaytime"
	"getRating"
	"getInformation"
	"CheckDBAwards"
	LoadROMImages 1
	"EnableThirdPanel"

#	$::Console0 insert end "CLIK> $idx\nprocessing:$selectedRomNAME_brackets\nresult:$::selectedRomNAME\n"
	updateinfogname
	updateExtrapanel
	updateGamecanvas;# $::textfromRomlist

# Print item stats

	set CRC_db1 [dbDATA eval "SELECT crc FROM \"$::SelectedDB\" WHERE crc=\"$::selectedRom\" ";]
	set NAM_db1 [dbDATA eval "SELECT name FROM \"$::SelectedDB\" WHERE crc=\"$::selectedRom\" ";]
	set DES_db1 [dbDATA eval "SELECT description FROM \"$::SelectedDB\" WHERE crc=\"$::selectedRom\" ";]
	set ROM_db1 [dbDATA eval "SELECT romname FROM \"$::SelectedDB\" WHERE crc=\"$::selectedRom\" ";]

	# TODO -- PLAN 031
	# * Name 	-> RL / matching
	# * Romname ->
	# * Descrip -> KANJI / original name
	# * CRC 	->
	logtext "-> DB : $::SelectedDB / $::selectedRom" 1
	logtext "->NAME: $NAM_db1" 1
	logtext "->ROMN: $ROM_db1" 1
	logtext "->DESC: $DES_db1" 1
	logtext "->CRC : $CRC_db1" 1



#wm title . "$::ixbarversion : DB:$::SelectedDB | EMU:$::selectedEmu | ROM:$::selectedRom: PATH:$::RomDirectory"

	# TEST nameaudit -- fixes naming issues
#	source ./SYS/fn_namefixerlist.tcl
#	set fixedName [string map "SRAA" "WRYY" $series]
#	$::Console0 insert end "QQ>$::SelectedDB!$::selectedRomNAME \n"
#	dbCORP eval "UPDATE \"$::SelectedDB\" SET series='$fixedName' WHERE crc='$::selectedRomNAME'; "

}



proc updateExtrapanel {} {
	if {[file exists "$::HOMEDIR/IMG/corp/$::infoDeveloper.png"]} {
		image create photo corplogoextraDev -file "$::HOMEDIR/IMG/corp/$::infoDeveloper.png" -height 64 -width 300
		.n.f0.3rd.extrapanel.dev configure -image corplogoextraDev -text "" -compound center
	} else {
		image create photo corplogoextraDev -file "$::HOMEDIR/IMG/corp/noLogo.png" -height 64 -width 300 
		.n.f0.3rd.extrapanel.dev configure -image corplogoextraDev -text $::infoDeveloper -compound center
	}
	if {[file exists "$::HOMEDIR/IMG/corp/$::infoPublisher.png"]} {
		image create photo corplogoextraPub -file "$::HOMEDIR/IMG/corp/$::infoPublisher.png" -height 64 -width 300
		.n.f0.3rd.extrapanel.pub configure -image corplogoextraPub -text "" -compound center
	} else {
		image create photo corplogoextraPub -file "$::HOMEDIR/IMG/corp/noLogo.png" -height 64 -width 300
		.n.f0.3rd.extrapanel.pub configure -image corplogoextraPub -text $::infoPublisher -compound center
	}

}

proc listAllToRomlist {} {;	# OMNI BUTTON
	.n.f0.stattree delete [.n.f0.stattree children {}]
	set ::TotalSelectedItems 0
	set ::SelectedDB "OMNI"

	if {[dbCONF exists "SELECT name FROM sqlite_master WHERE type='table' AND name='systemconfig' ";]} {
		set enabledSYS [dbCONF eval "SELECT System FROM systemconfig WHERE Active='1' ";]
#		$::Console0 insert end ">>>E-Systems2 $enabledSYS\n"
	}

	set enabledSYS [split $enabledSYS " "]
	foreach ActSystem $enabledSYS {
	#	$::Console0 insert end "- <>\n"
		if {[dbDATA exists "SELECT name FROM sqlite_master WHERE type='table' AND name='$ActSystem' ";]} {
			set StatisticDATAOMNI [dbDATA eval "SELECT name FROM \"$ActSystem\" ORDER BY name ASC"]
		} else {
			set StatisticDATAOMNI ""
		}

		set ld [list {*}$StatisticDATAOMNI]
		foreach i $ld {
		#	set OMNIDB [string range $i 0 [string first {>} $i]-1]
	#		set OMNIROM [string range $i [string first {>} $i]+1 end]
			incr ::TotalSelectedItems
			set id "$ActSystem>$i"
catch {			.n.f0.stattree insert {} end -id $id -text $id -tags "tagname" }
			lappend ::StatisticDATA $id
#====
if {$::enableOMNIvalues eq 1} {
	set j [dbSTAT eval "SELECT playtime FROM $ActSystem WHERE crc=\"$i\" ";]
	set tim ""
	if {$j > 0} {;		set tim [getHumanTime $j];		}
	.n.f0.stattree set $id time $tim

	.n.f0.stattree set $id count [dbSTAT eval "SELECT playcounter FROM $ActSystem WHERE crc=\"$i\" ";]

	set stars ""
	set j [dbSTAT eval "SELECT rating FROM $ActSystem WHERE crc=\"$i\" ";]
	for {set x 0} {$x<$j} {incr x} {;		set stars "*$stars";	}
	.n.f0.stattree set $id rating $stars

	set year [string map {\} ""} [string map {\{ ""} [dbCORP eval "SELECT year FROM $ActSystem WHERE crc=\"$i\" ";] ]]
	.n.f0.stattree set $id year $year
}
#====
		}
		set ::RomListMode "OMNI"
	}
	wm title . "$::ixbarversion : ($::TotalSelectedItems)"
}


proc updateinfogname {} {
	.n.f0.3rd.subnote.data.gname delete 1.0 end
	.n.f0.3rd.subnote.data.gname insert end $::selectedRomNAME
}

proc ClearStats {} {
	$::Console0 insert end "STATDB>CLEAR! \n"
	.n.f0.stattree delete [.n.f0.stattree children {}]
}

proc sortBy {col direction} {
	set tree ".n.f0.stattree"
#	tk_messageBox -message "sortBy: $col to $direction"

    set data {}
    foreach row [$tree children {}] {
	lappend data [list [$tree set $row $col] $row]
#	tk_messageBox -message "data: $data"
    }

    set dir [expr {$direction ? "-increasing" : "-decreasing"}]
    set r -1

    # Now reshuffle the rows into the sorted order
    foreach info [lsort -dictionary -index 0 $dir $data] {
	$tree move [lindex $info 1] {} [incr r]
    }

    # Switch the heading so that it will sort in the opposite direction
    $tree heading $col -command [list sortBy $col [expr {!$direction}]]
}


proc historyView {} {
	.n.f0.stattree delete [.n.f0.stattree children {}]
	set ::TotalSelectedItems 0
	set ::SelectedDB "HISTORY"
	set ::RomListMode "HISTORY"
	set historylimit 100

	#dbSTAT eval "DROP TABLE history"
	if {[dbSTAT exists "SELECT name FROM sqlite_master WHERE type='table' AND name='history' ";]} {

		set historyList [dbSTAT eval "SELECT name, system,lastplayed FROM history WHERE lastplayed>1479000000 ORDER BY lastplayed DESC LIMIT $historylimit";]
	#	set historyList1 [dbSTAT eval "SELECT * FROM history ORDER BY name DESC";]

		set ::historyName ""
		set ::historySys ""
		set ::historyTime ""

		set m 0
		foreach i $historyList {
			incr m
			if {$m eq 1} {
				set ::historyName $i
			} elseif {$m eq 2} {
				set ::historySys $i
			} elseif {$m eq 3} {
				set ::historyTime $i

				set id "$::historySys>$::historyName"
				catch {	.n.f0.stattree insert {} end -id $id -text $id -tags "tagname" }
				set m 0
				set j [dbSTAT eval "SELECT playtime FROM \"$::historySys\" WHERE crc=\"$::historyName\" ";]

				set tim ""
				if {$j > 0} {;		set tim [getHumanTime $j];		}
				.n.f0.stattree set $id time $tim

				.n.f0.stattree set $id count [dbSTAT eval "SELECT playcounter FROM \"$::historySys\" WHERE crc=\"$::historyName\" ";]

				set stars ""
				set j [dbSTAT eval "SELECT rating FROM \"$::historySys\" WHERE crc=\"$::historyName\" ";]
				for {set x 0} {$x<$j} {incr x} {
					set stars "$::ratingStar$stars"
				}
				for {set x 0} {$x<[expr 5-$j]} {incr x} {
					set stars "$stars$::ratingStar2"
				}
				.n.f0.stattree set $id rating $stars

				set year [string map {\} ""} [string map {\{ ""} [dbCORP eval "SELECT year FROM \"$::historySys\" WHERE crc=\"$::historyName\" ";] ]]
				.n.f0.stattree set $id year $year
			}
		}
	}
}



proc toggleLibraryLeft {} {
	if {$::toggleLibraryLeft eq "1"} {
		$::Console0 insert end "Left 1 \n"
#		iconifyReverse
#		set ::toggleLibraryLeft 0
	} elseif {$::toggleLibraryLeft eq "0"} {
		$::Console0 insert end "Left 0 \n"
#		iconify
#		set ::toggleLibraryLeft 2
	} elseif {$::toggleLibraryLeft eq "2"} {
		$::Console0 insert end "Left 2 \n"
		iconcanvas
		set ::toggleLibraryLeft 3
		grid .n.f0.listallRL;# restore OMNI
	} elseif {$::toggleLibraryLeft eq "3"} {
		$::Console0 insert end "Left 3 \n"
		iconhide
		set ::toggleLibraryLeft 2
	}
}

proc iconifyReverse {} {
	grid remove .n.f0.syslistcanvas
	grid remove .n.f0.syslistcanvasscr
	grid .n.f0.syslist
	grid .n.f0.syslistscroll
#	grid .n.f0.scroll
	set i [llength $::db_systems_human]
	for {set x 0} {$x<$i} {incr x} {
		.n.f0.syslist.row$x configure -compound left -width 220 
	}

}

proc iconify {} {
	set i [llength $::db_systems_human]
	for {set x 0} {$x<$i} {incr x} {
		.n.f0.syslist.row$x configure -compound none -width 45 -height 45
	}
}

proc getMousecoords {} {
	set window [lindex [wm stackorder .] end ]
	set MouseCoordsX [expr {[winfo pointerx .] - [winfo rootx $window]}]
#	set mo1 [winfo pointerx .]
#	set mo2 [winfo rootx $window]
	set MouseCoordsY [expr {[winfo pointery .] - [winfo rooty $window]}]
	$::Console0 insert end "mouse>$MouseCoordsX:$MouseCoordsY \n"
}

proc SLCanvasGetPlatform {e} {
	set dbName [lindex $::db_systems_human $e]
	$::Console0 insert end "platform>$e : $dbName\n"
	populateRomView $e
	#.n.f0.syslistcanvas move "SL_E" 0 -50
}

proc iconcanvas {} {
	grid remove .n.f0.syslist
	grid remove .n.f0.syslistscroll
	grid .n.f0.syslistcanvasscr
	grid .n.f0.syslistcanvas
#	.n.f0.syslistcanvas delete SL_E
#	grid remove .n.f0.scroll
#	set dbNamenonH [lindex $::db_systems $x]
	
	set i [llength $::db_systems_human]

	for {set x 0} {$x<$i} {incr x} {
	
		.n.f0.syslistcanvas bind "SL_En$x" <ButtonPress> "SLCanvasGetPlatform $x"

	}
}

proc iconhide {} {
	grid remove .n.f0.syslist
	grid remove .n.f0.syslistscroll
	grid remove .n.f0.syslistcanvasscr
	grid remove .n.f0.syslistcanvas
	grid remove .n.f0.listallRL
}


#TODO C64 fails bc subfolders
proc ClearMissing {} {
	if {![info exists ::SelectedDB]} { return }
	if { $::SelectedDB eq "PC_LIN" || $::SelectedDB eq "PC_WIN" || $::RomListMode eq "OMNI"} {

	} else {
		set romdir [dbCONF eval "SELECT RomDirectory FROM systemconfig WHERE System='$::SelectedDB' ";]
		set romdir [string map {\} ""} [string map {\{ ""} $romdir]]
		set gamelistmy [glob -dir $romdir *]
		set gamelistdat [list {*}$::StatisticDATA]
		set pathLength [string length $romdir]
		foreach i $gamelistdat {

			set fileexists [glob -nocomplain -dir $romdir $i.*]

			if { [string length $fileexists] < 3} {
				$::Console0 insert end "<hide:$i>\n"
				set i [list "$i"]
				catch { .n.f0.stattree delete "$i" }
			} 
		}
	}
}




proc ClearHaves {} {
	if {![info exists ::SelectedDB]} { return }
	if { $::SelectedDB eq "PC_LIN" || $::SelectedDB eq "PC_WIN" || $::RomListMode eq "OMNI"} {

	} else {
		set romdir [dbCONF eval "SELECT RomDirectory FROM systemconfig WHERE System='$::SelectedDB' ";]
		set romdir [string map {\} ""} [string map {\{ ""} $romdir]]
		set gamelistmy [glob -dir $romdir *]
		set gamelistdat [list {*}$::StatisticDATA]
		set pathLength [string length $romdir]
		foreach i $gamelistdat {

			set fileexists [glob -nocomplain -dir $romdir $i.*]

			if { [string length $fileexists] > 3} {
				$::Console0 insert end "<hide:$i>\n"
				set i [list "$i"]
				catch { .n.f0.stattree delete "$i" }
			} 
		}
	}
}

proc toggleFilterList {} {
	set RLType [.n.f0.searchBox.romlisttype get]
	if {$RLType eq "Hide Missing"} {
	ClearMissing
	} elseif {$RLType eq "Hide Available"} {
	ClearHaves
	}
}
