/*********************************************************** {{{1 ***********
 *  Copyright (C) 2005,2006  Martin Krischik (JavaME port)
 ****************************************************************************
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ****************************************************************************
 *  $Author: krischik $
 *
 *  $Revision: 461 $
 *  $Date: 2008-08-20 19:11:49 +0200 (Mi, 20 Aug 2008) $
 *
 *  $Id: Key.java 461 2008-08-20 17:11:49Z krischik $
 *  $HeadURL: https://uiq3.svn.sourceforge.net/svnroot/uiq3/tags/HP45-CLDC-2.0.1/Calculator-CLDC/src/net/sourceforge/uiq3/calculator/ui/Key.java $
 ************************************************************ }}}1 **********/

/**
 * @author "Martin Krischik" <krischik@users.sourceforge.net>
 * @model name="Uiq3.Calculator.UI"
 *
 */
package net.sourceforge.uiq3.calculator.ui;

/**
 * HP 45 Keyboard
 * 
 * @author "Martin Krischik" <krischik@users.sourceforge.net>
 * @model name="Key"
 */
public abstract class Key
   implements
      net.sourceforge.uiq3.calculator.ui.IKey
   {
   /**
    * No key is pressed
    * 
    * @model name="No_Key"
    */
   public static final int No_Key = -1;
   /**
    * Filename qualifier for image files.
    * 
    * @model name="Images_Names"
    */
   protected static String Images_Names = null;

   /**
    * Filename qualifier for image files.
    * 
    * @model name="Images_Names"
    */
   public static void Set_Images_Names (final String Images_Names)
      {
      Key.Images_Names = Images_Names;
      }

   /**
    * The Type of the key. The controls the visual display, size colour etc. pp.
    * 
    * @model name="Size"
    */
   protected int Type;

   /**
    * Key Code used inside the Calculator.
    * 
    * @return Calculator key code or No_Key if no key pressed
    * @model name="Calculator_Key_Code"
    */
   protected int Calculator_Key_Code;

   /**
    * Height of the key on the on screen display.
    * 
    * @model name="Height"
    */
   protected int Height;

   /**
    * Key Code used inside Java.
    * 
    * @return Java key code or No_Key if no key pressed
    * @model name="Java_Key_Code"
    */
   protected int Java_Key_Code;

   /**
    * Width of the key on the on screen display.
    * 
    * @model name="Width"
    */
   protected int Width;

   /**
    * X position of the Key on the on screen display.
    * 
    * @model name="X"
    */
   protected int x;

   /**
    * Y position of the Key on the on screen display.
    * 
    * @model name="Y"
    */
   protected int y;

   /**
    * Create a new key mapping.
    * 
    * @param x
    *                X position of the Key on the on screen display.
    * @param y
    *                Y position of the Key on the on screen display.
    * @param Width
    *                Width of the key on the on screen display.
    * @param Height
    *                Height of the key on the on screen display.
    * @param Size
    *                Size (0 .. 3) of the key
    * @param Calculator_Key_Code
    *                Key Code used inside the Calculator.
    * @param Java_Key_Code
    *                Key Code used inside Java.
    * @model name="Key"
    */
   public Key (
      final int x,
      final int y,
      final int Width,
      final int Height,
      final int Size,
      final int Calculator_Key_Code,
      final int Java_Key_Code)
      {
      this.x = x;
      this.y = y;
      this.Width = Width;
      this.Height = Height;
      this.Calculator_Key_Code = Calculator_Key_Code;
      this.Java_Key_Code = Java_Key_Code;
      Type = Size;

      return;
      } // Key

   /**
    * Key Code used inside the Calculator
    * 
    * @return key code or No_Key if no key pressed
    * @model name="Get_Calculator_Keycode"
    */
   public int Get_Calculator_Keycode ()
      {
      return Calculator_Key_Code;
      } // Get_Calculator_Keycode

   /**
    * Height of the key on the on screen display.
    * 
    * @return Height of the key on the on screen display.
    * @model name="Get_Height"
    */
   public int Get_Height ()
      {
      return Height;
      } // Get_Height

   /**
    * Key Code used inside the Java
    * 
    * @return key code or No_Key if no key pressed
    * @model name="Get_Java_Key_Code"
    */
   public int Get_Java_Keycode ()
      {
      return Java_Key_Code;
      } // Get_Java_Keycode

   /**
    * The Type of the key. The controls the visual display, size colour etc.
    * pp..
    * 
    * @return Type of the key.
    * @model name="Get_Width"
    */
   public int Get_Type ()
      {
      return Type;
      } // Get_Type

   /**
    * Width of the key on the on screen display.
    * 
    * @return Width of the key on the on screen display.
    * @model name="Get_Width"
    */
   public int Get_Width ()
      {
      return Width;
      } // Get_Width

   /**
    * X position of the Key on the on screen display.
    * 
    * @return X position of the Key on the on screen display.
    * @model name="Get_X"
    */
   public int Get_X ()
      {
      return x;
      } // Get_X

   /**
    * y position of the Key on the on screen display.
    * 
    * @return Y position of the Key on the on screen display.
    * @model name="Get_Y"
    */
   public int Get_Y ()
      {
      return y;
      } // Get_Y

   /**
    * Draw highlight for key
    * 
    * @model name="Highlight"
    */
   public abstract void Highlight (javax.microedition.lcdui.Graphics graphics);

   /**
    * check if key with Java Key code has been hit.
    * 
    * @param Java_Key_Code
    *                Key code from the Java virtual maschine
    * @return true when key was hit
    * @model name="Is_Key_Hit"
    */
   public boolean Is_Key_Hit (final int Java_Key_Code)
      {
      return this.Java_Key_Code == Java_Key_Code;
      } // Is_Key_Hit

   /**
    * does a click on x,y hits this key?
    * 
    * @param x
    *                X position which was clicked
    * @param y
    *                Y position which was clicked
    * @return true when the key was hit.
    * @model name="Key_Hit"
    */
   public boolean Is_Key_Hit (final int x, final int y)
      {
      return ((x >= this.x) && (x < (this.x + Width)) && (y >= this.y) && (y < (this.y + Height)));
      } // Is_Key_Hit

   } // Key

//vim: set nowrap tabstop=8 shiftwidth=4 softtabstop=4 expandtab :
//vim: set textwidth=0 filetype=java foldmethod=syntax nospell :