/*********************************************************** {{{1 ***********
 *  Copyright (C) 2005,2006  Martin Krischik (JavaME port)
 ****************************************************************************
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ****************************************************************************
 *  $Author: krischik $
 *
 *  $Revision: 461 $
 *  $Date: 2008-08-20 19:11:49 +0200 (Mi, 20 Aug 2008) $
 *
 *  $Id: Utils.java 461 2008-08-20 17:11:49Z krischik $
 *  $HeadURL: https://uiq3.svn.sourceforge.net/svnroot/uiq3/tags/HP45-CLDC-2.0.1/Calculator/src/net/sourceforge/uiq3/Utils.java $
 ************************************************************ }}}1 **********/

package net.sourceforge.uiq3;

/**
 * Utility functions - so much for a pure OO language.
 * 
 * @author "Martin Krischik" <krischik@users.sourceforge.net>
 * @model name="Utils"
 */
public final class Utils
   {
   //   /**
   //    * add an record to a record store
   //    * 
   //    * @param Store
   //    * @param recordId
   //    * @param newData
   //    * @throws javax.microedition.rms.RecordStoreNotOpenException
   //    * @throws javax.microedition.rms.RecordStoreFullException
   //    * @throws javax.microedition.rms.RecordStoreException
   //    * @model name="Add_Record"
   //    */
   //   public static void Add_Record (
   //      final javax.microedition.rms.RecordStore Store,
   //      final int recordId,
   //      final byte [] newData)
   //      throws javax.microedition.rms.RecordStoreNotOpenException,
   //         javax.microedition.rms.RecordStoreFullException,
   //         javax.microedition.rms.RecordStoreException
   //      {
   //      System.out.println ("+ Utils.Add_Record (" + recordId + ")");
   //
   //      System.out.println ("> newData.length  =" + newData.length);
   //
   //      if (Store.getNumRecords () < recordId)
   //         {
   //         System.out.println ("> Add!");
   //         Store.addRecord (
   //         /* data     => */newData,
   //         /* offset   => */0,
   //         /* numBytes => */newData.length);
   //         }
   //      else
   //         {
   //         System.out.println ("> Change!");
   //         Store.setRecord (
   //         /* recordId => */1,
   //         /* data     => */newData,
   //         /* offset   => */0,
   //         /* numBytes => */newData.length);
   //         } // if
   //
   //      System.out.println ("- Utils.Add_Record ()");
   //      return;
   //      } // addRecord

   /**
    * compare the content of two arrays.
    * 
    * @param Left
    *                Left array
    * @param Right
    *                right array
    * @return true if both arrays contain the same data
    * @model name="equals"
    */
   public static boolean equals (final boolean [] Left, final boolean [] Right)
      {
      boolean Retval = true;

      if (Left.length != Right.length)
         {
         Retval = false;
         }
      else
         {
         Search: for (int i = 0; i < Left.length; i++)
            {
            if (Left [i] != Right [i])
               {
               Retval = false;
               break Search;
               } // if
            } // for
         }// if
      return Retval;
      } // equals

   /**
    * compare the content of two arrays.
    * 
    * @param Left
    *                Left array
    * @param Right
    *                right array
    * @return true if both arrays contain the same data
    * @model name="equals"
    */
   public static boolean equals (final short [] Left, final short [] Right)
      {
      boolean Retval = true;

      if (Left.length != Right.length)
         {
         Retval = false;
         }
      else
         {
         Search: for (int i = 0; i < Left.length; i++)
            {
            if (Left [i] != Right [i])
               {
               Retval = false;
               break Search;
               } // if
            } // for
         }// if
      return Retval;
      } // equals

   /**
    * @param Left
    *                Left value
    * @param Right
    *                Right Value
    * @return Left or right - whichever is larger
    * @model name="max"
    */
   public static int max (final int Left, final int Right)
      {
      if (Left > Right)
         {
         return Left;
         }
      else
         {
         return Right;
         } // if
      } // max

   /**
    * @param Left
    *                Left value
    * @param Right
    *                Right Value
    * @return Left or right - whichever is larger
    * @model name="min"
    */
   public static int min (final int Left, final int Right)
      {
      if (Left < Right)
         {
         return Left;
         }
      else
         {
         return Right;
         } // if
      } // max

   /**
    * Read line from file
    * 
    * @param Reader
    *                File to read from
    * @model name="Read_Line"
    */
   public static String Read_Line (final java.io.InputStreamReader Reader)
      throws java.io.IOException
      {
      String Retval = "";
      int Char = Reader.read ();

      if (Char == -1)
         {
         return null;
         }
      else
         {
         while (Char != -1 && Char != '\n' && Char != '\r')
            {
            Retval += (char) Char;
            Char = Reader.read ();
            } // while
         } // if
      return Retval;
      } // Read_Line
   } // Utils

//vim: set nowrap tabstop=8 shiftwidth=4 softtabstop=4 expandtab :
//vim: set textwidth=0 filetype=java foldmethod=marker nospell :
