/*********************************************************** {{{1 ***********
 *  Copyright (C) 2005,2006  Martin Krischik (JavaME port)
 ****************************************************************************
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ****************************************************************************
 *  $Author: krischik $
 *
 *  $Revision: 363 $
 *  $Date: 2008-06-04 20:33:55 +0200 (Mi, 04 Jun 2008) $
 *
 *  $Id: IOperation.java 363 2008-06-04 18:33:55Z krischik $
 *  $HeadURL: https://uiq3.svn.sourceforge.net/svnroot/uiq3/tags/HP45-CLDC-2.0.1/Calculator/src/net/sourceforge/uiq3/calculator/engine/IOperation.java $
 ************************************************************ }}}1 **********/

/**
 * @author "Martin Krischik" <krischik@users.sourceforge.net>
 * @model name="Uiq3.Calculator.Engine"
 */
package net.sourceforge.uiq3.calculator.engine;

/**
 * Virtual CPU Operation
 * 
 * @author "Martin Krischik" <krischik@users.sourceforge.net>
 * @model name="Operation"
 */
public interface IOperation
   {
   /**
    * Execute virtual CPU command
    * 
    * @param opcode
    *                Virtual CPU Operation to be executed
    * @throws Error
    *                 "Error" is an abstract exception class representing all
    *                 possible errors the calculator can produce.
    * @model name="Execute"
    */
   public abstract void Execute (final short opcode)
      throws Error;
   } // IOperation

//vim: set nowrap tabstop=8 shiftwidth=4 softtabstop=4 expandtab :
//vim: set textwidth=0 filetype=java foldmethod=syntax nospell :