/*********************************************************** {{{1 ***********
 *  Copyright (C) 2005,2006  Martin Krischik (JavaME port)
 ****************************************************************************
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ****************************************************************************
 *  $Author: krischik $
 *
 *  $Revision: 295 $
 *  $Date: 2008-05-05 20:31:59 +0200 (Mo, 05 Mai 2008) $
 *
 *  $Id: IKey.java 295 2008-05-05 18:31:59Z krischik $
 *  $HeadURL: https://uiq3.svn.sourceforge.net/svnroot/uiq3/tags/HP45-CLDC-2.0.1/Calculator/src/net/sourceforge/uiq3/calculator/ui/IKey.java $
 ************************************************************ }}}1 **********/

/**
 * @author "Martin Krischik" <krischik@users.sourceforge.net>
 * @model name="Uiq3.Calculator.UI"
 */
package net.sourceforge.uiq3.calculator.ui;

/**
 * Key mapping info between Java keys and keys of the virtual calculator.
 * 
 * @author "Martin Krischik" <krischik@users.sourceforge.net>
 * @model name="IKey"
 */
public abstract interface IKey
   {
   /**
    * No key is pressed
    * 
    * @model name="No_Key"
    */
   public static final int No_Key = -1;

   /**
    * Key Code used inside the Calculator
    * 
    * @return key code or No_Key if no key pressed
    * @model name="Get_Calculator_Keycode"
    */
   public abstract int Get_Calculator_Keycode ();

   /**
    * Height of the key on the on screen display.
    * 
    * @return Height of the key on the on screen display.
    * @model name="Get_Height"
    */
   public abstract int Get_Height ();

   /**
    * Key Code used inside the Java
    * 
    * @return key code or No_Key if no key pressed
    * @model name="Get_Java_Key_Code"
    */
   public abstract int Get_Java_Keycode ();

   /**
    * Width of the key on the on screen display.
    * 
    * @return Width of the key on the on screen display.
    * @model name="Get_Width"
    */
   public abstract int Get_Width ();

   /**
    * X position of the Key on the on screen display.
    * 
    * @return X position of the Key on the on screen display.
    * @model name="Get_X"
    */
   public abstract int Get_X ();

   /**
    * y position of the Key on the on screen display.
    * 
    * @return Y position of the Key on the on screen display.
    * @model name="Get_Y"
    */
   public abstract int Get_Y ();

   /**
    * check if key with Java Key code has been hit.
    * 
    * @param Java_Key_Code
    *                Key code from the Java virtual maschine
    * @return true when key was hit
    * @model name="Is_Key_Hit"
    */
   public abstract boolean Is_Key_Hit (int Java_Key_Code);

   /**
    * does a click on x,y hits this key?
    * 
    * @param x
    *                X position which was clicked
    * @param y
    *                Y position which was clicked
    * @return true when the key was hit.
    * @model name="Key_Hit"
    */
   public abstract boolean Is_Key_Hit (int x, int y);
   } // Key

//vim: set nowrap tabstop=8 shiftwidth=4 softtabstop=4 expandtab :
//vim: set textwidth=0 filetype=java foldmethod=syntax nospell :
