/*********************************************************** {{{1 ***********
 *  Copyright (C) 2005,2006  Martin Krischik (JavaME port)
 *  Copyright 2000 David G. Hicks            (Java port)
 *  Copyright 1995 Eric L. Smith             (Original C/X Windows)
 ****************************************************************************
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ****************************************************************************
 *  $Author: krischik $
 *
 *  $Revision: 433 $
 *  $Date: 2008-07-27 10:28:15 +0200 (So, 27 Jul 2008) $
 *
 *  $Id: op_arith.java 433 2008-07-27 08:28:15Z krischik $
 *  $HeadURL: https://uiq3.svn.sourceforge.net/svnroot/uiq3/tags/HP45-CLDC-2.0.1/HP45/src/net/sourceforge/uiq3/hp45/op_arith.java $
 ************************************************************ }}}1 **********/

/**
 * @author "Martin Krischik" <krischik@users.sourceforge.net>
 * @model name="Uiq3.HP45"
 */
package net.sourceforge.uiq3.hp45;

/**
 * @model
 */
final class op_arith
   implements
      net.sourceforge.uiq3.calculator.engine.IOperation
   {
   /**
    * @model name="Owner"
    */
   private final Calculator Owner;

   /**
    * @param calculator
    * @model name="op_arith"
    */
   op_arith (final Calculator calculator)
      {
      Owner = calculator;
      }

   /**
    * @model
    */
   public void Execute (final short opcode)
      {
      int op, field;
      final byte zero = 0;
      int first = 0, last = 0;
      byte temp;
      int i;
      final byte t[] = new byte [Calculator.Word_Size];

      op = opcode >> 5;
      field = (opcode >> 2) & 7;

      switch (field)
         {
         case 0: /* p  */

            {
            first = Owner.p;
            last = Owner.p;
            if (Owner.p >= Calculator.Word_Size)
               {
               //#ifdef DEBUG
               //# System.out.println ("Warning! p > WSIZE at "
               //# + Owner.Previous_Programm_Counter);
               //#endif
               last = 0; /* don't do anything */
               }
            break;
            }
         case 1: /* m  */

            {
            first = 3;
            last = 12;
            break;
            }
         case 2: /* x  */

            {
            first = 0;
            last = 2;
            break;
            }
         case 3: /* w  */

            {
            first = 0;
            last = 13;
            break;
            }
         case 4: /* wp */

            {
            first = 0;
            last = Owner.p; /* break; bug in orig??? */
            if (Owner.p > 13)
               {
               //#ifdef DEBUG
               //# System.out.println ("Warning! p >= WSIZE at "
               //#      + Owner.Previous_Programm_Counter);
               //#endif
               last = 13;
               }
            break;
            }
         case 5: /* ms */

            {
            first = 3;
            last = 13;
            break;
            }
         case 6: /* xs */

            {
            first = 2;
            last = 2;
            break;
            }
         case 7: /* s  */

            {
            first = 13;
            last = 13;
            break;
            }
         }

      switch (op)
         {
         case 0x00: /* if b[f] = 0 */

            {
            Owner.carry = 0; // dgh added - needed?
            for (i = first; i <= last; i++)
               {
               Owner.carry |= (Owner.b [i] != 0) ? 1 : 0;
               }
            break;
            }
         case 0x01: /* 0 -> b[f] */

            {
            for (i = first; i <= last; i++)
               {
               Owner.b [i] = 0;
               }
            Owner.carry = 0;
            break;
            }
         case 0x02: /* if a >= Coefficient[f] */

            {
            Owner.carry = 0;
            for (i = first; i <= last; i++)
               {
               t [i] = Owner.do_sub (Owner.a [i], Owner.c [i]);
               }
            break;
            }
         case 0x03: /* if Coefficient[f] >= 1 */

            {
            Owner.carry = 1;
            for (i = first; i <= last; i++)
               {
               Owner.carry &= (Owner.c [i] == 0) ? 1 : 0;
               }
            break;
            }
         case 0x04: /* b -> Coefficient[f] */

            {
            for (i = first; i <= last; i++)
               {
               Owner.c [i] = Owner.b [i];
               }
            Owner.carry = 0;
            break;
            }
         case 0x05: /* 0 - Coefficient -> Coefficient[f] */

            {
            Owner.carry = 0;
            for (i = first; i <= last; i++)
               {
               Owner.c [i] = Owner.do_sub (zero, Owner.c [i]);
               }
            break;
            }
         case 0x06: /* 0 -> Coefficient[f] */

            {
            for (i = first; i <= last; i++)
               {
               Owner.c [i] = 0;
               }
            Owner.carry = 0;
            break;
            }
         case 0x07: /* 0 - Coefficient - 1 -> Coefficient[f] */

            {
            Owner.carry = 1;
            for (i = first; i <= last; i++)
               {
               Owner.c [i] = Owner.do_sub (zero, Owner.c [i]);
               }
            break;
            }
         case 0x08: /* shift left a[f] */

            {
            for (i = last; i >= first; i--)
               {
               Owner.a [i] = (i == first) ? 0 : Owner.a [i - 1];
               }
            Owner.carry = 0;
            break;
            }
         case 0x09: /* a -> b[f] */

            {
            for (i = first; i <= last; i++)
               {
               Owner.b [i] = Owner.a [i];
               }
            Owner.carry = 0;
            break;
            }
         case 0x0a: /* a - Coefficient -> Coefficient[f] */

            {
            Owner.carry = 0;
            for (i = first; i <= last; i++)
               {
               Owner.c [i] = Owner.do_sub (Owner.a [i], Owner.c [i]);
               }
            break;
            }
         case 0x0b: /* Coefficient - 1 -> Coefficient[f] */

            {
            Owner.carry = 1;
            for (i = first; i <= last; i++)
               {
               Owner.c [i] = Owner.do_sub (Owner.c [i], zero);
               }
            break;
            }
         case 0x0c: /* Coefficient -> a[f] */

            {
            for (i = first; i <= last; i++)
               {
               Owner.a [i] = Owner.c [i];
               }
            Owner.carry = 0;
            break;
            }
         case 0x0d: /* if Coefficient[f] = 0 */

            {
            for (i = first; i <= last; i++)
               {
               Owner.carry |= (Owner.c [i] != 0) ? 1 : 0;
               }
            break;
            }
         case 0x0e: /* a + Coefficient -> Coefficient[f] */

            {
            Owner.carry = 0;
            for (i = first; i <= last; i++)
               {
               Owner.c [i] = Owner.do_add (Owner.a [i], Owner.c [i]);
               }
            break;
            }
         case 0x0f: /* Coefficient + 1 -> Coefficient[f] */

            {
            Owner.carry = 1;
            for (i = first; i <= last; i++)
               {
               Owner.c [i] = Owner.do_add (Owner.c [i], zero);
               }
            break;
            }
         case 0x10: /* if a >= b[f] */

            {
            Owner.carry = 0;
            for (i = first; i <= last; i++)
               {
               t [i] = Owner.do_sub (Owner.a [i], Owner.b [i]);
               }
            break;
            }
         case 0x11: /* b exchange Coefficient[f] */

            {
            for (i = first; i <= last; i++)
               {
               temp = Owner.b [i];
               Owner.b [i] = Owner.c [i];
               Owner.c [i] = temp;
               }
            Owner.carry = 0;
            break;
            }
         case 0x12: /* shift right Coefficient[f] */

            {
            for (i = first; i <= last; i++)
               {
               Owner.c [i] = (i == last) ? 0 : Owner.c [i + 1];
               }
            Owner.carry = 0;
            break;
            }
         case 0x13: /* if a[f] >= 1 */

            {
            Owner.carry = 1;
            for (i = first; i <= last; i++)
               {
               Owner.carry &= (Owner.a [i] == 0) ? 1 : 0;
               }
            break;
            }
         case 0x14: /* shift right b[f] */

            {
            for (i = first; i <= last; i++)
               {
               Owner.b [i] = (i == last) ? 0 : Owner.b [i + 1];
               }
            Owner.carry = 0;
            break;
            }
         case 0x15: /* Coefficient + Coefficient -> Coefficient[f] */

            {
            Owner.carry = 0;
            for (i = first; i <= last; i++)
               {
               Owner.c [i] = Owner.do_add (Owner.c [i], Owner.c [i]);
               }
            break;
            }
         case 0x16: /* shift right a[f] */

            {
            for (i = first; i <= last; i++)
               {
               Owner.a [i] = (i == last) ? 0 : Owner.a [i + 1];
               }
            Owner.carry = 0;
            break;
            }
         case 0x17: /* 0 -> a[f] */

            {
            for (i = first; i <= last; i++)
               {
               Owner.a [i] = 0;
               }
            Owner.carry = 0;
            break;
            }
         case 0x18: /* a - b -> a[f] */

            {
            Owner.carry = 0;
            for (i = first; i <= last; i++)
               {
               Owner.a [i] = Owner.do_sub (Owner.a [i], Owner.b [i]);
               }
            break;
            }
         case 0x19: /* a exchange b[f] */

            {
            for (i = first; i <= last; i++)
               {
               temp = Owner.a [i];
               Owner.a [i] = Owner.b [i];
               Owner.b [i] = temp;
               }
            Owner.carry = 0;
            break;
            }
         case 0x1a: /* a - Coefficient -> a[f] */

            {
            Owner.carry = 0;
            for (i = first; i <= last; i++)
               {
               Owner.a [i] = Owner.do_sub (Owner.a [i], Owner.c [i]);
               }
            break;
            }
         case 0x1b: /* a - 1 -> a[f] */

            {
            Owner.carry = 1;
            for (i = first; i <= last; i++)
               {
               Owner.a [i] = Owner.do_sub (Owner.a [i], zero);
               }
            break;
            }
         case 0x1c: /* a + b -> a[f] */

            {
            Owner.carry = 0;
            for (i = first; i <= last; i++)
               {
               Owner.a [i] = Owner.do_add (Owner.a [i], Owner.b [i]);
               }
            break;
            }
         case 0x1d: /* a exchange Coefficient[f] */

            {
            for (i = first; i <= last; i++)
               {
               temp = Owner.a [i];
               Owner.a [i] = Owner.c [i];
               Owner.c [i] = temp;
               }
            Owner.carry = 0;
            break;
            }
         case 0x1e: /* a + Coefficient -> a[f] */

            {
            Owner.carry = 0;
            for (i = first; i <= last; i++)
               {
               Owner.a [i] = Owner.do_add (Owner.a [i], Owner.c [i]);
               }
            break;
            }
         case 0x1f: /* a + 1 -> a[f] */

            {
            Owner.carry = 1;
            for (i = first; i <= last; i++)
               {
               Owner.a [i] = Owner.do_add (Owner.a [i], zero);
               }
            break;
            }
         }
      return;
      } // Execute
   }
//vim: set nowrap tabstop=8 shiftwidth=3 softtabstop=3 expandtab :
//vim: set textwidth=0 filetype=java foldmethod=marker nospell :
