/*********************************************************** {{{1 ***********
 *  Copyright (C) 2005,2006  Martin Krischik (JavaME port)
 ****************************************************************************
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ****************************************************************************
 *  $Author: krischik $
 *
 *  $Revision: 461 $
 *  $Date: 2008-08-20 19:11:49 +0200 (Mi, 20 Aug 2008) $
 *
 *  $Id: Canvas.java 461 2008-08-20 17:11:49Z krischik $
 *  $HeadURL: https://uiq3.svn.sourceforge.net/svnroot/uiq3/tags/HP45-CLDC-2.0.1/Calculator-CLDC/src/net/sourceforge/uiq3/calculator/ui/Canvas.java $
 ************************************************************ }}}1 **********/

/**
 * @author "Martin Krischik" <krischik@users.sourceforge.net>
 * @model name="Uiq3.Calculator.IU"
 */
package net.sourceforge.uiq3.calculator.ui;

/**
 * An display canvas for an Calculator
 * 
 * @author "Martin Krischik" <krischik@users.sourceforge.net>
 * @model name="Canvas"
 */
public abstract class Canvas
   extends
      javax.microedition.lcdui.game.GameCanvas
   implements
      net.sourceforge.uiq3.calculator.ui.ICanvas
   {
   /**
    * Font used for displaying online help.
    * 
    * @model name="Display_Font"
    */
   private static final javax.microedition.lcdui.Font Help_Font =
      javax.microedition.lcdui.Font.getFont (
      /* face  => */javax.microedition.lcdui.Font.FACE_PROPORTIONAL,
      /* style => */javax.microedition.lcdui.Font.STYLE_PLAIN,
      /* size  => */javax.microedition.lcdui.Font.SIZE_SMALL);
   /**
    * Colour used for displaying online help of normal keys.
    * 
    * @model name="Display_Foreground"
    */
   private static final int Help_Normal = 0x007bceeb;
   /**
    * Colour used for displaying online help of shifted keys.
    * 
    * @model name="Display_Foreground"
    */
   private static final int Help_Shifted = 0x007bcefa;
   /**
    * Colour used for displaying online help of shifted keys.
    * 
    * @model name="Display_Foreground"
    */
   private static final int Help_Special = 0x0000bfff;
   /**
    * Thread in which the virtual calculator CPU is running.
    * 
    * @model name="CPU_Thread"
    */
   private java.lang.Thread CPU_Thread = null;
   /**
    * Toggle Keyboard help on and off
    * 
    * @model name="Help"
    */
   private boolean Help = false;
   /**
    * The Key currently pressed
    * 
    * @model name="Pressed_Key"
    */
   private int Pressed_Key = net.sourceforge.uiq3.calculator.ui.IKey.No_Key;
   /**
    * The Key last read from the keyboard.
    * 
    * @model name="Read_Key"
    */
   private int Read_Key = net.sourceforge.uiq3.calculator.ui.IKey.No_Key;
   /**
    * All keys in the keyboard.
    * 
    * @model name="Keys"
    */
   protected Key [] Keyboard = null;
   /**
    * All keys in the keyboard.
    * 
    * @model name="Keys_Count"
    */
   protected int Keys_Count = 0;
   /**
    * Filename qualifier for image files.
    * 
    * @model name="Images_Names"
    */
   protected String Images_Names = null;
   /**
    * Text to be displayed on the calculator display.
    * 
    * @model name="Text"
    */
   protected String Utf16_Text = "";

   /**
    * Create an new canvas
    * 
    * @model name="Canvas"
    */
   public Canvas ()
      {
      super (/* suppressKeyEvents => */false);
      //System.out.println ("+ Canvas.Canvas ()");

      //System.out.println ("- Canvas.Canvas ()");
      return;
      } // Canvas

   /**
    * Filename qualifier for image files.
    * 
    * @model name="Images_Names"
    */
   public String Get_Images_Names ()
      {
      return Images_Names;
      }

   /**
    * Get calculator key code of the last key (de)pressed.
    * 
    * @return Calculator key code or No_Key if no key pressed
    * @model name="Get_Key"
    */
   public int Get_Keycode ()
      {
      int Retval = net.sourceforge.uiq3.calculator.ui.IKey.No_Key;

      if (Read_Key >= 0)
         {
         Retval = Keyboard [Read_Key].Get_Calculator_Keycode ();
         Read_Key = net.sourceforge.uiq3.calculator.ui.IKey.No_Key;
         } // if
      return Retval;
      } // Get_Keycode

   /**
    * paint the calculator
    * 
    * @param graphics
    *                Graphic object to paint to
    * @model name="Paint"
    * @see javax.microedition.lcdui.Canvas#paint(javax.microedition.lcdui.Graphics)
    */
   public void paint (final javax.microedition.lcdui.Graphics graphics)
      {
      Paint_Background (graphics);
      Paint_Indicator (graphics);
      Paint_Display (graphics);
      Paint_Key (graphics);
      if (Help)
         {
         Paint_Help (graphics);
         } // if
      return;
      } // paint

   public final void Read_Display_Theme ()
      throws java.io.IOException
      {
      //System.out.println ("+ Canvas.Read_Display_Theme ()");

      final Class self = getClass ();
      final String Locale = System.getProperty ("microedition.locale");
      String Platform = System.getProperty ("microedition.platform");
      java.io.InputStream Theme_Stream = null;

      Platform = Platform.substring (
      /* beginIndex => */0,
      /* endIndex   => */Platform.indexOf ("/"));

      Theme_Stream =
         self.getResourceAsStream ("/" + Platform + "-" + Locale + ".lst");

      if (Theme_Stream == null)
         {
         Theme_Stream =
            self.getResourceAsStream ("/SonyEricssonP990i-en.lst");
         } // if

      if (Theme_Stream == null)
         {
         //#ifdef DEBUG
         //# System.out.println ("! Theme file not found");
         //#endif
         throw new java.io.IOException ("Theme file not found!");
         } //if

      final java.io.InputStreamReader Theme_Reader =
         new java.io.InputStreamReader (
         /* is  => */Theme_Stream,
         /* enc => */"UTF-8");

      final String Image_Info =
         net.sourceforge.uiq3.Utils.Read_Line (Theme_Reader);

      Set_Image (Image_Info);

      Key.Set_Images_Names (Images_Names);
      Keyboard = new Key [Keys_Count];

      for (int i = 0; i < Keys_Count; i++)
         {
         final String Buffer =
            net.sourceforge.uiq3.Utils.Read_Line (Theme_Reader);
         //System.out.println ("> " + Buffer);

         Keyboard [i] = Create_Key (Buffer);
         } // while
      //System.out.println ("- Canvas.Read_Display_Theme ()");
      return;
      }// Read_Display_Theme

   /**
    * Set calculator Thread so the canvas can wake up the calculator after key /
    * touch screen clicks.
    * 
    * @param CPU_Thread
    *                CPU Thread.
    * @model name="Get_Key"
    */
   public void Set_CPU_Thread (final java.lang.Thread CPU_Thread)
      {
      this.CPU_Thread = CPU_Thread;

      return;
      }

   /**
    * Set text to be displayed.
    * 
    * @param Text
    *                to be displayed
    * @model name="Set_Text"
    */
   public void Set_Text (final String Text)
      {
      //System.out.println ("+ Canvas.Set_Text ("+ Text + ")");

      if (!Utf16_Text.equals (Text))
         {
         //#ifdef DEBUG
         System.out.println (Text);
         //#endif 

         Utf16_Text = new String (Text);
         this.repaint ();
         } // if

      //System.out.println ("- Canvas.Set_Text ()");
      return;
      } // Set_Text

   /**
    * Toggle Keyboard help on and off
    * 
    * @model name="Toggle_Help"
    */
   public void Toggle_Help ()
      {
      Help = !Help;
      this.repaint ();
      return;
      } // Toggle_Help

   /**
    * Create new Key from an line read from the theme file
    * 
    * @see net.sourceforge.uiq3.ui.Canvas#Create_Key(java.lang.String)
    * @model name="Create_Key"
    */
   protected abstract Key Create_Key (String Theme_Line);

   /**
    * Called when a key is pressed
    * 
    * @param keyCode
    *                Java key code of real key pressed
    * @model name="Key_Pressed"
    */
   protected void keyPressed (final int keyCode)
      {
      //System.out.println ("+ Key.keyPressed (" + Integer.toString (keyCode)
      //+ ")");

      Pressed_Key = net.sourceforge.uiq3.calculator.ui.IKey.No_Key;

      Search_Key: for (int i = 0; i < Keyboard.length; i++)
         {
         if (Keyboard [i].Is_Key_Hit (keyCode))
            {
            Pressed_Key = i;
            Read_Key = i;
            break Search_Key;
            } // if
         } // for Search_Key

      // reset shift and alt state
      //
      getKeyStates ();
      synchronized (CPU_Thread)
         {
         CPU_Thread.interrupt ();
         } // synchronized
      this.repaint ();

      //System.out.println ("- Key.keyPressed ()");
      return;
      } // keyPressed

   /**
    * Called when a key is released
    * 
    * @param keyCode
    *                Java key code of real key released
    * @model name="Key_Released"
    */
   protected void keyReleased (final int keyCode)
      {
      //System.out.println ("+ Key.keyReleased (" + Integer.toString (keyCode)
      //+ ")");

      Pressed_Key = net.sourceforge.uiq3.calculator.ui.IKey.No_Key;
      synchronized (CPU_Thread)
         {
         CPU_Thread.interrupt ();
         } // synchronized
      this.repaint ();

      //System.out.println ("- Key.keyReleased ()");
      return;
      } // keyReleased

   /**
    * Paint the background image of our calculator
    * 
    * @param graphics
    *                Graphic object to paint to
    * @model name="Paint_Background"
    */
   protected abstract void Paint_Background (
      javax.microedition.lcdui.Graphics graphics);

   /**
    * Paint the calculator result display
    * 
    * @param graphics
    *                Graphic object to paint to
    * @model name="Paint_Display"
    */
   protected abstract void Paint_Display (
      javax.microedition.lcdui.Graphics graphics);

   /**
    * paint the online help on top of the calculator image.
    * 
    * @param graphics
    *                Graphic object to paint to
    * @model name="Paint_Help"
    */
   protected void Paint_Help (final javax.microedition.lcdui.Graphics graphics)
      {
      graphics.setFont (Canvas.Help_Font);

      for (int i = 0; i < Keyboard.length; i++)
         {
         final int Java_Key_Code = Keyboard [i].Get_Java_Keycode ();

         if (Java_Key_Code > 96)
            {
            graphics.setColor (Canvas.Help_Normal);
            graphics.drawString (
            /* str    => */String.valueOf ((char) Java_Key_Code),
            /* x      => */Keyboard [i].Get_X () - 2,
            /* y      => */Keyboard [i].Get_Y () - 10,
            /* anchor => */javax.microedition.lcdui.Graphics.TOP
               | javax.microedition.lcdui.Graphics.LEFT);
            }
         else if (Java_Key_Code > 32)
            {
            graphics.setColor (Canvas.Help_Shifted);
            graphics.drawString (
            /* str    => */String.valueOf ((char) Java_Key_Code),
            /* x      => */Keyboard [i].Get_X () - 2,
            /* y      => */Keyboard [i].Get_Y () - 10,
            /* anchor => */javax.microedition.lcdui.Graphics.TOP
               | javax.microedition.lcdui.Graphics.LEFT);
            }
         else if (Java_Key_Code != 0)
            {
            try
               {
               graphics.setColor (Canvas.Help_Special);
               graphics.drawString (
               /* str    => */getKeyName (Java_Key_Code),
               /* x      => */Keyboard [i].Get_X () - 2,
               /* y      => */Keyboard [i].Get_Y () - 10,
               /* anchor => */javax.microedition.lcdui.Graphics.TOP
                  | javax.microedition.lcdui.Graphics.LEFT);
               }
            catch (final IllegalArgumentException Exception)
               {
               //#ifdef DEBUG
               //# System.out.println ("Illegal Key: "
               //# + Integer.toString (Java_Key_Code));
               //# Exception.printStackTrace ();
               //#endif
               } // try
            } // if
         } // for
      return;
      } // Paint_Help

   /**
    * Paint the calculator status indicators
    * 
    * @param graphics
    *                Graphic object to paint to
    * @model name="Paint_Display"
    */
   protected abstract void Paint_Indicator (
      javax.microedition.lcdui.Graphics graphics);

   /**
    * paint highlight for the key pressed (if any).
    * 
    * @param graphics
    *                Graphic object to paint to
    * @model name="Paint_Key"
    */
   protected void Paint_Key (final javax.microedition.lcdui.Graphics graphics)
      {
      if (Pressed_Key != net.sourceforge.uiq3.calculator.ui.IKey.No_Key)
         {
         Keyboard [Pressed_Key].Highlight (graphics);
         } // if
      return;
      } // Paint_Key

   /**
    * the touch screen has been clicked
    * 
    * @param x
    *                X position of the click
    * @param y
    *                Y position of the click
    * @model name="Pointer_Pressed"
    */
   protected void pointerPressed (final int x, final int y)
      {
      //System.out.println ("+ Canvas.pointerPressed (" + Integer.toString (x) + ","
      //+ Integer.toString (y) + ")");

      Pressed_Key = net.sourceforge.uiq3.calculator.ui.IKey.No_Key;

      Search_Key: for (int i = 0; i < Keyboard.length; i++)
         {
         if (Keyboard [i].Is_Key_Hit (x, y))
            {
            Pressed_Key = i;
            Read_Key = i;
            break Search_Key;
            } // if
         } // for Search_Key
      synchronized (CPU_Thread)
         {
         CPU_Thread.interrupt ();
         } // synchronized
      this.repaint ();

      //System.out.println ("+ Canvas.pointerPressed ()");
      return;
      } // pointerPressed

   /**
    * the touch screen has been released
    * 
    * @param x
    *                X position of the click
    * @param y
    *                Y position of the click
    * @model name="Pointer_Released"
    */
   protected void pointerReleased (final int x, final int y)
      {
      Pressed_Key = net.sourceforge.uiq3.calculator.ui.IKey.No_Key;
      synchronized (CPU_Thread)
         {
         CPU_Thread.interrupt ();
         } // synchronized
      this.repaint ();

      return;
      } // pointerReleased

   /**
    * Set Image name and parameter
    * 
    * @param Theme_Line
    *                Line from theme file
    * @see net.sourceforge.uiq3.ui.Canvas#Create_Key(java.lang.String)
    * @model name="Create_Key"
    */
   protected abstract void Set_Image (String Theme_Line);
   } // Canvas

// vim: set nowrap tabstop=8 shiftwidth=3 softtabstop=3 expandtab :
// vim: set textwidth=0 filetype=java foldmethod=syntax nospell :