/*********************************************************** {{{1 ***********
 *  Copyright (C) 2005,2006  Martin Krischik (JavaME port)
 ****************************************************************************
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ****************************************************************************
 *  $Author: krischik $
 *
 *  $Revision: 461 $
 *  $Date: 2008-08-20 19:11:49 +0200 (Mi, 20 Aug 2008) $
 *
 *  $Id: Main.java 461 2008-08-20 17:11:49Z krischik $
 *  $HeadURL: https://uiq3.svn.sourceforge.net/svnroot/uiq3/tags/HP45-CLDC-2.0.1/Calculator-CLDC/src/net/sourceforge/uiq3/calculator/ui/Main.java $
 ************************************************************ }}}1 **********/

/**
 * @author "Martin Krischik" <krischik@users.sourceforge.net>
 * @model name="Calculator.UI"
 */
package net.sourceforge.uiq3.calculator.ui;

/**
 * @author "Martin Krischik" <krischik@users.sourceforge.net>
 * @model name="Main"
 */
public abstract class Main
   extends
      javax.microedition.midlet.MIDlet
   implements
      javax.microedition.lcdui.CommandListener,
      Runnable
   {
   /**
    * Exit command
    * 
    * @model name="Exit_Command"
    */
   private Thread Calculator_Thread;
   /**
    * Reset command
    * 
    * @model name="Reset_Command"
    */
   private javax.microedition.lcdui.Command Reset_Command = null;
   /**
    * Exit command
    * 
    * @model name="Exit_Command"
    */
   private javax.microedition.lcdui.Command Exit_Command = null;
   /**
    * Display on screen help
    * 
    * @model name="Help_Command"
    */
   private javax.microedition.lcdui.Command Help_Command = null;
   /**
    * Off command - stops the calculator without actually ending the program.
    * 
    * @model name="Off_Command"
    */
   private javax.microedition.lcdui.Command Off_Command = null;
   /**
    * Off command - restarts the calculator.
    * 
    * @model name="On_Command"
    */
   private javax.microedition.lcdui.Command On_Command = null;
   /**
    * Remember paused state
    * 
    * @model name="Paused"
    */
   private boolean Paused = true;
   /**
    * Calculator engine
    * 
    * @model name="Calculator"
    */
   protected net.sourceforge.uiq3.calculator.engine.ICalculator Calculator =
      null;
   /**
    * Canvas to display the Calculator in
    * 
    * @model name="Calculator_Canvas"
    */
   protected net.sourceforge.uiq3.calculator.ui.Canvas Form = null;

   /**
    * Show startup progress form
    * 
    * @model name="Startup_Progress"
    */
   protected javax.microedition.lcdui.Alert Startup_Progress = null;
   /**
    * Show startup progress gauge
    * 
    * @model name="Startup_Gauge"
    */
   protected javax.microedition.lcdui.Gauge Startup_Gauge = null;

   /**
    * Indicates that a command event has occurred on a Displayable.
    * 
    * @param Command
    *                command selected by user
    * @param Display
    *                object for which the command was selected
    * @model name="Command_Action"
    */
   public void commandAction (
      final javax.microedition.lcdui.Command Command,
      final javax.microedition.lcdui.Displayable Screen)
      {
      //System.out
      //.println ("+ Main.commandAction(" + Command.toString () + ")");

      if (Command == Exit_Command)
         {
         destroyApp (/* Unconditional => */true);
         notifyDestroyed ();
         }
      else if (Command == Help_Command)
         {
         Form.Toggle_Help ();
         }
      else if (Command == Reset_Command)
         {
         Calculator.Reset ();
         }
      else if (Command == Off_Command)
         {
         pauseApp ();
         notifyPaused ();
         }
      else if (Command == On_Command)
         {
         if (Paused)
            {
            resumeRequest ();
            }
         else
            {
            startApp ();
            } // if
         } // if

      //System.out.println ("- Main.commandAction()");
      return;
      } // commandAction

   /**
    * Signals the MIDlet to terminate and enter the Destroyed state.
    * 
    * @param Unconditional
    *                shutdown is mandantory
    * @model name="Destroy"
    */
   public void destroyApp (final boolean Unconditional)
      {
      //System.out.println ("+ Main.destroyApp()");

      if (Calculator.Is_Running ())
         {
         Calculator.stop ();
         try
            {
            Calculator_Thread.join ();
            }
         catch (final InterruptedException Exception)
            {
            //#ifdef DEBUG
            //# Exception.printStackTrace ();
            //#endif
            } // try
         } // if

      //System.out.println ("- Main.destroyApp()");
      return;
      } // destroyApp

   /**
    * Increment startup progress gauge by one
    * 
    * @model name="Startup_Gauge"
    */
   public void Increment_Progress ()
      {
      Startup_Gauge.setValue (Startup_Gauge.getValue () + 1);
      return;
      }

   /**
    * Signals the MIDlet to enter the Paused state.
    * 
    * @model name="Pause"
    */
   public void pauseApp ()
      {
      //System.out.println ("+ Main.pauseApp()");
      if (Calculator_Thread == null || Calculator.Is_Running ())
         {
         Calculator.stop ();
         } // if

      System.gc ();

      Paused = true;

      //System.out.println ("- Main.pauseApp()");
      return;
      } // pauseApp

   /**
    * Initialize system and run virtual calculator CPU
    * 
    * @model name="Run"
    */
   public void run ()
      {
      //System.out.println ("+ Main.run()");

      Startup_Gauge.setValue (10);
      //System.out.println ("> Create_Canvas: " + Startup_Gauge.getValue () +"%");
      if (Form == null)
         {
         try
            {
            Form = Create_Canvas ();
            Form.addCommand (On_Command);
            Form.addCommand (Off_Command);
            Form.addCommand (Reset_Command);
            Form.addCommand (Help_Command);
            Form.addCommand (Exit_Command);
            Form.setCommandListener (this);
            }
         catch (final java.io.IOException Exception)
            {
            //#ifdef DEBUG
            //# Exception.printStackTrace ();
            //#endif
            Fatal_Error ("Error reading Display Theme");
            } // try
         } // if

      Startup_Gauge.setValue (20);
      //System.out.println ("> Create_Calculator: " + Startup_Gauge.getValue () +"%");
      Form.Set_CPU_Thread (Calculator_Thread);
      if (Calculator == null)
         {
         try
            {
            Calculator = Create_Calculator ();

            Calculator.Reset ();
            }
         catch (final java.io.IOException Exception)
            {
            //#ifdef DEBUG
            //# Exception.printStackTrace ();
            //#endif
            Fatal_Error ("Error reading listing firmware file.");
            } // try
         } // if

      Startup_Gauge.setValue (30);
      //System.out.println ("> Calculator.run: " + Startup_Gauge.getValue () +"%");
      javax.microedition.lcdui.Display.getDisplay (this).setCurrent (Form);
      Calculator.run ();

      //System.out.println ("- Main.run()");
      return;
      } // run

   /**
    * Signals the MIDlet that it has entered the Active state.
    * 
    * @model name="Start"
    */
   public void startApp ()
      {
      //System.out.println ("+ Main.startApp()");

      //#ifdef DEBUG
      System.out.println ("Start mit DEBUG!");
      //#endif 

      if (Startup_Progress == null)
         {
         Startup_Progress =
            new javax.microedition.lcdui.Alert ("Start Calculator");
         Startup_Gauge = new javax.microedition.lcdui.Gauge (
         /* label        => */null,
         /* interactive  => */false,
         /* maxValue     => */30,
         /* initialValue => */0);
         Startup_Progress.setIndicator (Startup_Gauge);
         }

      javax.microedition.lcdui.Display.getDisplay (this).setCurrent (
         Startup_Progress);

      //System.out.println ("> On_Command: " + Startup_Gauge.getValue () +"%");
      if (On_Command == null)
         {
         On_Command = new javax.microedition.lcdui.Command (
         /* shortLabel  => */"On",
         /* longLabel   => */"Switch On",
         /* commandType => */
         javax.microedition.lcdui.Command.OK,
         /* priority    => */1);
         } // if

      Increment_Progress ();
      //System.out.println ("> Off_Command: " + Startup_Gauge.getValue () +"%");
      if (Off_Command == null)
         {
         Off_Command = new javax.microedition.lcdui.Command (
         /* shortLabel  => */"Off",
         /* longLabel   => */"Switch Off",
         /* commandType => */
         javax.microedition.lcdui.Command.STOP,
         /* priority    => */2);
         } // if    

      Increment_Progress ();
      //System.out.println ("> Reset_Command: " + Startup_Gauge.getValue () +"%");
      if (Reset_Command == null)
         {
         Reset_Command = new javax.microedition.lcdui.Command (
         /* shortLabel  => */"Reset",
         /* longLabel   => */"Reset Calculator",
         /* commandType => */
         javax.microedition.lcdui.Command.CANCEL,
         /* priority    => */3);
         } // if

      Increment_Progress ();
      //System.out.println ("> Help_Command: " + Startup_Gauge.getValue () +"%");
      if (Help_Command == null)
         {
         Help_Command = new javax.microedition.lcdui.Command (
         /* shortLabel  => */"Help",
         /* longLabel   => */"Keyboard Help",
         /* commandType => */
         javax.microedition.lcdui.Command.HELP,
         /* priority    => */4);
         } // if

      Increment_Progress ();
      //System.out.println ("> Exit_Command: " + Startup_Gauge.getValue () +"%");
      if (Exit_Command == null)
         {
         Exit_Command = new javax.microedition.lcdui.Command (
         /* shortLabel  => */"Exit",
         /* longLabel   => */"Exit Programm",
         /* commandType => */
         javax.microedition.lcdui.Command.EXIT,
         /* priority    => */5);
         } // if

      Increment_Progress ();
      //System.out.println ("> Calculator_Thread: " + Startup_Gauge.getValue () +"%");
      if (Calculator_Thread == null || !Calculator.Is_Running ())
         {
         Calculator_Thread = new Thread (this);
         Calculator_Thread.start ();
         } // if

      Paused = false;

      //System.out.println ("- Main.startApp()\n");
      return;
      } // startApp

   /**
    * Create Calculator engine.
    * 
    * @param Form
    *                Canvas to display the calculator in.
    * @model name="Create_Calculator"
    */
   protected abstract net.sourceforge.uiq3.calculator.engine.ICalculator Create_Calculator ()
      throws java.io.IOException;

   /**
    * Create Calculator display.
    * 
    * @model name="Create_Canvas"
    */
   protected abstract net.sourceforge.uiq3.calculator.ui.Canvas Create_Canvas ()
      throws java.io.IOException;

   /**
    * Print Error message Stop Calculator and exit program.
    * 
    * @param Message
    *                Message to be displayed
    * @model name="Exit_Command"
    */
   protected void Fatal_Error (final String Message)
      {
      //System.out.println ("+ Main.Fatal_Error (" + Message + ")");

      //#ifdef DEBUG
      //# System.out.println ("fatal error: " + Message);
      //#endif

      final javax.microedition.lcdui.TextBox Display_Error =
         new javax.microedition.lcdui.TextBox (
         /* title       => */"Fatal error!",
         /* text        => */Message,
         /* maxSize     => */1024,
         /* constraints => */javax.microedition.lcdui.TextField.ANY);
      javax.microedition.lcdui.Display.getDisplay (this).setCurrent (
         Display_Error);

      // notifyDestroyed ();

      //System.out.println ("- Main.Fatal_Error ()");
      return;
      } // Fatal_Error
   } // Main

// vim: set nowrap tabstop=8 shiftwidth=3 softtabstop=3 expandtab :
// vim: set textwidth=0 filetype=java foldmethod=marker nospell :