/*********************************************************** {{{1 ***********
 * Copyright (C) 2005,2006  Martin Krischik (JavaME port)
 ****************************************************************************
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 ****************************************************************************
 *  $Author: krischik $
 *
 *  $Revision: 295 $
 *  $Date: 2008-05-05 20:31:59 +0200 (Mo, 05 Mai 2008) $
 *
 *  $Id: ICalculator.java 295 2008-05-05 18:31:59Z krischik $
 *  $HeadURL: https://uiq3.svn.sourceforge.net/svnroot/uiq3/tags/HP45-CLDC-2.0.1/Calculator/src/net/sourceforge/uiq3/calculator/engine/ICalculator.java $
 ************************************************************ }}}1 **********/

/**
 * @author "Martin Krischik" <krischik@users.sourceforge.net>
 * @model name="Uiq3.Calculator.Engine"
 */
package net.sourceforge.uiq3.calculator.engine;

/**
 * Public calculator interface
 * 
 * @author "Martin Krischik" <krischik@users.sourceforge.net>
 * @model name="ICalculator"
 */
public interface ICalculator
   {
   /**
    * @return true when calculator is running.
    * @model
    */
   public abstract boolean Is_Running ();

   /**
    * Reset the calculator
    * 
    * @model name="Reset"
    */
   public abstract void Reset ();

   /**
    * Start virtual CPU
    * 
    * @model name="Start"
    */
   public abstract void run ();

   /**
    * Stop virtual CPU
    * 
    * @model name="Stop"
    */
   public abstract void stop ();

   } // ICalculator

//vim: set nowrap tabstop=8 shiftwidth=4 softtabstop=4 expandtab :
//vim: set textwidth=0 filetype=java foldmethod=syntax nospell :
