/*********************************************************** {{{1 ***********
 *  Copyright (C) 2005,2006  Martin Krischik (JavaME port)
 ****************************************************************************
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ****************************************************************************
 *  $Author: krischik $
 *
 *  $Revision: 295 $
 *  $Date: 2008-05-05 20:31:59 +0200 (Mo, 05 Mai 2008) $
 *
 *  $Id: ICanvas.java 295 2008-05-05 18:31:59Z krischik $
 *  $HeadURL: https://uiq3.svn.sourceforge.net/svnroot/uiq3/tags/HP45-CLDC-2.0.1/Calculator/src/net/sourceforge/uiq3/calculator/ui/ICanvas.java $
 ************************************************************ }}}1 **********/

/**
 * @author "Martin Krischik" <krischik@users.sourceforge.net>
 * @model name="Uiq3.Calculator.UI"
 */
package net.sourceforge.uiq3.calculator.ui;

/**
 * Interface for a display canvas for the calculator
 * 
 * @author "Martin Krischik" <krischik@users.sourceforge.net>
 */
public interface ICanvas
   {
   /**
    * Get calculator key code of the last key (de)pressed.
    * 
    * @return calculator key code
    * @model name="Get_Key"
    */
   public abstract int Get_Keycode ();

   /**
    * Set the indicators (Shift, Alpha, Deg, Grad, Gra, etc. pp.)
    * 
    * @param Indicators
    *                indicators to be shown
    * @model name="Set_Indicators"
    */
   public abstract void Set_Indicators (final boolean [] Indicators);

   /**
    * Set text to be displayed (calculator alpha codes). Null implementation for
    * calculators without alpha display.
    * 
    * @param Text
    *                to be displayed
    * @model name="Set_Text"
    */
   public abstract void Set_Text (final short [] Text);

   /**
    * Set text to be displayed (java string).
    * 
    * @param Text
    *                to be displayed
    * @model name="Set_Text"
    */
   public abstract void Set_Text (final String Text);

   /**
    * Toggle Keyboard help on and off
    * 
    * @model name="Toggle_Help"
    */
   public abstract void Toggle_Help ();

   } // ICanvas

//vim: set nowrap tabstop=8 shiftwidth=4 softtabstop=4 expandtab :
//vim: set textwidth=0 filetype=java foldmethod=syntax nospell :
