/*********************************************************** {{{1 ***********
 *  Copyright (C) 2005,2006  Martin Krischik (JavaME port)
 *  Copyright 2000 David G. Hicks            (Java port)
 *  Copyright 1995 Eric L. Smith             (Original C/X Windows)
 ****************************************************************************
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ****************************************************************************
 *  $Author: krischik $
 *
 *  $Revision: 433 $
 *  $Date: 2008-07-27 10:28:15 +0200 (So, 27 Jul 2008) $
 *
 *  $Id: op_c_to_data.java 433 2008-07-27 08:28:15Z krischik $
 *  $HeadURL: https://uiq3.svn.sourceforge.net/svnroot/uiq3/tags/HP45-CLDC-2.0.1/HP45/src/net/sourceforge/uiq3/hp45/op_c_to_data.java $
 ************************************************************ }}}1 **********/

/**
 * @author "Martin Krischik" <krischik@users.sourceforge.net>
 * @model name="Uiq3.HP45"
 */
package net.sourceforge.uiq3.hp45;

/**
 * @model
 */
final class op_c_to_data
   implements
      net.sourceforge.uiq3.calculator.engine.IOperation
   {
   /**
    * @model name="Owner"
    */
   private final Calculator Owner;

   /**
    * @param calculator
    * @model name="op_c_to_data"
    */
   op_c_to_data (final Calculator calculator)
      {
      Owner = calculator;
      }

   /**
    * @model
    */
   public void Execute (final short opcode)
      {
      int i;
      if (Owner.ram_addr >= Calculator.Max_Ram)
         {
         //#ifdef DEBUG
         //# System.out.println ("Coefficient -> data: address " + Owner.ram_addr
         //# + " out of range\n");
         //#endif
         return;
         } // if
      for (i = 0; i < Calculator.Word_Size; i++)
         {
         Owner.ram [Owner.ram_addr] [i] = Owner.c [i];
         } // for
      return;
      } // Execute
   }
//vim: set nowrap tabstop=8 shiftwidth=3 softtabstop=3 expandtab :
//vim: set textwidth=0 filetype=java foldmethod=marker nospell :
