/*********************************************************** {{{1 ***********
 *  Copyright (C) 2005,2006  Martin Krischik (JavaME port)
 *  Copyright 2000 David G. Hicks            (Java port)
 *  Copyright 1995 Eric L. Smith             (Original C/X Windows)
 ****************************************************************************
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ****************************************************************************
 *  $Author: krischik $
 *
 *  $Revision: 128 $
 *  $Date: 2008-03-06 19:07:13 +0100 (Do, 06 Mrz 2008) $
 *
 *  $Id: Main.java 128 2008-03-06 18:07:13Z krischik $
 *  $HeadURL: https://uiq3.svn.sourceforge.net/svnroot/uiq3/trunk/JavaME/HP45-CLDC/src/net/sourceforge/uiq3/hp45/Main.java $
 ************************************************************ }}}1 **********/

/**
 * @author "Martin Krischik" <krischik@users.sourceforge.net>
 * @model name="Uiq3.HP45"
 */
package net.sourceforge.uiq3.hp45;

import java.io.IOException;

/**
 * @author "Martin Krischik" <krischik@users.sourceforge.net>
 * @model name="CLDC_Calculator"
 */
public class CLDC_Calculator
   extends
      Calculator
   {
   /**
    * Name des record store
    */
   public static final String Record_Store_Name = "HP45";

   /**
    * @model name="CLDC_Calculator"
    */
   public CLDC_Calculator ()
      {
      super ();

      return;
      } // CLDC_Calculator

   /**
    * @see net.sourceforge.uiq3.hp45.Calculator#Load()
    * @model name="Load"
    */
   protected void Load ()
      {
      //System.out.println ("+ CLDC_Calculator.Load ()");

      Form.Set_Text ("Load status...");

      javax.microedition.rms.RecordStore Record_Store = null;
      java.io.ByteArrayInputStream Byte_In = null;
      java.io.DataInputStream Data_In = null;

      try
         {
         Record_Store = javax.microedition.rms.RecordStore.openRecordStore (
         /* recordStoreName       => */CLDC_Calculator.Record_Store_Name,
         /* createIfNecessary     => */false);

         final byte [] Data = Record_Store.getRecord (1);

         Byte_In = new java.io.ByteArrayInputStream (Data);
         Data_In = new java.io.DataInputStream (Byte_In);

         Display_Enable = Data_In.readBoolean ();
         Key_Flag = Data_In.readBoolean ();
         Programm_Counter = Data_In.readInt ();
         Programm_Rom = Data_In.readInt ();
         Programm_Group = Data_In.readInt ();
         Return_Programm_Counter = Data_In.readInt ();

         del_rom = Data_In.readInt ();
         del_grp = Data_In.readInt ();
         Data_In.read (a);
         Data_In.read (b);
         Data_In.read (c);
         Data_In.read (d);
         Data_In.read (e);
         Data_In.read (f);
         Data_In.read (m);
         Data_In.read (s);
         ram_addr = Data_In.readInt ();

         for (int i = 0; i < Calculator.Max_Ram; i++)
            {
            Data_In.read (ram [i]);
            } // for

         p = Data_In.readInt ();
         carry = Data_In.readByte ();
         Previous_Carry = Data_In.readByte ();
         IO_Count = Data_In.readInt ();

         Data_In.close ();
         Byte_In.close ();
         }
      catch (final javax.microedition.rms.RecordStoreFullException Exception)
         {
         //#ifdef DEBUG
         Exception.printStackTrace ();
         //#endif 
         }
      catch (final javax.microedition.rms.RecordStoreNotFoundException Exception)
         {
         //#ifdef DEBUG
         Exception.printStackTrace ();
         //#endif 
         }
      catch (final javax.microedition.rms.RecordStoreException Exception)
         {
         //#ifdef DEBUG
         Exception.printStackTrace ();
         //#endif 
         }
      catch (final java.io.IOException Exception)
         {
         //#ifdef DEBUG
         Exception.printStackTrace ();
         //#endif 
         }
      finally
         {
         try
            {
            if (Data_In != null)
               {
               Data_In.close ();
               } // if
            if (Byte_In != null)
               {
               Byte_In.close ();
               } // if
            if (Record_Store != null)
               {
               Record_Store.closeRecordStore ();
               } // if
            }
         catch (final javax.microedition.rms.RecordStoreNotOpenException Exception)
            {
            //#ifdef DEBUG
            Exception.printStackTrace ();
            //#endif 
            }
         catch (final javax.microedition.rms.RecordStoreException Exception)
            {
            //#ifdef DEBUG
            Exception.printStackTrace ();
            //#endif 
            }
         catch (final IOException Exception)
            {
            //#ifdef DEBUG
            Exception.printStackTrace ();
            //#endif 
            } // try
         } //  try

      //System.out.println ("- CLDC_Calculator.Load ()");
      return;
      } // Load

   /**
    * @see net.sourceforge.uiq3.hp45.Calculator#Save()
    * @model name="Save"
    */
   protected void Save ()
      {
      //System.out.println ("+ CLDC_Calculator.Save ()");

      Form.Set_Text ("Save status...");

      javax.microedition.rms.RecordStore Record_Store = null;
      java.io.ByteArrayOutputStream Byte_Out = null;
      java.io.DataOutputStream Data_Out = null;

      try
         {
         javax.microedition.rms.RecordStore
            .deleteRecordStore (CLDC_Calculator.Record_Store_Name);
         }
      catch (final javax.microedition.rms.RecordStoreNotFoundException Exception)
         {
         //#ifdef DEBUG
         Exception.printStackTrace ();
         //#endif 
         }
      catch (final javax.microedition.rms.RecordStoreException Exception)
         {
         //#ifdef DEBUG
         Exception.printStackTrace ();
         //#endif 
         } // try

      try
         {
         Byte_Out = new java.io.ByteArrayOutputStream ();
         Data_Out = new java.io.DataOutputStream (Byte_Out);

         Data_Out.writeBoolean (Display_Enable);
         Data_Out.writeBoolean (Key_Flag);
         Data_Out.writeInt (Programm_Counter);
         Data_Out.writeInt (Programm_Rom);
         Data_Out.writeInt (Programm_Group);
         Data_Out.writeInt (Return_Programm_Counter);

         Data_Out.writeInt (del_rom);
         Data_Out.writeInt (del_grp);
         Data_Out.write (a);
         Data_Out.write (b);
         Data_Out.write (c);
         Data_Out.write (d);
         Data_Out.write (e);
         Data_Out.write (f);
         Data_Out.write (m);
         Data_Out.write (s);
         Data_Out.writeInt (ram_addr);

         for (int i = 0; i < Calculator.Max_Ram; i++)
            {
            Data_Out.write (ram [i]);
            } // for

         Data_Out.writeInt (p);
         Data_Out.writeByte (carry);
         Data_Out.writeByte (Previous_Carry);
         Data_Out.writeInt (IO_Count);

         final byte [] Data = Byte_Out.toByteArray ();

         Record_Store = javax.microedition.rms.RecordStore.openRecordStore (
         /* recordStoreName       => */CLDC_Calculator.Record_Store_Name,
         /* createIfNecessary     => */true);

         Record_Store.addRecord (
         /* data     => */Data,
         /* offset   => */0,
         /* numBytes => */Data.length);
         }
      catch (final javax.microedition.rms.RecordStoreFullException Exception)
         {
         //#ifdef DEBUG
         Exception.printStackTrace ();
         //#endif 
         }
      catch (final javax.microedition.rms.RecordStoreNotFoundException Exception)
         {
         //#ifdef DEBUG
         Exception.printStackTrace ();
         //#endif 
         }
      catch (final javax.microedition.rms.RecordStoreException Exception)
         {
         //#ifdef DEBUG
         Exception.printStackTrace ();
         //#endif 
         }
      catch (final java.io.IOException Exception)
         {
         //#ifdef DEBUG
         Exception.printStackTrace ();
         //#endif 
         }
      finally
         {
         try
            {
            if (Data_Out != null)
               {
               Data_Out.close ();
               } // if
            if (Byte_Out != null)
               {
               Byte_Out.close ();
               } // if
            if (Record_Store != null)
               {
               Record_Store.closeRecordStore ();
               } // if
            }
         catch (final javax.microedition.rms.RecordStoreNotOpenException Exception)
            {
            //#ifdef DEBUG
            Exception.printStackTrace ();
            //#endif 
            }
         catch (final javax.microedition.rms.RecordStoreException Exception)
            {
            //#ifdef DEBUG
            Exception.printStackTrace ();
            //#endif 
            }
         catch (final IOException Exception)
            {
            //#ifdef DEBUG
            Exception.printStackTrace ();
            //#endif 
            } // try
         } //  try

      //System.out.println ("- CLDC_Calculator.Save ()");
      return;
      } // Save
   } // CLDC_Calculator

//vim: set nowrap tabstop=8 shiftwidth=3 softtabstop=3 expandtab :
//vim: set textwidth=0 filetype=java foldmethod=marker nospell :
