/*********************************************************** {{{1 ***********
 *  Copyright (C) 2005,2006  Martin Krischik (JavaME port)
 *  Copyright 2000 David G. Hicks            (Java port)
 *  Copyright 1995 Eric L. Smith             (Original C/X Windows)
 ****************************************************************************
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ****************************************************************************
 *  $Author: krischik $
 *
 *  $Revision: 436 $
 *  $Date: 2008-08-11 20:24:06 +0200 (Mo, 11 Aug 2008) $
 *
 *  $Id: Canvas.java 436 2008-08-11 18:24:06Z krischik $
 *  $HeadURL: https://uiq3.svn.sourceforge.net/svnroot/uiq3/tags/HP45-CLDC-2.0.1/src/net/sourceforge/uiq3/hp45/Canvas.java $
 ************************************************************ }}}1 **********/

/**
 * @author "Martin Krischik" <krischik@users.sourceforge.net>
 * @model name="Uiq3.HP45"
 */
package net.sourceforge.uiq3.hp45;

/**
 * An display canvas for an HP45
 * 
 * @author Martin Krischik
 * @model name="Canvas"
 */
public final class Canvas
   extends
      net.sourceforge.uiq3.calculator.ui.Canvas
   {
   /**
    * Background colour used for displaying results.
    * 
    * @model name="Display_Background"
    */
   private static final int Display_Background = 0x00500000;
   /**
    * Font used for displaying results.
    * 
    * @model name="Display_Font"
    */
   private static final javax.microedition.lcdui.Font Display_Font =
      javax.microedition.lcdui.Font.getFont (
      /* face  => */javax.microedition.lcdui.Font.FACE_MONOSPACE,
      /* style => */javax.microedition.lcdui.Font.STYLE_PLAIN,
      /* size  => */javax.microedition.lcdui.Font.SIZE_LARGE);
   /**
    * Colour used for displaying results.
    * 
    * @model name="Display_Foreground"
    */
   private static final int Display_Foreground = 0x00ff4000;
   /**
    * Background image
    * 
    * @model name="Background"
    */
   private javax.microedition.lcdui.Image Background = null;

   /**
    * Create an new canvas
    * 
    * @model name="Canvas"
    */
   public Canvas ()
      {
      super ();
      //System.out.println ("+ Canvas.Canvas ()");

      Keys_Count = 35;

      //System.out.println ("- Canvas.Canvas ()");
      return;
      } // Canvas

   /**
    * Set the indicators (Shift, Alpha,
    * 
    * @param Indicators
    *                indicators to be shown
    * @see net.sourceforge.uiq3.calculator.ui.ICanvas#Set_Indicators(boolean[])
    * @model name="Set_Indicators"
    */
   public void Set_Indicators (final boolean [] Indicators)
      {
      // No indicators on HP45
      return;
      } //Set_Indicators

   /**
    * Set text to be displayed (calculator alpha codes).
    * 
    * @param Text
    *                to be displayed
    * @see net.sourceforge.uiq3.calculator.ui.ICanvas#Set_Text(short[])
    * @model name="Set_Text"
    */
   public void Set_Text (final short [] Text)
      {
      //System.out.println ("+ Canvas.Set_Text ("+ Text + ")");

      throw new java.lang.RuntimeException ("No alpha display avaiable!");

      //System.out.println ("- Canvas.Set_Text ()");
      } // Set_Text

   /**
    * Create new Key from an line read from the theme file
    * 
    * @see net.sourceforge.uiq3.ui.Canvas#Create_Key(java.lang.String)
    * @model name="Create_Key"
    */
   protected net.sourceforge.uiq3.calculator.ui.Key Create_Key (
      final String Theme_Line)
      {
      final int x = Integer.parseInt (Theme_Line.substring (0, 3), 10);
      final int y = Integer.parseInt (Theme_Line.substring (4, 7), 10);
      final int Width = Integer.parseInt (Theme_Line.substring (8, 11), 10);
      final int Height = Integer.parseInt (Theme_Line.substring (12, 15), 10);
      final int Size = Integer.parseInt (Theme_Line.substring (16, 19), 10);
      final int Calc_Key_Code =
         Integer.parseInt (Theme_Line.substring (20, 23), 8);
      final int Java_Key_Code =
         Integer.parseInt (Theme_Line.substring (24, 27), 10);

      return new Key (
      /*x                  =>*/x,
      /*y                  =>*/y,
      /*Width              =>*/Width,
      /*Height             =>*/Height,
      /*Size               =>*/Size,
      /*Calculator_Key_Code=>*/Calc_Key_Code,
      /*Java_Key_Code      =>*/Java_Key_Code);
      } // Create_Key

   /**
    * Paint the background image of our calculator
    * 
    * @param graphics
    *                Graphic object to paint to
    * @model name="Paint_Background"
    */
   protected void Paint_Background (
      final javax.microedition.lcdui.Graphics graphics)
      {
      if (Images_Names != null)
         {
         Background =
            net.sourceforge.uiq3.calculator.ui.Utils.drawImage (
            /* graphics  => */graphics,
            /*  Image    => */Background,
            /* File_Name => */"/45-" + Images_Names + ".png",
            /* x         => */0,
            /* y         => */0,
            /* anchor    => */javax.microedition.lcdui.Graphics.TOP
               | javax.microedition.lcdui.Graphics.LEFT);
         }
      return;
      } // Paint_Background

   /**
    * Paint the calculator result display
    * 
    * @param graphics
    *                Graphic object to paint to
    * @model name="Paint_Display"
    */
   protected void Paint_Display (
      final javax.microedition.lcdui.Graphics graphics)
      {
      graphics.setColor (Canvas.Display_Background);
      graphics.fillRect (
      /* x      => */8,
      /* y      => */10,
      /* width  => */228,
      /* height => */24);
      graphics.setFont (Canvas.Display_Font);
      graphics.setColor (Canvas.Display_Foreground);
      graphics.drawString (
      /* str    => */Utf16_Text,
      /* x      => */14,
      /* y      => */12,
      /* anchor => */javax.microedition.lcdui.Graphics.TOP
         | javax.microedition.lcdui.Graphics.LEFT);
      return;
      } // Paint_Display

   /**
    * Paint the calculator status indicators
    * 
    * @param graphics
    *                Graphic object to paint to
    * @see net.sourceforge.uiq3.calculator.ui.ICanvas#Paint_Indicator()
    * @model name="Paint_Display"
    */
   protected void Paint_Indicator (
      final javax.microedition.lcdui.Graphics graphics)
      {
      // No indicators on HP45
      return;
      } // Paint_Indicator

   /**
    * Set Image name and parameter
    * 
    * @param Theme_Line
    *                Line from theme file
    * @see net.sourceforge.uiq3.ui.Canvas#Create_Key(java.lang.String)
    * @model name="Create_Key"
    */
   protected void Set_Image (final String Theme_Line)
      {
      //System.out.println ("+ Calculator_Canvas.Set_Image (" + Theme_Line
      //+ ")");

      Images_Names = Theme_Line.trim ();

      //System.out.println ("- Calculator_Canvas.Set_Image ()");
      return;
      } // Set_Image
   } // Canvas

// vim: set nowrap tabstop=8 shiftwidth=3 softtabstop=3 expandtab :
// vim: set textwidth=0 filetype=java foldmethod=syntax nospell :
