/*********************************************************** {{{1 ***********
 *  Copyright (C) 2005,2006  Martin Krischik (JavaME port)
 *  Copyright 2000 David G. Hicks            (Java port)
 *  Copyright 1995 Eric L. Smith             (Original C/X Windows)
 ****************************************************************************
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ****************************************************************************
 *  $Author: krischik $
 *
 *  $Revision: 441 $
 *  $Date: 2008-08-14 18:29:42 +0200 (Do, 14 Aug 2008) $
 *
 *  $Id: Key.java 441 2008-08-14 16:29:42Z krischik $
 *  $HeadURL: https://uiq3.svn.sourceforge.net/svnroot/uiq3/tags/HP45-CLDC-2.0.1/src/net/sourceforge/uiq3/hp45/Key.java $
 ************************************************************ }}}1 **********/

/**
 * @author "Martin Krischik" <krischik@users.sourceforge.net>
 * @model name="Uiq3.HP5"
 */
package net.sourceforge.uiq3.hp45;

/**
 * HP 45 Keyboard
 * 
 * @author "Martin Krischik" <krischik@users.sourceforge.net>
 * @model name="Key"
 */
public final class Key
   extends
      net.sourceforge.uiq3.calculator.ui.Key
   {
   /**
    * 4 images to highlight an key
    * 
    * @model name="Highlight_Image"
    */
   private static final javax.microedition.lcdui.Image highlightImage[] =
      new javax.microedition.lcdui.Image [4];

   /**
    * @param x
    *                X of the Key on the on screen display.
    * @param y
    *                Y of the Key on the on screen display.
    * @param Size
    *                Size (0 .. 3) of the key
    * @param Calculator_Key_Code
    *                Key Code used inside the Calculator.
    * @param Java_Key_Code
    *                Key Code used inside Java.
    * @model name="Key"
    */
   public Key (
      final int x,
      final int y,
      final int Width,
      final int Height,
      final int Size,
      final int Calculator_Key_Code,
      final int Java_Key_Code)
      {
      super (
      /* x                   => */x,
      /* y                   => */y,
      /* Width               => */Width,
      /* Height              => */Height,
      /* Size           => */Size,
      /* Calculator_Key_Code => */Calculator_Key_Code,
      /* Java_Key_Code       => */Java_Key_Code);

      return;
      }

   /**
    * Draw highlight for key
    * 
    * @model name="Highlight"
    */
   public void Highlight (final javax.microedition.lcdui.Graphics graphics)
      {
      if (Key.highlightImage [Type] == null)
         {
         try
            {
            Key.highlightImage [Type] =
               javax.microedition.lcdui.Image.createImage ("/highlight-"
                  + net.sourceforge.uiq3.calculator.ui.Key.Images_Names + "-"
                  + Integer.toString (Type) + ".png");
            }
         catch (final java.io.IOException Exception)
            {
            //#ifdef DEBUG
            Exception.printStackTrace ();
            //#endif
            } // try
         } // if
      graphics.drawImage (
      /* img    => */Key.highlightImage [Type],
      /* x      => */x,
      /* y      => */y,
      /* anchor => */javax.microedition.lcdui.Graphics.TOP
         | javax.microedition.lcdui.Graphics.LEFT);

      return;
      } // Highlight

   /**
    * Does a click on x,y hits this key? This overloaded version allows of an
    * extra of 5 pixel around each key.
    * 
    * @param x
    *                X position which was clicked
    * @param y
    *                Y position which was clicked
    * @return true when the key was hit.
    * @see net.sourceforge.uiq3.calculator.ui.IKey
    * @model name="Is_Key_Hit"
    */
   public boolean Is_Key_Hit (final int x, final int y)
      {
      return ((x >= this.x - 5) && (x < (this.x + Width + 5))
         && (y >= this.y - 5) && (y < (this.y + Height + 5)));
      } // Is_Key_Hit
   } // Key

//vim: set nowrap tabstop=8 shiftwidth=4 softtabstop=4 expandtab :
//vim: set textwidth=0 filetype=java foldmethod=syntax nospell :
