/*********************************************************** {{{1 ***********
 *  Copyright (C) 2005,2006  Martin Krischik (JavaME port)
 *  Copyright 2000 David G. Hicks            (Java port)
 *  Copyright 1995 Eric L. Smith             (Original C/X Windows)
 ****************************************************************************
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ****************************************************************************
 *  $Author: krischik $
 *
 *  $Revision: 461 $
 *  $Date: 2008-08-20 19:11:49 +0200 (Mi, 20 Aug 2008) $
 *
 *  $Id: Main.java 461 2008-08-20 17:11:49Z krischik $
 *  $HeadURL: https://uiq3.svn.sourceforge.net/svnroot/uiq3/tags/HP45-CLDC-2.0.1/src/net/sourceforge/uiq3/hp45/Main.java $
 ************************************************************ }}}1 **********/

/**
 * @author "Martin Krischik" <krischik@users.sourceforge.net>
 * @model name="Uiq3.HP5"
 */
package net.sourceforge.uiq3.hp45;

/**
 * @author "Martin Krischik" <krischik@users.sourceforge.net>
 * @model name="Main"
 */
public final class Main
   extends
      net.sourceforge.uiq3.calculator.ui.Main
   {
   /**
    * Create Calculator engine.
    * 
    * @model name="Create_Calculator"
    */
   protected net.sourceforge.uiq3.calculator.engine.ICalculator Create_Calculator ()
      throws java.io.IOException
      {
      //System.out.println ("+ Main.Create_Calculator ()");

      final Calculator Retval = new CLDC_Calculator ();
      Retval.Set_Form (Form);
      Increment_Progress ();
      Retval.Read_Listing_File ("/hp45.lst");
      Increment_Progress ();
      Retval.Init_Opcodes ();
      Increment_Progress ();

      //System.out.println ("- Main.Create_Calculator ()");
      return Retval;
      } // Create_Calculator

   /**
    * Create Calculator display.
    * 
    * @model name="Create_Canvas"
    */
   protected net.sourceforge.uiq3.calculator.ui.Canvas Create_Canvas ()
      throws java.io.IOException
      {
      //System.out.println ("+ Main.Create_Canvas ()");

      final net.sourceforge.uiq3.hp45.Canvas Retval =
         new net.sourceforge.uiq3.hp45.Canvas ();
      Increment_Progress ();
      Retval.setFullScreenMode (true);
      Increment_Progress ();
      Retval.Read_Display_Theme ();
      Increment_Progress ();

      //System.out.println ("- Main.Create_Canvas ()");

      return Retval;
      } // Create_Canvas
   } // Main

// vim: set nowrap tabstop=8 shiftwidth=3 softtabstop=3 expandtab :
// vim: set textwidth=0 filetype=java foldmethod=marker nospell :
