/*
 *   external.c
 *
 *   This file is part of Emu48
 *
 *   Copyright (C) 1995 Sebastien Carlier
 *
 */
#include "pch.h"
#include "Emu48.h"

// 02.02.98 cg, new, memory address for flags -53 to -56
#define SFLAG53_56	((cCurrentRomType=='S')?0x706D2:0x80850)

static __inline VOID Return(CHIPSET* w)
{
	w->rstkp=(w->rstkp-1)&7;
	w->pc = w->rstk[w->rstkp];
	w->rstk[w->rstkp] = 0;
	return;
}

VOID External(CHIPSET* w)
{
	if (w->pc==0x017A6) // Beep
	{
		// begin with patch
		// 02.02.98 cg, changed for better emulation
		BYTE  fbeep;
		DWORD freq,dur;

		freq = Npack(w->D,5);				// frequency in Hz
		dur = Npack(w->C,5);				// duration in ms
		Nread(&fbeep,SFLAG53_56,1);			// fetch system flags -53 to -56

		w->carry = TRUE;					// 22.07.98 cg, setting of no beep
		if (!(fbeep & 0x8) && freq)			// bit -56 clear and frequency > 0 Hz
		{
			if (freq < 37)   freq = 37;		// low limit of freqency (NT)
			if (freq > 4400) freq = 4400;	// 22.07.98 cg, high limit of HP (SX)

			if (dur > 1048575)				// 22.07.98 cg, high limit of HP (SX)
				dur = 1048575;

			Beep(freq,dur);					// NT: ok, Windows 95: default sound or standard system beep

			// 22.07.98 cg, estimate cpu cycles for beeping time (2MHz / 4MHz)
			w->cycles += dur * ((cCurrentRomType=='S') ? 2000 : 4000);           

			// original routine return with...
			w->P = 0;						// 22.07.98 cg, P=0
			w->intk = TRUE;					// 22.07.98 cg, INTON
			w->carry = FALSE;				// 22.07.98 cg, RTNCC
		}
		// MessageBeep(0xFFFFFFFF);			// original, replaced
		// continue with original part

		//Beep(600,50);
		Return(w);
		return;
	}
	w->pc +=4;
	return;
}
