/*
 *   Serial.h
 *
 *   This file is part of Emu48
 *
 *   Copyright (C) 1998 Christoph Gieelink
 *
 */

// UART addresses without mapping offset
#define BAUD		0x0d					// Baudrate (Bit 2-0)
#define IO_CTRL		0x10					// IO CONTROL
#define RCS			0x11					// RCS
#define TCS			0x12					// TCS
#define CRER		0x13					// CRER
#define RBR_LSB		0x14					// RBR low nibble
#define RBR_MSB		0x15					// RBR high nibble
#define TBR_LSB		0x16					// TBR low nibble
#define TBR_MSB		0x17					// TBR high nibble
#define IR_CTRL		0x1a					// IR CONTROL

// 0x10 Serial I/O Control [SON ETBE ERBF ERBZ]
#define SON			0x08					// Serial on
#define ETBE		0x04					// Interrupt on transmit buffer empty
#define ERBF		0x02					// Interrupt on receive buffer full
#define ERBZ		0x01					// Interrupt on receiver busy

// 0x11 Serial Receive Control/Status [RX RER RBZ RBF]
#define RX			0x08					// ??? Rx pin high (read-only)
#define RER			0x04					// Receiver error
#define RBZ			0x02					// Receiver busy
#define RBF			0x01					// Receive buffer full

// 0x12 Serial Transmit Control/Status [BRK LPB TBZ TBF]
#define BRK			0x08
#define LPB			0x04
#define TBZ			0x02					// Transmitter busy
#define TBF			0x01					// Transmit buffer full

// 0x1a IR Control Register [IRI EIRU EIRI IRE]
#define IRI			0x08					// IR input (read-only)
#define EIRU		0x04					// Enable IR UART mode
#define EIRI		0x02					// Enable IR interrupt
#define IRE			0x01					// IR event
