/*
 *   types.h
 *
 *   This file is part of Emu48
 *
 *   Copyright (C) 1995 Sebastien Carlier
 *
 */

#define CHIPSET Chipset_t
typedef struct
{
	WORD	wPosX;
	WORD	wPosY;
	BYTE	type;

	DWORD	Port0Size;						// real size of module im KB
	DWORD	Port1Size;						// real size of module im KB
	DWORD	Port2Size;						// 27.06.98 cg, not used any more
	LPBYTE  Port0;
	LPBYTE  Port1;
	LPBYTE  Port2;

	DWORD   pc;
	DWORD	d0;
	DWORD	d1;
	DWORD	rstkp;
	DWORD	rstk[8];
	BYTE    A[16];
	BYTE    B[16];
	BYTE    C[16];
	BYTE    D[16];
	BYTE    R0[16];
	BYTE    R1[16];
	BYTE    R2[16];
	BYTE    R3[16];
	BYTE    R4[16];
	BYTE    ST[4];
	BYTE    HST;
	BYTE    P;
	WORD    out;
	WORD	in;
	BOOL	SoftInt;
	BOOL	Shutdn;
	BOOL    mode_dec;
	BOOL	inte;							// interrupt status flag (FALSE = int in service)
	BOOL	intk;							// 1 ms keyboard scan flag (TRUE = enable)
	BOOL	intd;							// keyboard interrupt pending (TRUE = int pending)
	BOOL	carry;

	WORD    crc;
//	UINT    uUnused1;						// 21.02.99 cg, removed, not used
	WORD	wPort2Crc;						// 21.02.99 cg, new, fingerprint of port2
	WORD    wUnused1;						// 21.02.99 cg, new, dummy to fill rest of old variable
//	UINT    Port2_Size;						// 25.02.99 cg, removed, not used
	DWORD	dwKdnCycles;					// 25.02.99 cg, cpu cycles at start of 1ms key handler
	BOOL    Port1_Writeable;
	BOOL    Port2_Writeable;				// 30.05.98 cg, not used
	UINT    Port2_Bank;						// 15.12.98 cg, new, save state of GX port2 FF
	UINT    Port2_NBanks;					// 30.05.98 cg, not used
	BYTE    cards_status;
	BYTE    IORam[64];						// I/O hardware register
	UINT    IOBase;							// address of I/O modules page 
	BOOL    IOCfig;							// I/O module configuration flag
	BYTE    P0Base, BSBase, P1Base, P2Base;	// address of modules first 2KB page 
	BYTE    P0Size, BSSize, P1Size, P2Size;	// mapped size of module in 2KB
	BYTE    P0End,  BSEnd,  P1End,  P2End;	// address of modules last 2KB page
	BOOL    P0Cfig, BSCfig, P1Cfig, P2Cfig;	// module address configuration flag
	BOOL    P0Cfg2, BSCfg2, P1Cfg2, P2Cfg2;	// module size configuration flag

	BYTE    t1;
	DWORD   t2;
//	DWORD	t2_ticks;						// 03.03.98 cg, removed, not used

	DWORD	cycles;							// 03.03.98 cg, new, oscillator cycles

	BYTE    Keyboard_Row[9];
	WORD    IR15X;
	UINT    Keyboard_State;					// 30.05.98 cg, not used

	signed short loffset;
	signed int   width;
	UINT    boffset;
	UINT    lcounter;
	UINT    sync;							// 24.08.98 cg, not used
	BYTE    contrast;
	BOOL    dispon;
	DWORD   start1;
	DWORD   start12;
	DWORD   end1;
	DWORD   start2, end2;
} Chipset_t;
