#define WIN32_LEAN_AND_MEAN
#define WIN32_EXTRA_LEAN
#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <malloc.h>

HANDLE hFile;
DWORD  dwWritten;
UINT   nSize;
DWORD  nBlocks;
LPBYTE pbyBuffer;

UINT main(int argc, char *argv[])
{
	if (argc != 3)
	{
		printf("Usage:\n\t%s <filename> <size_in_kb>\n", argv[0]);
		return 1;
	}
	nSize = atoi(argv[2]);
	switch (nSize)
	{
	case 128:
		nBlocks = 64;
		break;
	case 256:
		nBlocks = 128;
		break;
	case 512:
		nBlocks = 256;
		break;
	case 1024:
		nBlocks = 512;
		break;
	case 2048:
		nBlocks = 1024;
		break;
	case 4096:
		nBlocks = 2048;
		break;
	default:
		puts("Error: Valid sizes are 128, 256, 512, 1024, 2048 and 4096.\n");
		return 0;
	}

	hFile = CreateFile(argv[1],GENERIC_WRITE,0,NULL,CREATE_ALWAYS,0,NULL);
	if (hFile == INVALID_HANDLE_VALUE)
	{
		printf("Cannot open file %s.\n", argv[1]);
		return 1;
	}

	pbyBuffer = LocalAlloc(LPTR,4096);

	while (nBlocks--) WriteFile(hFile, pbyBuffer, 4096, &dwWritten, NULL);

	CloseHandle(hFile);

	printf("Done.");
	return 0;
}
