/*
 *   DdeServ.c
 *
 *   This file is part of Emu48
 *
 *   Copyright (C) 1998 Christoph Gieelink
 *
 */
#include "pch.h"
#include "Emu48.h"

HDDEDATA CALLBACK DdeCallback(UINT iType,UINT iFmt,HCONV hConv,
                              HSZ hsz1,HSZ hsz2,HDDEDATA hData,
                              DWORD dwData1,DWORD dwData2)
{
	BYTE     szBuffer[32];
	HDDEDATA hReturn;
	LPBYTE   lpData;
	DWORD    dwAddress,dwSize,dwLoop,dwIndex;
	BOOL     bSuccess;

	switch (iType)
	{
		case XTYP_CONNECT:
			DdeQueryString(idDdeInst,hsz2,szBuffer,sizeof(szBuffer),0);
			if (0 != strcmp(szBuffer,szAppName))
				return (HDDEDATA) FALSE;
			DdeQueryString(idDdeInst,hsz1,szBuffer,sizeof(szBuffer),0);
			return (HDDEDATA) (0==strcmp(szBuffer,szTopic));

		case XTYP_POKE:
			// illegal data format or not in running state
			if (iFmt != uCF_HpObj || nState != 0)
				return (HDDEDATA) DDE_FNOTPROCESSED;

			DdeAccessData(hData,&dwSize);	// fetch data size
			DdeUnaccessData(hData);

			// reserve memory
			if ((lpData = (LPBYTE) LocalAlloc(LMEM_FIXED,dwSize * 2)) == NULL)
				return (HDDEDATA) DDE_FNOTPROCESSED;

			if (!Chipset.dispon)			// 25.08.98 cg, moved, HP off
			{
				// turn on HP
				KeyboardEvent(TRUE,0,0x8000);
				Sleep(200);
				KeyboardEvent(FALSE,0,0x8000);
				// while(Chipset.Shutdn == FALSE) Sleep(0); // 25.08.98 cg, removed
			}

			if (WaitForSleepState())		// 16.06.98 cg, wait for cpu SHUTDN then sleep state
			{
				LocalFree(lpData);			// free memory
				return (HDDEDATA) DDE_FNOTPROCESSED;
			}

			while (nState!=nNextState) Sleep(0);
			_ASSERT(nState==3);

			// fetch data and write to stack
			DdeGetData(hData,(LPBYTE) &dwIndex,sizeof(DWORD),0L);
			if (dwIndex <= dwSize - sizeof(DWORD))
				dwSize = dwIndex;
			dwSize = DdeGetData(hData,lpData+dwSize,dwSize,sizeof(DWORD));
			bSuccess = (WriteStack(lpData,dwSize) == S_ERR_NO);
			LocalFree(lpData);				// free memory

			SwitchToState(0);				// run state
			while (nState!=nNextState) Sleep(0);
			_ASSERT(nState==0);

			if (bSuccess == FALSE)
				return (HDDEDATA) DDE_FNOTPROCESSED;

			KeyboardEvent(TRUE,0,0x8000);
			Sleep(200);
			KeyboardEvent(FALSE,0,0x8000);
			// wait for sleep mode
			while(Chipset.Shutdn == FALSE) Sleep(0);

			return (HDDEDATA) DDE_FACK;

		case XTYP_REQUEST:
			// illegal data format or not in running state
			if (iFmt != uCF_HpObj || nState != 0)
				return NULL;

			if (WaitForSleepState())		// 16.06.98 cg, wait for cpu SHUTDN then sleep state
				return NULL;

			while (nState!=nNextState) Sleep(0);
			_ASSERT(nState==3);

			dwAddress = RPL_Pick(1);		// pick address of level1 object
			if (dwAddress == 0)
			{
				SwitchToState(0);			// run state
				return NULL;
			}
			dwLoop = dwSize = (RPL_SkipOb(dwAddress) - dwAddress + 1) / 2;

			// length of binary header
			dwIndex = sizeof(BINARYHEADER) - 1;

			// size of objectsize + header + object
			dwSize += dwIndex + sizeof(DWORD);

			// reserve memory
			if ((lpData = (LPBYTE) LocalAlloc(LMEM_FIXED,dwSize)) == NULL)
			{
				SwitchToState(0);			// run state
				return NULL;
			}

			// save data length
			*(DWORD *)lpData = dwLoop + dwIndex;
			
			// copy header
			memcpy(lpData + sizeof(DWORD),BINARYHEADER,dwIndex);

			// copy data
			for (dwIndex += sizeof(DWORD);dwLoop--;++dwIndex,dwAddress += 2)
				lpData[dwIndex] = Read2(dwAddress);

			// write data
			hReturn = DdeCreateDataHandle(idDdeInst,lpData,dwSize,0,hsz2,iFmt,0);
			LocalFree(lpData);

			SwitchToState(0);				// run state
			while (nState!=nNextState) Sleep(0);
			_ASSERT(nState==0);

			return hReturn;
	}
	return NULL;
}
