/*
 *   Emu48.h
 *
 *   This file is part of Emu48
 *
 *   Copyright (C) 1995 Sebastien Carlier
 *
 */
#include "types.h"

#define BINARYHEADER    "HPHP48-W"			// 11.05.98 cg, new

#define S_ERR_NO        0					// 11.05,98 cg, new, stack errorcodes
#define S_ERR_BINARY    1
#define S_ERR_ASCII     2

#define NO_SERIAL       "disabled"			// 22.05.98 cg, new, serial port not open

#define PORT_CLOSE      0					// 20.05.98 cg, new, COM port status
#define PORT_WIRE       1
#define PORT_IR         2

#define HP_MNEMONICS	FALSE				// 10.11.98 cg, new, disassembler mnenomics mode
#define CLASS_MNEMONICS	TRUE

#define MEM_MAP		0						// 10.11.98 cg, new, memory module definition
#define MEM_ROM		1
#define MEM_RAM		2
#define MEM_PORT1	3
#define MEM_PORT2	4

// Emu48.c
extern HPALETTE			hPalette;
extern HPALETTE         hOldPalette;		// 11.09.98 cg, old palette of hWindowDC
extern LPSTR            szAppName;			// 13.05.98 cg, application name for DDE server
extern LPSTR            szTopic;			// 13.05.98 cg, topic for DDE server
extern LPSTR			szTitle;
extern CRITICAL_SECTION csGDILock;			// 22.01.98 cg, critical section for hWindowDC
extern CRITICAL_SECTION csKeyLock;			// 02.09.98 cg, critical section for key scan
extern CRITICAL_SECTION csIOLock;			// 24.02.99 cg, critical section for I/O access
extern CRITICAL_SECTION csT1Lock;			// 21.04.98 cg, critical section for timer1 access
extern CRITICAL_SECTION csT2Lock;			// 21.04.98 cg, critical section for timer2 access
extern LARGE_INTEGER    lFreq;				// 24.08.98 cg, counter frequency
extern DWORD            idDdeInst;			// 13.05.98 cg, DDE server id
extern UINT             uCF_HpObj;			// 13.05.98 cg, DDE clipboard format
extern HINSTANCE		hApp;				// 01.11.98 cg, wrong variable type
extern HWND				hWnd;
extern HDC				hWindowDC;
extern BOOL				bPort2IsShared;
extern BOOL				bAlwaysDisplayLog;
extern UINT				uTimer1Period;
extern VOID				SetWindowTitle(LPSTR szString);
extern VOID				UpdateWindowStatus(VOID);

// Display.c
extern UINT    nBackgroundX;
extern UINT    nBackgroundY;
extern UINT    nBackgroundW;
extern UINT    nBackgroundH;
extern UINT    nLcdX;
extern UINT    nLcdY;
extern UINT    nLcdDoubled;					// 24.08.98 cg, changed to integer var
extern LPBYTE  pbyLcd;
extern HDC     hLcdDC;
extern HDC     hMainDC;
extern VOID UpdateContrast(BYTE byContrast);
extern VOID SetLcdColor(UINT nId, UINT nRed, UINT nGreen, UINT nBlue);
extern VOID CreateLcdBitmap(VOID);
extern VOID DestroyLcdBitmap(VOID);
extern BOOL CreateMainBitmap(LPSTR szFilename);
extern VOID DestroyMainBitmap(VOID);
extern VOID UpdateDisplayPointers(VOID);
extern VOID UpdateMainDisplay(VOID);
extern VOID UpdateMenuDisplay(VOID);
extern VOID WriteToMainDisplay(LPBYTE a, DWORD d, UINT s);
extern VOID WriteToMenuDisplay(LPBYTE a, DWORD d, UINT s);
extern VOID UpdateAnnunciators(VOID);
extern VOID ResizeWindow(VOID);

// Engine.c
extern BOOL     bInterrupt;
extern UINT     nState;
extern UINT     nNextState;
extern BOOL     bKeySlow;					// 18.11.98 cg, slow down for key emulation
extern HANDLE   hThread;
extern CHIPSET  Chipset;
extern char     szSerialWire[16];			// 20.05.98 cg, devicename for wire port
extern char     szSerialIr[16];				// 20.05.98 cg, devicename for IR port
extern DWORD    dwSXCycles;					// 23.04.98 cg, SX cpu cycles in 1/16384 Hz
extern DWORD    dwGXCycles;					// 23.04.98 cg, GX cpu cycles in 1/16384 Hz
extern VOID     SetSpeed(BOOL bAdjust);		// 23.04.98 cg, set emulation speed
extern VOID     UpdateKdnBit(VOID);			// 25.02.99 cg, update KDN bit
extern BOOL     WaitForSleepState(VOID);	// 16.06.98 cg, wait for cpu SHUTDN then sleep state
extern UINT     SwitchToState(UINT nNewState);
extern UINT     WorkerThread(LPVOID pParam);
extern DWORD    Npack(BYTE *a, UINT s);
extern VOID     Nunpack(BYTE *a, DWORD b, UINT s);

// Files.c
extern char    szEmu48Directory[260];
extern char    szCurrentDirectory[260];
extern char    szCurrentKml[260];
extern char    szBackupKml[260];
extern char    szCurrentFilename[260];
extern char    szBackupFilename[260];
extern char    szBufferFilename[260];
extern char    szPort2Filename[260];
extern LPBYTE  pbyRom;
extern DWORD   dwRomSize;
extern char    cCurrentRomType;
extern LPBYTE  pbyPort2;
extern BOOL    bPort2Writeable;
extern BOOL    bPort2IsShared;
extern DWORD   dwPort2Size;					// 26.06.98 cg, size of mapped port2
extern DWORD   dwPort2Mask;
// extern UINT    nPort2Bank;				// 15.12.98 cg, removed, not used any more
extern BOOL    bBackup;
extern WORD    WriteStack(LPBYTE,DWORD);	// 11.05.98 cg, write object to stack
extern BOOL    MapRom(LPCSTR szFilename);
extern VOID    UnmapRom(VOID);
extern BOOL    MapPort2(LPCSTR szFilename);
extern VOID    UnmapPort2(VOID);
extern BOOL    PatchRom(LPCSTR szFilename);
extern VOID    ResetDocument(VOID);
extern BOOL    NewDocument(VOID);
extern BOOL    OpenDocument(LPCSTR szFilename);
extern BOOL    SaveDocument(VOID);
extern BOOL    SaveDocumentAs(LPCTSTR szFilename);
extern BOOL    SaveBackup(VOID);
extern BOOL    RestoreBackup(VOID);
extern BOOL    ResetBackup(VOID);
extern BOOL    GetOpenFilename(VOID);
extern BOOL    GetSaveAsFilename(VOID);
extern BOOL    GetLoadObjectFilename(VOID);
extern BOOL    GetSaveObjectFilename(VOID);
extern BOOL    LoadObject(LPCSTR szFilename);
extern BOOL    SaveObject(LPCSTR szFilename);
extern HBITMAP LoadBitmapFile(LPCSTR szFilename);

// Timer.c
// extern BOOL  bAccurateTimer;				// 10.11.98 cg, removed, not adjustable any more
// extern UINT  uT1Period;					// 10.11.98 cg, removed, not adjustable any more
extern VOID  StartTimers(VOID);
extern VOID  StopTimers(VOID);
extern DWORD ReadT2(VOID);
extern VOID  SetT2(DWORD dwValue);
extern BYTE  ReadT1(VOID);
extern VOID  SetT1(BYTE byValue);

// MOps.c
extern BOOL    ioc_acc;						// 17.05.98 cg, flag ioc changed
extern BOOL    ir_ctrl_acc;					// 17.05.98 cg, flag ir_ctl changed
extern LPBYTE  RMap[256];
extern LPBYTE  WMap[256];
extern VOID    Map(BYTE a, BYTE b);
extern VOID    Config(VOID);
extern VOID    Uncnfg(VOID);
extern VOID    Reset(VOID);
extern VOID    C_Eq_Id(VOID);
extern VOID    Npeek(BYTE *a, DWORD d, UINT s);
extern VOID    Nread(BYTE *a, DWORD d, UINT s);
extern VOID    Nwrite(BYTE *a, DWORD d, UINT s);
// extern VOID    Nread2(BYTE *a, DWORD d);	// 15.12.98 cg, removed, repaced by Nread()
// extern VOID    Nwrite2(BYTE *a, DWORD d);// 15.12.98 cg, removed, repaced by Nwrite()
// extern VOID    Nread5(BYTE *a, DWORD d);	// 15.12.98 cg, removed, repaced by Nread()
// extern VOID    Nwrite5(BYTE *a, DWORD d);// 15.12.98 cg, removed, repaced by Nwite()
extern BYTE    Read2(DWORD d);
extern DWORD   Read5(DWORD d);
extern VOID    Write5(DWORD d, DWORD n);
extern VOID    IOBit(DWORD d, BYTE b, BOOL s);// 24.02.99 cg, set/clear bit in I/O section
extern VOID    ReadIO(BYTE *a, DWORD b, DWORD s);
extern VOID    WriteIO(BYTE *a, DWORD b, DWORD s);

// Keyboard.c
// extern WORD Keyboard_GetIR(VOID);		// 13.02.99 cg, is static now
extern VOID ScanKeyboard(BOOL bReset);		// 02.09.98 cg, add flag for key state reset
extern VOID KeyboardEvent(BOOL bPress, UINT out, UINT in);

// RPL.c
extern DWORD   RPL_SkipOb(DWORD d);
extern DWORD   RPL_ObjectSize(BYTE *o);
extern DWORD   RPL_CreateTemp(DWORD l);
extern DWORD   RPL_Pick(UINT l);
extern VOID    RPL_Replace(DWORD n);
extern VOID    RPL_Push(DWORD n);

// External.c
extern VOID External(CHIPSET* w);

// DDEserv.c
extern HDDEDATA CALLBACK DdeCallback(UINT, UINT, HCONV, HSZ, HSZ, HDDEDATA, DWORD, DWORD);

// Disasm.c
extern BOOL  disassembler_mode;
extern WORD  disassembler_map;
extern DWORD disassemble (DWORD addr, LPSTR out);

// Serial.c
extern WORD CommConnect(VOID);
extern VOID CommOpen(LPSTR strWirePort,LPSTR strIrPort);
extern VOID CommClose(VOID);
extern VOID CommSetBaud(VOID);
extern VOID CommTransmit(VOID);
extern VOID CommReceive(VOID);

// Message Boxes
static __inline int InfoMessage(LPCSTR szMessage)  {return MessageBox(hWnd, szMessage, szTitle, MB_APPLMODAL|MB_OK|MB_ICONINFORMATION|MB_SETFOREGROUND);}
static __inline int AbortMessage(LPCSTR szMessage) {return MessageBox(hWnd, szMessage, szTitle, MB_APPLMODAL|MB_OK|MB_ICONSTOP|MB_SETFOREGROUND);}
static __inline int YesNoMessage(LPCSTR szMessage) {return MessageBox(hWnd, szMessage, szTitle, MB_APPLMODAL|MB_YESNO|MB_ICONEXCLAMATION|MB_SETFOREGROUND);}
static __inline int YesNoCancelMessage(LPCSTR szMessage) {return MessageBox(hWnd, szMessage, szTitle, MB_APPLMODAL|MB_YESNOCANCEL|MB_ICONEXCLAMATION|MB_SETFOREGROUND);}

// Missing Win32 API calls
static __inline LPSTR   DuplicateString(LPCSTR szString)
{
	UINT  uLength = strlen(szString) + 1;
	LPSTR szDup   = LocalAlloc(LMEM_FIXED,uLength);	// 27.01.98 cg, adjust memsize
	CopyMemory(szDup,szString,uLength);
	return szDup;
}
