/*
 *   keyboard.c
 *
 *   This file is part of Emu48
 *
 *   Copyright (C) 1995 Sebastien Carlier
 *
 */
#include "pch.h"
#include "Emu48.h"

static WORD Keyboard_GetIR(VOID)			// 13.02.99 cg, make function static
{
	WORD r = 0;
	
	if (Chipset.out==0) return 0;
	if (Chipset.out&0x001) r|=Chipset.Keyboard_Row[0];
	if (Chipset.out&0x002) r|=Chipset.Keyboard_Row[1];
	if (Chipset.out&0x004) r|=Chipset.Keyboard_Row[2];
	if (Chipset.out&0x008) r|=Chipset.Keyboard_Row[3];
	if (Chipset.out&0x010) r|=Chipset.Keyboard_Row[4];
	if (Chipset.out&0x020) r|=Chipset.Keyboard_Row[5];
	if (Chipset.out&0x040) r|=Chipset.Keyboard_Row[6];
	if (Chipset.out&0x080) r|=Chipset.Keyboard_Row[7];
	if (Chipset.out&0x100) r|=Chipset.Keyboard_Row[8];
	return r;
}

VOID ScanKeyboard(BOOL bReset)				// 02.09.98 cg, changed, add flag for key state reset
{
	// 02.09.98 cg, new, changed implementation
	// bReset = TRUE  -> Reset Chipset.in interrupt state register
	//          FALSE -> generate interrupt only for new pressed keys

	EnterCriticalSection(&csKeyLock);		// synchronize
	{
		BOOL bKbdInt;

		WORD wOldIn = Chipset.in;			// save old Chipset.in state

		// 26.02.99 cg, bugfix, update KDN bit
		UpdateKdnBit();						
		Chipset.dwKdnCycles = Chipset.cycles;

		// update Chipset.in register
		Chipset.in = Keyboard_GetIR() | Chipset.IR15X;

		// interrrupt for any new pressed keys ?
		bKbdInt = ((Chipset.in & (Chipset.in ^ wOldIn)) != 0) || bReset;

		// 01.03.99 cg, bugfix, update keyboard interrupt pending flag
		Chipset.intd = Chipset.intd || (bKbdInt && !Chipset.intk);

		// 28.02.99 cg, changed, keyboard interrupt enabled
		bKbdInt = bKbdInt && (Chipset.intk || Chipset.IR15X != 0) && Chipset.inte;

		if (Chipset.in != 0)				// any key pressed
		{
			if (bKbdInt)					// interrupt enabled
			{
				Chipset.SoftInt = TRUE;		// interrupt request
				bInterrupt = TRUE;			// exit emulation loop
			}

			if (Chipset.Shutdn)				// cpu sleeping
				ResumeThread(hThread);		// wake up
		}
		else
		{
			Chipset.intd = FALSE;			// 01.03.99 cg, bugfix, no keyboard interrupt pending
		}
	}
	LeaveCriticalSection(&csKeyLock);

#if 0
	// 02.09.98 cg, removed
	// 11.06.98 cg, new, changed implementation
	// keyboard interrupt enabled
	BOOL bKbdInt = (Chipset.intk || Chipset.IR15X != 0) && Chipset.inte && Chipset.in == 0;

	// update Chipset.in register
	Chipset.in = Keyboard_GetIR() | Chipset.IR15X;

	if (Chipset.in != 0)					// call interrupt ?
	{
		if (bKbdInt)						// interrupt enabled
		{
			Chipset.SoftInt = TRUE;			// interrupt request
			bInterrupt = TRUE;				// exit emulation loop
		}

		if (Chipset.Shutdn)					// cpu sleeping
			ResumeThread(hThread);			// wake up
	}
#endif

#if 0
	// 11.06.98 cg, removed
	WORD IR = Keyboard_GetIR();	

	Chipset.in = IR | Chipset.IR15X;

	if (Chipset.IR15X)
	{
		if (Chipset.inte)
		{
//			PatBlt(hWindowDC,0,0,8,8,DSTINVERT);
			Chipset.SoftInt = TRUE;
			bInterrupt = TRUE;
		}
		if (Chipset.Shutdn)
		{
//			PatBlt(hWindowDC,8,0,8,8,DSTINVERT);
			Chipset.Shutdn = FALSE; // Prevent another ResumeThread
			ResumeThread(hThread);
		}
	}

	if (IR != 0)
	{
		if ((Chipset.inte) && (Chipset.intk))
		{
//			PatBlt(hWindowDC,0,8,8,8,DSTINVERT);
			Chipset.SoftInt = TRUE;
			bInterrupt = TRUE;
		}
		if (Chipset.Shutdn)
		{
//			PatBlt(hWindowDC,8,8,8,8,DSTINVERT);
			Chipset.Shutdn = FALSE; // Prevent another ResumeThread
			ResumeThread(hThread);
		}
	}
#endif

	return;
}

VOID KeyboardEvent(BOOL bPress, UINT out, UINT in)
{
	if (nState != 0)						// not in running state
		return;								// ignore key
	if (in == 0x8000)						// ON key ?
	{
		Chipset.IR15X = bPress?0x8000:0x0000; // refresh special ON key flag
	}
	else
	{
		_ASSERT(out<9);
		if (bPress)							// key pressed 
		{
			// 11.06.98 cg, removed, do interrupt handling in ScanKeyboard()
			// if (((Chipset.Keyboard_Row[out]&in) == 0) && (Chipset.inte==FALSE) && (Chipset.intk))
			//		Chipset.intd = TRUE;
			Chipset.Keyboard_Row[out] |= in; // set key marker in keyboard row
		}
		else
			Chipset.Keyboard_Row[out] &= (~in); // clear key marker in keyboard row
	}
	ScanKeyboard(FALSE);					// 02.09.98 cg, changed, update Chipset.in register
	bKeySlow = FALSE;						// 18.11.98 cg, new, break key slow down
	Sleep(50);								// 28.09.98 cg, hold key state for a definite time
	return;
}
