/*
 *   kml.h
 *
 *   This file is part of Emu48
 *
 *   Copyright (C) 1995 Sebastien Carlier
 *
 */

#define LEX_BLOCK   1
#define LEX_COMMAND 2
#define LEX_PARAM   3

typedef enum eTokenId
{
	TOK_NONE, //0
	TOK_ANNUNCIATOR, //1
	TOK_BACKGROUND, //2
	TOK_IFPRESSED, //3
	TOK_RESETFLAG, //4
	TOK_SCANCODE, //5
	TOK_MENUITEM, //6
	TOK_INTEGER, //7
	TOK_SETFLAG, //8
	TOK_RELEASE, //9
	TOK_VIRTUAL, //10
	TOK_INCLUDE, //11
	TOK_STRING, //12
	TOK_GLOBAL, //13
	TOK_AUTHOR, //14
	TOK_BITMAP, //15
	TOK_OFFSET, //16
	TOK_BUTTON, //17
	TOK_IFFLAG, //18
	TOK_ONDOWN, //19
	TOK_NOHOLD, //20
	TOK_TITLE, //21
	TOK_OUTIN, //22
	TOK_PATCH, //23
	TOK_PRINT, //24
	TOK_DEBUG, //25
	TOK_COLOR, //26
	TOK_MODEL, //27
	TOK_PRESS, //28
	TOK_TYPE, //29
	TOK_SIZE, //30
	TOK_DOWN, //31
	TOK_ZOOM, //32
	TOK_ELSE, //33
	TOK_ONUP, //34
	TOK_EOL, //35
	TOK_MAP, //36
	TOK_ROM, //37
	TOK_LCD, //38
	TOK_NOTFLAG, //39
	TOK_END //40
} TokenId;

#define TYPE_NONE    00
#define TYPE_INTEGER 01
#define TYPE_STRING  02

typedef struct Token
{
	TokenId eId;
	DWORD  nParams;
	DWORD  nLen;
	CHAR   szName[20];
} Token;

typedef struct Line
{
	struct Line* pNext;
	TokenId eCommand;
	DWORD nParam[6];
} Line;

typedef struct Block
{
	TokenId eType;
	DWORD nId;
	struct Line*  pFirstLine;
	struct Block* pNext;
} Block;

#define BUTTON_NOHOLD  0x0001
#define BUTTON_VIRTUAL 0x0002
typedef struct Button
{
	UINT nId;
	BOOL bDown;
	UINT nType;
	DWORD dwFlags;
	UINT nOx, nOy;
	UINT nDx, nDy;
	UINT nCx, nCy;
	UINT nOut, nIn;
	Line* pOnDown;
	Line* pOnUp;
} Button;

typedef struct Annunciator
{
	UINT nOx, nOy;
	UINT nDx, nDy;
	UINT nCx, nCy;
} Annunciator;

extern Block* pKml;
extern BOOL DisplayChooseKml(CHAR cType);
extern VOID FreeBlocks(Block* pBlock);
extern VOID DrawAnnunciator(UINT nId, BOOL bOn);
extern VOID RefreshButtons();
extern VOID MouseButtonDownAt(UINT nFlags, DWORD x, DWORD y);
extern VOID MouseButtonUpAt(UINT nFlags, DWORD x, DWORD y);
extern VOID MouseMovesTo(UINT nFlags, DWORD x, DWORD y);
extern VOID RunKey(BYTE nId, BOOL bPressed);
extern BOOL InitKML(LPCSTR szFilename, BOOL bNoLog);
extern VOID KillKML();
