/*
 *   opcodes.h
 *
 *   This file is part of Emu48
 *
 *   Copyright (C) 1995 Sebastien Carlier
 *
 */

// 05.03.98 cg, added cycles for each command (S(X) values)

o00: // RTNSXM
{
	w.cycles+=9;
	w.pc = rstkpop();
	w.HST |= XM; 
	continue;
}

o01: // RTN
{
	w.cycles+=9;
	w.pc = rstkpop();
	continue;
}

o02: // RTNSC
{
	w.cycles+=9;
	w.pc = rstkpop();
	w.carry = TRUE;
	continue;
}

o03: // RTNCC
{
	w.cycles+=9;
	w.pc = rstkpop();
	w.carry = FALSE;
	continue; 
}

o04: // SETHEX
{
	w.cycles+=3;
	w.pc+=2;
	w.mode_dec = FALSE;
	continue;
}

o05: // SETDEC
{
	w.cycles+=3;
	w.pc+=2;
	w.mode_dec = TRUE;
	continue;
}

o06: // RSTK=C
{
	w.cycles+=8;
	w.pc+=2;
	rstkpush(Npack(w.C,5));
	continue; 
}

o07: // C=RSTK
{
	w.cycles+=8;
	w.pc+=2;
	Nunpack(w.C,rstkpop(),5);
	continue;
}

o08: // CLRST
{
	w.cycles+=6;
	w.pc+=2;
	memset(w.ST, 0, 3);
	continue;
}

o09: // C=ST
{
	w.cycles+=6;
	w.pc+=2;
	memcpy(w.C, w.ST, 3);
	continue;
}

o0A: // ST=C
{
	w.cycles+=6;
	w.pc+=2;
	memcpy(w.ST, w.C, 3);
	continue;
}

o0B: // CSTEX
{
	w.cycles+=6;
	w.pc+=2;
	Nxchg(w.C, w.ST, 3);
	continue;
}

o0C: // P=P+1
{
	w.cycles+=3;
	w.pc+=2;
	if (w.P<15)
	{
		w.P++;
		w.carry=FALSE;
	}
	else
	{
		w.P=0;
		w.carry=TRUE;
	}
	PCHANGED;
	continue;
}

o0D: // P=P-1
{
	w.cycles+=3;
	w.pc+=2;
	if (w.P)
	{
		w.P--;
		w.carry=FALSE;
	}
	else
	{
		w.P=0xF;
		w.carry=TRUE;
	}
	PCHANGED;
	continue;
}

o0Ef0: // A=A&B f
{
	w.cycles+=4+F_l[I[2]];
	w.pc+=4;
	NFand(w.A,w.B,I[2]);
	continue;
}
o0Ef1: // B=B&C f
{
	w.cycles+=4+F_l[I[2]];
	w.pc+=4;
	NFand(w.B,w.C,I[2]);
	continue;
}
o0Ef2: // C=C&A f
{
	w.cycles+=4+F_l[I[2]];
	w.pc+=4;
	NFand(w.C,w.A,I[2]);
	continue;
}
o0Ef3: // D=D&C f
{
	w.cycles+=4+F_l[I[2]];
	w.pc+=4;
	NFand(w.D,w.C,I[2]);
	continue;
}
o0Ef4: // B=B&A f
{
	w.cycles+=4+F_l[I[2]];
	w.pc+=4;
	NFand(w.B,w.A,I[2]);
	continue;
}
o0Ef5: // C=C&B f
{
	w.cycles+=4+F_l[I[2]];
	w.pc+=4;
	NFand(w.C,w.B,I[2]);
	continue;
}
o0Ef6: // A=A&C f
{
	w.cycles+=4+F_l[I[2]];
	w.pc+=4;
	NFand(w.A,w.C,I[2]);
	continue;
}
o0Ef7: // C=C&D f
{
	w.cycles+=4+F_l[I[2]];
	w.pc+=4;
	NFand(w.C,w.D,I[2]);
	continue;
}

o0Ef8: // A=A!B f
{
	w.cycles+=4+F_l[I[2]];
	w.pc+=4;
	NFor(w.A,w.B,I[2]);
	continue;
}
o0Ef9: // B=B!C f
{
	w.cycles+=4+F_l[I[2]];
	w.pc+=4;
	NFor(w.B,w.C,I[2]);
	continue;
}
o0EfA: // C=C!A f
{
	w.cycles+=4+F_l[I[2]];
	w.pc+=4;
	NFor(w.C,w.A,I[2]);
	continue;
}
o0EfB: // D=D!C f
{
	w.cycles+=4+F_l[I[2]];
	w.pc+=4;
	NFor(w.D,w.C,I[2]);
	continue;
}
o0EfC: // B=B!A f
{
	w.cycles+=4+F_l[I[2]];
	w.pc+=4;
	NFor(w.B,w.A,I[2]);
	continue;
}
o0EfD: // C=C!B f
{
	w.cycles+=4+F_l[I[2]];
	w.pc+=4;
	NFor(w.C,w.B,I[2]);
	continue;
}
o0EfE: // A=A!C f
{
	w.cycles+=4+F_l[I[2]];
	w.pc+=4;
	NFor(w.A,w.C,I[2]);
	continue;
}
o0EfF: // C=C!D f
{
	w.cycles+=4+F_l[I[2]];
	w.pc+=4;
	NFor(w.C,w.D,I[2]);
	continue;
}

o0F: // RTI
{
	w.cycles+=9;
	w.pc = rstkpop();
	w.inte = TRUE;							// enable interrupt

	if ((w.intd && w.intk) || w.IR15X)		// 28.03.99 cg, bugfix, keyboard interrupt pending
	{
		w.intd = FALSE;						// no keyboard interrupt pending any more
		INTERRUPT;							// restart interrupt handler
	}

	// 30.11.98 cg, bugfix, restart interrupt handler when timer interrupt
	if (w.IORam[0x2E]&0x02)					// INT bit of timer1 is set
		ReadT1();							// check for int

	if (w.IORam[0x2F]&0x02)					// INT bit of timer2 is set
		ReadT2();							// check for int
	// 30.11.98 cg, end of bugfix
	continue;
}

o100: // R0=A W
{
	w.cycles+=19;
	w.pc+=3;
	memcpy(w.R0, w.A, 16);
	continue;
}

o101: // R1=A W
{
	w.cycles+=19;
	w.pc+=3;
	memcpy(w.R1, w.A, 16);
	continue;
}

o102: // R2=A W
{
	w.cycles+=19;
	w.pc+=3;
	memcpy(w.R2, w.A, 16);
	continue;
}

o103: // R3=A W
{
	w.cycles+=19;
	w.pc+=3;
	memcpy(w.R3, w.A, 16);
	continue;
}

o104: // R4=A W
{
	w.cycles+=19;
	w.pc+=3;
	memcpy(w.R4, w.A, 16);
	continue;
}

o108: // R0=C W
{
	w.cycles+=19;
	w.pc+=3;
	memcpy(w.R0, w.C, 16);
	continue;
}

o109: // R1=C W
{
	w.cycles+=19;
	w.pc+=3;
	memcpy(w.R1, w.C, 16);
	continue;
}

o10A: // R2=C W
{
	w.cycles+=19;
	w.pc+=3;
	memcpy(w.R2, w.C, 16);
	continue;
}

o10B: // R3=C W
{
	w.cycles+=19;
	w.pc+=3;
	memcpy(w.R3, w.C, 16);
	continue;
}

o10C: // R4=C W
{
	w.cycles+=19;
	w.pc+=3;
	memcpy(w.R4, w.C, 16);
	continue;
}

o110: // A=R0 W
{
	w.cycles+=19;
	w.pc+=3;
	memcpy(w.A, w.R0, 16);
	continue;
}

o111: // A=R1 W
{
	w.cycles+=19;
	w.pc+=3;
	memcpy(w.A, w.R1, 16);
	continue;
}

o112: // A=R2 W
{
	w.cycles+=19;
	w.pc+=3;
	memcpy(w.A, w.R2, 16);
	continue;
}

o113: // A=R3 W
{
	w.cycles+=19;
	w.pc+=3;
	memcpy(w.A, w.R3, 16);
	continue;
}

o114: // A=R4 W
{
	w.cycles+=19;
	w.pc+=3;
	memcpy(w.A, w.R4, 16);
	continue;
}

o118: // C=R0 W
{
	w.cycles+=19;
	w.pc+=3;
	memcpy(w.C, w.R0, 16);
	continue;
}

o119: // C=R1 W
{
	w.cycles+=19;
	w.pc+=3;
	memcpy(w.C, w.R1, 16);
	continue;
}

o11A: // C=R2 W
{
	w.cycles+=19;
	w.pc+=3;
	memcpy(w.C, w.R2, 16);
	continue;
}

o11B: // C=R3 W
{
	w.cycles+=19;
	w.pc+=3;
	memcpy(w.C, w.R3, 16);
	continue;
}

o11C: // C=R4 W
{
	w.cycles+=19;
	w.pc+=3;
	memcpy(w.C, w.R4, 16);
	continue;
}

o120: // AR0EX W
{
	w.cycles+=19;
	w.pc+=3;
	Nxchg(w.A, w.R0, 16);
	continue;
}

o121: // AR1EX W
{
	w.cycles+=19;
	w.pc+=3;
	Nxchg(w.A, w.R1, 16);
	continue;
}

o122: // AR2EX W
{
	w.cycles+=19;
	w.pc+=3;
	Nxchg(w.A, w.R2, 16);
	continue;
}

o123: // AR3EX W
{
	w.cycles+=19;
	w.pc+=3;
	Nxchg(w.A, w.R3, 16);
	continue;
}

o124: // AR4EX W
{
	w.cycles+=19;
	w.pc+=3;
	Nxchg(w.A, w.R4, 16);
	continue;
}

o128: // CR0EX W
{
	w.cycles+=19;
	w.pc+=3;
	Nxchg(w.C, w.R0, 16);
	continue;
}

o129: // CR1EX W
{
	w.cycles+=19;
	w.pc+=3;
	Nxchg(w.C, w.R1, 16);
	continue;
}

o12A: // CR2EX W
{
	w.cycles+=19;
	w.pc+=3;
	Nxchg(w.C, w.R2, 16);
	continue;
}

o12B: // CR3EX W
{
	w.cycles+=19;
	w.pc+=3;
	Nxchg(w.C, w.R3, 16);
	continue;
}

o12C: // CR4EX W
{
	w.cycles+=19;
	w.pc+=3;
	Nxchg(w.C, w.R4, 16);
	continue;
}

o130: // D0=A
{
	w.cycles+=8;
	w.pc+=3;
	w.d0=Npack(w.A,5);
	continue;
}

o131: // D1=A
{
	w.cycles+=8;
	w.pc+=3;
	w.d1=Npack(w.A,5);
	continue;
}

o132: // AD0EX
{
	DWORD d = w.d0;
	w.d0=Npack(w.A,5);
	Nunpack(w.A,d,5);
	w.cycles+=8;
	w.pc+=3;
	continue;
}

o133: // AD1EX
{
	DWORD d=w.d1;
	w.d1=Npack(w.A,5);
	Nunpack(w.A,d,5);
	w.cycles+=8;
	w.pc+=3;
	continue;
}

o134: // D0=C
{
	w.cycles+=8;
	w.pc+=3;
	w.d0=Npack(w.C,5);
	continue;
}

o135: // D1=C
{
	w.cycles+=8;
	w.pc+=3;
	w.d1=Npack(w.C,5);
	continue;
}

o136: // CD0EX
{
	DWORD d=w.d0;
	w.d0=Npack(w.C,5);
	Nunpack(w.C,d,5);
	w.cycles+=8;
	w.pc+=3;
	continue;
}

o137: // CD1EX
{
	DWORD d=w.d1;
	w.d1=Npack(w.C,5);
	Nunpack(w.C,d,5);
	w.cycles+=8;
	w.pc+=3;   
	continue;
}

o138:// D0=AS
{
	w.cycles+=7;
	w.pc+=3;
	*((WORD*)&w.d0)=(WORD)Npack(w.A,4);
	continue;
}

o139: // D1=AS
{
	w.cycles+=7;
	w.pc+=3;
	*((WORD*)&w.d1)=(WORD)Npack(w.A,4);
	continue;
}

o13A: // AD0XS
{
	DWORD d=w.d0;
	*((WORD*)&w.d0)=(WORD)Npack(w.A,4);
	Nunpack(w.A,d,4);
	w.cycles+=7;
	w.pc+=3;
	continue;
}

o13B: // AD1XS
{
	DWORD d=w.d1;
	*((WORD*)&w.d1)=(WORD)Npack(w.A,4);
	Nunpack(w.A,d,4);
	w.cycles+=7;
	w.pc+=3;
	continue;
}

o13C: // D0=CS
{
	w.cycles+=7;
	w.pc+=3;
	*((WORD*)&w.d0)=(WORD)Npack(w.C,4);
	continue;
}

o13D: // D1=CS
{
	w.cycles+=7;
	w.pc+=3;
	*((WORD*)&w.d1)=(WORD)Npack(w.C,4);
	continue;
}

o13E: // AD0XS
{
	DWORD d=w.d0;
	*((WORD*)&w.d0)=(WORD)Npack(w.C,4);
	Nunpack(w.C,d,4);
	w.cycles+=7;
	w.pc+=3;
	continue;
}

o13F: // AD1XS
{
	DWORD d=w.d1;
	*((WORD*)&w.d1)=(WORD)Npack(w.C,4);
	Nunpack(w.C,d,4);
	w.cycles+=7;
	w.pc+=3;
	continue;
}

o140: w.cycles+=17; w.pc+=3; Nwrite(w.A, w.d0, 5); continue; // DAT0=A A // 15.12.98 cg, replaced Nwrite()
o141: w.cycles+=17; w.pc+=3; Nwrite(w.A, w.d1, 5); continue; // DAT1=A A // 15.12.98 cg, replaced Nwrite()
o144: w.cycles+=17; w.pc+=3; Nwrite(w.C, w.d0, 5); continue; // DAT0=C A // 15.12.98 cg, replaced Nwrite()
o145: w.cycles+=17; w.pc+=3; Nwrite(w.C, w.d1, 5); continue; // DAT1=C A // 15.12.98 cg, replaced Nwrite()
o148: w.cycles+=14; w.pc+=3; Nwrite(w.A, w.d0, 2); continue; // DAT0=A B // 15.12.98 cg, replaced Nwrite()
o149: w.cycles+=14; w.pc+=3; Nwrite(w.A, w.d1, 2); continue; // DAT1=A B // 15.12.98 cg, replaced Nwrite()
o14C: w.cycles+=14; w.pc+=3; Nwrite(w.C, w.d0, 2); continue; // DAT0=C B // 15.12.98 cg, replaced Nwrite()
o14D: w.cycles+=14; w.pc+=3; Nwrite(w.C, w.d1, 2); continue; // DAT1=C B // 15.12.98 cg, replaced Nwrite()
	  
o142: w.cycles+=18; w.pc+=3; Nread(w.A, w.d0, 5); continue; // A=DAT0 A  // 15.12.98 cg, replaced Nread()
o143: w.cycles+=18; w.pc+=3; Nread(w.A, w.d1, 5); continue; // A=DAT1 A  // 15.12.98 cg, replaced Nread()
o146: w.cycles+=18; w.pc+=3; Nread(w.C, w.d0, 5); continue; // C=DAT0 A  // 15.12.98 cg, replaced Nread()
o147: w.cycles+=18; w.pc+=3; Nread(w.C, w.d1, 5); continue; // C=DAT1 A  // 15.12.98 cg, replaced Nread()
o14A: w.cycles+=15; w.pc+=3; Nread(w.A, w.d0, 2); continue; // A=DAT0 B  // 15.12.98 cg, replaced Nread()
o14B: w.cycles+=15; w.pc+=3; Nread(w.A, w.d1, 2); continue; // A=DAT1 B  // 15.12.98 cg, replaced Nread()
o14E: w.cycles+=15; w.pc+=3; Nread(w.C, w.d0, 2); continue; // C=DAT0 B  // 15.12.98 cg, replaced Nread()
o14F: w.cycles+=15; w.pc+=3; Nread(w.C, w.d1, 2); continue; // C=DAT0 B  // 15.12.98 cg, replaced Nread()
	  
o150a: w.cycles+=16+F_l[I[3]]; w.pc+=4; NFwrite(w.A, w.d0, I[3]); continue;// DAT0=A a
o151a: w.cycles+=16+F_l[I[3]]; w.pc+=4; NFwrite(w.A, w.d1, I[3]); continue;// DAT1=A a
o154a: w.cycles+=16+F_l[I[3]]; w.pc+=4; NFwrite(w.C, w.d0, I[3]); continue;// DAT0=C a
o155a: w.cycles+=16+F_l[I[3]]; w.pc+=4; NFwrite(w.C, w.d1, I[3]); continue;// DAT1=C a
o152a: w.cycles+=17+F_l[I[3]]; w.pc+=4; NFread(w.A, w.d0, I[3]); continue;// A=DAT0 a
o153a: w.cycles+=17+F_l[I[3]]; w.pc+=4; NFread(w.A, w.d1, I[3]); continue;// A=DAT1 a
o156a: w.cycles+=17+F_l[I[3]]; w.pc+=4; NFread(w.C, w.d0, I[3]); continue;// C=DAT0 a
o157a: w.cycles+=17+F_l[I[3]]; w.pc+=4; NFread(w.C, w.d1, I[3]); continue;// C=DAT1 a
	   
o158x: w.cycles+=15+I[3]+1; w.pc+=4; Nwrite(w.A, w.d0, I[3]+1); continue;// DAT0=A x
o159x: w.cycles+=15+I[3]+1; w.pc+=4; Nwrite(w.A, w.d1, I[3]+1); continue;// DAT1=A x
o15Cx: w.cycles+=15+I[3]+1; w.pc+=4; Nwrite(w.C, w.d0, I[3]+1); continue;// DAT0=C x
o15Dx: w.cycles+=15+I[3]+1; w.pc+=4; Nwrite(w.C, w.d1, I[3]+1); continue;// DAT1=C x
o15Ax: w.cycles+=16+I[3]+1; w.pc+=4; Nread(w.A, w.d0, I[3]+1); continue;// A=DAT0 x
o15Bx: w.cycles+=16+I[3]+1; w.pc+=4; Nread(w.A, w.d1, I[3]+1); continue;// A=DAT1 x
o15Ex: w.cycles+=16+I[3]+1; w.pc+=4; Nread(w.C, w.d0, I[3]+1); continue;// C=DAT0 x
o15Fx: w.cycles+=16+I[3]+1; w.pc+=4; Nread(w.C, w.d1, I[3]+1); continue; // C=DAT1 x	   

o16x: // D0=D0+ (n+1)
{
	w.cycles+=7;
	w.pc+=3;
	w.d0+=I[2]+1;
	if (w.d0>0xfffff)
	{
		w.d0&=0xfffff;
		w.carry=TRUE;
	}
	else
	{
		w.carry=FALSE;
	}
	continue;
}

o17x: // D1=D1+ (n+1)
{
	w.cycles+=7;
	w.pc+=3;
	w.d1+=I[2]+1;
	if (w.d1>0xfffff)
	{
		w.d1&=0xfffff;
		w.carry=TRUE;
	}
	else
	{
		w.carry=FALSE;
	}
	continue;
}

o18x: // D0=D0- (n+1)
{
	w.cycles+=7;
	w.pc+=3;
	w.d0-=I[2]+1;
	if (w.d0>0xfffff)
	{
		w.d0&=0xfffff;
		w.carry=TRUE;
	}
	else
	{
		w.carry=FALSE;
	}
	continue;
}

o19d2: // D0=(2) #dd
{
	w.cycles+=4;
	w.pc+=4;
	*((BYTE*)&w.d0)=(BYTE)Npack(I+2,2);
	continue;
}

o1Ad4: // D0=(4) #dddd
{
	w.cycles+=6;
	w.pc+=6;
	*((WORD*)&w.d0)=(WORD)Npack(I+2,4);
	continue;
}

o1Bd5: // D0=(5) #ddddd
{
	w.cycles+=7;
	w.pc+=7;
	w.d0=Npack(I+2,5);
	continue;
}

o1Cx: // D1=D1- (n+1)
{
	w.cycles+=7; 
	w.pc+=3;
	w.d1-=I[2]+1;
	if (w.d1>0xfffff)
	{
		w.d1&=0xfffff;
		w.carry=TRUE;
	}
	else
	{
		w.carry=FALSE;
	}
	continue;
}

o1Dd2: // D1=(2) #dd
{
	w.cycles+=4;
	w.pc+=4;
	*((BYTE*)&w.d1)=(BYTE)Npack(I+2,2);
	continue;
}

o1Ed4: // D1=(4) #dddd
{
	w.cycles+=6;
	w.pc+=6;
	*((WORD*)&w.d1)=(WORD)Npack(I+2,4);
	continue;
}

o1Fd5: // D1=(5) #ddddd
{
	w.cycles+=7;
	w.pc+=7;
	w.d1=Npack(I+2,5);
	continue;
}

o2n: // P= n
{
	w.cycles+=2;
	w.pc+=2;
	w.P=I[1];
	PCHANGED;
	continue;
}

o3X: // LCHEX
{
	UINT n=I[1]+1;
	UINT d=16-w.P;
	w.cycles+=4+n;
	w.pc+=2;
	I+=2; // UNSAFE
	if (n<=d)
	{
		memcpy(w.C+w.P,I,n); //Nread(C+P,w.pc,n);
	}
	else
	{
		memcpy(w.C+w.P,I,d); //Nread(C+P,w.pc,d);
		memcpy(w.C,I+d,n-d); //Nread(C,w.pc+d,n-d);
	}
	w.pc+=n;
	continue;
}

o4d2: // GOC #dd
{
	if (!w.carry)
	{
		w.cycles+=3;
		w.pc+=3;
	}
	else
	{
		signed char jmp=I[1]+(I[2]<<4);
		if (jmp)
			w.pc+=jmp+1;
		else
			w.pc=rstkpop();
		w.cycles+=10;
		w.pc&=0xFFFFF;
	}
	continue;
}

o5d2: // GONC
{
	if (w.carry)
	{
		w.cycles+=3;
		w.pc+=3;
	}
	else
	{
		signed char jmp=I[1]+(I[2]<<4);
		if (jmp)
			w.pc+=jmp+1;
		else
			w.pc=rstkpop();
		w.cycles+=10;
		w.pc&=0xFFFFF;
	}
	continue;
}

o6d3: // GOTO
{
	DWORD d=Npack(I+1,3);
	if (d&0x800)
		w.pc-=0xFFF-d;
	else
		w.pc+=d+1;
	w.cycles+=11;
	w.pc&=0xFFFFF;
	continue;
}

o7d3: // GOSUB
{
	DWORD d=Npack(I+1,3);
	rstkpush(w.pc+4);
	if (d&0x800) w.pc-=0xFFC-d; else w.pc+=d+4;
	w.cycles+=12;
	w.pc&=0xFFFFF;
	continue;
}

o800: // OUT=CS
{
	w.cycles+=4;
	w.pc+=3;
	w.out = (w.out&0xff0) | w.C[0];
	ScanKeyboard(FALSE);					// 02.09.98 cg, changed, add parameter
	continue;
}

o801: // OUT=C
{
	w.cycles+=6;
	w.pc+=3;
	w.out = (WORD)Npack(w.C, 3);
	ScanKeyboard(FALSE);					// 02.09.98 cg, changed, add parameter
	continue;
}

o802: // A=IN
{
	w.cycles+=7;
	if ((w.pc&1)==0) w.pc+=3;				// 02.03.98 cg, bugfix, emulate saturn bug
	AdjKeySpeed();							// 06.07.98 cg, new, slow down key repeat
	IOBit(0x19,8,w.in != 0);				// 24.02.99 cg, bugfix, update KDN bit in the SRQ register
	Nunpack(w.A, w.in, 4);
	continue;
}

o803: // C=IN
{
	w.cycles+=7;
	if ((w.pc&1)==0) w.pc+=3;				// 02.03.98 cg, bugfix, emulate saturn bug
	AdjKeySpeed();							// 06.07.98 cg, new, slow down key repeat
	IOBit(0x19,8,w.in != 0);				// 24.02.99 cg, bugfix, update KDN bit in the SRQ register
	Nunpack(w.C, w.in, 4);
	continue;
}

o804: // UNCNFG
{
	w.cycles+=12;
	w.pc+=3;
	Uncnfg();
	continue;
}

o805: // CONFIG
{
	w.cycles+=11;
	w.pc+=3;
	Config();
	continue;
}

o806: // C=ID
{
	w.cycles+=11;
	w.pc+=3;
	C_Eq_Id();
	continue;
}

o807: // SHUTDN
{
	BOOL bShutdn = TRUE;					// 25.11.98 cg, new, shut down

	w.cycles+=5;
	w.pc+=3;
	// 25.11.98 cg, bugfix, only shut down when no timer wake up
	if (w.IORam[0x2E]&0x04)					// WKE bit of timer1 is set
	{
		if (ReadT1()&0x08)					// and MSB of timer1 is set
		{
			w.IORam[0x2E] &= ~0x04;			// clear WKE
			bShutdn = FALSE;				// don't shut down
		}
	}
	if (w.IORam[0x2F]&0x04)					// WKE bit of timer2 is set
	{
		if (ReadT2()&0x80000000)			// and MSB of timer2 is set
		{
			w.IORam[0x2F] &= ~0x04;			// clear WKE
			bShutdn = FALSE;				// don't shut down
		}
	}
	// 25.11.98 cg, end of bugfix
	if (w.in==0 && bShutdn)					// 25.11.98 cg, changed, shut down only when enabled
	{
		w.Shutdn = TRUE;					// 30.05.98 cg, set mode before exit emulation loop
		bInterrupt = TRUE;
	}
	continue;
}

o8080: // INTON
{
	w.cycles+=5;
	w.pc+=4;
	w.dwKdnCycles = w.cycles;				// 25.02.99 cg, new, cpu cycles at start of 1ms key handler
	w.intk = TRUE;
	if (w.intd || w.IR15X)					// 28.03.99 cg, bugfix, keyboard interrupt pending
	{
		w.intd = FALSE;						// no keyboard interrupt pending any more
		INTERRUPT;							// restart interrupt handler
	}
	// ScanKeyboard();						// 30.05.98 cg, don't generate a keyboard interrupt here
	continue;
}

o80810: // RSI
{
	w.cycles+=6;
	w.pc+=5;
	// w.intk = TRUE;						// 04.06.98 cg, removed, no INTON operation
	ScanKeyboard(TRUE);						// 02.09.98 cg, changed, one input bit high ?

	// 25.02.99 cg, enable KDN update
	w.dwKdnCycles = w.cycles - (DWORD) T2CYCLES * 16;

	if (w.in && w.inte == FALSE)			// 28.02.99 cg, bugfix, key interrupt pending
		w.intd = TRUE;						// 02.09.98 cg, keyboard interrupt pending
	continue;
}

o8082X: // LA
{
	UINT n=I[4]+1;
	UINT d=16-w.P;
	w.cycles+=6+n;							// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=5+n;
	I+=5; // UNSAFE
	if (n<=d)
	{
		memcpy(w.A+w.P,I,n);
	}
	else
	{
		memcpy(w.A+w.P,I,d);
		memcpy(w.A,I+d,n-d);
	}
	continue;
}

o8083: // BUSCB
{
	w.cycles+=7;							// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=4;
	// 25.11.98 cg, removed, emulated as NOP
	// InfoMessage("BUSCB instruction executed.");
	continue;
}

o8084n: // ABIT=0 n
{
	w.cycles+=6;							// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=5;
	Nbit0(w.A, I[4]);
	continue;
}

o8085n: // ABIT=1 n
{
	w.cycles+=6;							// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=5;
	Nbit1(w.A, I[4]);
	continue;
}

o8086n: // ?ABIT=0 n
{
	w.cycles+=7;							// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=5;
	Tbit0(w.A, I[4]);
	GOYES5;
}

o8087n: // ?ABIT=1 n
{
	w.cycles+=7;							// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=5;
	Tbit1(w.A, I[4]);
	GOYES5;
}

o8088n: // CBIT=0 n
{
	w.cycles+=6;							// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=5;
	Nbit0(w.C, I[4]);
	continue;
}

o8089n: // CBIT=1 n
{
	w.cycles+=6;							// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=5;
	Nbit1(w.C, I[4]);
	continue;
}

o808An: // ?CBIT=0 n
{
	w.cycles+=7;							// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=5;
	Tbit0(w.C, I[4]);
	GOYES5;
}

o808Bn: // ?CBIT=1 n
{
	w.cycles+=7;							// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=5;
	Tbit1(w.C, I[4]);
	GOYES5;
}

o808C: // PC=(A)
{
	w.cycles+=23;
	w.pc=Read5(Npack(w.A,5));
	continue;
}

o808D: // BUSCD
{
	w.cycles+=7;							// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=4;
	// 25.11.98 cg, removed, emulated as NOP
	// InfoMessage("BUSCD instruction executed.");
	continue;
}

o808E: // PC=(C)
{
	w.cycles+=23;							// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc=Read5(Npack(w.C,5));
	continue;
}

o808F: // INTOFF
{
	w.cycles+=5;
	w.pc+=4;
	UpdateKdnBit();							// 25.02.99 cg, bugfix, update KDN bit
	w.intk = FALSE;
	// ScanKeyboard();						// 30.05.98 cg, don't generate a keyboard interrupt here
	continue;
}

o809: // C+P+1 - HEX MODE
{
	w.cycles+=8;
	w.pc+=3;
	w.C[0]+=w.P; Nincx(w.C,5);
	continue;
}

o80A: // RESET
{
	w.cycles+=6;
	w.pc+=3;
	Reset();
	continue;
}

o80B: // BUSCC
{
	w.cycles+=6;
	w.pc+=3;
	// 25.11.98 cg, removed, emulated as NOP
	// InfoMessage("BUSCC instruction executed.");
	continue;
}

o80Cn: // C=P n
{
	w.cycles+=6;
	w.pc+=4;
	w.C[I[3]] = w.P;
	continue;
}

o80Dn: // P=C n
{
	w.cycles+=6;
	w.pc+=4;
	w.P = w.C[I[3]];
	PCHANGED;
	continue;
}

o80E: // SREQ?
{
	w.cycles+=7;
	w.pc+=3;
	w.C[0]=0;
	InfoMessage("SREQ? instruction executed.");
	continue;
}

o80Fn: // CPEX n
{
	BYTE n = w.P;
	w.P = w.C[I[3]];
	w.C[I[3]] = n;
	PCHANGED;
	w.cycles+=6;
	w.pc+=4;
	continue;
}

o810: // ASLC
{
	w.cycles+=21;
	w.pc+=3;
	Nslc(w.A, 16);
	continue;
}

o811: // BSLC
{
	w.cycles+=21;
	w.pc+=3;
	Nslc(w.B, 16);
	continue;
}

o812: // CSLC
{
	w.cycles+=21;
	w.pc+=3;
	Nslc(w.C, 16);
	continue;
}

o813: // DSLC
{
	w.cycles+=21;
	w.pc+=3;
	Nslc(w.D, 16);
	continue;
}
	  
o814: // ASRC
{
	w.cycles+=21;
	w.pc+=3;
	Nsrc(w.A, 16);
	continue;
}

o815: // BSRC
{
	w.cycles+=21;
	w.pc+=3;
	Nsrc(w.B, 16);
	continue;
}

o816: // CSRC
{
	w.cycles+=21;
	w.pc+=3;
	Nsrc(w.C, 16);
	continue;
}

o817: // DSRC
{
	w.cycles+=21;
	w.pc+=3;
	Nsrc(w.D, 16);
	continue;
}

o818f0x: // A=A+x+1 f
{
	// 15.02.99 cg, changed, register length with saturn bug emulation
	UINT nF_l = (F_l[I[3]] == 1) ? 0x11 : F_l[I[3]];

	w.cycles+=5+F_l[I[3]];					// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=6;
	w.A[F_s[I[3]]]+=I[5];					// add constant value-1
	Ninc16(w.A,nF_l,F_s[I[3]]);				// 15.02.99 cg, bugfix, add one and adjust in HEX mode
	continue;
}

o818f1x: // B=B+x+1 f
{
	// 15.02.99 cg, changed, register length with saturn bug emulation
	UINT nF_l = (F_l[I[3]] == 1) ? 0x11 : F_l[I[3]];

	w.cycles+=5+F_l[I[3]];					// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=6;
	w.B[F_s[I[3]]]+=I[5];					// add constant value-1
	Ninc16(w.B,nF_l,F_s[I[3]]);				// 15.02.99 cg, bugfix, add one and adjust in HEX mode
	continue;
}

o818f2x: // C=C+x+1 f
{
	// 15.02.99 cg, changed, register length with saturn bug emulation
	UINT nF_l = (F_l[I[3]] == 1) ? 0x11 : F_l[I[3]];

	w.cycles+=5+F_l[I[3]];					// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=6;
	w.C[F_s[I[3]]]+=I[5];					// add constant value-1
	Ninc16(w.C,nF_l,F_s[I[3]]);				// 15.02.99 cg, bugfix, add one and adjust in HEX mode
	continue;
}

o818f3x: // D=D+x+1 f
{
	// 15.02.99 cg, changed, register length with saturn bug emulation
	UINT nF_l = (F_l[I[3]] == 1) ? 0x11 : F_l[I[3]];

	w.cycles+=5+F_l[I[3]];					// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=6;
	w.D[F_s[I[3]]]+=I[5];					// add constant value-1
	Ninc16(w.D,nF_l,F_s[I[3]]);				// 15.02.99 cg, bugfix, add one and adjust in HEX mode
	// 24.03.98 cg, end of saturn bug emulation
	continue;
}
		 
o818f8x: // A=A-x-1 f
{
	// 15.02.99 cg, changed, register length with saturn bug emulation
	UINT nF_l = (F_l[I[3]] == 1) ? 0x11 : F_l[I[3]];

	w.cycles+=5+F_l[I[3]];					// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=6;
	w.A[F_s[I[3]]]-=I[5];					// sub constant value+1
	Ndec16(w.A,nF_l,F_s[I[3]]);				// 15.02.99 cg, bugfix, dec one and adjust in HEX mode
	continue;
}

o818f9x: // B=B-x-1 f
{
	// 15.02.99 cg, changed, register length with saturn bug emulation
	UINT nF_l = (F_l[I[3]] == 1) ? 0x11 : F_l[I[3]];

	w.cycles+=5+F_l[I[3]];					// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=6;
	w.B[F_s[I[3]]]-=I[5];					// sub constant value+1
	Ndec16(w.B,nF_l,F_s[I[3]]);				// 15.02.99 cg, bugfix, dec one and adjust in HEX mode
	continue;
}

o818fAx: // C=C-x-1 f
{
	// 15.02.99 cg, changed, register length with saturn bug emulation
	UINT nF_l = (F_l[I[3]] == 1) ? 0x11 : F_l[I[3]];

	w.cycles+=5+F_l[I[3]];					// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=6;
	w.C[F_s[I[3]]]-=I[5];					// sub constant value+1
	Ndec16(w.C,nF_l,F_s[I[3]]);				// 15.02.99 cg, bugfix, dec one and adjust in HEX mode
	continue;
}

o818fBx: // D=D-x-1 f
{
	// 15.02.99 cg, changed, register length with saturn bug emulation
	UINT nF_l = (F_l[I[3]] == 1) ? 0x11 : F_l[I[3]];

	w.cycles+=5+F_l[I[3]];					// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=6;
	w.D[F_s[I[3]]]-=I[5];					// sub constant value+1
	Ndec16(w.D,nF_l,F_s[I[3]]);				// 15.02.99 cg, bugfix, dec one and adjust in HEX mode
	continue;
}

o819f0: // ASRB
{
	w.cycles+=20;
	w.pc+=5;
	NFsrb(w.A, I[3]);
	continue;
}

o819f1: // BSRB
{
	w.cycles+=20;
	w.pc+=5;
	NFsrb(w.B, I[3]);
	continue;
}

o819f2: // CSRB
{
	w.cycles+=20;
	w.pc+=5;
	NFsrb(w.C, I[3]);
	continue;
}

o819f3: // DSRB
{
	w.cycles+=20;
	w.pc+=5;
	NFsrb(w.D, I[3]);
	continue;
}

o81Af00: // R0=A f
{
	w.cycles+=6+F_l[I[3]];					// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=6;
	NFcopy(w.R0, w.A, I[3]);
	continue;
}

o81Af01: // R1=A f
{
	w.cycles+=6+F_l[I[3]];					// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=6;
	NFcopy(w.R1, w.A, I[3]);
	continue;
}

o81Af02: // R2=A f
{
	w.cycles+=6+F_l[I[3]];					// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=6;
	NFcopy(w.R2, w.A, I[3]);
	continue;
}

o81Af03: // R3=A f
{
	w.cycles+=6+F_l[I[3]];					// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=6;
	NFcopy(w.R3, w.A, I[3]);
	continue;
}

o81Af04: // R4=A f
{
	w.cycles+=6+F_l[I[3]];					// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=6;
	NFcopy(w.R4, w.A, I[3]);
	continue;
}

o81Af08: // R0=C f
{
	w.cycles+=6+F_l[I[3]];					// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=6;
	NFcopy(w.R0, w.C, I[3]);
	continue;
}

o81Af09: // R1=C f
{
	w.cycles+=6+F_l[I[3]];					// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=6;
	NFcopy(w.R1, w.C, I[3]);
	continue;
}

o81Af0A: // R2=C f
{
	w.cycles+=6+F_l[I[3]];					// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=6;
	NFcopy(w.R2, w.C, I[3]);
	continue;
}

o81Af0B: // R3=C f
{
	w.cycles+=6+F_l[I[3]];					// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=6;
	NFcopy(w.R3, w.C, I[3]);
	continue;
}

o81Af0C: // R4=C f
{
	w.cycles+=6+F_l[I[3]];					// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=6;
	NFcopy(w.R4, w.C, I[3]);
	continue;
}

o81Af10: // A=R0 f
{
	w.cycles+=6+F_l[I[3]];					// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=6;
	NFcopy(w.A, w.R0, I[3]);
	continue;
}

o81Af11: // A=R1 f
{
	w.cycles+=6+F_l[I[3]];					// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=6;
	NFcopy(w.A, w.R1, I[3]);
	continue;
}

o81Af12: // A=R2 f
{
	w.cycles+=6+F_l[I[3]];					// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=6;
	NFcopy(w.A, w.R2, I[3]);
	continue;
}

o81Af13: // A=R3 f
{
	w.cycles+=6+F_l[I[3]];					// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=6;
	NFcopy(w.A, w.R3, I[3]);
	continue;
}

o81Af14: // A=R4 f
{
	w.cycles+=6+F_l[I[3]];					// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=6;
	NFcopy(w.A, w.R4, I[3]);
	continue;
}

o81Af18: // C=R0 f
{
	w.cycles+=6+F_l[I[3]];					// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=6;
	NFcopy(w.C, w.R0, I[3]);
	continue;
}

o81Af19: // C=R1 f
{
	w.cycles+=6+F_l[I[3]];					// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=6;
	NFcopy(w.C, w.R1, I[3]);
	continue;
}

o81Af1A: // C=R2 f
{
	w.cycles+=6+F_l[I[3]];					// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=6;
	NFcopy(w.C, w.R2, I[3]);
	continue;
}

o81Af1B: // C=R3 f
{
	w.cycles+=6+F_l[I[3]];					// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=6;
	NFcopy(w.C, w.R3, I[3]);
	continue;
}

o81Af1C: // C=R4 f
{
	w.cycles+=6+F_l[I[3]];					// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=6;
	NFcopy(w.C, w.R4, I[3]);
	continue;
}

o81Af20: // AR0EX f
{
	w.cycles+=6+F_l[I[3]];					// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=6;
	NFxchg(w.A, w.R0, I[3]);
	continue;
}

o81Af21: // AR1EX f
{
	w.cycles+=6+F_l[I[3]];					// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=6;
	NFxchg(w.A, w.R1, I[3]);
	continue;
}

o81Af22: // AR2EX f
{
	w.cycles+=6+F_l[I[3]];					// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=6;
	NFxchg(w.A, w.R2, I[3]);
	continue;
}

o81Af23: // AR3EX f
{
	w.cycles+=6+F_l[I[3]];					// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=6;
	NFxchg(w.A, w.R3, I[3]);
	continue;
}

o81Af24: // AR4EX f
{
	w.cycles+=6+F_l[I[3]];					// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=6;
	NFxchg(w.A, w.R4, I[3]);
	continue;
}

o81Af28: // CR0EX f
{
	w.cycles+=6+F_l[I[3]];					// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=6;
	NFxchg(w.C, w.R0, I[3]);
	continue;
}

o81Af29: // CR1EX f
{
	w.cycles+=6+F_l[I[3]];					// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=6;
	NFxchg(w.C, w.R1, I[3]);
	continue;
}

o81Af2A: // CR2EX f
{
	w.cycles+=6+F_l[I[3]];					// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=6;
	NFxchg(w.C, w.R2, I[3]);
	continue;
}

o81Af2B: // CR3EX f
{
	w.cycles+=6+F_l[I[3]];					// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=6;
	NFxchg(w.C, w.R3, I[3]);
	continue;
}

o81Af2C: // CR4EX f
{
	w.cycles+=6+F_l[I[3]];					// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=6;
	NFxchg(w.C, w.R4, I[3]);
	continue;
}

o81B2: // PC=A
{
	w.cycles+=16;							// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc = Npack(w.A,5);
	continue;
}

o81B3: // PC=C
{
	w.cycles+=16;							// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc = Npack(w.C,5);
	continue;
}
 
o81B4: // A=PC
{
	w.cycles+=9;							// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=4;
	Nunpack(w.A,w.pc,5);
	continue;
}

o81B5: // C=PC
{
	w.cycles+=9;							// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=4;
	Nunpack(w.C,w.pc,5);
	continue;
}

o81B6: // APCEX
{
	DWORD d=w.pc+4;
	w.cycles+=16;							// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc=Npack(w.A,5);
	Nunpack(w.A,d,5);
	continue;
}

o81B7: // CPCEX
{
	DWORD d=w.pc+4;
	w.cycles+=16;							// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc=Npack(w.C,5);
	Nunpack(w.C,d,5);
	continue;
}

o81C: // ASRB
{
	w.cycles+=20;
	w.pc+=3;
	Nsrb(w.A, 16);
	continue;
}

o81D: // BSRB
{
	w.cycles+=20;
	w.pc+=3;
	Nsrb(w.B, 16);
	continue;
}

o81E: // CSRB
{
	w.cycles+=20;
	w.pc+=3;
	Nsrb(w.C, 16);
	continue;
}

o81F: // DSRB
{
	w.cycles+=20;
	w.pc+=3;
	Nsrb(w.D, 16);
	continue;
}
	  
o82n: // HST=0 m
{
	w.cycles+=3;							// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=3;
	w.HST&=~I[2];
	continue;
}

o83n: // ?HST=0 m
{
	w.cycles+=6;							// cg, cycles undocumented, fetched from JAZZ V6.5
	w.pc+=3;
	if ((w.HST&I[2])==0)
		w.carry=TRUE;
	else
		w.carry=FALSE;
	GOYES3;
}

o84n: // ST=0 n
{
	w.cycles+=4;
	w.pc+=3;
	Nbit0(w.ST, I[2]);
	continue;
}

o85n: // ST=1 n
{
	w.cycles+=4;
	w.pc+=3;
	Nbit1(w.ST, I[2]);
	continue;
}

o86n: // ?ST=0 n
{
	w.cycles+=7;
	w.pc+=3;
	Tbit0(w.ST, I[2]);
	GOYES3;
}

o87n: // ?ST=1 n
{
	w.cycles+=7;
	w.pc+=3;
	Tbit1(w.ST, I[2]);
	GOYES3;
}
	  
o88n: // ?P# n
{
	w.cycles+=6;
	w.pc+=3;
	if (w.P!=I[2])
		w.carry=TRUE;
	else
		w.carry=FALSE;
	GOYES3;
}

o89n: // ?P= n
{
	w.cycles+=6;
	w.pc+=3;
	if (w.P==I[2])
		w.carry=TRUE;
	else
		w.carry=FALSE;
	GOYES3;
}

o8A0: // ?A=B A
{
	w.cycles+=11;
	w.pc+=3;
	Te(w.A, w.B, 5);
	GOYES3;
}

o8A1: // ?B=C A
{
	w.cycles+=11;
	w.pc+=3;
	Te(w.B, w.C, 5);
	GOYES3;
}

o8A2: // ?C=A A
{
	w.cycles+=11;
	w.pc+=3;
	Te(w.C, w.A, 5);
	GOYES3;
}

o8A3: // ?D=C A
{
	w.cycles+=11;
	w.pc+=3;
	Te(w.D, w.C, 5);
	GOYES3;
}

o8A4: // ?A#B A
{
	w.cycles+=11;
	w.pc+=3;
	Tne(w.A, w.B, 5);
	GOYES3;
}

o8A5: // ?B#C A
{
	w.cycles+=11;
	w.pc+=3;
	Tne(w.B, w.C, 5);
	GOYES3;
}

o8A6: // ?C#A A
{
	w.cycles+=11;
	w.pc+=3;
	Tne(w.C, w.A, 5);
	GOYES3;
}

o8A7: // ?D#C A
{
	w.cycles+=11;
	w.pc+=3;
	Tne(w.D, w.C, 5);
	GOYES3;
}

o8A8: // ?A=0 A
{
	w.cycles+=11;
	w.pc+=3;
	Tz(w.A, 5);
	GOYES3;
}

o8A9: // ?B=0 A
{
	w.cycles+=11;
	w.pc+=3;
	Tz(w.B, 5);
	GOYES3;
}

o8AA: // ?C=0 A
{
	w.cycles+=11;
	w.pc+=3;
	Tz(w.C, 5);
	GOYES3;
}

o8AB: // ?D=0 A
{
	w.cycles+=11;
	w.pc+=3;
	Tz(w.D, 5);
	GOYES3;
}

o8AC: // ?A#0 A
{
	w.cycles+=11;
	w.pc+=3;
	Tnz(w.A, 5);
	GOYES3;
}

o8AD: // ?B#0 A
{
	w.cycles+=11;
	w.pc+=3;
	Tnz(w.B, 5);
	GOYES3;
}

o8AE: // ?C#0 A
{
	w.cycles+=11;
	w.pc+=3;
	Tnz(w.C, 5);
	GOYES3;
}

o8AF: // ?D#0 A
{
	w.cycles+=11;
	w.pc+=3;
	Tnz(w.D, 5);
	GOYES3;
}

o8B0: // ?A>B A
{
	w.cycles+=11;
	w.pc+=3;
	Ta(w.A, w.B, 5);
	GOYES3;
}

o8B1: // ?B>C A
{
	w.cycles+=11;
	w.pc+=3;
	Ta(w.B, w.C, 5);
	GOYES3;
}

o8B2: // ?C>A A
{
	w.cycles+=11;
	w.pc+=3;
	Ta(w.C, w.A, 5);
	GOYES3;
}

o8B3: // ?D>C A
{
	w.cycles+=11;
	w.pc+=3;
	Ta(w.D, w.C, 5);
	GOYES3;
}

o8B4: // ?A<B A
{
	w.cycles+=11;
	w.pc+=3;
	Tb(w.A, w.B, 5);
	GOYES3;
}

o8B5: // ?B<C A
{
	w.cycles+=11;
	w.pc+=3;
	Tb(w.B, w.C, 5);
	GOYES3;
}

o8B6: // ?C<A A
{
	w.cycles+=11;
	w.pc+=3;
	Tb(w.C, w.A, 5);
	GOYES3;
}

o8B7: // ?D<C A
{
	w.cycles+=11;
	w.pc+=3;
	Tb(w.D, w.C, 5);
	GOYES3;
}

o8B8: // ?A>=B A
{
	w.cycles+=11;
	w.pc+=3;
	Tae(w.A, w.B, 5);
	GOYES3;
}

o8B9: // ?B>=C A
{
	w.cycles+=11;
	w.pc+=3;
	Tae(w.B, w.C, 5);
	GOYES3;
}

o8BA: // ?C>=A A
{
	w.cycles+=11;
	w.pc+=3;
	Tae(w.C, w.A, 5);
	GOYES3;
}

o8BB: // ?D>=C A
{
	w.cycles+=11;
	w.pc+=3;
	Tae(w.D, w.C, 5);
	GOYES3;
}

o8BC: // ?A<=B A
{
	w.cycles+=11;
	w.pc+=3;
	Tbe(w.A, w.B, 5);
	GOYES3;
}

o8BD: // ?B<=C A
{
	w.cycles+=11;
	w.pc+=3;
	Tbe(w.B, w.C, 5);
	GOYES3;
}

o8BE: // ?C<=A A
{
	w.cycles+=11;
	w.pc+=3;
	Tbe(w.C, w.A, 5);
	GOYES3;
}

o8BF: // ?D<=C A
{
	w.cycles+=11;
	w.pc+=3;
	Tbe(w.D, w.C, 5);
	GOYES3;
}

o8Cd4: // GOLONG #dddd
{
	DWORD d=Npack(I+2, 4);
	if (d&0x8000) w.pc-=0xfffe-d; else w.pc+=d+2;
	w.cycles+=14;
	w.pc&=0xFFFFF;
	continue;
}
	  
o8Dd5: // GOVLNG #ddddd
{
	w.cycles+=14;
	w.pc = Npack(I+2, 5);
	continue;
}
	  
o8Ed4: // GOSUBL #dddd
{
	DWORD d=Npack(I+2,4);
	rstkpush(w.pc+6);
	if (d&0x8000) w.pc-=0xfffa-d; else w.pc+=d+6;
	w.cycles+=15;
	w.pc&=0xFFFFF;
	continue;
}
	  
o8Fd5: // GOSBVL #ddddd
{
	w.cycles+=15;
	rstkpush(w.pc+7);
	w.pc=Npack(I+2, 5);
	continue;
}

      // ?r=s f
o9a0: w.cycles+=6+F_l[I[1]]; w.pc+=3; TFe(w.A, w.B, I[1]); GOYES3;
o9a1: w.cycles+=6+F_l[I[1]]; w.pc+=3; TFe(w.B, w.C, I[1]); GOYES3;
o9a2: w.cycles+=6+F_l[I[1]]; w.pc+=3; TFe(w.C, w.A, I[1]); GOYES3;
o9a3: w.cycles+=6+F_l[I[1]]; w.pc+=3; TFe(w.D, w.C, I[1]); GOYES3;
	  
	  // ?r#s f
o9a4: w.cycles+=6+F_l[I[1]]; w.pc+=3; TFne(w.A, w.B, I[1]); GOYES3;
o9a5: w.cycles+=6+F_l[I[1]]; w.pc+=3; TFne(w.B, w.C, I[1]); GOYES3;
o9a6: w.cycles+=6+F_l[I[1]]; w.pc+=3; TFne(w.C, w.A, I[1]); GOYES3;
o9a7: w.cycles+=6+F_l[I[1]]; w.pc+=3; TFne(w.D, w.C, I[1]); GOYES3;
	  
	  // ?r=0 f
o9a8: w.cycles+=6+F_l[I[1]]; w.pc+=3; TFz(w.A, I[1]); GOYES3;
o9a9: w.cycles+=6+F_l[I[1]]; w.pc+=3; TFz(w.B, I[1]); GOYES3;
o9aA: w.cycles+=6+F_l[I[1]]; w.pc+=3; TFz(w.C, I[1]); GOYES3;
o9aB: w.cycles+=6+F_l[I[1]]; w.pc+=3; TFz(w.D, I[1]); GOYES3;
	  
	  // ?r#0 f
o9aC: w.cycles+=6+F_l[I[1]]; w.pc+=3; TFnz(w.A, I[1]); GOYES3;
o9aD: w.cycles+=6+F_l[I[1]]; w.pc+=3; TFnz(w.B, I[1]); GOYES3;
o9aE: w.cycles+=6+F_l[I[1]]; w.pc+=3; TFnz(w.C, I[1]); GOYES3;
o9aF: w.cycles+=6+F_l[I[1]]; w.pc+=3; TFnz(w.D, I[1]); GOYES3;
	  
	  // ?s>r f
o9b0: w.cycles+=6+F_l[I[1]&7]; w.pc+=3; TFa(w.A, w.B, I[1]&7); GOYES3;
o9b1: w.cycles+=6+F_l[I[1]&7]; w.pc+=3; TFa(w.B, w.C, I[1]&7); GOYES3;
o9b2: w.cycles+=6+F_l[I[1]&7]; w.pc+=3; TFa(w.C, w.A, I[1]&7); GOYES3;
o9b3: w.cycles+=6+F_l[I[1]&7]; w.pc+=3; TFa(w.D, w.C, I[1]&7); GOYES3;
	  
	  // ?r<s f
o9b4: w.cycles+=6+F_l[I[1]&7]; w.pc+=3; TFb(w.A, w.B, I[1]&7); GOYES3;
o9b5: w.cycles+=6+F_l[I[1]&7]; w.pc+=3; TFb(w.B, w.C, I[1]&7); GOYES3;
o9b6: w.cycles+=6+F_l[I[1]&7]; w.pc+=3; TFb(w.C, w.A, I[1]&7); GOYES3;
o9b7: w.cycles+=6+F_l[I[1]&7]; w.pc+=3; TFb(w.D, w.C, I[1]&7); GOYES3;
	  
	  // ?r>=s f
o9b8: w.cycles+=6+F_l[I[1]&7]; w.pc+=3; TFae(w.A, w.B, I[1]&7); GOYES3;
o9b9: w.cycles+=6+F_l[I[1]&7]; w.pc+=3; TFae(w.B, w.C, I[1]&7); GOYES3;
o9bA: w.cycles+=6+F_l[I[1]&7]; w.pc+=3; TFae(w.C, w.A, I[1]&7); GOYES3;
o9bB: w.cycles+=6+F_l[I[1]&7]; w.pc+=3; TFae(w.D, w.C, I[1]&7); GOYES3;
	  
	  // ?r<=s f
o9bC: w.cycles+=6+F_l[I[1]&7]; w.pc+=3; TFbe(w.A, w.B, I[1]&7); GOYES3;
o9bD: w.cycles+=6+F_l[I[1]&7]; w.pc+=3; TFbe(w.B, w.C, I[1]&7); GOYES3;
o9bE: w.cycles+=6+F_l[I[1]&7]; w.pc+=3; TFbe(w.C, w.A, I[1]&7); GOYES3;
o9bF: w.cycles+=6+F_l[I[1]&7]; w.pc+=3; TFbe(w.D, w.C, I[1]&7); GOYES3;
	  
	  // r=r+s f
oAa0: w.cycles+=3+F_l[I[1]]; w.pc+=3; NFadd(w.A, w.B, I[1]); continue;
oAa1: w.cycles+=3+F_l[I[1]]; w.pc+=3; NFadd(w.B, w.C, I[1]); continue;
oAa2: w.cycles+=3+F_l[I[1]]; w.pc+=3; NFadd(w.C, w.A, I[1]); continue;
oAa3: w.cycles+=3+F_l[I[1]]; w.pc+=3; NFadd(w.D, w.C, I[1]); continue;
	  
	  // r=r+r f
oAa4: w.cycles+=3+F_l[I[1]]; w.pc+=3; NFadd(w.A, w.A, I[1]); continue; // 25.03.98 cg, replaced NFdbl()
oAa5: w.cycles+=3+F_l[I[1]]; w.pc+=3; NFadd(w.B, w.B, I[1]); continue; // 25.03.98 cg, replaced NFdbl()
oAa6: w.cycles+=3+F_l[I[1]]; w.pc+=3; NFadd(w.C, w.C, I[1]); continue; // 25.03.98 cg, replaced NFdbl()
oAa7: w.cycles+=3+F_l[I[1]]; w.pc+=3; NFadd(w.D, w.D, I[1]); continue; // 25.03.98 cg, replaced NFdbl()
	  
	  // s=s+r f
oAa8: w.cycles+=3+F_l[I[1]]; w.pc+=3; NFadd(w.B, w.A, I[1]); continue;
oAa9: w.cycles+=3+F_l[I[1]]; w.pc+=3; NFadd(w.C, w.B, I[1]); continue;
oAaA: w.cycles+=3+F_l[I[1]]; w.pc+=3; NFadd(w.A, w.C, I[1]); continue;
oAaB: w.cycles+=3+F_l[I[1]]; w.pc+=3; NFadd(w.C, w.D, I[1]); continue;
	  
	  // r=r-1 f
oAaC: w.cycles+=3+F_l[I[1]]; w.pc+=3; NFdec(w.A, I[1]); continue;
oAaD: w.cycles+=3+F_l[I[1]]; w.pc+=3; NFdec(w.B, I[1]); continue;
oAaE: w.cycles+=3+F_l[I[1]]; w.pc+=3; NFdec(w.C, I[1]); continue;
oAaF: w.cycles+=3+F_l[I[1]]; w.pc+=3; NFdec(w.D, I[1]); continue;
	  
	  // r=0 f
oAb0: w.cycles+=3+F_l[I[1]&7]; w.pc+=3; NFzero(w.A, I[1]&7); continue;
oAb1: w.cycles+=3+F_l[I[1]&7]; w.pc+=3; NFzero(w.B, I[1]&7); continue;
oAb2: w.cycles+=3+F_l[I[1]&7]; w.pc+=3; NFzero(w.C, I[1]&7); continue;
oAb3: w.cycles+=3+F_l[I[1]&7]; w.pc+=3; NFzero(w.D, I[1]&7); continue;
	  
	  // r=s f
oAb4: w.cycles+=3+F_l[I[1]&7]; w.pc+=3; NFcopy(w.A, w.B, I[1]&7); continue;
oAb5: w.cycles+=3+F_l[I[1]&7]; w.pc+=3; NFcopy(w.B, w.C, I[1]&7); continue;
oAb6: w.cycles+=3+F_l[I[1]&7]; w.pc+=3; NFcopy(w.C, w.A, I[1]&7); continue;
oAb7: w.cycles+=3+F_l[I[1]&7]; w.pc+=3; NFcopy(w.D, w.C, I[1]&7); continue;
	  
	  // s=r f
oAb8: w.cycles+=3+F_l[I[1]&7]; w.pc+=3; NFcopy(w.B, w.A, I[1]&7); continue;
oAb9: w.cycles+=3+F_l[I[1]&7]; w.pc+=3; NFcopy(w.C, w.B, I[1]&7); continue;
oAbA: w.cycles+=3+F_l[I[1]&7]; w.pc+=3; NFcopy(w.A, w.C, I[1]&7); continue;
oAbB: w.cycles+=3+F_l[I[1]&7]; w.pc+=3; NFcopy(w.C, w.D, I[1]&7); continue;
	  
	  // rsEX f
oAbC: w.cycles+=3+F_l[I[1]&7]; w.pc+=3; NFxchg(w.A, w.B, I[1]&7); continue;
oAbD: w.cycles+=3+F_l[I[1]&7]; w.pc+=3; NFxchg(w.B, w.C, I[1]&7); continue;
oAbE: w.cycles+=3+F_l[I[1]&7]; w.pc+=3; NFxchg(w.C, w.A, I[1]&7); continue;
oAbF: w.cycles+=3+F_l[I[1]&7]; w.pc+=3; NFxchg(w.D, w.C, I[1]&7); continue;
	  
	  // r=r-s f
oBa0: w.cycles+=3+F_l[I[1]]; w.pc+=3; NFsub(w.A, w.B, I[1]); continue;
oBa1: w.cycles+=3+F_l[I[1]]; w.pc+=3; NFsub(w.B, w.C, I[1]); continue;
oBa2: w.cycles+=3+F_l[I[1]]; w.pc+=3; NFsub(w.C, w.A, I[1]); continue;
oBa3: w.cycles+=3+F_l[I[1]]; w.pc+=3; NFsub(w.D, w.C, I[1]); continue;
	  
	  // r=r+1 f
oBa4: w.cycles+=3+F_l[I[1]]; w.pc+=3; NFinc(w.A, I[1]); continue;
oBa5: w.cycles+=3+F_l[I[1]]; w.pc+=3; NFinc(w.B, I[1]); continue;
oBa6: w.cycles+=3+F_l[I[1]]; w.pc+=3; NFinc(w.C, I[1]); continue;
oBa7: w.cycles+=3+F_l[I[1]]; w.pc+=3; NFinc(w.D, I[1]); continue;
	  
	  // s=s-r f
oBa8: w.cycles+=3+F_l[I[1]]; w.pc+=3; NFsub(w.B, w.A, I[1]); continue;
oBa9: w.cycles+=3+F_l[I[1]]; w.pc+=3; NFsub(w.C, w.B, I[1]); continue;
oBaA: w.cycles+=3+F_l[I[1]]; w.pc+=3; NFsub(w.A, w.C, I[1]); continue;
oBaB: w.cycles+=3+F_l[I[1]]; w.pc+=3; NFsub(w.C, w.D, I[1]); continue;
	  
	  // r=s-r f
oBaC: w.cycles+=3+F_l[I[1]]; w.pc+=3; NFrsub(w.A, w.B, I[1]); continue;
oBaD: w.cycles+=3+F_l[I[1]]; w.pc+=3; NFrsub(w.B, w.C, I[1]); continue;
oBaE: w.cycles+=3+F_l[I[1]]; w.pc+=3; NFrsub(w.C, w.A, I[1]); continue;
oBaF: w.cycles+=3+F_l[I[1]]; w.pc+=3; NFrsub(w.D, w.C, I[1]); continue;
	  
	  // rSL f
oBb0: w.cycles+=3+F_l[I[1]&7]; w.pc+=3; NFsl(w.A, I[1]&7); continue;
oBb1: w.cycles+=3+F_l[I[1]&7]; w.pc+=3; NFsl(w.B, I[1]&7); continue;
oBb2: w.cycles+=3+F_l[I[1]&7]; w.pc+=3; NFsl(w.C, I[1]&7); continue;
oBb3: w.cycles+=3+F_l[I[1]&7]; w.pc+=3; NFsl(w.D, I[1]&7); continue;
	  
	  // rSR f
oBb4: w.cycles+=3+F_l[I[1]&7]; w.pc+=3; NFsr(w.A, I[1]&7); continue;
oBb5: w.cycles+=3+F_l[I[1]&7]; w.pc+=3; NFsr(w.B, I[1]&7); continue;
oBb6: w.cycles+=3+F_l[I[1]&7]; w.pc+=3; NFsr(w.C, I[1]&7); continue;
oBb7: w.cycles+=3+F_l[I[1]&7]; w.pc+=3; NFsr(w.D, I[1]&7); continue;
	  
	  // r=-r f
oBb8: w.cycles+=3+F_l[I[1]&7]; w.pc+=3; NFneg(w.A, I[1]&7); continue;
oBb9: w.cycles+=3+F_l[I[1]&7]; w.pc+=3; NFneg(w.B, I[1]&7); continue;
oBbA: w.cycles+=3+F_l[I[1]&7]; w.pc+=3; NFneg(w.C, I[1]&7); continue;
oBbB: w.cycles+=3+F_l[I[1]&7]; w.pc+=3; NFneg(w.D, I[1]&7); continue;
	  
	  // r=-r-1 f
oBbC: w.cycles+=3+F_l[I[1]&7]; w.pc+=3; NFnot(w.A, I[1]&7); continue;
oBbD: w.cycles+=3+F_l[I[1]&7]; w.pc+=3; NFnot(w.B, I[1]&7); continue;
oBbE: w.cycles+=3+F_l[I[1]&7]; w.pc+=3; NFnot(w.C, I[1]&7); continue;
oBbF: w.cycles+=3+F_l[I[1]&7]; w.pc+=3; NFnot(w.D, I[1]&7); continue;
	  
	 // r=r+s A
oC0: w.cycles+=7; w.pc+=2; Nadd(w.A, w.B, 5); continue;
oC1: w.cycles+=7; w.pc+=2; Nadd(w.B, w.C, 5); continue;
oC2: w.cycles+=7; w.pc+=2; Nadd(w.C, w.A, 5); continue;
oC3: w.cycles+=7; w.pc+=2; Nadd(w.D, w.C, 5); continue;
	 
	 // r=r+r A
oC4: w.cycles+=7; w.pc+=2; Nadd(w.A, w.A, 5); continue; // 25.03.98 cg, replaced Ndbl()
oC5: w.cycles+=7; w.pc+=2; Nadd(w.B, w.B, 5); continue; // 25.03.98 cg, replaced Ndbl()
oC6: w.cycles+=7; w.pc+=2; Nadd(w.C, w.C, 5); continue; // 25.03.98 cg, replaced Ndbl()
oC7: w.cycles+=7; w.pc+=2; Nadd(w.D, w.D, 5); continue; // 25.03.98 cg, replaced Ndbl()
	 
	 // s=s+r A
oC8: w.cycles+=7; w.pc+=2; Nadd(w.B, w.A, 5); continue;
oC9: w.cycles+=7; w.pc+=2; Nadd(w.C, w.B, 5); continue;
oCA: w.cycles+=7; w.pc+=2; Nadd(w.A, w.C, 5); continue;
oCB: w.cycles+=7; w.pc+=2; Nadd(w.C, w.D, 5); continue;
	 
	 // r=r-1 A
oCC: w.cycles+=7; w.pc+=2; Ndec(w.A, 5, 0); continue; // 24.03.98 cg, changed
oCD: w.cycles+=7; w.pc+=2; Ndec(w.B, 5, 0); continue; // 24.03.98 cg, changed
oCE: w.cycles+=7; w.pc+=2; Ndec(w.C, 5, 0); continue; // 24.03.98 cg, changed
oCF: w.cycles+=7; w.pc+=2; Ndec(w.D, 5, 0); continue; // 24.03.98 cg, changed
	 
	 // r=0 A
oD0: w.cycles+=7; w.pc+=2; memset(w.A, 0, 5); continue;
oD1: w.cycles+=7; w.pc+=2; memset(w.B, 0, 5); continue;
oD2: w.cycles+=7; w.pc+=2; memset(w.C, 0, 5); continue;
oD3: w.cycles+=7; w.pc+=2; memset(w.D, 0, 5); continue;
	 
	 // r=s A
oD4: w.cycles+=7; w.pc+=2; memcpy(w.A, w.B, 5); continue;
oD5: w.cycles+=7; w.pc+=2; memcpy(w.B, w.C, 5); continue;
oD6: w.cycles+=7; w.pc+=2; memcpy(w.C, w.A, 5); continue;
oD7: w.cycles+=7; w.pc+=2; memcpy(w.D, w.C, 5); continue;
	 
	 // s=r A
oD8: w.cycles+=7; w.pc+=2; memcpy(w.B, w.A, 5); continue;
oD9: w.cycles+=7; w.pc+=2; memcpy(w.C, w.B, 5); continue;
oDA: w.cycles+=7; w.pc+=2; memcpy(w.A, w.C, 5); continue;
oDB: w.cycles+=7; w.pc+=2; memcpy(w.C, w.D, 5); continue;
	 
	 // rsEX
oDC: w.cycles+=7; w.pc+=2; Nxchg(w.A, w.B, 5); continue;
oDD: w.cycles+=7; w.pc+=2; Nxchg(w.B, w.C, 5); continue;
oDE: w.cycles+=7; w.pc+=2; Nxchg(w.C, w.A, 5); continue;
oDF: w.cycles+=7; w.pc+=2; Nxchg(w.D, w.C, 5); continue;
	 
	 // r=r-s A
oE0: w.cycles+=7; w.pc+=2; Nsub(w.A, w.B, 5); continue;
oE1: w.cycles+=7; w.pc+=2; Nsub(w.B, w.C, 5); continue;
oE2: w.cycles+=7; w.pc+=2; Nsub(w.C, w.A, 5); continue;
oE3: w.cycles+=7; w.pc+=2; Nsub(w.D, w.C, 5); continue;
	 
	 // r=r+1 A
oE4: w.cycles+=7; w.pc+=2; Ninc(w.A, 5, 0); continue; // 24.03.98 cg, changed
oE5: w.cycles+=7; w.pc+=2; Ninc(w.B, 5, 0); continue; // 24.03.98 cg, changed
oE6: w.cycles+=7; w.pc+=2; Ninc(w.C, 5, 0); continue; // 24.03.98 cg, changed
oE7: w.cycles+=7; w.pc+=2; Ninc(w.D, 5, 0); continue; // 24.03.98 cg, changed
	 
	 // s=s-r A
oE8: w.cycles+=7; w.pc+=2; Nsub(w.B, w.A, 5); continue;
oE9: w.cycles+=7; w.pc+=2; Nsub(w.C, w.B, 5); continue;
oEA: w.cycles+=7; w.pc+=2; Nsub(w.A, w.C, 5); continue;
oEB: w.cycles+=7; w.pc+=2; Nsub(w.C, w.D, 5); continue;

	 // r=s-r A
oEC: w.cycles+=7; w.pc+=2; Nrsub(w.A, w.B, 5); continue;
oED: w.cycles+=7; w.pc+=2; Nrsub(w.B, w.C, 5); continue;
oEE: w.cycles+=7; w.pc+=2; Nrsub(w.C, w.A, 5); continue;
oEF: w.cycles+=7; w.pc+=2; Nrsub(w.D, w.C, 5); continue;
	 
	 // rSL A
oF0: w.cycles+=7; w.pc+=2; Nsl(w.A, 5); continue;
oF1: w.cycles+=7; w.pc+=2; Nsl(w.B, 5); continue;
oF2: w.cycles+=7; w.pc+=2; Nsl(w.C, 5); continue;
oF3: w.cycles+=7; w.pc+=2; Nsl(w.D, 5); continue;
	 
	 // rSR A
oF4: w.cycles+=7; w.pc+=2; Nsr(w.A, 5); continue;
oF5: w.cycles+=7; w.pc+=2; Nsr(w.B, 5); continue;
oF6: w.cycles+=7; w.pc+=2; Nsr(w.C, 5); continue;
oF7: w.cycles+=7; w.pc+=2; Nsr(w.D, 5); continue;
	 
	 // r=-r A
oF8: w.cycles+=7; w.pc+=2; Nneg(w.A, 5); continue;
oF9: w.cycles+=7; w.pc+=2; Nneg(w.B, 5); continue;
oFA: w.cycles+=7; w.pc+=2; Nneg(w.C, 5); continue;
oFB: w.cycles+=7; w.pc+=2; Nneg(w.D, 5); continue;
	 
	 // r=-r-1 A
oFC: w.cycles+=7; w.pc+=2; Nnot(w.A, 5); continue;
oFD: w.cycles+=7; w.pc+=2; Nnot(w.B, 5); continue;
oFE: w.cycles+=7; w.pc+=2; Nnot(w.C, 5); continue;
oFF: w.cycles+=7; w.pc+=2; Nnot(w.D, 5); continue;
	 
// invalid, unknown length : reset
o_invalid:
{
	_ASSERT(FALSE);								// invalid, unknow length
	w.pc=0;
	continue;
}

// length is guessed, just skip
o_invalid3:
{
	_ASSERT(FALSE);								// invalid, length guessed, skip 3 nibbles
	w.pc+=3;
	continue;
}

o_invalid4:
{
	_ASSERT(FALSE);								// invalid, length guessed, skip 4 nibbles
	w.pc+=4;
	continue;
}

o_invalid5:
{
	_ASSERT(FALSE);								// invalid, length guessed, skip 5 nibbles
	w.pc+=5;
	continue;
}

o_invalid6:
{
	_ASSERT(FALSE);								// invalid, length guessed, skip 6 nibbles
	w.pc+=6;
	continue;
}

o_goyes3:
{
	signed char jmp = I[3]+(I[4]<<4);
	w.cycles+=7;
	if (jmp)
		w.pc=(w.pc+jmp)&0xFFFFF;
	else
		w.pc=rstkpop();
	continue;
}

o_goyes5:
{
	signed char jmp = I[5]+(I[6]<<4);
	w.cycles+=7;
	if (jmp)
		w.pc=(w.pc+jmp)&0xFFFFF;
	else
		w.pc=rstkpop();
	continue;
}

//////// EXTENSIONS ////////
#if 0										// 05.01.99 cg, removed, unused extension
o81B0:
	// ?Win48
	w.HST |= SB;
	w.pc+=4;
	continue;
#endif

o81B1:
	External(&w);
	PCHANGED;								// 22.07.98 cg, new, update field select table
	continue;
////////////////////////////
