// bootmsx.h
BOOL LoadROMfile (HWND, char*, BYTE**, int*, WORD) ;

typedef struct tagMSXMEM
	{
	// before anything, the void
	BYTE	*pVoid ;
	// the standard ROM BIOSes
	BYTE	*pBIOS, *pSubBIOS, *pDiskBIOS ;
	// the RAM
	BYTE	*pMMRAM[16],*pRAM[4][4][4] ;
	// the cartridges
	BYTE	*pCarts[4] ;
	// ... the video memory, of course!
	BYTE	*pVideo ;
	BYTE	*pSurface, *pSurfaceBack ;
	// and now for the memory in MSX style:
	DWORD	dwLastVideoAddress ;
	BYTE	*pMap[4][4][4] ;
	BYTE	bSlotExpanded[4] ;
	BYTE	bMapType[4][4][4] ;
	BYTE	bLastMMpage[16] ;
	BYTE	bMaxMMpage ;
	BYTE	bLastCartPage[4] ;
	BYTE	bCartType[4] ;
	} MSXMEM ;

BOOL LoadMSXMemory (CONFIG*) ;
void FreeMSXMemory (CONFIG*) ;

#define ROM_CART					(0x4241)
#define ROM_BIOS					(0xc3f3)
#define ROM_SUBBIOS					(0x4443)

#define MAP_CARTA					0x00
#define MAP_CARTB					0x01
#define MAP_CARTC					0x02
#define MAP_CARTD					0x03
#define MAP_RAMMM					0x04
#define MAP_RAM						0x05
#define MAP_ROM						0x06

/*
#define MAP_MSXDOS2					0x03

#define MAP_CARTA					0x10
#define MAP_CARTB					0x20
#define MAP_CARTC					0x30

#define MAP_SCC						0x00
#define MAP_THSCCP					0x01
#define MAP_SDSCCP					0x02
#define MAP_KON4_8KB				0x03
#define MAP_KON4_16KB				0x04
#define MAP_KON5_8KB				0x05
#define MAP_KON5_16KB				0x06
#define MAP_ASCII_8KB				0x07
#define MAP_ASCII_16KB				0x08
#define MAP_GM2						0x09
*/
