// config.c
#include <windows.h>
#include "config.h"

CONFIG		g_cf ;

static CONFIG DefaultConfig = {
	CONFIG_VERSION_MSX1, 
	CONFIG_LANGUAGE_INT, 
	CONFIG_VRAM_128KB, 
	CONFIG_FPS_30, 
	FALSE, 
	CONFIG_INT_VAR, 
	CONFIG_SYNC_FRAME, 
	0, 0, 0, 0, 		36, 219, 36, 0, 
	109, 255, 109, 0, 	36, 36, 255, 0, 
	73, 109, 255, 0, 	182, 36, 36, 0, 
	73, 219, 255, 0, 	255, 36, 36, 0, 
	255, 109, 109, 0, 	219, 219, 36, 0, 
	219, 219, 146, 0, 	36, 146, 36, 0, 
	219, 73, 182, 0, 	182, 182, 182, 0, 
	255, 255, 255, 0, 
	TRUE,  CONFIG_CARTRIDGE_STANDARD, "", "", 
	TRUE,  CONFIG_CARTRIDGE_STANDARD, "", "", 
	FALSE, CONFIG_CARTRIDGE_STANDARD, "", "", 
	FALSE, CONFIG_CARTRIDGE_STANDARD, "", "", 
	// slot 0
	CONFIG_MEMORY_BIOS , CONFIG_MEMORY_BIOS , CONFIG_MEMORY_EMPTY, CONFIG_MEMORY_EMPTY, 
	CONFIG_MEMORY_EMPTY, CONFIG_MEMORY_EMPTY, CONFIG_MEMORY_EMPTY, CONFIG_MEMORY_EMPTY, 
	CONFIG_MEMORY_EMPTY, CONFIG_MEMORY_EMPTY, CONFIG_MEMORY_EMPTY, CONFIG_MEMORY_EMPTY, 
	CONFIG_MEMORY_EMPTY, CONFIG_MEMORY_EMPTY, CONFIG_MEMORY_EMPTY, CONFIG_MEMORY_EMPTY, 
	// slot 1
	CONFIG_MEMORY_CARTA, CONFIG_MEMORY_CARTA, CONFIG_MEMORY_CARTA, CONFIG_MEMORY_CARTA, 
	CONFIG_MEMORY_EMPTY, CONFIG_MEMORY_EMPTY, CONFIG_MEMORY_EMPTY, CONFIG_MEMORY_EMPTY, 
	CONFIG_MEMORY_EMPTY, CONFIG_MEMORY_EMPTY, CONFIG_MEMORY_EMPTY, CONFIG_MEMORY_EMPTY, 
	CONFIG_MEMORY_EMPTY, CONFIG_MEMORY_EMPTY, CONFIG_MEMORY_EMPTY, CONFIG_MEMORY_EMPTY, 
	// slot 2
	CONFIG_MEMORY_CARTB, CONFIG_MEMORY_CARTB, CONFIG_MEMORY_CARTB, CONFIG_MEMORY_CARTB, 
	CONFIG_MEMORY_EMPTY, CONFIG_MEMORY_EMPTY, CONFIG_MEMORY_EMPTY, CONFIG_MEMORY_EMPTY, 
	CONFIG_MEMORY_EMPTY, CONFIG_MEMORY_EMPTY, CONFIG_MEMORY_EMPTY, CONFIG_MEMORY_EMPTY, 
	CONFIG_MEMORY_EMPTY, CONFIG_MEMORY_EMPTY, CONFIG_MEMORY_EMPTY, CONFIG_MEMORY_EMPTY, 
	// slot 3
	CONFIG_MEMORY_RAM  , CONFIG_MEMORY_RAM  , CONFIG_MEMORY_RAM  , CONFIG_MEMORY_RAM  , 
	CONFIG_MEMORY_EMPTY, CONFIG_MEMORY_EMPTY, CONFIG_MEMORY_EMPTY, CONFIG_MEMORY_EMPTY, 
	CONFIG_MEMORY_EMPTY, CONFIG_MEMORY_EMPTY, CONFIG_MEMORY_EMPTY, CONFIG_MEMORY_EMPTY, 
	CONFIG_MEMORY_EMPTY, CONFIG_MEMORY_EMPTY, CONFIG_MEMORY_EMPTY, CONFIG_MEMORY_EMPTY, 
	// expanded
	FALSE, FALSE, FALSE, FALSE, 
	// mapper sizes
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 16 ? who knows.. */
	// volume
	TRUE, 0, 5, TRUE, 0, 5, TRUE, 0, 0, TRUE, 0, 0, TRUE, 0, 0, TRUE, 0, 0, TRUE, 0, 0 
	} ;
static char szConfigName[CONFIG_MAX_NAMELEN] = "" ;

BOOL GetCurrentConfig (CONFIG *pConfig, char *pName)
	{
	*pConfig = g_cf ;
	if (pName != NULL) strcpy (pName, szConfigName) ;
	
	return TRUE ;
	}

BOOL SetCurrentConfig (const CONFIG *pConfig, const char *pName)
	{
	g_cf = *pConfig ;
	if (pName != NULL) strcpy (szConfigName, pName) ;

	return TRUE ;
	}

/////////////////////////////////////////////////////////////////////////////////////////
// savestruct

static char		sID[4] = "SVCF" ;

void GetConfigsFileName (char *szBuf)
	{
	char	*p ;
	
	GetModuleFileName (NULL, szBuf, _MAX_PATH) ;
	p = strrchr (szBuf, '\\') ;
	strcpy (p + 1, "configs.dat") ;
	}

static void InitConfigs (FILECONFIG **ppfc, int *piSize)
	{
	*piSize = sizeof (FILECONFIG) ;
	*ppfc = (FILECONFIG*)malloc (sizeof (FILECONFIG) ) ;

	memcpy ((*ppfc)->sID, sID, 4) ;
	(*ppfc)->iCount = 0 ;
	(*ppfc)->iVersion = 0x0100 ;
	(*ppfc)->fCurrent = FALSE ;
	}

static void ConfigsLoadError (HWND hwnd)
	{
	MessageBox (hwnd, "Unable to load configurations.", NULL, MB_ICONSTOP) ;
	}

void LoadConfigs (HWND hwnd, FILECONFIG **ppfc, int *piSize)
	{
	char		szBuf[_MAX_PATH] ;
	HANDLE		hFile ;
	DWORD		dw ;

	GetConfigsFileName (szBuf) ;

	hFile = CreateFile (szBuf, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, 
		FILE_ATTRIBUTE_NORMAL | FILE_FLAG_SEQUENTIAL_SCAN, 0) ;
	if (hFile == INVALID_HANDLE_VALUE)
		{
		InitConfigs (ppfc, piSize) ;
		
		ConfigsLoadError (hwnd) ;
		
		return ;
		}

	*piSize = GetFileSize (hFile, NULL) ;
	*ppfc = (FILECONFIG*)malloc (*piSize) ;
	if (!ReadFile (hFile, *ppfc, *piSize, &dw, NULL) || (int)dw != *piSize)
		{
		CloseHandle (hFile) ;
		free (*ppfc) ;

		InitConfigs (ppfc, piSize) ;

		ConfigsLoadError (hwnd) ;
		
		return ;
		}

	CloseHandle (hFile) ;
	
	if (memcmp ((*ppfc)->sID, sID, 4) || (*ppfc)->iVersion != 0x0100)
		{
		free (*ppfc) ;
		
		ConfigsLoadError (hwnd) ;
		
		InitConfigs (ppfc, piSize) ;
		}
	
	return ;
	}

static void ConfigsSaveError (HWND hwnd)
	{
	MessageBox (hwnd, "Unable to save new configurations.", NULL, MB_ICONSTOP) ;
	}

void SaveConfigs (HWND hwnd, FILECONFIG *pcf, int iSize)
	{
	char		szBuf[_MAX_PATH] ;
	HANDLE		hFile ;
	DWORD		dw ;

	GetConfigsFileName (szBuf) ;

	hFile = CreateFile (szBuf, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, 
		FILE_ATTRIBUTE_NORMAL | FILE_FLAG_SEQUENTIAL_SCAN, 0) ;
	if (hFile == INVALID_HANDLE_VALUE)
		{
		ConfigsSaveError (hwnd) ;
		
		return ;
		}

	if (!WriteFile (hFile, pcf, iSize, &dw, NULL) || (int)dw != iSize)
		{
		CloseHandle (hFile) ;

		ConfigsSaveError (hwnd) ;
		
		return ;
		}

	CloseHandle (hFile) ;
	
	return ;
	}	

void LoadDefaultConfig (HWND hwnd)
	{
	FILECONFIG	*pfc ;
	int			i ;

	LoadConfigs (hwnd, &pfc, &i) ;
	
	if (pfc->fCurrent)
		SetCurrentConfig (&pfc->scfCurrent.cf, pfc->scfCurrent.szName) ;
	else
		SetCurrentConfig (&DefaultConfig, NULL) ;

	free (pfc) ;
	}
