// config.h
#include "sound.h"

typedef struct tagCARTRIDGE
	{
	char		fEnabled ;
	char		iType ;
	char		szROMfile[_MAX_PATH] ;
	char		szSRAMfile[_MAX_PATH] ;
	} CARTRIDGE ;

#define	CONFIG_CARTRIDGE_STANDARD		0
#define CONFIG_CARTRIDGE_FM_PAC			1
#define CONFIG_CARTRIDGE_MSXDOS2		2
#define	CONFIG_CARTRIDGE_KONAMI4		3
#define	CONFIG_CARTRIDGE_KONAMI5		4
#define	CONFIG_CARTRIDGE_ASCII_8KB		5
#define	CONFIG_CARTRIDGE_ASCII_8KB_SRAM	6
#define	CONFIG_CARTRIDGE_ASCII_16KB		7
#define	CONFIG_CARTRIDGE_GM2			8
#define	CONFIG_CARTRIDGE_R_TYPE			9
#define CONFIG_CARTRIDGE_THSCCP			10
#define CONFIG_CARTRIDGE_SDSCCP			11
#define CONFIG_CARTRIDGE_SCCP			12
#define CONFIG_CARTRIDGE_RAM256			13
#define CONFIG_CARTRIDGE_RAM512			14
#define CONFIG_CARTRIDGE_RAM768			15

typedef struct tagMEMORY
	{
	char		iMem[4][4][4] ;	 /* [primary][secundary][page] */
	char		fSlotExpanded[4] ;
	char		iMapperSize[16] ;
	} MEMORY ;

#define CONFIG_MEMORY_EMPTY			0
#define CONFIG_MEMORY_BIOS			1
#define CONFIG_MEMORY_SUBBIOS		2
#define CONFIG_MEMORY_DISKROM		3
#define CONFIG_MEMORY_RAM			4
#define CONFIG_MEMORY_RAMMM			5
#define CONFIG_MEMORY_CARTA			6
#define CONFIG_MEMORY_CARTB			7
#define CONFIG_MEMORY_CARTC			8
#define CONFIG_MEMORY_CARTD			9

typedef struct tagCONFIG
	{
	char			iMSXversion ;
	char			iMSXlanguage ;
	char			iVRAMsize ;
	char			iFPS ;
	char			fIllegalSprites ;
	char			iIntSpeed ;
	char			iSync ;
	PALETTEENTRY	apeClr[15] ;
	CARTRIDGE		cart[4] ;
	MEMORY			mem ;
	VOLSETTINGS		vol ;
	} CONFIG ;

#define CONFIG_VERSION_MSX1			0
#define CONFIG_VERSION_MSX2			1
#define CONFIG_VERSION_MSX2P		2
#define CONFIG_VERSION_MSXTURBOR	3

#define CONFIG_LANGUAGE_INT			0
#define CONFIG_LANGUAGE_JAPANESE	1

#define CONFIG_VRAM_64KB			0
#define CONFIG_VRAM_128KB			1
#define CONFIG_VRAM_196KB			2

#define CONFIG_FPS_60				0
#define CONFIG_FPS_30				1
#define CONFIG_FPS_20				2
#define CONFIG_FPS_15				3
#define CONFIG_FPS_12				4
#define CONFIG_FPS_10				5

#define CONFIG_INT_50				0
#define CONFIG_INT_60				1
#define CONFIG_INT_VAR				2

#define CONFIG_SYNC_INT				0
#define CONFIG_SYNC_FRAME			1
#define CONFIG_SYNC_NEVER			2

#define CONFIG_MAX_NAMELEN			64

BOOL GetCurrentConfig (CONFIG*, char*) ;
BOOL SetCurrentConfig (const CONFIG*, const char*) ;

typedef struct tagSAVECONFIG
	{
	char		szName[CONFIG_MAX_NAMELEN] ;
	CONFIG		cf ;
	} SAVECONFIG ;

typedef struct tagFILECONFIG
	{
	char		sID[4] ;
	short		iVersion ;
	short		iCount ;
	BOOL		fCurrent ;
	SAVECONFIG	scfCurrent ;
	SAVECONFIG	scf[1] ;
	} FILECONFIG ;

void LoadConfigs (HWND, FILECONFIG**, int *) ;
void SaveConfigs (HWND, FILECONFIG*,int) ;
void LoadDefaultConfig (HWND) ;
