// msxcore.c
#include <windows.h>
#include <process.h>
#include <assert.h>
#include "msxcore.h"
#include "mem.h"
#include "z80.h"
#include "memory.h"
#include "config.h"
#include "bootmsx.h"
#include "vdp.h"
#include "main.h"
#include "keyboard.h"
#include "sound.h"

#define DO_DISPLAY

extern Z80STATE		z80 ;
extern HWND		g_hwndMain ;
extern VDPSTATE		vdp ;
extern MSXMEM		msxmem ;
extern CONFIG		g_cf ;
static UINT		uRunning = MS_NOTRUNNING ;

void EmulationThread (void *) ;

void CreatePal (const PALETTEENTRY *apeClr)
	{
	HDC				hdc ;
	int				i ;
	PALETTEENTRY	apeDes[256] ;

	hdc = GetDC (NULL) ;

	memset (apeDes, 0, 256 * sizeof (PALETTEENTRY) ) ;

	if (GetDeviceCaps (hdc, BITSPIXEL) == 8)
		{
		for (i=0;i<10;i++)
			{
			apeDes[i].peRed = i ;
			apeDes[i].peFlags = PC_EXPLICIT ;
			}

		for (;i<246;i++)
			apeDes[i].peFlags = PC_NOCOLLAPSE ;

		for (;i<256;i++)
			{
			apeDes[i].peRed   = i ;
			apeDes[i].peFlags = PC_EXPLICIT ;
			}
		}
	else
		{
		for (i=0;i<256;i++)
			apeDes[i].peFlags = PC_NOCOLLAPSE ;
		}


	ReleaseDC (NULL, hdc) ;

	for (i=0;i<15;i++)
		{
		apeDes[0x81 + i].peRed   = apeClr[i].peRed ;
		apeDes[0x81 + i].peGreen = apeClr[i].peGreen ;
		apeDes[0x81 + i].peBlue  = apeClr[i].peBlue ;

		apeDes[0x91 + i].peRed   = apeClr[i].peRed ;
		apeDes[0x91 + i].peGreen = apeClr[i].peGreen ;
		apeDes[0x91 + i].peBlue  = apeClr[i].peBlue ;

		apeDes[0x7e - i].peRed   = ~apeClr[i].peRed ;
		apeDes[0x7e - i].peGreen = ~apeClr[i].peGreen ;
		apeDes[0x7e - i].peBlue  = ~apeClr[i].peBlue ;

		apeDes[0x6e - i].peRed   = ~apeClr[i].peRed ;
		apeDes[0x6e - i].peGreen = ~apeClr[i].peGreen ;
		apeDes[0x6e - i].peBlue  = ~apeClr[i].peBlue ;
		}
	
	apeDes[0x80].peRed   = apeClr[0].peRed ;
	apeDes[0x80].peGreen = apeClr[0].peGreen ;
	apeDes[0x80].peBlue  = apeClr[0].peBlue ;
	apeDes[0x80].peFlags = PC_RESERVED ;
	
	apeDes[0x7f].peRed   = ~apeClr[0].peRed ;
	apeDes[0x7f].peGreen = ~apeClr[0].peGreen ;
	apeDes[0x7f].peBlue  = ~apeClr[0].peBlue ;
	apeDes[0x7f].peFlags = PC_RESERVED ;
	
	apeDes[0x90].peFlags = PC_RESERVED ;

	SetPalette (0, 256, apeDes) ;
	}

void SetBackDrop ()
	{
	PALETTEENTRY	ape[2] ;

	ape[1] = g_cf.apeClr[vdp.wBackDrop] ;
	
	ape[0].peRed   = ~g_cf.apeClr[vdp.wBackDrop].peRed ;
	ape[0].peGreen = ~g_cf.apeClr[vdp.wBackDrop].peGreen ;
	ape[0].peBlue  = ~g_cf.apeClr[vdp.wBackDrop].peBlue ;
	
	ape[0].peFlags = PC_RESERVED ;
	ape[1].peFlags = PC_RESERVED ;

	SetPalette (127, 2, ape) ;
	}

BOOL StartEmulator ()
	{
	memset (&z80, 0, sizeof (z80) ) ;
	memset (&vdp, 0, sizeof (vdp) ) ;

	if (!LoadMSXMemory (&g_cf) )
		return FALSE ;

#ifdef DO_DISPLAY
	if (!InitDisplay (0) )
		{
		FreeMSXMemory (&g_cf) ;
		
		return FALSE ;
		}
#endif

	InitSound (&g_cf.vol) ;

	InitMemory () ;
	DoMemory () ;
	ResetKeyb () ;

	switch (g_cf.iIntSpeed)
		{
		case CONFIG_INT_50:
			vdp.fNTSC = FALSE ;
			break ;
		case CONFIG_INT_60:
			vdp.fNTSC = TRUE ;
			break ;
		case CONFIG_INT_VAR:
			if (g_cf.iMSXversion == CONFIG_VERSION_MSX1)
				vdp.fNTSC = !(msxmem.pMap[0][0][0][0x2b] & 0x80) ;
			else
				vdp.fNTSC = TRUE ;
			break ;
		default:
			assert (0) ;
		}
	
	uRunning = MS_RUNNING ;

	_beginthread (EmulationThread, 0, NULL) ;
	
	return TRUE ;
	}

void StopEmulator ()
	{
	uRunning = MS_NOTRUNNING ;
	}

void PauseEmulator ()
	{
	switch (uRunning)
		{
		case MS_RUNNING:
			uRunning = MS_PAUSED ;
			break ;
		case MS_PAUSED:
			uRunning = MS_RUNNING ;
			break ;
#ifdef _DEBUG
		default:
			{
			char	szBuf[256] ;
			wsprintf (szBuf, "Attempted to pause emulator while in state %d.\n", uRunning) ;
			OutputDebugString (szBuf) ;
			}
#endif
		}

	ResetKeyb () ;
	}

UINT GetEmulatorState ()
	{
	return uRunning ;
	}

void SetEmulatorState (UINT i)
	{
	uRunning = i ;
	}

static BYTE joy ;
BYTE GetJoystick1 () ;

void EmulationThread (void *pv)
	{
	int		iLastBackDrop, iPeriod, iLast, i, n ;
	
	iLastBackDrop = -1 ;
	iPeriod = 0 ;

#ifdef DO_DISPLAY
	CreatePal (g_cf.apeClr) ;
#endif

	iLast = timeGetTime () ;

	while (uRunning != MS_NOTRUNNING)
		{
		while (uRunning == MS_RUNNING)
			{
#ifdef DO_DISPLAY
			if (!iPeriod--)
				{
				iPeriod = g_cf.iFPS ;
				
				if (vdp.fModified)
					{
//					for (i=0;i<256*3;i++)
//						msxmem.pVideo[vdp.pNameTbl+i] = (BYTE)i ;
					
					VDP1BuildScreen () ;
					
					vdp.fModified = 0 ;

					if (vdp.wBackDrop != iLastBackDrop)
						{
						SetBackDrop () ;
						vdp.wBackDrop = iLastBackDrop ;
						}

					DisplayScreen (msxmem.pSurface) ;
					}
				else VDP1NotBuildScreen () ;
				
				if (g_cf.iSync == CONFIG_SYNC_FRAME)
					{
					while (1)
						{
						i = timeGetTime () ;

						n = (vdp.fNTSC ? 1000 / 60 : 1000 / 50) * (g_cf.iFPS + 1) - 
							(i - iLast) ;

						if (n > 0)
							/* Sleep (n)*/ ;
						else
							break ;
						}

					iLast = i ;
					}
				}
			else 
#endif		
			VDP1NotBuildScreen () ;

			joy = GetJoystick1 () ;
			
			z80.dwTstates = (vdp.fNTSC ? T_60HZ : T_50HZ) ;

			AssembleKeyb () ;
			if (!DoZ80 () )
				uRunning = MS_CRASHED ;

//			UpdateSound () ;

			if (g_cf.iSync == CONFIG_SYNC_INT)
				{
				while (1)
					{
					i = timeGetTime () ;

					n = (vdp.fNTSC ? 1000 / 60 : 1000 / 50) - (i - iLast) ;

					if (n > 0)
						Sleep (n) ;
					else
						break ;
					}

				iLast = i ;
				}
			}
		}

	FreeMSXMemory (&g_cf) ;
	ReleaseSound () ;
#ifdef DO_DISPLAY
	ReleaseDisplay () ;
#endif
	}

BYTE GetJoystick1 ()
	{
	JOYINFO	joyinfo ;
	BYTE	byJoy1 ;

	if (JOYERR_NOERROR != joyGetPos (JOYSTICKID1, &joyinfo) )
		return 0xff ;

	byJoy1 = 0xff ;
	if (joyinfo.wButtons & JOY_BUTTON1)
		byJoy1 &= ~0x10 ;
	if (joyinfo.wButtons & JOY_BUTTON2)
		byJoy1 &= ~0x20 ;
	
	if (joyinfo.wXpos > 0xc000)
		byJoy1 &= ~0x08;
	else if (joyinfo.wXpos < 0x4000)
		byJoy1 &= ~0x04 ;
	
	if (joyinfo.wYpos > 0xc000)
		byJoy1 &= ~0x02 ;
	else if (joyinfo.wYpos < 0x4000)
		byJoy1 &= ~0x01 ;
	
	return byJoy1 ;
	}

BYTE GetJoystick () { return joy ; }
