// rominfo.c
#include <windows.h>
#include <crtdbg.h>
#include <string.h>
#include "rominfo.h"

BOOL GetRC (BYTE*, WORD*) ;

static const char szUnknown[] = "<unknown>" ;

static const struct
	{
	const char	*szTitle ;
	const short	iSize, iFeatures ;
	} AllKonamiGames[] = {
	"Athletic Land", 						16, RI_MSX1, 
	"Antartic Adventure", 					16, RI_MSX1, 
	"Monkey Academy", 						16, RI_MSX1, 
	"Time Pilot", 							16, RI_MSX1, 
	"Frogger", 								8, RI_MSX1, 
	"Super Cobra", 							8, RI_MSX1, 
	"Billiards / Video Hustler", 			8, RI_MSX1, 
	"Mah Jongg", 							32, RI_MSX1, 
	szUnknown, 								0, 0, 
	szUnknown, 								0, 0, 
	"Track & Field 1 / Hyper Olympic 1", 	16, RI_MSX1, 
	"Track & Field 2 / Hyper Olympic 2", 	16, RI_MSX1, 
	"Circus Charlie",						16, RI_MSX1, 
	"Magical Tree", 						16, RI_MSX1, 
	"Comic Bakery", 						16, RI_MSX1, 
	"Hyper Sports 1", 						16, RI_MSX1, 
	"Cabbage Patch Kids", 					16, RI_MSX1, 
	"Hyper Sports 2", 						16, RI_MSX1, 
	"Hyper Rally",							16, RI_MSX1, 
	szUnknown, 								0, 0, 
	"Tennis", 								16, RI_MSX1, 
	"Sky Jaguar", 							16, RI_MSX1, 
	szUnknown, 								0, 0, 
	"Golf", 								16, RI_MSX1, 
	"Baseball", 							16, RI_MSX1, 
	"Yie Ar Kung-Fu", 						16, RI_MSX1, 
	szUnknown, 								0, 0, 
	"King's Valley", 						16, RI_MSX1, 
	"Mopi Ranger", 							16, RI_MSX1, 
	"Pippols", 								16, RI_MSX1, 
	"Road Fighter",							16, RI_MSX1, 
	"Ping Pong", 							16, RI_MSX1, 
	"Soccer / Football", 					32, RI_MSX1, 
	"Hyper Sports 3", 						32, RI_MSX1, 
	"The Goonies", 							32, RI_MSX1, 
	"The Game Master", 						16, RI_MSX1, 
	"Boxing", 								32, RI_MSX1, 
	"Yie Ar Kung-Fu 2",						32, RI_MSX1, 
	szUnknown, 								0, 0, 
	"Knightmare", 							32, RI_MSX1, 
	"Twinbee", 								32, RI_MSX1, 
	"Synthesizer", 							32, RI_MSX1, 
	"Nemesis / Gradius", 					128, RI_MSX1, 
	"Penguin Adventure", 					128, RI_MSX1, 
	"Vampire Killer", 						128, RI_MSX2, 
	"King Kong 2", 							128, RI_MSX2, 
	"Q Bert", 								32, RI_MSX1, 
	"Hinotory / Firebird",					128, RI_MSX2, 
	"Samurai / Goemon", 					128, RI_MSX2, 
	"The Maze of Galious", 					128, RI_MSX1, 
	"Metal Gear", 							128, RI_MSX2, 
	"Nemesis 2", 							128, RI_MSX1 | RI_SCC, 
	"F1 Spirit", 							128, RI_MSX1 | RI_SCC, 
	"Usas", 								128, RI_MSX2, 
	"Shalom",								256, RI_MSX1, 
	"The Game Master 2", 					128, RI_MSX1 | RI_MSX2 | RI_SRAM, 
	"Break Shot", 							0, 0, 
	"Pennant Race / Baseball 2", 			128, RI_MSX2 | RI_SCC, 
	"Salamander", 							128, RI_MSX1 | RI_SCC, 
	"Parodius", 							128, RI_MSX1 | RI_SCC, 
	"King's Valley 2", 						128, RI_MSX1 | RI_SCC, 
	"King's Valley 2", 						128, RI_MSX2 | RI_SCC, 
	"Contra / Gryzor", 						128, RI_MSX2 | RI_SCC, 
	szUnknown, 								0, 0, 
	"Nemesis 3",							256, RI_MSX1 | RI_MSX2 | RI_SCC, 
	"Majutsushi / Mah Jongg 2", 			128, RI_MSX2, 
	"Pennant Race 2 / Baseball 3", 			128, RI_MSX2 | RI_SCC, 
	"Solid Snake / Metal Gear 2",  			512, RI_MSX2 | RI_SCC, 
	"Space Manbow",							256, RI_MSX2 | RI_MSX2P | RI_SCC, 
	"Quarth", 								128, RI_MSX2 | RI_SCC } ;

BOOL GetROMInfo (BYTE *pROM, ROMINFO *prominfo)
	{
	int			i ;
	WORD		w ;
	
#ifdef _DEBUG
	_ASSERT (!strcmp (AllKonamiGames[69].szTitle, "Quarth") ) ;
	
	for (i=0;i<=69;i++)
		_ASSERT (strlen (AllKonamiGames[i].szTitle) < RI_MAXTITLELEN) ;

#endif
	
	if (!GetRC (pROM, &w) )
		{
		strcpy (prominfo->szTitle, szUnknown) ;
		strcpy (prominfo->szProducer, szUnknown) ;
		prominfo->iFeatures = 0 ;
		prominfo->iSize = -1 ;
		prominfo->nRC = 0 ;
		
		return FALSE ;
		}
	
	i = (int)w - 700 ;
	
	_ASSERT (i >= 0 && i <= 69) ;
	
	strcpy (prominfo->szTitle, AllKonamiGames[i].szTitle) ;
	strcpy (prominfo->szProducer, "Konami") ; /* fucking ace */
	prominfo->iFeatures = AllKonamiGames[i].iFeatures ;
	prominfo->iSize = AllKonamiGames[i].iSize ;
	prominfo->nRC = (short)w ;
	
	return TRUE ;
	}
