// sound.c
#include <windows.h>
#include <mmsystem.h>
#include <stdio.h>
#include "../sound.h"
#include "psg.h"
#include "scc.h"


#define SOUND_RATE	(22050)
#define SOUND_BUF	(SOUND_RATE / 40)
//#define SAVE_SOUND

HWAVEOUT hWaveOut=NULL;
WORD SCCBuf[4][SOUND_BUF];
BYTE PSGBuf[SOUND_BUF] ;
BOOL fPlaying ;
#ifdef SAVE_SOUND
FILE *FF ;
#endif

void UpdateSound (WORD *Buf)
{
    int	i ;

    AYUpdate (SOUND_BUF) ;
    SCCUpdate (SOUND_BUF) ;

    for (i=0;i<SOUND_BUF;i++) {
	Buf[i] = (((int)(char)PSGBuf[i]) * 25) + SCCBuf[0][i] + 
		SCCBuf[1][i] + SCCBuf[2][i] + SCCBuf[3][i] ;
    }
#ifdef SAVE_SOUND
    fwrite (Buf, 2, SOUND_BUF, FF) ;
#endif
}

void CALLBACK
prepare_one(HWAVEOUT hwo, UINT uMsg, DWORD dwInstance, 
    DWORD dwParam1, DWORD dwParam2)
{
	MMRESULT hRes;
	WAVEHDR	*pwhdr ;

	switch (uMsg)
		{
		case MM_WOM_OPEN:
			prepare_one(hwo, 102, dwInstance, dwParam1, dwParam2) ;
			prepare_one(hwo, 102, dwInstance, dwParam1, dwParam2) ;
		case 102:
			pwhdr = malloc (sizeof (WAVEHDR) ) ;
			pwhdr->lpData = malloc (SOUND_BUF*2) ;
			break ;
		case MM_WOM_DONE:
			pwhdr = (WAVEHDR*)dwParam1 ;
			waveOutUnprepareHeader (hwo, pwhdr, sizeof (WAVEHDR) ) ;
			if (!fPlaying) {
				free (pwhdr->lpData);
				free (pwhdr) ;
				return ;
			}
			break ;
		default:
			return ;
		}

	UpdateSound((WORD*)pwhdr->lpData);
	pwhdr->dwFlags = 0 ;
	pwhdr->dwBufferLength = SOUND_BUF *2 ;
	if((hRes = waveOutPrepareHeader(hwo,pwhdr,sizeof(WAVEHDR))) != MMSYSERR_NOERROR)
	{
		OutputDebugString ("prepare_one failed (1)") ;
		return;
	}
	if(waveOutWrite(hwo,pwhdr,sizeof(WAVEHDR)) != MMSYSERR_NOERROR)
	{
		OutputDebugString ("prepare_one failed (2)") ;
	  return;
	}
}

BOOL InitSound (VOLSETTINGS*vol)
{
    WAVEFORMATEX wfx;

    if (AYInit (1, SOUND_RATE, SOUND_BUF, PSGBuf) )
	return FALSE ;

    if (SCCInit (4, SOUND_RATE, 16, SOUND_BUF, SCCBuf[0], SCCBuf[1], 
	    SCCBuf[2], SCCBuf[3]) ) {
	AYShutdown () ;
	return FALSE ;
    }

    memset(&wfx,0,sizeof(wfx));
    wfx.wFormatTag = WAVE_FORMAT_PCM;
    wfx.nChannels = 1;
    wfx.nSamplesPerSec = SOUND_RATE;
    wfx.nAvgBytesPerSec = wfx.nSamplesPerSec*2;
    wfx.wBitsPerSample = 16;
    wfx.nBlockAlign = 2;
    wfx.cbSize = 0;

    fPlaying = TRUE ;
#ifdef SAVE_SOUND
    FF=fopen("C:\\WINDOWS\\TEMP\\PSG.RAW", "wb") ;
#endif
    waveOutOpen(&hWaveOut,WAVE_MAPPER,&wfx,(DWORD)&prepare_one,0,CALLBACK_FUNCTION);
    if(hWaveOut == NULL)
    {
	AYShutdown () ;
	SCCShutdown () ;
	MessageBox(NULL, "Fuckup", NULL, MB_ICONEXCLAMATION) ;
	return FALSE;
    }

    return TRUE ;
}

void ReleaseSound ()
{
    AYShutdown () ;
    SCCShutdown () ;
    fPlaying = FALSE ;
    waveOutReset (hWaveOut);
    waveOutClose (hWaveOut) ;
    hWaveOut = NULL;
#ifdef SAVE_SOUND
    fclose (FF) ;
#endif
}

void WritePSG (BYTE bReg, BYTE bVal)
{ AYWriteReg (0, bReg, bVal) ; }
void WriteSCC (int type, BYTE bReg, BYTE bVal)
{ SCCWriteReg (type/4,bReg,bVal,type&3) ; }
void WritePPI (BOOL dinky) { } 
